<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile Consent
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Consent</sch:title>
    <sch:rule context="f:Consent">
      <sch:assert test="count(f:meta) &gt;= 1">meta: minimum cardinality of 'meta' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://ns.electronichealth.net.au/ci/fhir/StructureDefinition/extension-dateinitialregistration']) &lt;= 1">extension with URL = 'http://ns.electronichealth.net.au/ci/fhir/StructureDefinition/extension-dateinitialregistration': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://ns.electronichealth.net.au/ci/fhir/StructureDefinition/extension-donationdecision']) &gt;= 1">extension with URL = 'http://ns.electronichealth.net.au/ci/fhir/StructureDefinition/extension-donationdecision': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://ns.electronichealth.net.au/ci/fhir/StructureDefinition/extension-donationdecision']) &lt;= 1">extension with URL = 'http://ns.electronichealth.net.au/ci/fhir/StructureDefinition/extension-donationdecision': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:identifier) &gt;= 1">identifier: minimum cardinality of 'identifier' is 1</sch:assert>
      <sch:assert test="count(f:dateTime) &gt;= 1">dateTime: minimum cardinality of 'dateTime' is 1</sch:assert>
      <sch:assert test="count(f:organization) &lt;= 1">organization: maximum cardinality of 'organization' is 1</sch:assert>
      <sch:assert test="count(f:policy) &gt;= 1">policy: minimum cardinality of 'policy' is 1</sch:assert>
      <sch:assert test="count(f:policy) &lt;= 1">policy: maximum cardinality of 'policy' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Consent/f:meta</sch:title>
    <sch:rule context="f:Consent/f:meta">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:versionId) &lt;= 1">versionId: maximum cardinality of 'versionId' is 1</sch:assert>
      <sch:assert test="count(f:lastUpdated) &lt;= 1">lastUpdated: maximum cardinality of 'lastUpdated' is 1</sch:assert>
      <sch:assert test="count(f:profile) &gt;= 1">profile: minimum cardinality of 'profile' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>Consent.extension</sch:title>
    <sch:rule context="f:Consent/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), 'value')])">Must have either extensions or value[x], not both (inherited)</sch:assert>
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), 'value')])">Must have either extensions or value[x], not both (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>Consent.actor</sch:title>
    <sch:rule context="f:Consent/f:actor">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Consent/f:policy</sch:title>
    <sch:rule context="f:Consent/f:policy">
      <sch:assert test="count(f:uri) &gt;= 1">uri: minimum cardinality of 'uri' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>Consent.policy</sch:title>
    <sch:rule context="f:Consent/f:policy">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>Consent.data</sch:title>
    <sch:rule context="f:Consent/f:data">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Consent/f:except</sch:title>
    <sch:rule context="f:Consent/f:except">
      <sch:assert test="count(f:action) &gt;= 1">action: minimum cardinality of 'action' is 1</sch:assert>
      <sch:assert test="count(f:action) &lt;= 1">action: maximum cardinality of 'action' is 1</sch:assert>
      <sch:assert test="count(f:data) &gt;= 1">data: minimum cardinality of 'data' is 1</sch:assert>
      <sch:assert test="count(f:data) &lt;= 1">data: maximum cardinality of 'data' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>Consent.except</sch:title>
    <sch:rule context="f:Consent/f:except">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>Consent.except.actor</sch:title>
    <sch:rule context="f:Consent/f:except/f:actor">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>Consent.except.data</sch:title>
    <sch:rule context="f:Consent/f:except/f:data">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children (inherited)</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
