
### Common behaviour

A PCA Publisher Agent manages the service offerings for one publisher organisation.      
    
 The PCA service instantiates one PCA Publisher Agent for each participating publisher organisation. That is, each publisher organisation interacts with a PCA Publisher Agent located at a *publisher agent base URL* that is unique to that organisation.    
    
 The *publisher agent base URL* for a particular organisation is available via the PCA portal on the 'Organisation Details' screen of the publisher organisation.     
    
 **Publication process**    
    
 A PCA Publisher Agent creates the ```Location```, ```HealthcareService``` and ```PractitionerRole``` resources (that are associated with existing ```Organization``` and ```Practitioner``` resources) that represent their service offerings.  These resources are made available to a subscriber organisation when a publisher authorises publication of a ```HealthcareService``` or ```PractitionerRole``` resource to one or more of the subscriber organisation's partner services.    
    
 The authority to publish is represented using ```Contract``` resources which are also implemented by the PCA Publisher Agent (see the [Contract resource endpoint](CapabilityStatement-pca-publisher-agent.html#contract)).    
    
 **Identifier disclosure rules**    
    
 The PCA service enforces certain business rules regarding the disclosure of *Identifiers* (including subscriber-issued identifiers) in the resources that it makes available to subscribers.     
    
 The result of these rules may be that a copy of  a resource received by one subscriber may contain *Identifiers* that are not included in the copy of the same resource that is received by a different subscriber.    
    
 In the case of HPI-Is these *identifier disclosure rules* ensure that relevant legal requirements are complied with.    
    
 Other *identifier disclosure rules* are defined by the PCA operator.     
    
 The *identifier disclosure rules* are applied automatically at the time that the resource is retrieved by the target PCA Subscriber Agent.    
    
 **Authorisation rules**    
    
Authorised client systems are only permitted to interact with a PCA Publisher Agent API where the participating organisation associated with the PCA Publisher Agent has a publisher approval status of 'Approved'.    
    
 **Resource profiles and extensions**    
    
This API specification defines the required resource profiles for each operation.  In addition, the PCA Publisher Agent will reject any request to create or update a resource that contains any extensions (including modifier extensions) not explicitly defined in that resource profile.    
    
       

<hr/>

### Whole system interactions



<hr/>

#### search-system

<b>Supported search parameters:</b>

<table border="1">
   <tr>
      <td>
         <b>Parameter</b>
      </td>
      <td>
         <b>Type</b>
      </td>
      <td>
         <b>Definition</b>
      </td>
   </tr>
   <tr>
      <td>_lastUpdated</td>
      <td>date</td>
      <td>http://hl7.org/fhir/SearchParameter/Resource-lastUpdated</td>
   </tr>
   <tr>
      <td>_type</td>
      <td>token</td>
      <td/>
   </tr>
   <tr>
      <td>_include</td>
      <td>special</td>
      <td/>
   </tr>
   <tr>
      <td>_include:iterate</td>
      <td>special</td>
      <td/>
   </tr>
   <tr>
      <td>_page</td>
      <td>special</td>
      <td/>
   </tr>
   <tr>
      <td>_count</td>
      <td>special</td>
      <td/>
   </tr>
   <tr>
      <td>_resultId</td>
      <td>special</td>
      <td/>
   </tr>
</table>**Definition**:     
 This operation is a RESTful *search* interaction (whole system interaction), across multiple resource types (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#search)).      
     
 **Behaviour**:     
 This operation is used by a client system operated by a publisher organisation to get resources that match the specified search parameters and that are within the scope of the publisher organisation.     
     
 The following  search parameters are supported:     
 * *_lastUpdated* is used to get the resources that have been added or changed since the requesting system last synchronised their local data store with PCA Publisher Agent.  This search parameter supports the ```gt``` and ```lt``` comparison prefixes.     
 * *_type* is used to filter the resources returned by their resource type. The available types are:      
     
   * ```HealthcareService``` (returns resources conforming to the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) profile)     
   * ```PractitionerRole``` (returns resources conforming to the [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) profile)     
   * ```Organization``` (returns resources conforming to the [PCA Organization](StructureDefinition-pca-organization.html) profile)     
   * ```Location``` (returns resources conforming to the [PCA Location](StructureDefinition-pca-location.html) profile)     
   * ```Practitioner``` (returns resources conforming to the [PCA Practitioner](StructureDefinition-pca-practitioner.html) profile)     
   * ```Provenance``` (returns resources conforming to the [PCA Provenance](StructureDefinition-pca-provenance.html) profile)     
   * ```Contract``` (returns resources conforming to the [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile)      
   * ```Task``` (returns resources conforming to the [PCA Match Record](StructureDefinition-pca-match-record.html) profile)      
     
     
 * *_include* (and *_include:iterate*) are used in order that all the resources that match the *_lastUpdated* and *_type* filters will be accompanied, in the result Bundle, with all the other resources which they reference (directly or indirectly).     
     
 Note that the use of *_include* (and *_include:iterate*) means that a resource may be present in the result ```Bundle``` either because it matched the other query parameters or because it was referenced (possibly indirectly) by another resource that matched the other query parameters.     
      
 All of the following query parameters are required in order to receive the complete set of resources that have been created or changed since *[last_synchronized]*:     
     
 ``` _lastUpdated=[last_synchronized] ```     
 ```_type=HealthcareService,PractitionerRole,Practitioner,Organization,Location,Provenance,Contract,Task ```     
 ```_include=Location:organization ```     
 ```_include=HealthcareService:organization ```     
 ```_include=HealthcareService:location ```     
 ```_include=PractitionerRole:organization ```     
 ```_include=PractitionerRole:location ```       
 ```_include=PractitionerRole:service ```     
 ```_include=PractitionerRole:practitioner ```      
 ```_include=Provenance:target ```        
 ```_include=Contract:subject ```        
 ```_include:iterate=HealthcareService:organization  ```       
 ```_include:iterate=HealthcareService:location ```     
 ```_include:iterate=PractitionerRole:organization ```     
 ```_include:iterate=PractitionerRole:location ```     
 ```_include:iterate=PractitionerRole:service ```     
 ```_include:iterate=PractitionerRole:practitioner ```     
      
 This operation supports 'paging' ([see FHIR specification](https://www.hl7.org/fhir/search.html#Paging)).  If there are too many resources to return in one ```Bundle```, the FHIR server adds a *next* link to the response ```Bundle```. The contents of the result ```Bundle``` therefore comprise all instances of the requested resource types whose *lastUpdated* timestamp is greater than the &lt;lastSync&gt; in the request query expression and less than or equal to &lt;lastInBundle&gt; where &lt;lastInBundle&gt; is the greatest *lastUpdated* value of all resources included in the result ```Bundle```. The Publisher Agent FHIR server sets the *next* link to the filter expression that was used in the original request except that &lt;lastSync&gt; is replaced with &lt;lastInBundle&gt;. If the *next* link is not present in the ```Bundle```, then there are no more service offerings available.     
     
 **HTTP interaction signature**:     
 * ```GET [publisher agent base url]/?[parameters]```     
     
 **Mandatory Request Headers**:     
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```     
 * ```Authorization: Bearer [token]```     
     
 **Request Body**:     
 * (No request body)     
     
 **Mandatory Response Headers**:     
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```     
     
 **Response Body**:     
 * Success: ```Bundle``` that contains zero to many resources (where the resource type was included in the filter expression of the search request) that conform to the following [PCA profiles](profiles.html):      
     
   * ```HealthcareService``` resources conforming to the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) profile     
   * ```PractitionerRole``` resources conforming to the [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) profile     
   * ```Organization``` resources conforming to the [PCA Organization](StructureDefinition-pca-organization.html) profile     
   * ```Location``` resources conforming to the [PCA Location](StructureDefinition-pca-location.html) profile     
   * ```Practitioner``` resources conforming to the [PCA Practitioner](StructureDefinition-pca-practitioner.html) profile     
   * ```Provenance``` resources conforming to the [PCA Provenance](StructureDefinition-pca-provenance.html) profile     
   * ```Contract``` resources conforming to the [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile     
   * ```Task``` resources conforming to the [PCA Match Record](StructureDefinition-pca-match-record.html) profile      
     
     
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
     
 **Required OAuth 2.0 scopes**:     
     
 The *scope* string **SHALL** contain the following *scoped role*:     
 * ```Organization/[id]:PS_Read```     
     
 Where [id] **SHALL** identify the ```Organization``` associated with the target PCA Publisher Agent.     
     
 **Response Codes**:         
 * Code 200:  Search successfully performed (but may return zero matching results).     
 * Code 403:  Server refused to perform the search.     

<hr/>

### Organization

     
     
 This section defines the supported interactions for the [PCA Organization](StructureDefinition-pca-organization.html) profile of the ```Organization``` resource type.     
     

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>versioned</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>

### RESTful operations



<hr/>

#### read

**Definition**:      
      
 This operation is a RESTful **read** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#read)) of an ```Organization``` resource.       
      
 **Behaviour**:      
      
 This operation retrieves an identified ```Organization``` resource that conforms to the [PCA Organization](StructureDefinition-pca-organization.html) profile.       
      
 **HTTP interaction signature**:      
      
 ```GET [publisher agent base url]/Organization/[id]```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * (No request body)      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```ETag: [version id]``` where [version id] identifies the version of the ```Organization``` resource returned.        
      
 **Response Body**:      
 * Success: ```Organization``` resource that conforms to the [PCA Organization](StructureDefinition-pca-organization.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ```Organization/[id]:PCA:Om```      
 * ```Location/[id]:PCA:Hsm```      
 * ```HealthcareService/[id]:PCA:Hsm```      
 * ```Organization/[id]:PS_Read```      
 * ```Location/[id]:PS_Read```      
 * ```HealthcareService/[id]:PS_Read```      
      
 If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the target ```Organization``` being read.      
      
 if a *scoped role* identifies a ```Location``` then [id] **SHALL** identify any ```Location``` where its *managingOrganisation* references the target ```Organization``` being read.      
      
 if a *scoped role* identifies a ```HealthcareService``` then [id] **SHALL** identify any ```HealthcareService``` where its *providedBy* references the target ```Organization``` being read.      
      
 **Response Codes**:          
 *  Code 200:  The resource was found and returned.      
 *  Code 404:  The resource was not found.      

<hr/>

### Location

       
     
This section defines the supported interactions for the [PCA Location](StructureDefinition-pca-location.html) profile of the ```Location``` resource type.     
     
A ```Location``` resource conforming to the [PCA Location](StructureDefinition-pca-location.html) profile represents a location at which healthcare services are offered by a PCA publisher.       

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>versioned-update</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>

#### RESTful operations



<hr/>

#### create

**Definition**:      
      
 This operation is a RESTful **create** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#create)) of a ```Location``` resource conforming to the [PCA Location](StructureDefinition-pca-location.html) profile.       
      
 **Behaviour**:      
      
 If any of the following data validation rules are violated in the input resource then the request is rejected and the error code 422 is returned:      
      
 * The resource **SHALL** conform to the [PCA Location](StructureDefinition-pca-location.html) profile.      
 * *id* **SHALL NOT** be present.         
 * *meta.versionId* **SHALL NOT** be present.         
 * *meta.lastUpdated* **SHALL NOT** be present.         
 * *identifier:pca-li* **SHALL NOT** be present.         
 * *providedBy* **SHALL** reference an existing ```Organization``` within the scope of the requesting system.      
 * *status* **SHALL NOT** use the code 'suspended'.         
 * If *type* is not present, then *address* **SHALL** be present.          
      
 **HTTP interaction signature**:      
 * ```POST [publisher agent base url]/Location```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * ```Location``` resource that conforms to the [PCA Location](StructureDefinition-pca-location.html) profile.      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```ETag: [version id]``` where [version id] identifies the version of the new ```Location``` resource.        
      
 **Response Body**:      
 * Success: ```Location``` resource that conforms to the [PCA Location](StructureDefinition-pca-location.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
       
 The *scope* string **SHALL** contain the following *scoped role*:      
 * ``` Organization/[id]:PCA:Om```      
 * ``` Organization/[id]:PCA:Hsm```      
 * ``` Organization/[id]:PS_ServicesMgr```      
      
 Where [id] **SHALL** identify the ```Organization``` referenced by *managingOrganization* in the new ```Location```.      
      
      
 **Response Codes**:          
 * Code 201:  The resource was successfully created.      
 * Code 400:  The input resource could not be parsed or failed basic FHIR validation rules.      
 * Code 404:  The resource type is not supported, or not a FHIR end-point.      
 * Code 422:  The input resource violated applicable FHIR profiles or server data validation rules.      

<hr/>

#### read

**Definition**:      
      
 This operation is a RESTful **read** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#read)) of a ```Location``` resource.       
      
 **Behaviour**:      
      
 This operation retrieves an identified ```Location``` resource that conforms to the [PCA Location](StructureDefinition-pca-location.html) profile.       
      
 **HTTP interaction signature**:      
 * ```GET [publisher agent base url]/Location/[id]```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * (No request body)      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```ETag: [version id]``` where [version id] identifies the version of the ```Location``` resource returned.        
      
 **Response Body**:      
 * Success: ```Location``` resource that conforms to the [PCA Location](StructureDefinition-pca-location.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain the following *scoped role*:      
 * ```Organization/[id]:PCA:Om```      
 * ```Location/[id]:PCA:Hsm```      
 * ```HealthcareService/[id]:PCA:Hsm```      
 * ```Organization/[id]:PS_Read```      
 * ```Location/[id]:PS_Read```      
 * ```HealthcareService/[id]:PS_Read```      
      
 If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the ```Organization``` referenced by *managingOrganization* in the target ```Location``` being read.      
      
 if a *scoped role* identifies a ```Location``` then [id] **SHALL** identify the ```Location``` being read.      
      
 if a *scoped role* identifies a ```HealthcareService``` then [id] **SHALL** identify a ```HealthcareService``` where its *location* references the target ```Location``` being read.      
      
 **Response Codes**:          
 *  Code 200:  The resource was found and returned.      
 *  Code 404:  The resource was not found.      

<hr/>

#### update

**Definition**:      

  This operation is a RESTful **update** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#update)) of a ```Location``` resource.       
      
 **Behaviour**:      
      
 If any of the following data validation rules are violated in the input resource, then the request is rejected and the error code 422 is returned:      
      
 * The resource **SHALL** conform to the [PCA Location](StructureDefinition-pca-location.html) profile.      
 * *id* **SHALL**  be identical to the value in the version of the ```Location``` identified in the 'if-match' HTTP header.      
 * *meta.versionId* **SHALL NOT** be present.         
 * *meta.lastUpdated* **SHALL NOT** be present.         
 * *managingOrganization* **SHALL**   be identical to the corresponding value in the version of the ```Location``` identified in the 'if-match' HTTP header.      
 * *identifier:pca-li* **SHALL**  be identical to the corresponding value in the version of the ```Location``` identified in the 'if-match' HTTP header.      
 * *status* **SHALL NOT** use the code 'suspended'.         
 * If *type* is not present, then *address* **SHALL** be present.          
 * If *status* is 'inactive', then all healthcare services linked to the location **SHALL** have an *active* value of 'false'.      
      
 If the 'if-match' HTTP header is not provided in the request, then the PCA Publisher Agent will reject the request and return the error code 400.        
      
 If the 'if-match' HTTP header does not match the current version, then the PCA Publisher Agent will reject the request and return the error code 412.            
      
 **HTTP interaction signature**:      
 * ```PUT [publisher agent base url]/Location/[id]```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
 * ```if-match [version id]``` where [version id] is the version of the ```Location``` being updated.      
      
 **Request Body**:      
 * ```Location``` resource that conforms to the [PCA Location](StructureDefinition-pca-location.html) profile.      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```ETag: [version id]``` where [version id] identifies the version of the ```Location``` resource returned.        
      
 **Response Body**:      
 * Success: ```Location``` resource that conforms to the [PCA Location](StructureDefinition-pca-location.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ``` Organization/[id]:PCA:Om```      
 * ``` Organization/[id]:PCA:Hsm```      
 * ``` Location/[id]:PCA:Hsm```      
 * ``` Organization/[id]:PS_ServiceMgr```      
 * ``` Location/[id]:PS_ServiceMgr```      
      
 If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the ```Organization``` referenced by *managingOrganization* in the target ```Location``` being updated.      
      
 If a *scoped role* identifies a ```Location``` then [id] **SHALL** identify the target ```Location``` being updated.      
      
 **Response Codes**:          
 * Code 200:  The resource was found and returned.      
 * Code 400:  Client error:  request did not include the *if-match* HTTP header.      
 * Code 404:  The resource was not found.      
 * Code 412:  The version id given in the *if-Match* HTTP request header does not match the current version.      
*  Code 422:  The input resource violated applicable FHIR profiles or server data validation rules.      

<hr/>

### HealthcareService

       
     
 This section defines the supported interactions for the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) profile and the [PCA Partner Service](StructureDefinition-pca-partner-service.html) profile of the ```HealthcareService``` resource type.     
     
 A ```HealthcareService``` resource conforming to the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) profile describes a healthcare service offered at a location by a PCA publisher.     
     
 A ```HealthcareService``` resource conforming to the [PCA Partner Service](StructureDefinition-pca-partner-service.html) profile describes a partner service offered by a subscriber to which PCA publishers can publish their service offerings.     

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>versioned-update</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>

#### RESTful operations



<hr/>

#### create

**Definition**:      
      
 This operation is a RESTful **create** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#create)) of a ```HealthcareService``` resource conforming to the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) profile.      
      
 **Behaviour**:      
      
 If any of the following data validation rules are violated in the input resource then the request is rejected and the error code 422 is returned:      
      
 * The resource **SHALL** conform to the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) profile.      
 * *id* **SHALL NOT** be present.         
 * *meta.versionId* **SHALL NOT** be present.         
 * *meta.lastUpdated* **SHALL NOT** be present.         
 * *identifier:pca-hsi* **SHALL NOT** be present.         
 * *providedBy* **SHALL** reference an existing ```Organization``` within the scope of the requesting system.      
 * *location* **SHALL** reference an existing ```Location``` within the scope of the requesting system.       
*  *location* **SHALL** reference a ```Location``` for which *managingOrganization* references the same ```Organization``` as is referenced by *providedBy*.      
 * One and only one *type* **SHALL** use the *iso21090-preferred* extension.        
 * *coverageArea* **SHALL** only be present if *eligibility* contains the 'coverage-restrictedResidents' code, and/or if the *type* element of the referenced *location* contains either the 'MOBL' (mobile) or 'VI' (virtual) code.      
 * If present, *notAvailable.during* **SHALL** contain a complete date and **SHALL NOT** include time or timezone data.        
 * If present, *availableTime.during* elements (including *availableTime* elements using the *availableTimeApplicability* extension) **SHALL** contain a complete date and **SHALL NOT** include time or timezone data.      
 * If present, *availableTime* elements using the *availableTimeApplicability* extension **SHALL** include both a start and end date for the *during* element.          
 * If present, *pca-active-period* SHALL have at least *value[x].start* or *value[x].end*.       
 * If present, *pca-active-period.value[x].start* SHALL be later than '1900-01-01'.      
 * If present, *pca-active-period.value[x].start* SHALL be equal to, or earlier than, the *period.start* or *period.end* values of any ```PractitionerRole`` resources that reference this ```HealthcareService```.      
 * If present, *pca-active-period.value[x].end* SHALL be no more than 5 years from the current date.      
 * If present, *pca-active-period.value[x].end* SHALL be equal to, or later than, the *period.start* or *period.end* values of any ```PractitionerRole`` resources that reference this ```HealthcareService```.      
      
 **HTTP interaction signature**:      
 * ```POST [publisher agent base url]/HealthcareService```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * ```HealthcareService``` resource that conforms to the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) profile.      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```ETag: [version id]``` where [version id] identifies the version of the new ```HealthcareService``` resource.        
      
 **Response Body**:      
 * Success: ```HealthcareService``` resource that conforms to the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
       
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ``` Organization/[id]:PCA:Om```      
 * ``` Organization/[id]:PCA:Hsm```      
 * ``` Location/[id]:PCA:Hsm```      
 * ``` Organization/[id]:PS_ServicesMgr```      
 * ``` Location/[id]:PS_ServicesMgr```      
      
 If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the ```Organization``` referenced by *providedBy* in the new ```HealthcareService```.      
      
 if a *scoped role* identifies a ```Location``` then [id] **SHALL** identify the ```Location``` referenced by *location* in the new ```HealthcareService```.      
      
 **Response Codes**:          
 * Code 201:  The resource was successfully created.      
 * Code 400:  The input resource could not be parsed or failed basic FHIR validation rules.      
 * Code 404:  The resource type is not supported, or not a FHIR end-point.      
 * Code 422:  The input resource violated applicable FHIR profiles or server data validation rules.      

<hr/>

#### read

**Definition**:      
      
 This operation is a RESTful **read** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#read)) of a ```HealthcareService``` resource.       
      
 **Behaviour**:      
      
 This operation is used to retrieve an identified ```HealthcareService``` resource that conforms to one of the following profiles:      
 * [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html)      
 * [PCA Partner Service](StructureDefinition-pca-partner-service.html)      
      
 Different authorisation rules apply depending on the profile of the ```HealthcareService``` resource being retrieved; see the 'Required OAuth 2.0 scopes' section below.      
      
 **HTTP interaction signature**:      
 * ```GET [publisher agent base url]/HealthcareService/[id]```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * (No request body)      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```ETag: [version id]``` where [version id] identifies the version of the ```HealthcareService``` resource returned.        
      
 **Response Body**:      
 * Success: ```HealthcareService``` resource that conforms to either the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) or [PCA Partner Service](StructureDefinition-pca-partner-service.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 *  ``` Organization/[id]:PS_Read```      
 *  ``` Location/[id]:PS_Read```      
 *  ``` HealthcareService/[id]:PS_Read```          
       
 When retrieving a ```HealthcareService``` resource that conforms to the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) profile:      
 * If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the ```Organization``` referenced by *providedBy* in the target ```HealthcareService``` being read.      
 * If a *scoped role* identifies a ```Location``` then [id] **SHALL** identify the ```Location``` referenced by *location* in the target ```HealthcareService``` being read.      
 * If a *scoped role* identifies a ```HealthcareService``` then [id] **SHALL** identify the target ```HealthcareService``` being read.      
      
 When retrieving a ```HealthcareService``` resource that conforms to the [PCA Partner Service](StructureDefinition-pca-partner-service.html) profile:      
 * If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the publishing organisation associated with the target PCA Publisher Agent.      
 * If a *scoped role* identifies a ```Location``` then [id] **SHALL** identify any existing ```Location``` within the scope of the requesting system.      
 * If a *scoped role* identifies a ```HealthcareService``` then [id] **SHALL** identify any existing ```HealthcareService``` within the scope of the requesting system.             
      
 **Response Codes**:          
 * Code 200:  The resource was found and returned.      
 * Code 404:  The resource was not found.      

<hr/>

#### update

**Definition**:      

  This operation is a RESTful **update** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#update)) of a ```HealthcareService``` resource.       
      
 **Behaviour**:      
      
 If any of the following data validation rules are violated in the input resource, then the request is rejected and the error code 422 is returned:      
      
 * The resource **SHALL** conform to the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) profile.      
 * *id* **SHALL**   be identical to the value in the version of the ```HealthcareService``` identified in the 'if-match' HTTP header.      
 * *meta.versionId* **SHALL NOT** be present.         
 * *meta.lastUpdated* **SHALL NOT** be present.         
 * *providedBy* **SHALL**  be identical to the corresponding value in the version of the ```HealthcareService``` identified in the 'if-match' HTTP header.      
 * *location* **SHALL**   be identical to the corresponding value in the version of the ```HealthcareService``` identified in the 'if-match' HTTP header.      
 * *identifier:pca-hsi* **SHALL**  be identical to the corresponding value in the version of the ```HealthcareService``` identified in the 'if-match' HTTP header.      
 * One and only one *type* **SHALL** use the *iso21090-preferred* extension.        
 * *coverageArea* **SHALL** only be present if *eligibility* contains the 'coverage-restrictedResidents' code, and/or if the *type* element of the referenced *location* contains either the 'MOBL' (mobile) or 'VI' (virtual) code.      
 * If present, *notAvailable.during* **SHALL** contain a complete date and **SHALL NOT** include time or timezone data.        
 * If present, *availableTime.during* elements (including *availableTime* elements using the *availableTimeApplicability* extension) **SHALL** contain a complete date and **SHALL NOT** include time or timezone data.      
 * If present, *availableTime* elements using the *availableTimeApplicability* extension **SHALL** include both a start and end date for the *during* element.          
 * If present, *availableTime* elements using the *availableTimeApplicability* extension **SHALL** include both a start and end date for the *during* element.          
 * If present, *pca-active-period* SHALL have at least *value[x].start* or *value[x].end*.       
 * If present, *pca-active-period.value[x].start* SHALL be later than '1900-01-01'.      
 * If present, *pca-active-period.value[x].start* SHALL be equal to, or earlier than, the *period.start* or *period.end* values of any ```PractitionerRole`` resources that reference this ```HealthcareService```.      
 * If present, *pca-active-period.value[x].end* SHALL be no more than 5 years from the current date.      
 * If present, *pca-active-period.value[x].end* SHALL be equal to, or later than, the *period.start* or *period.end* values of any ```PractitionerRole`` resources that reference this ```HealthcareService```.      
      
 If the 'if-match' HTTP header is not provided in the request, then the PCA Publisher Agent will reject the request and return the error code 400.        
      
 If the 'if-match' HTTP header does not match the current version, then the PCA Publisher Agent will reject the request and return the error code 412.            
      
 **HTTP interaction signature**:      
 * ```PUT [publisher agent base url]/HealthcareService/[id]```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
 * ```if-match [version id]``` where [version id] is the version of the ```HealthcareService``` being updated.      
      
 **Request Body**:      
 ```HealthcareService``` resource that conforms to the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) profile.      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```ETag: [version id]``` where [version id] identifies the version of the ```HealthcareService``` resource returned.        
      
 **Response Body**:      
 * Success: ```HealthcareService``` resource that conforms to the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ``` Organization/[id]:PCA:Om```      
 * ``` Organization/[id]:PCA:Hsm```      
 * ``` Location/[id]:PCA:Hsm```      
 * ``` HealthcareService/[id]:PCA:Hsm```      
 * ``` Organization/[id]:PS_ServiceMgr```      
 * ``` Location/[id]:PS_ServiceMgr```      
 * ``` HealthcareService/[id]:PS_ServiceMgr```             
      
 If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the ```Organization``` referenced by *providedBy* in the target ```HealthcareService``` being updated.      
      
 If a *scoped role* identifies a ```Location``` then [id] **SHALL** identify the ```Location``` referenced by *location* in the target ```HealthcareService``` being updated.      
      
 If a *scoped role* identifies a ```HealthcareService``` then [id] **SHALL** identify the target ```HealthcareService``` being updated.      
      
 **Response Codes**:          
 * Code 200:  The resource was found and returned.      
 * Code 400:  Client error:  request did not include the *if-match* HTTP header.      
 * Code 404:  The resource was not found.      
 * Code 412:  The version id given in the *if-Match* HTTP request header does not match the current version.      
*  Code 422:  The input resource violated applicable FHIR profiles or server data validation rules.      

<hr/>

#### search-type

<b>Supported search parameters:</b>

<table border="1">
   <tr>
      <td>
         <b>Parameter</b>
      </td>
      <td>
         <b>Type</b>
      </td>
      <td>
         <b>Definition</b>
      </td>
   </tr>
   <tr>
      <td>_profile</td>
      <td>uri</td>
      <td>http://hl7.org/fhir/SearchParameter/Resource-profile</td>
   </tr>
   <tr>
      <td>active</td>
      <td>token</td>
      <td>http://hl7.org/fhir/SearchParameter/HealthcareService-active</td>
   </tr>
   <tr>
      <td>organization</td>
      <td>reference</td>
      <td>http://hl7.org/fhir/SearchParameter/HealthcareService-organization</td>
   </tr>
   <tr>
      <td>service-catgeory</td>
      <td>token</td>
      <td>http://hl7.org/fhir/SearchParameter/HealthcareService-service-category</td>
   </tr>
   <tr>
      <td>coverage-area.location.address-postalcode</td>
      <td>string</td>
      <td/>
   </tr>
</table>**Definition**:      
      
 This operation is a RESTful **search** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#search)) for ```HealthcareService``` resources that conform to the [PCA Partner Service](StructureDefinition-pca-partner-service.html) profile.       
      
 **Behaviour**:      
      
 The operation is used to find ```HealthcareService``` resources that that conform to the [PCA Partner Service](StructureDefinition-pca-partner-service.html) profile and that match the search parameters.      
 Note that all [PCA Partner Service](StructureDefinition-pca-partner-service.html) resources in the PCA service are accessible to all authorised client systems.      
      
 **HTTP interaction signature**:      
 * ```GET [publisher agent base url]/HealthcareService/{?[parameters]}```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * (No request body)      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
      
 **Response Body**:      
 * Success: Bundle that contains zero to many ```HealthcareService``` resources that conform to the [PCA Partner Service](StructureDefinition-pca-partner-service.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ``` Organization/[id]:PCA:Om```      
 * ``` Organization/[id]:PCA:Hsm```      
 * ``` Location/[id]:PCA:Hsm```      
 * ``` HealthcareService/[id]:PCA:Hsm```      
 * ``` Organization/[id]:PS_Read```      
 * ``` Location/[id]:PS_Read```      
 * ``` HealthcareService/[id]:PS_Read```          
      
 If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the publishing organisation associated with the target PCA Publisher Agent.      
      
 If a *scoped role* identifies a ```Location``` then [id] **SHALL** identify any existing ```Location``` within the scope of the requesting system.      
      
 If a *scoped role* identifies a ```HealthcareService``` then [id] **SHALL** identify any existing ```HealthcareService``` within the scope of the requesting system.      
      
 **Response Codes**:          
 * Code 200:  Search successfully performed (but may return zero matching results).      
 * Code 403:  Server refused to perform the search.      

<hr/>

### PractitionerRole

       
     
This section defines the supported interactions for the [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) profile of the ```PractitionerRole``` resource type.     
     
Each ```PractitionerRole``` resource conforming to the [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) profile describes a practitioner in a role at a healthcare service.     

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>versioned-update</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>

#### RESTful operations



<hr/>

#### create

**Definition**:      
      
 This operation is a RESTful **create** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#create)) of a ```PractitionerRole``` resource conforming to the [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) profile.       
      
 **Behaviour**:      
      
 If the ```Organization``` associated with the target PCA Publisher Agent has not been approved to participate in the PCA service, then the request will be rejected and the error code 422 will be returned.      
      
 If any of the following data validation rules are violated in the input resource, then the request is rejected and the error code 422 is returned:      
 * The resource **SHALL** conform to the profile [http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-practitioner-role](StructureDefinition-pca-practitioner-role.html).      
 * *id* **SHALL NOT** be present.         
 * *meta.versionId* **SHALL NOT** be present.         
 * *meta.lastUpdated* **SHALL NOT** be present.         
 * *identifier:pca-pri* **SHALL** not be present.         
 * *active* **SHALL NOT** be present.      
 * *organization* **SHALL** not be present.         
 * *location* **SHALL** not be present.         
 * *healthcareService* **SHALL** reference an existing ```HealthcareService``` that exists within the target PCA Publisher Agent.      
 * *practitioner* **SHALL** reference an existing ```Practitioner``` that exists within the PCA service.      
 * if *coding:hiServiceRole* is present and has the value 'ProvidesHealthcareToIndividuals', then the ```Organization``` associated with the target PCA Publisher Agent **SHALL** have authorised the Agency as a Contracted Service Provider (CSP).      
 * If present, *period.start* SHALL be later than '1900-01-01'.      
 * If present, *period.start* SHALL be equal to, or later than, the *pca-active-period.value[x].start* value (if present) of the ```HealthcareService``` referenced by the *healthcareService* element.          
 * If present, *period.end* SHALL be no more than 5 years from the current date.      
 * If present, *period.end* SHALL be equal to, or earlier than, the *pca-active-period.value[x].end* value (if present) of the ```HealthcareService``` referenced by the *healthcareService* element.          
      
 Note: While the referenced ```Practitioner``` resource is managed via the PCA portal, it is also instantiated as a read-only 'proxy' within the PCA Publisher Agent.  This means that the reference to ```Practitioner``` contained in the ```PractitionerRole``` is a local reference that is resolved within the PCA Publisher Agent.  This 'proxy' has the same id as the resource within the PCA Portal for which it is a proxy.       
      
 **HTTP interaction signature**:      
 * ```POST [publisher agent base url]/PractitionerRole```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * ```PractitionerRole``` resource that conforms to the [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) profile.      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```ETag: [version id]``` where [version id] identifies the version of the new ```PractitionerRole``` resource.        
      
 **Response Body**:      
 * Success: ```PractitionerRole``` resource that conforms to the [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ``` Organization/[id]:PCA:Om```      
 * ``` Organization/[id]:PCA:Hsm```      
 * ``` Location/[id]:PCA:Hsm```      
 * ``` HealthcareService/[id]:PCA:Hsm```      
 * ``` Organization/[id]:PS_ServicesMgr```      
 * ``` Location/[id]:PS_ServicesMgr```      
 * ``` HealthcareService/[id]:PS_ServicesMgr```      
      
 If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the ```Organization``` referenced by *providedBy* of the ```HealthcareService``` referenced by *healthcareService* in the new ```PractitionerRole```.      
      
 if a *scoped role* identifies a ```Location``` then [id] **SHALL** identify the ```Location``` referenced by *location* of the ```HealthcareService``` referenced by *healthcareService* in the new ```PractitionerRole```.      
      
 if a *scoped role* identifies a ```HealthcareService``` then [id] **SHALL** identify the ```HealthcareService``` referenced by *healthcareService* in the new ```PractitionerRole```.      
      
 **Response Codes**:          
 * Code 201:  The resource was successfully created.      
 * Code 400:  The input resource could not be parsed or failed basic FHIR validation rules.      
 * Code 404:  The resource type is not supported, or not a FHIR end-point.      
 * Code 422:  The input resource violated applicable FHIR profiles or server data validation rules.      

<hr/>

#### read

**Definition**:      
      
 This operation is a RESTful **read** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#read)) of a ```PractitionerRole``` resource.       
      
 **Behaviour**:      
      
 This operation retrieves an identified ```PractitionerRole``` resource that conforms to the [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) profile.      
      
 **HTTP interaction signature**:      
      
 * ```GET [publisher agent base url]/PractitionerRole/[id]```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * (No request body)      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```ETag: [version id]``` where [version id] identifies the version of the ```PractitionerRole``` resource returned.        
      
 **Response Body**:      
 * Success: ```PractitionerRole``` resource that conforms to the [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ```Organization/[id]:PCA:Om```      
 * ```Organization/[id]:PCA:Hsm```      
 * ```Location/[id]:PCA:Hsm```      
 * ```HealthcareService/[id]:PCA:Hsm```      
 * ```Organization/[id]:PS_Read```      
 * ```Location/[id]:PS_Read```        
 * ```HealthcareService/[id]:PS_Read```        
      
 If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the ```Organization``` referenced by *providedBy* in the ```HealthcareService``` referenced by *healthcareService* in the target ```PractitionerRole``` being read.      
      
 If a *scoped role* identifies a ```Location``` then [id] **SHALL** identify the ```Location``` referenced by *location* in the ```HealthcareService``` referenced by *healthcareService* in the target ```PractitionerRole``` being read.      
      
 If a *scoped role* identifies a ```HealthcareService``` then [id] **SHALL** identify the ```HealthcareService``` referenced by *healthcareService* in the target ```PractitionerRole``` being read.      
      
 **Response Codes**:          
*  Code 200:  The resource was found and returned.      
*  Code 404:  The resource was not found.      

<hr/>

#### update

**Definition**:      
      
 This operation is a RESTful **update** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#update)) of a ```PractitionerRole``` resource.       
      
 **Behaviour**:      
      
 If the ```Organization``` associated with the target PCA Publisher Agent has not been approved to participate in the PCA service, then the request will be rejected and the error code 422 will be returned.      
      
 If any of the following data validation rules are violated in the input resource then the request is rejected and the error code 422 is returned:      
 * The resource **SHALL** conform to the [PCA Practitoner Role](StructureDefinition-pca-practitioner-role.html) profile.      
 * *id* **SHALL**  be identical to the value in the version of the ```PractitionerRole``` identified in the 'if-match' HTTP header.      
 * *meta.versionId* **SHALL NOT** be present.         
 * *meta.lastUpdated* **SHALL NOT** be present.         
 * *identifier:pca-pri* **SHALL** be identical to the corresponding value in the version of the ```PractitionerRole``` identified in the 'if-match' HTTP header.      
 * *active* **SHALL NOT** be present.      
 * *organization* **SHALL** be identical to the corresponding value in the version of the ```PractitionerRole``` identified in the 'if-match' HTTP header.         
 * *location* **SHALL** be identical to the corresponding value in the version of the ```PractitionerRole``` identified in the 'if-match' HTTP header.            
 * *healthcareService* **SHALL** be identical to the corresponding value in the version of the ```PractitionerRole``` identified in the 'if-match' HTTP header.      
 * *practitioner* **SHALL** be identical to the corresponding value in the version of the ```PractitionerRole``` identified in the 'if-match' HTTP header.      
 * if *coding:hiServiceRole* is present and has the value 'ProvidesHealthcareToIndividuals', then the Organization associated with the target PCA Publisher Agent **SHALL** have authorised the Agency as a Contracted Service Provider (CSP).      
 * If present, *period.start* SHALL be later than '1900-01-01'.      
 * If present, *period.start* SHALL be equal to, or later than, the *pca-active-period.value[x].start* value (if present) of the ```HealthcareService``` referenced by the *healthcareService* element.          
 * If present, *period.end* SHALL be no more than 5 years from the current date.      
 * If present, *period.end* SHALL be equal to, or earlier than, the *pca-active-period.value[x].end* value (if present) of the ```HealthcareService``` referenced by the *healthcareService* element.          
      
 If the 'if-match' HTTP header is not provided in the request, then the PCA Publisher Agent will reject the request and return the error code 400.        
      
 If the 'if-match' HTTP header does not match the current version, then the PCA Publisher Agent will reject the request and return the error code 412.            
      
 **HTTP interaction signature**:      
 * ```PUT [publisher agent base url]/PractitionerRole/[id]```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
 * ```if-match [version id]``` where [version id] is the version of the PractitionerRole being updated.      
      
 **Request Body**:      
 * ```PractitionerRole``` resource that conforms to the [PCA Practtiioner Role](StructureDefinition-pca-practitioner-role.html) profile.      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```ETag: [version id]``` where [version id] identifies the version of the PractitionerRole resource returned.        
      
 **Response Body**:      
 * Success: ```PractitionerRole``` resource that conforms to the [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ```Organization/[id]:PCA:Om```      
 * ```Organization/[id]:PCA:Hsm```      
 * ```Location/[id]:PCA:Hsm```      
 * ```HealthcareService/[id]:PCA:Hsm```      
 * ```Organization/[id]:PS_PractitionerMgr```      
 * ```Location/[id]:PS_PractitionerMgr```      
 * ```HealthcareService/[id]:PS_PractitionerMgr```      
      
 If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the ```Organization``` referenced by *providedBy* in the ```HealthcareService``` referenced by *healthcareService* in the target ```PractitionerRole``` being updated.      
      
 If a *scoped role* identifies a ```Location``` then [id] **SHALL** identify the ```Location``` referenced by *location* in the ```HealthcareService``` referenced by *healthcareService* in the target ```PractitionerRole``` being updated.      
      
 If a *scoped role* identifies a ```HealthcareService``` then [id] **SHALL** identify the ```HealthcareService``` referenced by *healthcareService* in the target ```PractitionerRole``` being updated.      
      
 **Response Codes**:          
 * Code 200:  The resource was found and returned.      
 * Code 400:  Client error:  request did not include the *if-match* HTTP header.      
 * Code 404:  The resource was not found.      
 * Code 412:  The version id given in the *if-Match* HTTP request header does not match the current version      
 * Code 422:  The input resource violated applicable FHIR profiles or server data validation rules.      

<hr/>

### Practitioner

     
     
This section defines the supported interactions for the [PCA Practitioner](StructureDefinition-pca-practitioner.html) profile of the ```Practitioner``` resource type.     
     
Each ```Practitioner``` resource conforming the [PCA Practitioner](StructureDefinition-pca-practitioner.html) profile is a read-only proxy for a corresponding ```Practitioner``` resource managed by the PCA portal.     
     
Each 'proxy' has the same *id* and *versionId* as the resource within the PCA portal for which it is a proxy.       

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>versioned</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>

#### RESTful operations



<hr/>

#### read

**Definition**:      
      
 This operation is a RESTful **read** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#read)) of a ```Practitioner``` resource.       
      
 **Behaviour**:      
      
 This operation retrieves an identified ```Practitioner``` resource that conforms to the [PCA Practitioner](StructureDefinition-pca-practitioner.html) profile.       
      
 The PCA Publisher Agent will include a *identifier:hpii* in the ```Practitioner``` resource returned if **all** of the following conditions are met:      
 * HPI-I and Ahpra number match in the HI service.       
 * The ```Organization``` on whose behalf the request is made is a publisher organisation.       
 * The ```Organization``` on whose behalf the request is made has been approved to participate in the PCA service.      
 * The ```Organization``` on whose behalf the request is made has authorised the Agency as a Contracted Service Provider (CSP).      
 * The client system is authorised to read an existing PractitionerRole where *practitioner* references the ```Practitioner``` resource returned **and** where *coding:hiServiceRole* has the value 'ProvidesHealthcareToIndividuals'.      
      
 **HTTP interaction signature**:      
 * ```GET [publisher agent base url]/Practitioner/[id]```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * (No request body)      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```ETag: [version id]``` where [version id] identifies the version of the ```Practitioner``` resource returned.        
      
 **Response Body**:      
 * Success: ```Practitioner``` resource that conforms to the [PCA Practitioner](StructureDefinition-pca-practitioner.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ```Organization/[id]:PCA:Om```      
 * ```Organization/[id]:PCA:Hsm```      
 * ```Location/[id]:PCA:Hsm```      
 * ```HealthcareService/[id]:PCA:Hsm```      
 * ```Organization/[id]:PS_Read```      
 * ```Location/[id]:PS_Read```      
 * ```HealthcareService/[id]:PS_Read```      
      
 If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the publishing organisation associated with the requesting system.      
      
 If a *scoped role* identifies a ```Location``` then [id] **SHALL** identify any existing ```Location``` within the scope of the requesting system.      
      
 If a *scoped role* identifies a ```HealthcareService``` then [id] **SHALL** identify any existing ```HealthcareService``` within the scope of the requesting system.      
      
 **Response Codes**:          
 * Code 200:  The resource was found and returned.      
 * Code 404:  The resource was not found.      

<hr/>

#### search-type

<b>Supported search parameters:</b>

<table border="1">
   <tr>
      <td>
         <b>Parameter</b>
      </td>
      <td>
         <b>Type</b>
      </td>
      <td>
         <b>Definition</b>
      </td>
   </tr>
   <tr>
      <td>identifier</td>
      <td>token</td>
      <td>http://hl7.org/fhir/SearchParameter/Practitioner-identifier</td>
   </tr>
</table>**Definition**:      
      
 This operation is a RESTful **search** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#search)) for a ```Practitioner``` resource for either a given Ahpra registration number or HPI-I identifier that conforms to the [PCA Practitioner](StructureDefinition-pca-practitioner.html) profile.       
      
 **Behaviour**:      
      
 The operation is used to find a ```Practitioner``` resource given their Ahpra registration number or HPI-I identifier.  The PCA Publisher Agent will return zero or one ```Practitioner``` resource that conforms to the [PCA Practitioner](StructureDefinition-pca-partner-service.html) profile.      
       
 The operation is only available to client systems acting on behalf of publisher organisations (see ‘Required OAuth 2.0 scopes’ below).      
       
 The PCA Publisher Agent will reject requests and return the error code 403 if the identifier query string is not present, or if the identifier query string does not qualify the identifier value with one of the following systems:      
 * http://hl7.org.au/id/ahpra-registration-number (when searching on Ahpra registration number)      
 * http://ns.electronichealth.net.au/id/hi/hpii/1.0 (when searching on HPI-I)      
       
 The PCA Publisher Agent return a ```Bundle``` containing exactly one ```Practitioner``` resource if the identifier query string matches the same record in either the Ahpra Register of practitioners or the HI Service, else it will return a ```Bundle``` contanining zero results.      
       
 The PCA Publisher Agent will only support searching by HPI-I if the client system’s organisation has has made the PCA a Contracted Service Provider (CSP).      
      
 The PCA Publisher Agent will include the *identifier:hpii* element in the ```Practitioner``` resource returned if the client system’s organisation has has made the PCA a Contracted Service Provider (CSP) and the ```Practitioner``` resource's *coding:hiServiceRole* element has the value ‘ProvidesHealthcareToIndividuals’.      
      
 **HTTP interaction signature**:      
 * ```GET [publisher agent base url]/Practitioner/{?[parameter]}```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * (No request body)      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
      
 **Response Body**:      
 * Success: Bundle that contains zero to one ```Practitioner``` resources that conforms to the [PCA Practitioner](StructureDefinition-pca-practitioner.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ```Organization/[id]:PCA:Om```      
 * ```Organization/[id]:PCA:Hsm```      
 * ```Location/[id]:PCA:Hsm```      
 * ```HealthcareService/[id]:PCA:Hsm```      
 * ```Organization/[id]:PS_ServicesMgr```      
 * ```Location/[id]:PS_ServicesMgr```      
 * ```HealthcareService/[id]:PS_ServicesMgr```      
      
 If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the publishing organisation associated with the requesting system.      
      
 If a *scoped role* identifies a ```Location``` then [id] **SHALL** identify any existing ```Location``` within the scope of the requesting system.      
      
 If a *scoped role* identifies a ```HealthcareService``` then [id] **SHALL** identify any existing ```HealthcareService``` within the scope of the requesting system.      
      
 **Response Codes**:          
 * Code 200:  Search successfully performed (but may return zero matching results).      
 * Code 403:  Server refused to perform the search.      

<hr/>

### Provenance

     
     
 This section defines the supported interactions for the [PCA Provenance](StructureDefinition-pca-provenance.html) profile of the ```Provenance``` resource type.     
     
 Each ```Provenance``` resource conforming to the [PCA Provenance](StructureDefinition-pca-provenance.html) profile represents an activity performed by the PCA service (conditionally on behalf of a participating organisation when the target element references a PCA Organization resource) whereby specific data elements of a PCA Organization or PCA Practitioner resource have been initially retrieved, updated or verified from an external system of record.   

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>no-version</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>

#### RESTful operations



<hr/>

#### read

**Definition**:      
      
 This operation is a RESTful **read** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#read)) of a ```Provenance``` resource.       
      
 **Behaviour**:      
      
 This operation retrieves an identified ```Provenance``` resource that conforms to the [PCA Provenance](StructureDefinition-pca-practitioner-role.html) profile.      
      
 **HTTP interaction signature**:      
 * ```GET [publisher agent base url]/Provenance/[id]```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * (No request body)      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
      
 **Response Body**:      
 * Success: ```Provenance``` resource that conforms to the [PCA Provenance](StructureDefinition-pca-provenance.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ```Organization/[id]:PCA:Om```      
 * ```Organization/[id]:PCA:Hsm```      
 * ```Location/[id]:PCA:Hsm```      
 * ```HealthcareService/[id]:PCA:Hsm```      
 * ```Organization/[id]:PS_Read```      
 * ```Location/[id]:PS_Read```      
 * ```HealthcareService/[id]:PS_Read```      
      
 If the ```Provenance``` resource being read has a *target* that references an ```Organization```, then:      
 * If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the ```Organization``` referenced by *target* in the ```Provenance``` resource being read.      
      
 If the ```Provenance``` resource being read has a *target* that references a ```Practitioner```, then:      
 * If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the publishing organisation associated with the requesting system.      
 * If a *scoped role* identifies a ```Location``` then [id] **SHALL** identify any existing ```Location``` within the scope of the requesting system.      
 * If a *scoped role* identifies a ```HealthcareService``` then [id] **SHALL** identify any existing ```HealthcareService``` within the scope of the requesting system.      
      
 **Response Codes**:          
 * Code 200:  The resource was found and returned.      
 * Code 404:  The resource was not found.      

<hr/>

### Contract

       
     
 This section defines the supported interactions for the [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile and the [PCA Information Use Statement](StructureDefinition-pca-information-use-statement.html) profile of the ```Contract``` resource type.     
     
     
 A ```Contract``` resource conforming to the [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile records a decision regarding the publication of a specific service offering (either a ```HealthcareService``` or a ```PractitionerRole```) to a specific partner service. The decision is either to authorise publication or to revoke a previous authority to publish.     
     
 A ```Contract``` resource conforming to the [PCA Information Use Statement](StructureDefinition-pca-information-use-statement.html) profile represents a policy statement by a subscriber organisation's partner service that describes how they will use the information from publisher organisations that is disclosed to the partner service.          

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>versioned-update</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>

#### RESTful operations



<hr/>

#### create

**Definition**:      
      
 This operation is a RESTful **create** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#create)) of a ```Contract``` resource conforming to the [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile.       
      
 Please note: This operation will be available in Release 2.1 of PCA.      
      
 **Behaviour**:      
      
 This operation records a decision made by an authorised representative of a publisher organisation to authorise the publication of a ```HealthcareService``` or ```PractitionerRole``` to a partner service.      
      
 Authorisation is implemented using this operation.  Revocation is implemented by updating the *status* of the existing ```Contract``` to 'revoked'.      
      
 A ```Contract``` resource cannot be created with a *status* of 'cancelled' - this status can only by set by the PCA service and is used to indicate that the partner service associated with the publication authorisation is inactive.      
      
 If the invocation of a ```Contract``` resource with *status* of 'executed' is sucessful then the PCA service will make the following resources available to the PCA Subscriber Agent of the organisation referenced by *providedBy* of the partner service:      
      
 * *target* resource (```HealthcareService``` or ```PractitionerRole```).       
 * ```Organization```, ```Location``` and ```Practitioner``` resources that are referenced directly or indirectly by the target ```HealthcareService``` or ```PractitionerRole```.      
 * The newly created ```Contract``` resource.      
      
 The PCA service will also continue to make available any new versions of these resources to the same PCA Subscriber Agent. This process continues until the existing ```Contract``` resource is updated with a *status* of 'revoked'.      
      
 Prior to invoking this operation the following PCA API operations are available to provide the information that is recorded in the ```Contract``` resource to be created.      
      
 * If not already identified or synchronised locally, then search for the relevant resource(s) using [search-system](CapabilityStatement-pca-publisher-agent.html#search-system) (for service offering resources to publish) and [PartnerService search-type](CapabilityStatement-pca-publisher-agent.html#search-type-1) (for partner services registered in the PCA service)      
 * Get the current text of the information use statement for the selected partner service:      
   * Get the partner service (i.e. a HealthcareService) using [PartnerService read](CapabilityStatement-pca-publisher-agent.html#read-2)      
   * Get the reference to the latest version of the Information Use Statement (i.e. a ```Contract``` resource) from the  [pca-current-information-use-statement](StructureDefinition-pca-current-information-use-statement.html) extension in the partner service resource      
   * Get the text of the information use statement using [Information Use Statement read](CapabilityStatement-pca-publisher-agent.html#read-7)      
      
 If any of the following data validation rules are violated in the input resource, then the request is rejected and the error code 422 is returned:      
      
 * The resource **SHALL** conform to the  [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile.      
 * *id* **SHALL NOT** be present.         
 * *meta.versionId* **SHALL NOT** be present.         
 * *meta.lastUpdated* **SHALL NOT** be present.         
 * *subject* **SHALL**  reference an existing ```HealthcareService``` or ```PractitionerRole``` implemented by the PCA Publisher Agent (i.e. the target FHIR server)      
 * *instantiatesCanonical* **SHALL** reference the information use statement (i.e. a ```Contract``` resource) whose *legal.content[x].data* element was viewed by the person responsible for making the publication decision recorded via the new ```Contract``` resource.        
 * *author* **SHALL** be a local reference to a contained resource of type [PCA Publication Approver](StructureDefinition-pca-publication-approver.html).      
 * *status* **SHALL** use the code 'executed'.      
 * The partner service referenced by the *subject* of the information use statement referenced in *instantiatesCanonical* **SHALL** have an *active* value of 'true'.      
      
 **HTTP interaction signature**:      
 * ```POST [publisher agent base url]/Contract```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * ```Contract``` resource that conforms to the  [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile.      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
      
 **Response Body**:      
 * Success: ```Contract``` resource that conforms to the  [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ```Organization/[id]:PCA:Om```      
 * ```Organization/[id]:PCA:Hsm```      
 * ```Location/[id]:PCA:Hsm```      
 * ```HealthcareService/[id]:PCA:Hsm```      
 * ```Organization/[id]:PS_PublicationMgr```      
 * ```Location/[id]:PS_PublicationMgr```      
 * ```HealthcareService/[id]:PS_PublicationMgr```      
      
 If a *scoped role* identifies an ```Organization``` then:      
      
 * If the *subject* of the ```Contract``` being created references a ```HealthcareService``` then [id] **SHALL** identify the ```Organization``` referenced by *providedBy* in that ```HealthcareService```.      
 * If the *subject* of the ```Contract``` being created references a ```PractitionerRole``` then [id] **SHALL** identify the ```Organization``` referenced by *providedBy* in the ```HealthcareService``` referenced by *healthcareService* in that ```PractitionerRole```.      
      
 If a *scoped role* identifies a ```Location``` then:       
 * If the *subject* of the ```Contract``` being created references a ```HealthcareService``` then [id] **SHALL** identify  the ```Location``` referenced by *location* in that ```HealthcareService```.      
 * If the *subject* of the ```Contract``` being created references a ```PractitionerRole``` then [id] **SHALL** identify the ```Location``` referenced by *location* in the ```HealthcareService``` referenced by *healthcareService* in that ```PractitionerRole```.      
      
 If a *scoped role* identifies a ```HealthcareService``` then:       
 * If the *subject* of the ```Contract``` being created references a ```HealthcareService``` then [id] **SHALL** identify that ```HealthcareService```.      
 * If the *subject* of the ```Contract``` being created references a ```PractitionerRole``` then [id] **SHALL** identify the ```HealthcareService``` referenced by *healthcareService* in that ```PractitionerRole```.      
      
 **Response Codes**:          
 * Code 201:  The resource was successfully created.      
 * Code 400:  The input resource could not be parsed or failed basic FHIR validation rules.      
 * Code 404:  The resource type is not supported, or not a FHIR end-point.      
 * Code 422:  The input resource violated applicable FHIR profiles or server data validation rules.      

<hr/>

#### read

**Definition**:      
      
 This operation is a RESTful **read** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#read)) of a ```Contract``` resource.       
      
 Please note: This operation will be available in Release 2.1 of PCA.      
      
 **Behaviour**:      
      
 This operation is used to retrieve an identified ```Contract``` resource that conforms to one of the following profiles:      
 * [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html)      
 * [PCA Information Use Statement](StructureDefinition-pca-information-use-statement.html)      
      
 **HTTP interaction signature**:      
 * ```GET [publisher agent base url]/Contract/[id]```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * (No request body)      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
      
 **Response Body**:      
 * Success: ```Contract``` resource that conforms to the [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile or the [PCA Information Use Statement](StructureDefinition-pca-information-use-statement.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      

  The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ```Organization/[id]:PCA:Om```      
 * ```Organization/[id]:PCA:Hsm```      
 * ```Location/[id]:PCA:Hsm```      
 * ```HealthcareService/[id]:PCA:Hsm```      
 * ```Organization/[id]:PS_Read```      
 * ```Location/[id]:PS_Read```      
 * ```HealthcareService/[id]:PS_Read```      
      
 When retrieving a ```Contract``` resource that conforms to the [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile:      
 * If a *scoped role* identifies an ```Organization``` then:      
      
   * If the *subject* of the ```Contract``` being read references a ```HealthcareService``` then [id] **SHALL** identify the ```Organization``` referenced by *providedBy* in that ```HealthcareService```.      
   * If the *subject* of the ```Contract``` being read references a ```PractitionerRole``` then [id] **SHALL** identify the ```Organization``` referenced by *providedBy* in the ```HealthcareService``` referenced by *healthcareService* in that ```PractitionerRole```.      
 * If a *scoped role* identifies a ```Location``` then:       
   * If the *subject* of the ```Contract``` being read references a ```HealthcareService``` then [id] **SHALL** identify  the ```Location``` referenced by *location* in that ```HealthcareService```.      
   * If the *subject* of the ```Contract``` being read references a ```PractitionerRole``` then [id] **SHALL** identify the ```Location``` referenced by *location* in the ```HealthcareService``` referenced by *healthcareService* in that ```PractitionerRole```.      
 * If a *scoped role* identifies a ```HealthcareService``` then:       
   * If the *subject* of the ```Contract``` being read references a ```HealthcareService``` then [id] **SHALL** identify that ```HealthcareService```.      
   * If the *subject* of the ```Contract``` being read references a ```PractitionerRole``` then [id] **SHALL** identify the ```HealthcareService``` referenced by *healthcareService* in that ```PractitionerRole```.      
      
 When retrieving a ```Contract``` resource that conforms to the [PCA Information Use Statement](StructureDefinition-pca-information-use-statement.html) profile:      
 * If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the publishing organisation associated with the target PCA Publisher Agent.      
 * If a *scoped role* identifies a ```Location``` then [id] **SHALL** identify any existing ```Location``` within the scope of the requesting system.      
 * If a *scoped role* identifies a ```HealthcareService``` then [id] **SHALL** identify any existing ```HealthcareService``` within the scope of the requesting      
      
      
 **Response Codes**:          
 * Code 200:  The resource was found and returned.      
 * Code 404:  The resource was not found.      

<hr/>

#### update

**Definition**:      
      
 This operation is a RESTful **update** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#create)) of a ```Contract``` resource.       
      
 Please note: This operation will be available in Release 2.1 of PCA.      
      
 **Behaviour**:      
      
 This operation can be used to record a decision made by an authorised representative of a publisher organisation to revoke an existing authorisation to publish, or to record that a new version of a partner service's information use statement has been accepted:      
      
 * Revocation is implemented using this operation by updating the *status* of an existing ```Contract``` resource to 'revoked'.      
 * Accepting a new version of a partner service's information use statement is implemented using this operation by updating the *instantiatesCanonical* of an existing ```Contract``` resource to reference a new information use statement.      
      
 To re-authorise publication after revoking, create a new ```Contract``` resource.        
      
 If any of the following data validation rules are violated in the input resource, then the request is rejected and the error code 422 is returned:      
 * The resource **SHALL** conform to the [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile.      
 * *id* **SHALL** be identical to the corresponding value in the version of the ```Contract``` identified in the 'if-match' HTTP header.       
 * *meta.versionId* **SHALL NOT** be present.         
 * *meta.lastUpdated* **SHALL NOT** be present.         
 * *subject* **SHALL** be identical to the corresponding value in the version of the ```Contract``` identified in the 'if-match' HTTP header.       
 * *author* **SHALL** be identical to the corresponding value in the version of the ```Contract``` identified in the 'if-match' HTTP header.       
 * Updates to *instantiatesCanonical* **SHALL** only be permitted where the version of the ```Contract``` identified in the 'if-match' HTTP header has a *status* of 'executed', and *status* is not also being updated.      
 * Updates to *status* **SHALL** only be permitted where the *status* is being updated to *revoked*, and *instantiatesCanonical* is not also being updated.      
 * If *instantiatesCanonical* is being updated, the partner service referenced by the *subject* of the information use statement referenced in *instantiatesCanonical* **SHALL** have an *active* value of 'true'.      
 * If *instantiatesCanonical* is being updated, the partner service referenced by the *subject* of the information use statement referenced in *instantiatesCanonical* **SHALL** be identical to the previous *subject* of the information use statement referenced in *instantiatesCanonical* in the version of the ```Contract``` identified in the 'if-match' HTTP header.      
      
 If the 'if-match' HTTP header is not provided in the request, then the PCA Publisher Agent will reject the request and return the error code 400.        
      
 If the 'if-match' HTTP header does not match the current version, then the PCA Publisher Agent will reject the request and return the error code 412.        
      
 **HTTP interaction signature**:      
 * ```PUT [publisher agent base url]/Contract```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
 * ```if-match [version id]``` where [version id] is the version of the ```Contract``` being updated.      
      
 **Request Body**:      
 * ```Contract``` resource that conforms to the  [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile.      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
 * ```ETag: [version id]``` where [version id] identifies the version of the ```Contract``` resource returned.        
      
 **Response Body**:      
 * Success: ```Contract``` resource that conforms to the  [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ```Organization/[id]:PCA:Om```      
 * ```Organization/[id]:PCA:Hsm```      
 * ```Location/[id]:PCA:Hsm```      
 * ```HealthcareService/[id]:PCA:Hsm```      
 * ```Organization/[id]:PS_PublicationMgr```      
 * ```Location/[id]:PS_PublicationMgr```      
 * ```HealthcareService/[id]:PS_PublicationMgr```      
      
 If a *scoped role* identifies an ```Organization``` then:      
      
 * If the *subject* of the ```Contract``` being created references a ```HealthcareService``` then [id] **SHALL** identify the ```Organization``` referenced by *providedBy* in that ```HealthcareService```.      
 * If the *subject* of the ```Contract``` being created references a ```PractitionerRole``` then [id] **SHALL** identify the ```Organization``` referenced by *providedBy* in the ```HealthcareService``` referenced by *healthcareService* in that ```PractitionerRole```.      
      
 If a *scoped role* identifies a ```Location``` then:       
 * If the *subject* of the ```Contract``` being created references a ```HealthcareService``` then [id] **SHALL** identify  the ```Location``` referenced by *location* in that ```HealthcareService```.      
 * If the *subject* of the ```Contract``` being created references a ```PractitionerRole``` then [id] **SHALL** identify the ```Location``` referenced by *location* in the ```HealthcareService``` referenced by *healthcareService* in that ```PractitionerRole```.      
      
 If a *scoped role* identifies a ```HealthcareService``` then:       
 * If the *subject* of the ```Contract``` being created references a ```HealthcareService``` then [id] **SHALL** identify that ```HealthcareService```.      
 * If the *subject* of the ```Contract``` being created references a ```PractitionerRole``` then [id] **SHALL** identify the ```HealthcareService``` referenced by *healthcareService* in that ```PractitionerRole```.      
      
 **Response Codes**:          
 * Code 200:  The resource was found and returned.      
 * Code 400:  Client error:  request did not include the *if-match* HTTP header.      
 * Code 404:  The resource was not found.      
 * Code 412:  The version id given in the *if-Match* HTTP request header does not match the current version      
 * Code 422:  The input resource violated applicable FHIR profiles or server data validation rules.      

<hr/>

#### search-type

<b>Supported search parameters:</b>

<table border="1">
   <tr>
      <td>
         <b>Parameter</b>
      </td>
      <td>
         <b>Type</b>
      </td>
      <td>
         <b>Definition</b>
      </td>
   </tr>
   <tr>
      <td>_profile</td>
      <td>uri</td>
      <td>http://hl7.org/fhir/SearchParameter/Resource-profile</td>
   </tr>
   <tr>
      <td>subject</td>
      <td>reference</td>
      <td>http://hl7.org/fhir/SearchParameter/Contract-subject</td>
   </tr>
   <tr>
      <td>version</td>
      <td>string</td>
      <td/>
   </tr>
</table>**Definition**:      
      
 This operation is a RESTful **search** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#search)) for ```Contract``` resources.       
      
 **Behaviour**:      
      
 This operation is used to find ```Contract``` resources that conform to the [PCA Information Use Statement](StructureDefinition-pca-information-use-statement.html) profile and that match the search parameters.       
      
 Note that all [PCA Information Use Statement](StructureDefinition-pca-information-use-statement.html) resources in the PCA service are accessible to all authorised client systems.      
      
 **HTTP interaction signature**:      
 * ```GET [publisher agent base url]/Contract/{?[parameters]}```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * (No request body)      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
      
 **Response Body**:      
* Success: ```Bundle``` containing zero to many ```Contract``` resources that conform to the [PCA Information Use Statement](StructureDefinition-pca-information-use-statement.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ```Organization/[id]:PCA:Om```      
 * ```Organization/[id]:PCA:Hsm```      
 * ```Location/[id]:PCA:Hsm```      
 * ```HealthcareService/[id]:PCA:Hsm```      
 * ```Organization/[id]:PS_Read```      
 * ```Location/[id]:PS_Read```      
 * ```HealthcareService/[id]:PS_Read```          
       
 If a *scoped role* identifies an ```Organization``` then [id] **SHALL** identify the publishing organisation associated with the target PCA Publisher Agent.      
      
 If a *scoped role* identifies a ```Location``` then [id] **SHALL** identify any existing ```Location``` within the scope of the requesting system.      
      
 If a *scoped role* identifies a ```HealthcareService``` then [id] **SHALL** identify any existing ```HealthcareService``` within the scope of the requesting system.      
      
 **Response Codes**:          
 * Code 200:  Search successfully performed (but may return zero matching results).      
 * Code 403:  Server refused to perform the search.      

<hr/>

### Task

     
     
 This section defines the supported interactions for the [PCA Match Record](StructureDefinition-pca-match-record.html) profile of the ```Task``` resource type.     
     
 A ```Task``` resource conforming to the [PCA Match Record](StructureDefinition-pca-match-record.html) profile indicates the matching status of a service offering to a partner service’s local data store.       

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>versioned</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>

#### RESTful operations



<hr/>

#### read

**Definition**:      
      
 This operation is a RESTful **read** interaction (as described in the [FHIR specification](https://www.hl7.org/fhir/http.html#read)) of a ```Task``` resource.       
      
 **Behaviour**:      
      
 This operation retrieves an identified ```Task``` resource that conforms to the [PCA Match Record](StructureDefinition-pca-match-record.html) profile.       
       
 **HTTP interaction signature**:      
 * ```GET [publisher agent base url]/Task/[id]```      
      
 **Mandatory Request Headers**:      
 * ```Accept: application/fhir+json;charset=utf-8``` or ```Accept: application/fhir+xml;charset=utf-8```      
 * ```Authorization: Bearer [token]```      
      
 **Request Body**:      
 * (No request body)      
      
 **Mandatory Response Headers**:      
 * ```Content-Type: application/fhir+json;charset=utf-8``` or ```Content-Type: application/fhir+xml;charset=utf-8```      
      
 **Response Body**:      
 * Success: ```Task``` resource that conforms to the [PCA Match Record](StructureDefinition-pca-match-record.html) profile.      
 * Error: ```OperationOutcome``` resource (see [FHIR specification](https://www.hl7.org/fhir/operationoutcome.html)).      
      
 **Required OAuth 2.0 scopes**:      
      
 The *scope* string **SHALL** contain one or more of the following *scoped roles*:      
 * ```Organization/[id]:PCA:Om```      
 * ```Organization/[id]:PCA:Hsm```      
 * ```Location/[id]:PCA:Hsm```      
 * ```HealthcareService/[id]:PCA:Hsm```      
 * ```Organization/[id]:PS_Read```      
 * ```Location/[id]:PS_Read```      
 * ```HealthcareService/[id]:PS_Read```      
      
 If a *scoped role* identifies an ```Organization``` then:      
 * If the *focus* of the ```Task``` being read references an ```Organization```, then [id] **SHALL** identify that ```Organization```.       
 * If the *focus* of the ```Task``` being read references a ```Location```, then [id] **SHALL** identify the ```Organization``` referenced by *managingOrganization* of the ```Location```.       
 * If the *focus* of the ```Task``` being read references a ```HealthcareService```, then [id] **SHALL** identify the ```Organization``` referenced by *providedBy* of that HealthcareService.      
 * If the *focus* of the ```Task``` being read references a ```PractitionerRole```, then [id] **SHALL** identify the ```Organization``` referenced by *providedBy* of the ```HealthcareService``` referenced by *healthcareService* of that ```PractitionerRole```.      
       
 If a *scoped role* identifies a ```Location``` then:      
 * If the *focus* of the ```Task``` being read references a ```Location```, then [id] **SHALL** identify that ```Location```.       
 * If the *focus* of the ```Task``` being read references a ```HealthcareService```, then [id] **SHALL** identify the ```Location``` referenced by *location* of that ```HealthcareService```.      
 * If the *focus* of the ```Task``` being read references a ```PractitionerRole```, then [id] **SHALL** identify the ```Location``` referenced by *location* of the ```HealthcareService``` referenced by *healthcareService* of that PractitionerRole.      
       
 If a *scoped role* identifies a ```HealthcareService``` then:      
 * If the *focus* of the ```Task``` being read references a ```HealthcareService```, then [id] **SHALL** identify that ```HealthcareService```.      
 * If the *focus* of the ```Task``` being read references a ```PractitionerRole```, then [id] **SHALL** identify the ```HealthcareService``` referenced by *healthcareService* of that PractitionerRole.      
      
 **Response Codes**:          
 * Code 200:  The resource was found and returned.      
 * Code 404:  The resource was not found.      