### Must support
The meaning of the presence or absence of the must support flag is described in [Must support](guidance.html#must-support), except for the following elements:

* For the *id* and *identifier:pca-li* elements: publishing systems creating a new PCA Location resource shall not provide these elements.  These identifiers are generated by the PCA service.
* For the *meta.versionId* and *meta.lastUpdated* elements: publishing systems creating or updating a PCA Location resource shall not provide these elements.  These values are generated by the PCA service.

### Extensions
Extensions introduced in this profile:
* Location: [PCA Amenity](StructureDefinition-pca-amenity.html)
* Location: [PCA Postal Address](StructureDefinition-pca-postal-address.html)

### Usage notes

#### Identifiers
The PCA Location profile explicitly supports the following identifier slice (as indicated by the must support flag):
* PCA Location Identifier (PCA-LI)

A PCA Location resource may also have additional identifiers specific to other PCA business partners, and their identifier systems may or may not match other identifier slices defined in [AU Base Location](http://hl7.org.au/fhir/4.1.0/StructureDefinition-au-location.html).

#### Status
The *status* element can only be set to 'inactive' if all healthcare services linked to the location have an *active* value of 'false'.

#### Location address
A PCA Location without a *type* represents a physical location in PCA.  A PCA Location without a *type* must include the 
physical address of the location in the *address* element.

#### Address lines
When a PCA Location is created or updated by a publishing system, or retrieved by a publishing or subscribing system, the *line* elements for *pca-postal-address* (if present) and *address* are processed/populated by PCA using the rules that are defined the usage notes of the [PCA Postal Address](StructureDefinition-pca-postal-address.html) extension.

#### Type
The usage notes of the AU Base Location profile provide guidance for Locations that may form part of defining a mobile or remotely delivered service. The PCA Location profile formalises this guidance as mandatory requirements (via invariants).  The requirements are summarised below:

A PCA Location for a mobile service **shall** have:
* mode=’kind’
* type=’MOBL’ plus at least one of the following codes: 'PTRES', 'SCHOOL', 'WORK', 'COMM' or 'AMB', to further qualify where the mobile service is offered

A PCA Location for a remotely delivered service **shall** have:
* mode=’kind’
* type=’VI’
* physicalType=’vi’ (Note: the 'vi' code with code system ```http://terminology.hl7.org.au/CodeSystem/location-physical-type``` has been deprecated as it has been replaced by an equivalent term provided by HL7 international.  The 'vi' code with code system ```http://terminology.hl7.org/CodeSystem/location-physical-type``` should be used instead.)

#### Organisation reference
The *managingOrganization* element must contain a relative reference to an existing [PCA Organization](StructureDefinition-pca-organization.html).  Publishing systems can [search for organisations](CapabilityStatement-pca-publisher-agent.html#search-system) using the PCA Publisher Agent API.  After a location has been created, the *managingOrganization* element cannot be changed to reference a different organisation - this functionality will be supported in a future release of PCA.

### Supported interactions
Supported service interactions for this profile are defined in the following capability statements:
* For publishing systems: [PCA Publisher Agent](CapabilityStatement-pca-publisher-agent.html#location)
* For subscribing systems: [PCA Subscriber Agent](CapabilityStatement-pca-subscriber-agent.html#location)
