### Must support
The meaning of the presence or absence of the must support flag is described in [Must support](guidance.html#must-support), except for the following elements:

* For the *id* element: publishing systems creating a PCA Publication Authorisation Record shall not provide this element.  This value is generated by the PCA service.
* For the *meta.versionId* and *meta.lastUpdated* elements: publishing systems creating or updating a PCA Publication Authorisation Record resource shall not provide these elements.  These values are generated by the PCA service.
* For the *status* element: a publishing system is not permitted to set the *status* element to 'cancelled'.  This value is only set by the PCA service.  When a Contract is provided to a subscribing system the *status* may have a value of either 'executed', 'revoked' or 'cancelled'.

### Extensions
No extensions have been introduced in this profile.

### Usage notes

For publishing systems:

* To authorise publication, use the 'executed' value for the status element.
* To revoke an existing publication authorisation, use the 'revoked' value for the status element.

For subscribing systems:

* The presence of a Contract resource whose status = 'executed' represents a decision to authorise publication of the subject of the Contract (either a [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) or [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html)).
* The presence of a Contract resource whose status = 'revoked' represents a decision to revoke an existing publication authorisation for the subject of the Contract (either a [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) or [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html)).

For publishing and subscribing systems:

* The presence of a Contract resource with a status of 'cancelled' indicates that the associated [PCA Partner Service](StructureDefinition-pca-partner-service.html) has been made inactive and the subject of the Contract (either a [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) or [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html)) is not currently being published to that inactive [PCA Partner Service](StructureDefinition-pca-partner-service.html).

### Supported interactions
Supported service interactions for this profile are defined in the following capability statements:
* For publishing systems: [PCA Publisher Agent](CapabilityStatement-pca-publisher-agent.html#contract)
* For subscribing systems: [PCA Subscriber Agent](CapabilityStatement-pca-subscriber-agent.html#contract)
 