The PCA service provides a number of APIs to support integration between authorised client systems and the PCA.  

Please note that some functionality (such as initially registering a participating organisation or managing user roles) is only available via the PCA Portal.

### Identity and Access Manager 
[View the PCA Identity and Access Manager API specification](security.html)

The *PCA Identity and Access Manager* implements an OAuth 2.0 authorization server in order to issue access tokens to a client system.  These access tokens are required in order to invoke operations of other PCA APIs.

PCA API access tokens represent permissions that are determined from the current set of *Authorisations* stored by the *PCA Identity and Access Manager* for a particular client system.  

Currently, client applications are only permitted by the PCA service operator to use system-based authorisation (that is, applications invoke PCA API operations independently of a PCA user session).

### PCA Publisher Agent
[View the PCA Publisher Agent API specification](CapabilityStatement-pca-publisher-agent.html)

The *PCA Publisher Agent* is a FHIR API used by authorised publishing systems to interact with the PCA service.

The *PCA Publisher Agent* is used to create and manage the service offerings (including any associated location information) for one participating publisher organisation, and to authorise (and revoke) the publication of service offerings to partner services provided by subscribing organisations.

The PCA service instantiates one *PCA Publisher Agent* for each participating publisher organisation. That is, each publisher organisation interacts with a *PCA Publisher Agent* located at a publisher agent base URL that is unique to their organisation.

### PCA Subscriber Agent
[View the PCA Subscriber Agent API specification](CapabilityStatement-pca-subscriber-agent.html)

The *PCA Subscriber Agent* is a FHIR API used by authorised subscribing systems to interact with the PCA service.

The *PCA Subscriber Agent* is used to retrieve any new or changed service offerings that have been authorised for publication to one or more partner services associated with a participating subscriber organisation.  It can also be used to register a client system to receive notifications from the PCA service when new or updated service offerings are available, or when the publication of existing service offerings has been newly revoked.

The PCA service instantiates one *PCA Subscriber Agent* for each participating subscriber organisation. That is, each subscriber organisation interacts with a *PCA Subscriber Agent* located at a subscriber agent base URL that is unique to their organisation.

### System of Record Agent
The *PCA System of Record Agent* API allows client systems to find and validate addresses, Australian Business Numbers, Ahpra numbers and identifiers from the Healthcare Identifiers (HI) service without needing to integrate directly with the various external systems of records.

An organisation must authorise the PCA Operator to act as their Contracted Service Provider (CSP) in order for the *PCA System of Record Agent* to access the HI service - this can be done via the PCA Portal.

**Please note: the *PCA System of Record Agent* API specification will be made available in a future release of PCA.**

<br/>
