<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile AUBaseHealthcareService
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:HealthcareService</sch:title>
    <sch:rule context="f:HealthcareService">
      <sch:assert test="count(f:extension[@url = 'http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-postal-address']) &lt;= 1">extension with URL = 'http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-postal-address': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-referral-information-for-consumer']) &lt;= 1">extension with URL = 'http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-referral-information-for-consumer': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-referral-information-for-provider']) &lt;= 1">extension with URL = 'http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-referral-information-for-provider': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-new-patient-availability']) &gt;= 1">extension with URL = 'http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-new-patient-availability': minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-new-patient-availability']) &lt;= 1">extension with URL = 'http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-new-patient-availability': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-active-period']) &lt;= 1">extension with URL = 'http://pca.digitalhealth.gov.au/fhir/4.0/StructureDefinition/pca-active-period': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:active) &gt;= 1">active: minimum cardinality of 'active' is 1</sch:assert>
      <sch:assert test="count(f:providedBy) &gt;= 1">providedBy: minimum cardinality of 'providedBy' is 1</sch:assert>
      <sch:assert test="count(f:type) &gt;= 1">type: minimum cardinality of 'type' is 1</sch:assert>
      <sch:assert test="count(f:location) &gt;= 1">location: minimum cardinality of 'location' is 1</sch:assert>
      <sch:assert test="count(f:location) &lt;= 1">location: maximum cardinality of 'location' is 1</sch:assert>
      <sch:assert test="count(f:name) &gt;= 1">name: minimum cardinality of 'name' is 1</sch:assert>
      <sch:assert test="count(f:serviceProvisionCode) &gt;= 1">serviceProvisionCode: minimum cardinality of 'serviceProvisionCode' is 1</sch:assert>
      <sch:assert test="count(f:serviceProvisionCode) &lt;= 1">serviceProvisionCode: maximum cardinality of 'serviceProvisionCode' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:HealthcareService/f:type</sch:title>
    <sch:rule context="f:HealthcareService/f:type">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:extension[@url = 'http://hl7.org/fhir/StructureDefinition/iso21090-preferred']) &lt;= 1">extension with URL = 'http://hl7.org/fhir/StructureDefinition/iso21090-preferred': maximum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:text) &lt;= 1">text: maximum cardinality of 'text' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:HealthcareService/f:telecom</sch:title>
    <sch:rule context="f:HealthcareService/f:telecom">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:system) &lt;= 1">system: maximum cardinality of 'system' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:use) &lt;= 1">use: maximum cardinality of 'use' is 1</sch:assert>
      <sch:assert test="count(f:rank) &lt;= 1">rank: maximum cardinality of 'rank' is 1</sch:assert>
      <sch:assert test="count(f:period) &lt;= 1">period: maximum cardinality of 'period' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:HealthcareService/f:eligibility</sch:title>
    <sch:rule context="f:HealthcareService/f:eligibility">
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:HealthcareService/f:availableTime/f:availableStartTime</sch:title>
    <sch:rule context="f:HealthcareService/f:availableTime/f:availableStartTime">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.au/fhir/StructureDefinition/au-timezone']) &lt;= 1">extension with URL = 'http://hl7.org.au/fhir/StructureDefinition/au-timezone': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:HealthcareService/f:availableTime/f:availableEndTime</sch:title>
    <sch:rule context="f:HealthcareService/f:availableTime/f:availableEndTime">
      <sch:assert test="count(f:extension[@url = 'http://hl7.org.au/fhir/StructureDefinition/au-timezone']) &lt;= 1">extension with URL = 'http://hl7.org.au/fhir/StructureDefinition/au-timezone': maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
