### Must support
The meaning of the presence or absence of the must support flag is described in [Must support](guidance.html#must-support), except for the following elements:
* For the *identifier:pca-pri* element: publishing systems creating a new PCA Practitioner Role resource shall not provide this element. This identifier is generated by the PCA service.
* For the *active* element: publishing systems creating or updating a PCA Practitioner Role resource shall not provide this element.  This value is calculated by the PCA service at the time the PCA Practitioner Role resource is provided to a subscribing system.  See the 'Period' section in the usage notes below for more information.
* For the *organization* and *location* elements: where a publishing system provides values for these elements the values will be ignored. When a PCA Practitioner Role is provided to a subscribing system the values for these elements are populated as per the referenced *healthcareService*. Subscribing systems can ignore these values, but may find them useful to simplify queries.
* For the *code:practitionerRole* element: please see the usage notes section below for how this element should be populated by publishing systems and what values will be provided to subscribing systems.
* For the *pca-bank-account* extension: any values provided by publishing systems when adding or updating a PCA Practitioner Role will be ignored by the PCA service.  Bank account details must be managed by a healthcare provider organisation via the PCA Portal. The PCA service will populate the extension when providing the PCA Practitioner Role resource to subscribing systems.

### Extensions
Extensions introduced in this profile:
* PractitionerRole: [PCA Bank Account](StructureDefinition-pca-bank-account.html)
* PractitionerRole: [PCA PBS Prescriber Number](StructureDefinition-pca-pbs-prescriber-number.html)
* PractitionerRole: [PCA Preferred Name](StructureDefinition-pca-preferred-name.html)
* PractitionerRole: [PCA Practitioner Role Communication](StructureDefinition-pca-practitioner-role-communication.html)
* PractitionerRole.code: [Preferred](http://hl7.org/fhir/R4/extension-iso21090-preferred.html)

### Usage notes

#### Identifiers
The PCA Practitioner Role profile explicitly supports the following identifier slice (as indicated by the must support flag):
* PCA Medicare Provider Number
* AU Ahpra Registration Number
* PCA Practitioner Role Identifier (PCA-PRI)

A PCA Practitioner Role resource may also have additional identifiers specific to other PCA business partners, and their identifier systems may or may not match other identifier slices defined in [AU Base Practitioner Role](http://hl7.org.au/fhir/4.1.0/StructureDefinition-au-practitionerrole.html).

#### Practitioner Role
To indicate the primary code of the practitioner role, use the *iso21090-preferred* extension on the *code:PractitionerRole* element.

For the *code:practitionerRole* element: a publishing system is required to provide a single code that represents the primary practitioner role type (by using the ‘iso21090-preferred’ extension). Any other values for the *practitionerRole* element will be ignored. When a PractitionerRole is provided to a subscribing system the values for the *code:practitionerRole* element are populated with the primary practitioner role type (through the presence of the of the ‘iso21090-preferred’ extension), as well as any parent terms of the primary practitioner role type term in the SNOMED hierarchy, up to but not including direct descendants of 223366009 - Healthcare Professional.

#### Period
The PCA calculates the *active* element based on the *period* element at the time the PCA Practitioner Role resource is provided to a subscribing system.  
* If *period* is not present, or if *period* is present with a start date in the past and/or an end date in the future, the PCA service sets the *active* element to 'true'.
* If *period* is present with a a start date in the future or an end date in the past, the PCA service sets the *active* element to 'false'.
* If the *active* element of the associated *healthcareService* is 'false', then the PCA service sets the *active* element to 'false' regardless of the *period* value.

In addition to the invariants defined in this profile, the PCA service applies the following additional validation rules for *pca-active-period*:
* If present, *period.start* SHALL be equal to, or later than, the *pca-active-period.value[x].start* value (if present) of the ```HealthcareService``` referenced by the *healthcareService* element.    
* If present, *period.end* SHALL be equal to, or earlier than, the *pca-active-period.value[x].end* value (if present) of the ```HealthcareService``` referenced by the *healthcareService* element.    

#### Practitioner reference
The *practitioner* element must contain a relative reference to a [PCA Practitioner](StructureDefinition-pca-practitioner.html).  Publishing systems can [search for practitioners](CapabilityStatement-pca-publisher-agent.html#search-type-1) using the PCA Publisher Agent API.  After a practitioner role has been created, the *practitioner* element cannot be changed to reference a different practitioner.

#### Practitioner reference
The *healthcareService* element must contain a relative reference to an existing [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html).  Publishing systems can [create new healthcare services](CapabilityStatement-pca-publisher-agent.html#create-1) or [search for existing healthcare services](CapabilityStatement-pca-publisher-agent.html#search-system) using the PCA Publisher Agent API.    After a practitioner role has been created, the *healthcareService* element cannot be changed to reference a different healthcare service.

### Supported interactions
Supported service interactions for this profile are defined in the following capability statements:
* For publishing systems: [PCA Publisher Agent](CapabilityStatement-pca-publisher-agent.html#practitionerrole)
* For subscribing systems: [PCA Subscriber Agent](CapabilityStatement-pca-subscriber-agent.html#practitionerrole)

