### Must support
The meaning of the presence or absence of the must support flag is described in [Must support](guidance.html#must-support).

### Extensions
No extensions have been introduced in this profile.

### Usage notes
A Provenance resource whose target element references a PCA Organization resource records an initial retrieval, update or verification activity for the following elements:

* Where the entity used as the source of the Provenance activity (i.e. entity.what) is 'Australian Business Register (ABR)':
    * Organization.identifier (AUAustralianBusinessNumber profile)
    * Organization.name
    * Organization.alias
* Where the entity used as the source of the Provenance activity (i.e. entity.what) is 'Healthcare Identifiers (HI) Service'
    * Organization.identifier (AUHPIO profile)
    * Organization.name

A Provenance resource whose target element references a PCA Practitioner resource records an initial retrieval, update or verification activity for the following elements:

* Where the entity used as the source of the Provenance activity (i.e. entity.what) is 'Australian Health Practitioner Regulation Agency (Ahpra)'
    * Practitioner.identifier (AUAhpraRegistrationNumber profile)
    * Practitioner.name
* Where the entity used as the source of the Provenance activity (i.e. entity.what) is 'Healthcare Identifiers (HI) Service':
    * Practitioner.identifier (AUHPII profile)

For each Provenance resource created by the the PCA service, the agent.who element will include a contained Organization resource with the following fixed values:

* Organization.name: 'Provider Connect Australia'
* Organization.identifier: '84425496912' (i.e. the ABN of Australian Digital Health Agency)

### Supported interactions
Supported service interactions for this profile are defined in the following capability statements:
* For publishing systems: [PCA Publisher Agent](CapabilityStatement-pca-publisher-agent.html#provenance)
* For subscribing systems: [PCA Subscriber Agent](CapabilityStatement-pca-subscriber-agent.html#provenance)
 
