The extensions listed below form part of this implementation guide.
<table class="list" width="100%">
    <tr>
        <th>Extension</th>
        <th>id</th>
        <th>Type</th>
        <th>Context</th>
    </tr>
	<tr>
        <td><a href="StructureDefinition-pca-active-in-system-of-record.html">PCA Active In System Of Record</a></td>
        <td>pca-active-in-system-of-record</td>
        <td>(complex)</td>
        <td><a href="http://hl7.org/fhir/R4/organization.html">Organization</a>, <a href="http://hl7.org/fhir/R4/practitioner.html">Practitioner</a></td>
    </tr>
	<tr>
        <td><a href="StructureDefinition-pca-active-period.html">PCA Active Period</a></td>
        <td>pca-active-period</td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#period">Period</a></td>
        <td><a href="http://hl7.org/fhir/R4/healthcareservice.html">HealthcareService</a></td>
    </tr>
    <tr>
        <td><a href="StructureDefinition-pca-amenity.html">PCA Amenity</a></td>
        <td>pca-amenity</td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#CodeableConcept">CodeableConcept</a></td>
        <td><a href="http://hl7.org/fhir/R4/location.html">Location</a></td>
    </tr>
	<tr>
        <td><a href="StructureDefinition-pca-available-time-applicability.html">PCA Available Time Applicability</a></td>
        <td>pca-available-time-applicability</td>
        <td>(complex)</td>
        <td><a href="http://hl7.org/fhir/R4/healthcareservice.html">HealthcareService</a></td>
    </tr>
	<tr>
        <td><a href="StructureDefinition-pca-bank-account.html">PCA Bank Account</a></td>
        <td>pca-bank-account</td>
        <td>(complex)</td>
        <td><a href="http://hl7.org/fhir/R4/healthcareservice.html">HealthcareService</a>, <a href="http://hl7.org/fhir/R4/practitionerrole.html">PractitionerRole</a></td>    
    </tr>
	<tr>
        <td><a href="StructureDefinition-pca-current-information-use-statement.html">PCA Current Information Use Statement</a></td>
        <td>pca-current-information-use-statement</td>
        <td><a href="http://hl7.org/fhir/R4/references.html#Reference">Reference</a></td>
        <td><a href="http://hl7.org/fhir/R4/healthcareservice.html">HealthcareService</a></td>
    </tr>
	<tr>
        <td><a href="StructureDefinition-pca-description.html">PCA Description</a></td>
        <td>pca-description</td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#string">string</a></td>
        <td><a href="http://hl7.org/fhir/R4/element.html">Element</a></td>
    </tr>
    <tr>
        <td><a href="StructureDefinition-pca-iar-levels-of-care.html">PCA IAR Levels of Care</a></td>
        <td>pca-iar-levels-of-care</td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#CodeableConcept">CodeableConcept</a></td>
        <td><a href="http://hl7.org/fhir/R4/healthcareservice.html">HealthcareService</a></td>
    </tr>
	<tr>
        <td><a href="StructureDefinition-pca-medicareprovidernumber-status.html">PCA Medicare Provider Number Status</a></td>
        <td>pca-medicareprovidernumber-status</td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#Coding">Coding</a></td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#Identifier">Identifier</a></td>
    </tr>
	<tr>
        <td><a href="StructureDefinition-pca-new-patient-availability.html">PCA New Patient Availability</a></td>
        <td>pca-new-patient-availability</td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#CodeableConcept">CodeableConcept</a></td>
        <td><a href="http://hl7.org/fhir/R4/healthcareservice.html">HealthcareService</a></td>
    </tr>    
    <tr>
        <td><a href="StructureDefinition-pca-part-of-legal-entity.html">PCA Part Of Legal Entity</a></td>
        <td>pca-part-of-legal-entity</td>
        <td><a href="http://hl7.org/fhir/R4/references.html#Reference">Reference</a></td>
        <td><a href="http://hl7.org/fhir/R4/organization.html">Organization</a></td>
    </tr>
	<tr>
        <td><a href="StructureDefinition-pca-pbs-prescriber-number.html">PCA PBS Prescriber Number</a></td>
        <td>pca-pbs-prescriber-number</td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#Identifier">Identifier</a></td>
        <td><a href="http://hl7.org/fhir/R4/practitionerrole.html">PractitionerRole</a></td>
    </tr>
    <tr>
        <td><a href="StructureDefinition-pca-postal-address.html">PCA Postal Address</a></td>
        <td>pca-postal-address</td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#Address">Address</a></td>
        <td><a href="http://hl7.org/fhir/R4/healthcareservice.html">HealthcareService</a>, <a href="http://hl7.org/fhir/R4/location.html">Location</a></td>
    </tr>
    <tr>
        <td><a href="StructureDefinition-pca-practitioner-role-communication.html">PCA Practitioner Role Communication</a></td>
        <td>pca-practitioner-role-communication</td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#CodeableConcept">CodeableConcept</a></td>
        <td><a href="http://hl7.org/fhir/R4/practitionerrole.html">PractitionerRole</a></td>
    </tr>
    <tr>
        <td><a href="StructureDefinition-pca-preferred-name.html">PCA Preferred Name</a></td>
        <td>pca-preferred-name</td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#HumanName">HumanName</a></td>
        <td><a href="http://hl7.org/fhir/R4/practitionerrole.html">PractitionerRole</a></td>
    </tr>
    <tr>
        <td><a href="StructureDefinition-pca-property-name.html">PCA Property Name</a></td>
        <td>pca-property-name</td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#string">string</a></td>
        <td><a href="https://hl7.org/fhir/R4/backboneelement.html">BackboneElement</a></td>
    </tr>
	<tr>
        <td><a href="StructureDefinition-pca-referral-information-for-consumer.html">PCA Referral Information For Consumer</a></td>
        <td>pca-referral-information-for-consumer</td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#markdown">markdown</a></td>
        <td><a href="http://hl7.org/fhir/R4/healthcareservice.html">HealthcareService</a></td>
    </tr>
	<tr>
        <td><a href="StructureDefinition-pca-referral-information-for-provider.html">PCA Referral Information For Provider</a></td>
        <td>pca-referral-information-for-provider</td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#markdown">markdown</a></td>
        <td><a href="http://hl7.org/fhir/R4/healthcareservice.html">HealthcareService</a></td>
    </tr>
	<tr>
        <td><a href="StructureDefinition-pca-service-provision-capacity.html">PCA Service Provision Capacity</a></td>
        <td>pca-service-provision-capacity</td>
        <td><a href="http://hl7.org/fhir/R4/datatypes.html#string">string</a></td>
        <td><a href="http://hl7.org/fhir/R4/practitionerrole.html">PractitionerRole</a></td>
    </tr>
 </table>