The Provider Connect Australia (PCA) service is a hosted service that is intended to assist organisations that provide healthcare or related services to maintain accurate information about their various service offerings, and to make that information available to partner services of their choice who are also registered with the PCA service (e.g. directories operated by other organisations). 

There are two roles available to organisations that choose to participate in the PCA service:
* **Publishers**
* **Subscribers**

The same organisation may be both a publisher and a subscriber.

The PCA service stores service offering resources (e.g. ```HealthcareService``` and ```PractitionerRole``` and their associated ```Organization```, ```Practitioner``` and ```Location``` resources) that are created by publishers and distributes them to all the partner services that are authorised to receive them by the publisher.

A subscriber can operate one or more partner services and the publisher must authorise publication individually for each partner service. 

A publisher can either create & maintain their service offerings via the PCA portal, or they may integrate their own systems with the Publisher Agent FHIR API.

A subscriber receives copies of the resources, which one or more of their partner services are authorised to receive, as bundles of FHIR resources in response to FHIR search operations. 
They can search for new or changed resources on a schedule that they determine, they can also subscribe to receive notifications whenever new or changed resources are available to them. 

See [PCA API](pcaAPI.html) for more details.

### Conventions

#### Must support
Must support is inherited by elements from their parents except in the following cases: extensions, modifier extensions and children of resource, meta or backbone element. This may be overridden explicitly. So, must support on an element 

* when it is resource, meta or a backbone element, **does not** apply to any children;
* when it is neither resource, meta nor a backbone element, applies to all children, other than extension and modifier extension, e.g. for Observation.code it applies to id, coding and text, but not to extension;
* when it has more than one data type, profile, target profile or slice, applies to all data types, profiles, target profiles and slices;
* when it is an extension or modifier extension, applies to its children normally;
* when it is a reference with a value for reference, **does not** apply to the referenced resource. A resource is not an element.

In profiles that represent published organisation information, **the presence of 'must support'** on any data element shall be interpreted as follows:

* For a publishing system providing the data element to the PCA service: the PCA service will publish the data element to subscribing systems.
* For a subscribing system receiving the data element from the PCA service: the PCA service will include the data element if it is available. Subscribing systems are not obliged to process the data element.

In profiles that **do not** represent published organisation information, **the presence of ‘must support’** on any data element shall be interpreted as follows:

* For a subscribing system providing the data element to the PCA service: the PCA service will process the data element.
* For a publishing or subscribing system receiving the data element from the PCA service: the PCA service will include the data element if it is available.

In **all** profiles, **the absence of ‘must support’** on any data element shall be interpreted as follows:

* For a publishing system providing the data element to the PCA service: the PCA service will ignore the data element. If the data element is in a profile that represents published organisation information, the PCA service will not publish the data element to subscribing systems.
* For a subscribing system providing the data element to the PCA service: the PCA service will ignore the data element.
* For a subscribing system receiving the data element from the PCA service: the PCA service will never include the data element.

<br/>

### Third party extensions

**Please note: this section and all referenced specifications are under development**

In addition to the extensions specified in the [resource profiles](profiles.html) of this implementation guide (which includes [PCA-defined extensions](extensions.html)), resources retrieved from the PCA service may include additional extensions that are used by third parties to assist in their integration with the PCA service. 

These third party extensions and their definitions are listed below:

<table class="list" width="100%">
    <tr>
        <th>ID</th>
        <th>Name</th>
        <th>Description</th>
        <th>Context</th>
    </tr>
	<tr>
        <td><a href="https://build.fhir.nhsd.healthdirect.org.au/ingestion/StructureDefinition-nhsd-au-address.html">address-identifier</a> (Inline extension) </td>
        <td>Address Identifier</td>
        <td>Inline extension for <em>address</em> element. Published by Healthdirect Australia.</td>
        <td><a href="http://hl7.org/fhir/R4/location.html">Location</a></td>
    </tr>
	<tr>
        <td><a href="https://build.fhir.nhsd.healthdirect.org.au/ingestion/StructureDefinition-nhsd-booking-provider.html">http://fhir.nhsd.com.au/StructureDefinition/nhsd-booking-provider</a></td>
        <td>NHSD Booking Provider</td>
        <td>Extension used to indicate the details of a booking provider offering a URL or ID to support integration or click-throughs for booking pages. Published by Healthdirect Australia.</td>
        <td><a href="http://hl7.org/fhir/R4/healthcareservice.html">HealthcareService</a></td>
    </tr>
	<tr>
        <td><a href="https://build.fhir.nhsd.healthdirect.org.au/ingestion/StructureDefinition-nhsd-address-line.html">http://fhir.nhsd.com.au/StructureDefinition/nhsd-address-line</a> </td>
        <td>NHSD Address Line</td>
        <td>Extension for <em>address</em> element. Published by Healthdirect Australia.</td>
        <td><a href="http://hl7.org/fhir/R4/location.html">Location</a></td>
    </tr>
	<tr>
        <td><a href="https://build.fhir.nhsd.healthdirect.org.au/ingestion/StructureDefinition-nhsd-availability-reason.html">http://fhir.nhsd.com.au/StructureDefinition/nhsd-availability-reason</a> </td>
        <td>NHSD Availability Reason</td>
        <td>Extension used to provide the reason (if due to a public holiday) for the availability or non-availability of a healthcare service.  Published by Healthdirect Australia.</td>
        <td><a href="http://hl7.org/fhir/R4/healthcareservice.html">HealthcareService</a></td>
    </tr>

    </table>

### Third party value sets

**Please note: this section and all referenced value sets are under development**

In addition to the value set binding defined in resource profiles, some published resources may contain codes sourced from third party value sets.  These value sets and their definitions are listed below:

<table class="list" width="100%">
    <tr>
        <th>ID</th>
        <th>Name</th>
        <th>Description</th>
        <th>Binding</th>
    </tr>
	<tr>
        <td><a href="https://build.fhir.nhsd.healthdirect.org.au/ingestion/ValueSet-valueset-au-nhsd-offering.html">http://fhir.nhsd.com.au/ValueSet/valueset-au-nhsd-offering</a></td>
        <td>Healthcare Service supporting services (offerings)</td>
        <td>Additional offerings of a Healthcare Service.  Published by Healthdirect Australia.</td>
        <td><a href="http://hl7.org/fhir/R4/healthcareservice.html">HealthcareService.characteristic</a></td>
    </tr>
	<tr>
        <td><a href="https://build.fhir.nhsd.healthdirect.org.au/ingestion/ValueSet-valueset-au-nhsd-program.html">http://fhir.nhsd.com.au/ValueSet/valueset-au-nhsd-program</a></td>
        <td>Healthcare Service Programs (Funded or Unfunded)</td>
        <td>Programs supported by a Healthcare Service or programs which fund applicable areas of a Healthcare Service.  Published by Healthdirect Australia.</td>
        <td><a href="http://hl7.org/fhir/R4/healthcareservice.html">HealthcareService.program</a></td>
    </tr>
</table>
