

### Introduction

This implementation guide is an HL7<sup>TM</sup> FHIR<sup>&reg;</sup> specification for the APIs offered by the Provider Connect Australia service.  It can be used to develop publishing systems and subscribing systems that integrate with the PCA service.

This [implementation guide](http://hl7.org/fhir/R4/implementationguide.html#scope) is based on [FHIR, Release 4 (v{{ site.data.fhir.version }}) [HL7FHIR4]](#HL7FHIR4).

### Document purpose and scope

The primary aim of this implementation guide is to support implementers of publishing and subscribing systems integrating with the PCA service using [FHIR, Release 4 (v{{ site.data.fhir.version }}) [HL7FHIR4]](#HL7FHIR4).

This implementation guide does not describe presentation of the information, user experience, or expected behaviour of publishing and subscribing systems. Systems cannot connect to the PCA APIs until they have been assessed for conformance to system behaviour requirements. These conformance requirements are available from [https://collaborate.digitalhealth.gov.au/display/SRA/Provider+Connect+Australia+Home](https://collaborate.digitalhealth.gov.au/display/SRA/Provider+Connect+Australia+Home).

Reference has been made to International and Australian Standards, and to Standards from Health Level Seven. The following standards are referred to in the text in such a way that some or all of its content constitutes requirements for the purposes of this specification:
* [FHIR, Release 4 (v{{ site.data.fhir.version }}) [HL7FHIR4]](#HL7FHIR4)
* [Australian Base Profiles Implementation Guide (AU Base 2) [HL7AUBIG]](#HL7AUBIG)

Wherever possible, material in this specification is based on existing standards. All efforts have been made to minimise divergence from the HL7 Australia profiles of HL7 International standards ([Australian Base Profiles Implementation Guide (AU Base 2) [HL7AUBIG]](#HL7AUBIG)) to provide for system interoperability and compatibility with other profiles. Issues of an editorial nature in the source material (such as spelling or punctuation errors) are intentionally reproduced.

### Context and use

This FHIR implementation guide is part of the documentation for the Provider Connect Australia and should be read in conjunction with the remaining documentation available from [https://collaborate.digitalhealth.gov.au/display/SRA/Provider+Connect+Australia+Home](https://collaborate.digitalhealth.gov.au/display/SRA/Provider+Connect+Australia+Home).

The guide includes:
* capability statements and operation definitions for the PCA FHIR interfaces
* structure definitions and terminologies for content exchanged through the PCA FHIR interfaces
* specifications of the PCA non-FHIR interfaces
* a list of known issues (below)

### Intended audience

This implementation guide is aimed at software development teams, architects, and designers of publishing and subscribing systems that integrate with the PCA service.

This implementation guide and related artefacts are technical in nature and the audience is expected to be familiar with the language of health data specifications and to have some familiarity with health information standards and specifications, such as FHIR.

### Document information

#### Key Information

<table class="list" width="100%" cellspacing="6">
 <tbody>
   <tr>
     <td><b>Owner</b></td>
     <td>Product Manager, Connectivity and Informatics</td>
   </tr>
   <tr>
     <td><b>Contact for enquiries</b></td>
     <td>
       <p>Australian Digital Health Agency Help Centre<br />
          t: 1300 901 001<br />
          e: <a href ="mailto:help@digitalhealth.gov.au">help@digitalhealth.gov.au</a></p>    
     </td>
   </tr>
 </tbody>
</table> 

### Known issues

This table lists known issues with this specification at the time of publishing. We are working on solutions to these issues and encourage comments to help us develop these solutions.

<table border="1" cellpadding="1" valign="middle">
 <tbody>
   <col width="15%" />
   <col width="auto" />
   <tr bgcolor="#DCDCDC">
     <th>Reference</th>
     <th>Description</th>
   </tr>
   <tr>
     <td>TBD</td>
     <td>TBD</td>
   </tr>
 </tbody>
</table> 

### References

|[<a name="HL7AUBIG">HL7AUBIG</a>]| HL7 Australia, FHIR R4 standard for AU Base Implementation Guide, v4.1.0 (Standard for Trial Use)|
||[https://hl7.org.au/fhir/4.1.0/index.html](https://hl7.org.au/fhir/4.1.0/index.html)|  

|[<a name="HL7FHIR4">HL7FHIR4</a>]|Health Level Seven, Inc., 30 October 2019, FHIR R4.|
||[http://hl7.org/fhir/R4/](http://hl7.org/fhir/R4/)|
