### Introduction

The PCA servers (see [PCA API](pcaAPI.html)) are OAuth 2.0 *resource servers*. That is, PCA API clients require valid OAuth 2.0 access tokens.
 
The PCA API access tokens are issued by the PCA Identity and Access Manager - i.e. it implements an OAuth 2.0 *authorization server*. 
The PCA Identity and Access Manager issues PCA API access tokens in accordance with two patterns:
1.	**user-based** authorisation - in this pattern applications invoke PCA API operations in the context of active PCA user sessions.
2.	**system-based** authorisation - in this pattern applications invoke PCA API operations independently of a PCA user session.

In both patterns, a PCA API access token represents the permissions that the PCA Identity and Access Manager determines for the subject (user or system) at the time when that token is presented i.e. when a PCA API operation is invoked.  It determines these permissions from the current set of *Authorisations* stored by the PCA Identity and Access Manager for the subject (see <a href="pcaIAM.html#role-based-authorisation-model">below</a>).
	
A client application  must be a ‘confidential’ client as described in <a href="https://tools.ietf.org/html/rfc6749#section-2.1">section 2.1 of RFC 6749</a>.  **Public clients are not supported by PCA**.

All client systems must be registered via the <a href="pcaIAM.html#register-endpoint">register endpoint</a>. 

### User-based authorisation 

In user-based authorisation, the users must be authenticated by PRODA before they will be granted authorization codes by the PCA Identity and Access Manager. That is, as well as implementing an OAuth2.0 authorization server, the PCA Identity and Access Manager also implements an OpenId Connect client of PRODA.
<br/>
<br/>
The PCA user-based authorisation pattern is aligned with the <a href="http://hl7.org/fhir/smart-app-launch/scopes-and-launch-context.html">SMART on FHIR</a> approach.
The SMART on FHIR OAuth2.0 access token *scopes* are, however, insufficient to model the <a href="pcaIAM.html#role-based-authorisation-model">role based authorisation model</a> which is used for PCA operations. Note that PCA API access token *scopes* (see <a href="pcaIAM.html#pca-api-access-token-scope">below</a>), unlike SMART on FHIR scopes, may depend on resource instances, e.g.  "read-only access to all HealthcareServices associated with a particular Location".

The following diagram shows a typical sequence by which a client system accesses a PCA API under user-based authorisation.
<div>
<img src="images/user_auth.png" width="80%" height="80%"/>
</div>
<br/>
#### Steps
1. The user of a PCA API client system triggers a function that requires the client system to invoke a PCA API.
2. The user (via a HTTP *user-agent* ) requests an authorization code from the authorization endpoint of the PCA Identity and Access Manager (which is acting as an OAuth2.0 *authorization server*).
    * note that, depending on its architecture, the client system may need to launch this HTTP user-agent.
3. The PCA Identity and Access Manager (now acting as a OpenIDConnect client of PRODA) redirects the user-agent to the PRODA authorization endpoint and requests a PRODA authorization code.
4. User authenticates to PRODA. 
5. PRODA provides the PRODA authorization code to the PCA Identity and Access Manager via the OAuth2.0 *authorization code* grant type.
6. The PCA Identity and Access Manager requests PRODA for UserInfo access and identity tokens (providing the PRODA authorization code).
7. If PRODA successfully authenticates the PCA Identity and Access Manager, and validates the PRODA authorization code, it responds with the requested PRODA UserInfo access and identity tokens.
8. If the PCA Identity and Access Manager can match the PRODA user identity to one of its existing PCA user identities, then it returns a PCA API authorization code (linked to that PCA user identity) to the user-agent.
9. The user-agent receives the PCA API authorization code and passes this to the client system via the OAuth2.0 *authorization code* grant type.
10. The client system requests a PCA API access token from the <a href="pcaIAM.html#token-endpoint">token endpoint</a> of the PCA Identity and Access Manager (providing the PCA API authorization code).
11. If the PCA Identity and Access Manager successfully authenticates the client system, and validates the PCA API authorization code, it responds with a PCA API access token. 
12. The client system makes a request of a PCA Server and provides the PCA API access token.
13. The PCA Server queries the <a href="pcaIAM.html#introspect-endpoint">introspect endpoint</a> of the PCA Identity and Access Manager to validate the PCA API access token and to obtain the *scope* of this access token (this scope is set by the PCA Identity and Access Manager to reflect the current set of authorizations of the user that is associated with the authorization code in step 8). 
14. The PCA  Server either grants or rejects the client system request based on the *status* and *scope* obtained from the <a href="pcaIAM.html#introspect-endpoint">introspect endpoint</a>.
  
<div>
</div>

### System-based authorisation
In system-based authorisation, a client system uses the OAuth 2.0 *client credentials* grant type to request PCA API access tokens.
The PCA Identity and Access Manager issues access tokens to client systems in accordance with the authorisation settings for the particular client system that were previously created by authorised users via the PCA portal.
The PCA system-based authorisation pattern is aligned with the <a href="http://www.hl7.org/fhir/smart-app-launch/backend-services.html">SMART Backend Services: Authorization Guide</a>. 
A key element of this approach is that client system credentials are represented as JWT tokens that the client system signs using a private key which is not disclosed to the authorization server.
The SMART Backend Services approach is profiled for PCA as described below:
+ PCA OAuth 2.0 access token *scopes* implement role based authorisations that are appropriate for the PCA operations (which support administrative, rather than clinical, workflows). The PCA role based authorisation model is described <a href="pcaIAM.html#role-based-authorisation-model">below</a>.
+ PCA requires client systems to dynamically register themselves using the <a href="pcaIAM.html#register-endpoint">register endpoint</a> of the PCA Identity and Access Manager.
+ PCA allows client systems to de-register themselves using the <a href="pcaIAM.html#client-configuration-endpoint">client configuration endpoint</a> of the PCA Identity and Access Manager (the URL of this endpoint is provided in the response to the registration request).  
+ PCA requires client systems to provide their public key, or a URL at which it can be found, to the PCA service at registration time. 
+ If a client system provides the public key then any subsequent change of keys requires a client system to be de-registered and then re-registered (and be issued a new client id though the registration process).  The PCA Operator will be able to 'replace' a client system's authorisations to avoid users having to re-authorize the new client system id. 

The following diagram shows a typical sequence by which a client system accesses a PCA API under system-based authorisation.
<div>
<img src="images/system_auth.png" width="80%" height="80%"/>
</div>

The sequence has the following steps:
1. The client system creates a signed JSON Web Token which identifies itself and is signed with a RSA private key (having provided the corresponding RSA public key, or its URL, to the PCA Identity and Access Manager when the client system was <a href="pcaIAM.html#register-endpoint">registered</a> as an OAuth 2.0 client system).
2. The client system requests a PCA API access token from the <a href="pcaIAM.html#token-endpoint">token endpoint</a> of the PCA Identity and Access Manager  (providing the signed JWT).
3. If the PCA Identity and Access Manager successfully authenticates the client system it responds with a PCA API access token. 
4. The client system makes a request of a PCA API and provides the PCA API access token.
5. The PCA  Server queries the <a href="pcaIAM.html#introspect-endpoint">introspect endpoint</a> of the PCA Identity and Access Manager to validate the PCA API access token and to obtain the *scope* of this access token (this scope is set by the PCA Identity and Access Manager to reflect the current set of authorisations of the client system). 
6. The PCA  Server either grants or rejects the client system request based on the *status* and *scope* obtained from the <a href="pcaIAM.html#introspect-endpoint">introspect endpoint</a>.

### Role based authorisation model
Underpinning  both *user-based* and *system-based* authorisation is the PCA 'role based authorisation' model. This model is outlined in the following UML class diagram.
<div>
<img src="images/authorisation.png" width="80%" height="80%"/>
</div>
<br/>

As shown above, *Authorisation* specifies a *roleType* that the associated *Subject* (either a PCAUser or a ClientSystem) can perform on a set of FHIR resources that are 'contained by' the *<em>scopingObject</em>*.

The *roleType*  attribute of an *Authorisation* is a coded value from the <a href="CodeSystem-pca-security-role-type.html">security role code system.</a> **Currently, client applications are only permitted by the PCA service operator to use system-based authorisation, so the security role code system is currently limited to system-based role types.**

The various *roleTypes* used by system-based authorisation, and their use in *Authorisations*, are described in the following table:

<table border="1">
<thead> <tr>
<td rowspan="2"><b>RoleType code</b></td>
<td rowspan="2"><b>Description</b></td>
<td rowspan="2"><b>Type of associated <em>scopingObject</em></b></td>
<td colspan="2"><b>Required Authorisation to manage the assignment of a target Authorisation with this roleType</b></td>
</tr>
<tr>
<td><b>RoleType of required Authorisation</b></td>
<td><b><em>scopingObject</em> of required Authorisation</b></td>
</tr>
</thead> <tbody>
<tr>
<td rowspan="2">PS_Read</td>
<td rowspan="2">The <b>PS_Read</b> <em>roleType</em>
models a set of permissions that are assigned to
systems acting on behalf of publishers, which require
read-only access to either:
<ul>
<li>a specific healthcare service (identified by the
HealthcareService <em>scopingObject</em>), or</li>
<li>a location and all the healthcare services provided at
that location (identified by the associated Location <em>scopingObject</em>), or</li>
<li>all the locations and healthcare services provided by
an organisation (identified by the Organisation <em>scopingObject</em>), 
including healthcare services provided
by any of its subordinate organisations.</li>
</ul>
The target set of objects to which access is granted is
determined by the <em>scopingObject</em>. </td>
<td rowspan="2"> 
<ul>
<li><a href="StructureDefinition-pca-healthcare-service.html">PCA Healthcare Service</a></li>
<li><a href="StructureDefinition-pca-location.html">PCA Location</a></li>
<li><a href="StructureDefinition-pca-organization.html">PCA Organization</a></li>
</ul>
</td>
<td>OrganisationManager</td>
<td>
<ul>
<li>The HealthcareService <em>scopingObject</em> must be a
healthcare service provided by an organisation they
manage</li>
<li>The Location <em>scopingObject</em> must be associated with an
organisation they manage</li>
<li>The Organisation <em>scopingObject</em> must be an
organisation they manage</li>
</ul>
</td>
</tr>
<tr>
<td>HealthcareServiceManager</td>
<td>
<ul>
<li>The HealthcareService <em>scopingObject</em> must be a
healthcare service they manage (i.e. a healthcare
service their HealthcareServiceManager role is scoped
to, or a healthcare service provided by an organisation
their HealthcareServiceManager role is scoped to or a
subordinate organisation)</li>
<li>The Location <em>scopingObject</em> must be a location they
manage (i.e. a location their HealthcareServiceManager
role is scoped to, or a location provided by an
organisation their HealthcareServiceManager role is
scoped to or a subordinate organisation)</li>
<li>The Organisation <em>scopingObject</em> must be an
organisation they manage</li>
</ul>
</td>
</tr>
<tr>
<td rowspan="2">PS_ServicesMgr</td>
<td rowspan="2">The <b>PS_ServicesMgr</b> <em>roleType</em>
models a set of permissions that are assigned to systems,
acting on behalf of publishers, that manage either:
<ul>
<li>a specific healthcare service (identified by the
HealthcareService <em>scopingObject</em>), or;</li>
<li>all the locations and healthcare services provided by
an organisation (identified by the Organisation <em>scopingObject</em>),
including healthcare services provided by any
of its subordinate organisations, or;</li>
<li>a location and all the healthcare services provided at
that location (identified by the associated Location
<em>scopingObject</em>)</li>
</ul>
The target set of objects to which access is granted is
determined by the <em>scopingObject</em>.</td>
<td rowspan="2">
<ul>
<li><a href="StructureDefinition-pca-healthcare-service.html">PCA Healthcare Service</a></li>
<li><a href="StructureDefinition-pca-location.html">PCA Location</a></li>
<li><a href="StructureDefinition-pca-organization.html">PCA Organization</a></li>
</ul>
</td>
<td>OrganisationManager</td>
<td>
<ul>
<li>The HealthcareService <em>scopingObject</em> must be a
healthcare service provided by an organisation they
manage </li>
<li>The Organisation <em>scopingObject</em> must be an
organisation they manage </li>
<li>The Location <em>scopingObject</em> must be associated with an
organisation they manage </li>
</ul>
</td>
</tr>
<tr>
<td>HealthcareServiceManager</td>
<td>
<ul>
<li>The HealthcareService <em>scopingObject</em> must be a
healthcare service they manage (i.e. a healthcare
service their HealthcareServiceManager role is scoped
to, or a healthcare service provided by an organisation
their HealthcareServiceManager role is scoped to, or a
subordinate organisation)</li>
<li>The Location <em>scopingObject</em> must be a location they
manage (i.e. a location their HealthcareServiceManager
role is scoped to, or a location provided by an
organisation their HealthcareServiceManager role is
scoped to or a subordinate organisation)</li>
<li>The Organisation <em>scopingObject</em> must be an
organisation they manage</li>
</ul>
</td>
</tr>
<tr>
<td rowspan="2">PS_IdentifierUpdater</td>
<td rowspan="2">The <b>PS_IdentifierUpdater</b> <em>roleType</em>
models a set of permissions that are assigned to systems,
acting on behalf of publishers, that add and/or update 
subscriber-specific identifiers for either:
<ul>
<li>a specific healthcare service (identified by the
HealthcareService <em>scopingObject</em>), or;</li>
<li>all the locations and healthcare services provided by
an organisation (identified by the Organisation <em>scopingObject</em>),
including healthcare services provided by any
of its subordinate organisations, or;</li>
<li>a location and all the healthcare services provided at
that location (identified by the associated Location
<em>scopingObject</em>)</li>
</ul>
The target set of objects to which access is granted is
determined by the <em>scopingObject</em>.</td>
<td rowspan="2">
<ul>
<li><a href="StructureDefinition-pca-healthcare-service.html">PCA Healthcare Service</a></li>
<li><a href="StructureDefinition-pca-location.html">PCA Location</a></li>
<li><a href="StructureDefinition-pca-organization.html">PCA Organization</a></li>
</ul>
</td>
<td>OrganisationManager</td>
<td>
<ul>
<li>The HealthcareService <em>scopingObject</em> must be a
healthcare service provided by an organisation they
manage </li>
<li>The Organisation <em>scopingObject</em> must be an
organisation they manage </li>
<li>The Location <em>scopingObject</em> must be associated with an
organisation they manage </li>
</ul>
</td>
</tr>
<tr>
<td>HealthcareServiceManager</td>
<td>
<ul>
<li>The HealthcareService <em>scopingObject</em> must be a
healthcare service they manage (i.e. a healthcare
service their HealthcareServiceManager role is scoped
to, or a healthcare service provided by an organisation
their HealthcareServiceManager role is scoped to, or a
subordinate organisation)</li>
<li>The Location <em>scopingObject</em> must be a location they
manage (i.e. a location their HealthcareServiceManager
role is scoped to, or a location provided by an
organisation their HealthcareServiceManager role is
scoped to or a subordinate organisation)</li>
<li>The Organisation <em>scopingObject</em> must be an
organisation they manage</li>
</ul>
</td>
</tr>
<tr>
<td rowspan="2">PS_PractitionerMgr</td>
<td rowspan="2">The <b>PS_PractitionerMgr</b> <em>roleType</em>
models a set of permissions that are assigned to systems
that manage the information about Practitioner roles
associated with:<ul>
<li>a specific healthcare service (identified by the
HealthcareService <em>scopingObject</em>, or;</li>
<li>all the healthcare services provided at a location
(identified by the associated Location <em>scopingObject</em>), or;</li>
<li>all the healthcare services provided by an
organisation (identified by the Organisation <em>scopingObject</em>), 
including healthcare services provided by any
of its subordinate organisations.</li>
</ul>
The target set of objects to which access is granted is
determined by the <em>scopingObject</em>.
</td>
<td rowspan="2">
<ul>
<li><a href="StructureDefinition-pca-healthcare-service.html">PCA Healthcare Service</a></li>
<li><a href="StructureDefinition-pca-location.html">PCA Location</a></li>
<li><a href="StructureDefinition-pca-organization.html">PCA Organization</a></li>
</ul>
</td>
<td>OrganisationManager</td>
<td>
<ul>
<li>The HealthcareService <em>scopingObject</em> must be a
healthcare service provided by an organisation they
manage </li>
<li>The Location <em>scopingObject</em> must be associated with an
organisation they manage </li>
<li>The Organisation <em>scopingObject</em> must be an
organisation they manage </li>
</ul>
</td>
</tr>
<tr>
<td>HealthcareServiceManager</td>
<td>
<ul>
<li>The HealthcareService <em>scopingObject</em> must be a
healthcare service they manage</li>
<li>The Location <em>scopingObject</em> must be a location they
manage (i.e. a location their HealthcareServiceManager
role is scoped to, or a location provided by an
organisation their HealthcareServiceManager role is
scoped to or a subordinate organisation)</li>
<li>The Organisation <em>scopingObject</em> must be an
organisation they manage</li>
</ul>
</td>
</tr>
<tr>
<td rowspan="2">PS_PublicationMgr</td>
<td rowspan="2">The <b>PS_PublicationMgr</b> <em>roleType</em>
models a set of permissions that are assigned to systems
that manage the publication of service offerings (including
providing subscriber-specific identifiers for published
service offerings) provided by the organisation, location or
healthcare service that is identified by the <em>scopingObject</em>,
including service offerings provided by any of its
subordinate organisations.</td>
<td rowspan="2">
<ul>
<li><a href="StructureDefinition-pca-healthcare-service.html">PCA Healthcare Service</a></li>
<li><a href="StructureDefinition-pca-location.html">PCA Location</a></li>
<li><a href="StructureDefinition-pca-organization.html">PCA Organization</a></li>
</ul>
</td>
<td>OrganisationManager</td>
<td>
<ul>
<li>The HealthcareService <em>scopingObject</em> must be a service
offering provided by an organisation they manage </li>
<li>The Location <em>scopingObject</em> must be associated with an
organisation they manage </li>
<li>The Organisation <em>scopingObject</em> must be an
organisation they manage value)</li>
</ul>
</td>
</tr>
<tr>
<td>HealthcareServiceManager</td>
<td>
<ul>
<li>The HealthcareService <em>scopingObject</em> must be a service
offering they manage</li>
<li>The Location <em>scopingObject</em> must be a location they
manage (i.e. a location their HealthcareServiceManager
role is scoped to, or a location provided by an
organisation their HealthcareServiceManager role is
scoped to or a subordinate organisation)</li>
<li>The Organisation <em>scopingObject</em> must be an
organisation they manage</li>
</ul>
</td>
</tr>
<tr>
<td>SS_Updater</td>
<td>The <b>SS_Updater</b> <em>roleType</em>
allows a system operating on behalf of the subscriber
organisation that is identified by the <em>scopingObject</em>, to
update:
<ul>
<li>Subscriber identifiers for subscribing systems owned
by (or shared with) the subscriber organisation</li>
<li>The match status for organisations, healthcare
services, practitioner roles, and locations published to
the subscribing organisation’s partner service/s</li>
</ul>
</td>
<td>
<ul>
<li><a href="StructureDefinition-pca-organization.html">PCA Organization</a></li>
</ul>
</td>
<td>OrganisationManager</td>
<td>
<ul>
<li>The Organisation <em>scopingObject</em> must be the
subscriber’s ParticipatingOrganisation</li>
</ul>
</td>
</tr>
<tr>
<td>SS_Receiver</td>
<td>The <b>SS_Receiver</b> <em>roleType</em> allows a system
operating on behalf of the subscriber organisation that is
identified by the <em>scopingObject</em>, to retrieve service
offerings that have been published to that subscriber
organisation</td>
<td>
<ul>
<li><a href="StructureDefinition-pca-organization.html">PCA Organization</a></li>
</ul>
</td>
<td>OrganizationManager</td>
<td>
<ul>
<li>The Organisation <em>scopingObject</em>
must be the subscriber’s ParticipatingOrganisation</li>
</ul>
</td>
</tr>
</tbody>
</table>


In addition to *roleType*, *Authorisations*  have the following attributes which are all set by the PCA service:
* **lastUpdated**:      The time when the *Authorisation* was last updated.
* **id**:  A unique identifier assigned by the PCA service.
* **approvalStatus**:	Either "approved" or "revoked".

<br/>
### Information requirements
This section contains conformance requirements for exchanging security related information objects over the PCA API.

### PCA API access token 
The PCA API access tokens are opaque “handles” (as defined in <a href="https://tools.ietf.org/html/rfc6819#section-3.1">section 3.1 of RFC 6819</a>). 

A PCA API access token is represented as a string of at least 128 bits that is constructed from a cryptographically strong random or pseudo-random number sequence that conforms to the current practices described in <a href="https://tools.ietf.org/html/rfc4086">RFC 4086</a>.

### PCA API access token *scope*  

In accordance with <a href="https://tools.ietf.org/html/rfc6749#section-3.3">Section 3.3 of RFC 6749</a>, each PCA issued OAuth 2.0 access token has a *scope* that is represented as a JSON string containing a space-separated list of elements. 

If the *Authorisation* has a *<em>scopingObject</em>* then it is represented as follows:

```
    <scopingObject type> / <resource_id>:<roleType>
```	
Where
*  **<em>scopingObject</em> type** is either “organisation”, “location”, “healthcareService”,  or “partnerService”
*  **resource_id** is the FHIR resource id of the <em>scopingObject</em>
*  **roleType**  is a coded value from the <a href="CodeSystem-pca-security-role-type.html">security role code system.</a>

If the *Authorisation* does not have a *<em>scopingObject</em>* then it is represented as follows:	 

``` 
     pca:<roleType> 
```

### Client system credential
Client systems authenticate themselves to the OAuth2 endpoints implemented by the PCA Identity and Access Manager by presenting signed JSON Web Tokens (JWTs). 

A client system **SHALL** authenticate itself by presenting a signed JWT that conforms to <a href="https://tools.ietf.org/html/rfc7523#section-2.2">section 2.2 of  RFC 7523</a>. 

A client system **SHALL** include the following Authentication JWT Header Values:
*  *alg*:	The algorithm used for signing the authentication JWT **SHALL** be *RS256*.
*  *kid*:	The value **SHALL** be the  identifier of the key-pair used to sign this JWT. Note that the client’s JWK Set was provided to the PCA Identity and Access Manager when the client system was registered.
*  *typ*:	The value **SHALL** be *JWT*.

A client system **SHALL** include the following Authentication JWT Claims:
*  *iss*:	The value **SHALL** be the client system’s client_id.
*  *sub*:	The value **SHALL** be the client system’s client_id.
*  *aud*:	The value **SHALL** the  URL of the endpoint (*token* or *introspect*) which is authenticating the client system.
*  *exp*:	The value **SHALL** be no more than five minutes after the time when the JWT was signed.
*  *jti*:	The value **SHALL** be a nonce string value that uniquely identifies the authentication JWT.

A client system **SHALL** sign its client credential JWTs with an RSA private key which they generate prior to registration (see <a href="pcaIAM.html#register-endpoint">register endpoint</a>).

<br/>
### OAuth2 implementation

This section specifies the OAuth2 endpoints that are implemented by the PCA Identity and Access Manager **for system-based authorisation**.

### Token endpoint
The *token* endpoint conforms to <a href="https://tools.ietf.org/html/rfc6749#section-3.2">section 3.2 of RFC 6749</a>. 

The *token* endpoint currently only supports the *client credentials* grant type (as client systems are currently only permitted by the PCA service operator to use system-based authorisation) in accordance with <a href="https://tools.ietf.org/html/rfc6749#section-4.4">RFC 6749 section 4.4</a>.

#### Request - client credentials grant type
A client system using the *client credentials* grant type to request a PCA API access token **SHALL** conform with <a href="https://tools.ietf.org/html/rfc6749#section-4.4.2">section 4.4.2. of RFC 6749</a>, in particular it **SHALL** request an access token via a HTTP POST using content-type *application/x-www-form-urlencoded* and a body containing the following parameters:
*  *grant_type*:            The value **SHALL** be *client_credentials*.
*  *client_id*:         	The value **SHALL** be the client_id of the client system.
*  *client_assertion_type*:	The value **SHALL** be *urn:ietf:params:oauth:client-assertion-type:jwt-bearer*.
*  *client_assertion*: 	    The value **SHALL** be a signed client system authentication JWT (see <a href="#client-system-credential">client system credentials</a>). 
 
#### Response
On receipt of a valid token request, the PCA Identity and Access Manager will validate the client credentials in accordance with <a href="https://tools.ietf.org/html/rfc7523#section-3">section 3 of RFC 7523</a>.

The PCA Identity and Access Manager will either issue a <a href="pcaIAM.html#pca-api-access-token">PCA API access token</a> or return an error in accordance with <a href="https://tools.ietf.org/html/rfc6749#section-5">section 5 of RFC 6749</a>.

###  Management of tokens 

#### Token management - client systems 

A client system **SHALL** only send PCA API access tokens over an encrypted link to an authenticated PCA service endpoint (i.e. over TLS).

A client system that receives PCA API access tokens as a result of a client credential grant **SHALL** only store these tokens in transient memory.

```
Note:
PCA API tokens used for system-based authorisation are short lived (default is 5 minutes). Rather than managing token expiry, a client system may simply request a new token for each set of PCA API invocations that it makes without significant intervening delay (such as would be caused by user interaction).
```

#### Token management - server systems
The PCA Identity and Access Manager will invalidate a PCA API access token that was granted via the client credentials code grant, and reject requests that present that access token, when a configurable period of time (default will be 5 minutes) has elapsed since that access token was granted.

### Introspect endpoint
The *introspect* endpoint is invoked by a PCA server whenever a PCA API access token is presented to it. The response reflects the current state of the access token and the current Authorisations of the user (in the case of user-based authorisation) or of the client system (in the case of system-based authorisation). 

The *introspect* endpoint conforms to <a href="https://tools.ietf.org/html/rfc7662">RFC 7662</a>. 

#### Request
A client system **SHALL** request token introspection in accordance with <a href="https://tools.ietf.org/html/rfc7662#section-2.1">section 2.1. of RFC 7662</a>, in particular it **SHALL** do so using a HTTP POST using content-type *application/x-www-form-urlencoded* and a body containing the following parameters:
*  *token*:   The value **SHALL** be the PCA API access token to be introspected.
*  *client_assertion_type*: The value **SHALL** be *urn:ietf:params:oauth:client-assertion-type:jwt-bearer*.
*  *client_assertion*: The value shall be a signed client system authentication JWT (see <a href="#client-system-credential">client system credentials</a>).

#### Response 
On receipt of a valid request, the PCA Identity and Access Manager will validate the client credentials in accordance with <a href="https://tools.ietf.org/html/rfc7523#section-3">section 3 of RFC 7523</a>.

The PCA Identity and Access Manager will reject a request to introspect a token if the token was not granted to the client system making the request.

The PCA Identity and Access Manager will either respond with a JSON object or return an error in accordance with <a href="https://tools.ietf.org/html/rfc7662#section-2.2">section 2.2 or 2.3 of RFC 7662</a>.

If there is no error then the PCA Identity and Access Manager will return a JSON object that contains the following elements:
*  *active*: Whether or not the presented token is currently active. 
*  *scope*: An OAuth2 scope that conforms to <a href="pcaIAM.html#pca-api-access-token-scope">PCA scope specification</a>.
*  *client_id*: The client_id of the client system.
*  *exp*:  The present day & timestamp.
*  *iat*: The present.

### Register endpoint

The *register* endpoint conforms to <a href="https://tools.ietf.org/html/rfc7591">RFC 7591</a>. 

The PCA Identity and Access Manager implements the "protected dynamic registration" model, as described in <a href="https://datatracker.ietf.org/doc/html/rfc7591#appendix-A.1.2">RFC 7591 appendix A</a>.1.  That is, the PCA service operator issues initial access tokens that are required to be presented by client systems in order to be registered.

The PCA service operator will generate an *initial access token* that is unique to each *software product* that has been approved by the PCA service operator for connection to the production environment of the PCA service, where each *software product* is identified by its unique combination of values for *software_id*, *software_version*, *scope* and *redirect_uris*.  

The PCA service operator will provide a *initial access token* to the manufacturer of each approved *software product* via a secure communications channel.

The manufacturer of each software product **SHALL** ensure that the *initial access token* is secured within their *software product* and is only exposed via the secure network link between a client-system (i.e. an operating instance of that *software product*) and the PCA *register* endpoint.

A client system **SHALL**, prior to registration, generate a 2048-bit RSA key pair as defined in <a href="https://tools.ietf.org/html/rfc8017">RFC 8017</a>.

A client system **SHALL** securely store the generated RSA private key. 

#### Request 

A client system **SHALL**  dynamically register itself using the *register* endpoint of the PCA Identity and Access Manager prior to accessing the PCA API.

A client system **SHALL** present its *initial access token* as a bearer token using the Authorization http request-header field.

A client system **SHALL** request registration in accordance with <a href="https://tools.ietf.org/html/rfc7591#section-3.1">section 3.1. of RFC 7591</a>, in particular it **SHALL** do so using a HTTP POST using content-type *application/json* and a body containing a JSON object that comprises the following client metadata elements:
*  *software_id*: The value **SHALL** identify the software manufacturer and product name of the software product that implements the client system. This product **SHALL** have been previously approved for connection to the PCA service.
*  *software_version*:  The value **SHALL** identify the software version number of the software product that implements the client system.
*  *scope*: The value **SHALL** identify the roleTypes that the client system is configured to use, this **SHALL** be a sub-set of the roleTypes that the software product that implements the client system has been approved for.
*  *redirect_uris*: If the client system supports user-based authorisation  then exactly one URL **SHALL** be  provided.

The JSON object **SHALL** also contain either  a *jwks_uri* or a  *jwks* element where:
*  *jwks*: The value contains the public key used to validate the client system's client credentials, if present it **SHALL** represent the public key as a *bare key*, i.e. by including its modulus and exponent (*n* and *e* values),  the key identifier (i.e. *kid*) **SHALL** also be included.
*  *jwks_uri*: The value contains the URL string referencing the client's JSON Web Key (JWK) Set document, if present it **SHALL** provide a link to the client's public key used to validate the client system's client credentials.  

#### Response 
On receipt of a registration request, the PCA Identity and Access Manager will validate the *initial access token* provided in the request header. An *initial access token*  is invalid if **either** of the following are true:
*  *software_id*, *software_version*, *scope* or *redirect_uris*, as specified in the registration request, do not match the corresponding values that were associated with the *initial access token* when it was issued.
*  The PCA service operator has determined that the  *initial access token* is no longer valid.

The PCA Identity and Access Manager will reject a registration request if the *initial access token*  is invalid.

The PCA Identity and Access Manager will process a registration request in accordance with <a href="https://tools.ietf.org/html/rfc7591#section-3.2">section 3.2 RFC 7591</a>.

The PCA Identity and Access Manager will reject a registration request if the public key (either contained in, or referenced by, the client metadata) has been previously associated with any successfully executed client system registration request. (This requirement prevents a client system from being de-registered and then re-registered without also generating a new key pair.)

On successful registration the PCA Identity and Access Manager will respond in accordance with <a href="https://tools.ietf.org/html/rfc7591#section-3.2.1">3.2.1 RFC 7591</a> and the response will include the following:
*  *client_id*: The client_id created by the PCA Identity and Access Manager.
*  *registration_client_uri*: The URL, provided by the PCA Identity and Access Manager, that is available to manage the client registration in accordance with <a href="https://tools.ietf.org/html/rfc7592">RFC 7592</a>.
*  *registration_access_token*: The bearer token, created by the PCA Identity and Access Manager, that is required to manage the client registration. 
*  *software_id*: A value that identifies the software manufacturer and product name of a software product that has been approved for connection to the PCA service.
*  *software_version*:  A value that identifies the software version number of a software product that has been approved for connection to the PCA service.
*  *scope*: The roleTypes that the client system is configured to use, this will be a sub-set of the roleTypes that the software has been approved for.
*  *redirect_uris*: This value will not be provided, as client applications are currently only permitted by the PCA service operator to use system-based authorisation.  
*  either *jwks* or *jwks_uri* will be provided and the value will be the corresponding meta-data element which was provided by the client system in the registration request.

### Client configuration endpoint
The PCA Identity and Access Manager provides a unique *client configuration* endpoint to each registered client system.

The URLs of these endpoints are of the form: 
```
<registration endpoint URL>/<client_id>.
```
Each *client configuration* endpoint conforms to <a href="https://tools.ietf.org/html/rfc7592">RFC 7592</a>.

While RFC 7592 allows for other types of request message, the *client configuration* endpoints provided by the PCA Identity and Access Manager are only used to enable client systems to deregister themselves and therefore only *Client Delete* requests are supported. It is recommended that a client system send a *client delete* request as a step in the process by which it is un-installed or decommissioned.

#### Deregister client request 

A client system **SHOULD** de-register itself before it is de-installed or decommissioned by an organisation.

A client system **SHALL** de-register itself by sending a *Client Delete* request to the *client configuration* endpoint of the PCA Identity and Access Manager that was identified in the *registration_client_uri* field of the client metadata that was returned by the PCA Identity and Access Manager when the client system was registered, in doing so it **SHALL** comply with <a href="https://tools.ietf.org/html/rfc7592#section-2.3">section 2.3 of RFC 7592</a>.

A client system **SHALL** authenticate itself to the *client configuration* endpoint by providing the *registration_access_token* as a bearer token in the HTTP Authorization header. The *registration_access_token* was provided in the  <a href="pcaIAM.html#response-2">register endpoint response</a>.

#### Deregister client response 
On receipt of a *client delete* request, the PCA Identity and Access Manager will validate the bearer token in Authorization in the request header.

The PCA Identity and Access Manager will process a *client delete* request  in accordance with <a href="https://tools.ietf.org/html/rfc7592#section-2.3">section 2.3 RFC 7592</a>.

