
<hr/>

### Whole system interactions

<hr/>

#### search-system

<b>Supported search parameters:</b>

<table border="1">
   <tr>
      <td>
         <b>Parameter</b>
      </td>
      <td>
         <b>Type</b>
      </td>
      <td>
         <b>Definition</b>
      </td>
   </tr>
   <tr>
      <td>_lastUpdated</td>
      <td>date</td>
      <td>http://hl7.org/fhir/SearchParameter/Resource-lastUpdated</td>
   </tr>
   <tr>
      <td>_type</td>
      <td>token</td>
      <td/>
   </tr>
   <tr>
      <td>_include</td>
      <td>special</td>
      <td/>
   </tr>
   <tr>
      <td>_include:iterate</td>
      <td>special</td>
      <td/>
   </tr>
   <tr>
      <td>_filter</td>
      <td>special</td>
      <td/>
   </tr>
   <tr>
      <td>_page</td>
      <td>special</td>
      <td/>
   </tr>
   <tr>
      <td>_count</td>
      <td>special</td>
      <td/>
   </tr>
   <tr>
      <td>_resultId</td>
      <td>special</td>
      <td/>
   </tr>
</table>

### Organization

     
     
 This section defines the supported interactions for the [PCA Organization](StructureDefinition-pca-organization.html) profile of the ```Organization``` resource type.     

<hr/>

### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>versioned</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>

### Location

       
     
 This section defines the supported interactions for the [PCA Location](StructureDefinition-pca-location.html) profile of the ```Location``` resource type.     
     
 A ```Location``` resource conforming to the [PCA Location](StructureDefinition-pca-location.html) profile represents a location at which healthcare services are offered by a PCA publisher.       

<hr/>

### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>versioned</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>

### HealthcareService
      
     
This section defines the supported interactions for the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) profile and the [PCA Partner Service](StructureDefinition-pca-partner-service.html) profile of the ```HealthcareService``` resource type.     
     
 A ```HealthcareService``` resource conforming to the [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) profile describes a healthcare service offered at a location by a PCA publisher.     
     
 A ```HealthcareService``` resource conforming to the [PCA Partner Service](StructureDefinition-pca-partner-service.html) profile describes a partner service offered by a subscriber to which PCA publishers can publish their service offerings.     

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>versioned</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>

#### search-type

<b>Supported search parameters:</b>

<table border="1">
   <tr>
      <td>
         <b>Parameter</b>
      </td>
      <td>
         <b>Type</b>
      </td>
      <td>
         <b>Definition</b>
      </td>
   </tr>
   <tr>
      <td>_profile</td>
      <td>uri</td>
      <td>http://hl7.org/fhir/SearchParameter/Resource-profile</td>
   </tr>
   <tr>
      <td>active</td>
      <td>token</td>
      <td>http://hl7.org/fhir/SearchParameter/HealthcareService-active</td>
   </tr>
   <tr>
      <td>organization</td>
      <td>reference</td>
      <td>http://hl7.org/fhir/SearchParameter/HealthcareService-organization</td>
   </tr>
   <tr>
      <td>service-catgeory</td>
      <td>token</td>
      <td>http://hl7.org/fhir/SearchParameter/HealthcareService-service-category</td>
   </tr>
   <tr>
      <td>coverage-area.location.address-postalcode</td>
      <td>string</td>
      <td/>
   </tr>
</table>

### PractitionerRole
     
 This section defines the supported interactions for the [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) profile of the ```PractitionerRole``` resource type.     
Each ```PractitionerRole``` resource conforming to the [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) profile describes a practitioner in a role at a healthcare service.     

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>versioned</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>PractitionerRole:practitioner</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>PractitionerRole:healthcareService</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>PractitionerRole:organization</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>PractitionerRole:location</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>


### Practitioner
     
     
This section defines the supported interactions for the [PCA Practitioner](StructureDefinition-pca-practitioner.html) profile of the ```Practitioner``` resource type.       
     
Each ```Practitioner``` resource conforming the [PCA Practitioner](StructureDefinition-pca-practitioner.html) profile is a read-only proxy for a corresponding ```Practitioner``` resource managed by the PCA portal.     
     
Each 'proxy' has the same *id* and *versionId* as the resource within the PCA portal for which it is a proxy.       

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>versioned</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>

### Provenance
     
 This section defines the supported interactions for the [PCA Provenance](StructureDefinition-pca-provenance.html) profile of the ```Provenance``` resource type.     
     
 Each ```Provenance``` resource conforming to the [PCA Provenance](StructureDefinition-pca-provenance.html) profile represents an activity performed by the PCA service (conditionally on behalf of a participating organisation when the target element references a PCA Organization resource) whereby specific data elements of a PCA Organization or PCA Practitioner resource have been initially retrieved, updated or verified from an external system of record.   

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>no-version</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>

### Contract
     
 This section defines the supported interactions for the [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile and the [PCA Information Use Statement](StructureDefinition-pca-information-use-statement.html) profile of the ```Contract``` resource type.     
     
     
 A ```Contract``` resource conforming to the [PCA Publication Authorisation Record](StructureDefinition-pca-publication-authorisation-record.html) profile records a decision regarding the publication of a specific service offering (either a ```HealthcareService``` or a ```PractitionerRole```) to a specific partner service. The decision is either to authorise publication or to revoke a previous authority to publish.     
     
 A ```Contract``` resource conforming to the [PCA Information Use Statement](StructureDefinition-pca-information-use-statement.html) profile represents a policy statement by a subscriber organisation's partner service that describes how they will use the information from publisher organisations that is disclosed to the partner service.         

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>versioned</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>


### Task
     
 This section defines the supported interactions for the [PCA Match Record](StructureDefinition-pca-match-record.html) profile or the [PCA Partner Service Task](StructureDefinition-pca-partner-service-task.html) profile of the ```Task``` resource type.     
     
 A ```Task``` resource conforming to the [PCA Match Record](StructureDefinition-pca-match-record.html) profile indicates the matching status of a service offering to a partner service’s local data store.       
     
 A ```Task``` resource conforming to the [PCA Partner Service  Task](StructureDefinition-pca-partner-service-task.html) profile indicates a task created by a partner service via their authorised subscribing system.      

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>versioned-update</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>

#### search-type

<b>Supported search parameters:</b>

<table border="1">
   <tr>
      <td>
         <b>Parameter</b>
      </td>
      <td>
         <b>Type</b>
      </td>
      <td>
         <b>Definition</b>
      </td>
   </tr>
   <tr>
      <td>_profile</td>
      <td>uri</td>
      <td>http://hl7.org/fhir/SearchParameter/Resource-profile</td>
   </tr>
   <tr>
      <td>subject</td>
      <td>reference</td>
      <td>http://hl7.org/fhir/SearchParameter/Task-subject</td>
   </tr>
   <tr>
      <td>owner</td>
      <td>reference</td>
      <td>http://hl7.org/fhir/SearchParameter/Task-owner</td>
   </tr>
</table>

### Subscription

     
      
 This section defines the supported interactions for the [PCA Subscription](StructureDefinition-pca-subscription.html) profile of the ```Subscription``` resource type.     
     
 The [PCA Subscription](StructureDefinition-pca-subscription.html) profile of ```Subscription``` is used by subscribing systems to register for notifications from the PCA service when new or updated service offerings are available, or when publication of existing service offerings has been newly revoked.       

<hr/>

#### Server implementation options

<table border="1">
   <tr>
      <td>
         <b>Option</b>
      </td>
      <td>
         <b>Value</b>
      </td>
   </tr>
   <tr>
      <td>versioning</td>
      <td>no-version</td>
   </tr>
   <tr>
      <td>readHistory</td>
      <td>false</td>
   </tr>
   <tr>
      <td>updateCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalCreate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalRead</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>conditionalUpdate</td>
      <td>false</td>
   </tr>
   <tr>
      <td>conditionalDelete</td>
      <td>not-supported</td>
   </tr>
   <tr>
      <td>referencePolicy</td>
      <td>not specified</td>
   </tr>
   <tr>
      <td>searchInclude</td>
      <td>_include not supported</td>
   </tr>
   <tr>
      <td>searchRevInclude</td>
      <td>_revinclude not supported</td>
   </tr>
</table>

<hr/>



#### search-type

<b>Supported search parameters:</b>

<table border="1">
   <tr>
      <td>
         <b>Parameter</b>
      </td>
      <td>
         <b>Type</b>
      </td>
      <td>
         <b>Definition</b>
      </td>
   </tr>
</table>    