### Must support
The meaning of the presence or absence of the must support flag is described in [Must support](guidance.html#must-support), except for the following elements:
* For the *identifier:pca-hsi* element: publishing systems creating a new PCA Healthcare Service resource shall not provide these elements.  This identifier is generated by the PCA service.
* For the *type* element: a publishing system is required to provide a single code that represents the primary service type (by using the 'iso21090-preferred' extension). Any other values for the *type* element will be ignored.
* For the *active* element: publishing systems creating or updating a PCA Healthcare Service resource shall not provide this element. This value is calculated by the PCA service at the time the PCA Healthcare Service resource is provided to a subscribing system, using the period defined in the *pca-active-period* extension. See the ‘PCA Active Period’ section in the usage notes below for more information.
* For the *pca-bank-account* extension: any values provided by publishing systems when adding or updating a PCA Healthcare Service will be ignored by the PCA service.  Bank account details must be managed by a healthcare provider organisation via the PCA Portal. The PCA service will populate the extension when providing the PCA Healthcare Service resource to subscribing systems.
* For the *pca-key-contact* extension: any values provided by publishing systems when adding or updating a healthcare service will be ignored by the PCA service. Key contact details must be managed by a healthcare provider organisation via the PCA Portal. The PCA service will populate the extension when providing healthcare service resources to subscribing systems.


### Extensions
Extensions introduced in this profile:
* HealthcareService: [PCA Active Period](StructureDefinition-pca-active-period.html)
* HealthcareService.availableTime: [PCA Available Time Applicability](StructureDefinition-pca-available-time-applicability.html)
* HealthcareService: [PCA Bank Account](StructureDefinition-pca-bank-account.html)
* HealthcareService: [PCA IAR Levels of Care](StructureDefinition-pca-iar-levels-of-care.html)
* HealthcareService: [PCA New Patient Availability](StructureDefinition-pca-new-patient-availability.html)
* HealthcareService: [PCA Postal Address](StructureDefinition-pca-postal-address.html)
* HealthcareService: [PCA Referral Information For Consumer](StructureDefinition-pca-referral-information-for-consumer.html)
* HealthcareService: [PCA Referral Information For Provider](StructureDefinition-pca-referral-information-for-provider.html)
* HealthcareService.telecom: [Contact Purpose](https://hl7.org.au/fhir/4.1.0/StructureDefinition-contact-purpose.html)
* HealthcareService.type: [preferred](http://hl7.org/fhir/StructureDefinition/iso21090-preferred)
* HealthcareService: [PCA Key Contact](StructureDefinition-pca-key-contact.html)

### Usage notes

#### Identifiers
The PCA Healthcare Service profile explicitly supports the following identifier slice (as indicated by the must support flag):
* PCA Healthcare Service Identifier (PCA-HSI)

A PCA Healthcare Service resource may also have additional identifiers specific to other PCA business partners, and their identifier systems may or may not match other identifier slices defined in [AU Base Healthcare Service](http://hl7.org.au/fhir/4.1.0/StructureDefinition-au-healthcareservice.html).

#### Active and PCA Active Period
The *pca-active-period* extension is used to indicate the period when the healthcare service is active.  It is used by the PCA service to set the value of the *active* element:
* If the *pca-active-period* extension is present, the PCA service will set the *active* value based on the extension's *start* and/or *end* elements.
* If the *pca-active-period* extension is not present, the PCA service will set the *active* value to 'true'.

The *active* element is used by the PCA service to set the *active* element of practitioner roles that reference the healthcare service:
* If the PCA service sets the *active* element to 'false', then the *active* element of all practitioner roles that reference the healthcare service will also be set to 'false' by the PCA service, regardless of the value of the practitioner role's *period* element.  
* If the PCA service sets the *active* element to 'true', then the *active* element of all practitioner roles that reference the healthcare service will be calculated based on their *period* value.  See the Usage notes of the [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) profile for more information.

In addition to the invariants defined in this profile, the PCA service applies the following additional validation rules for *pca-active-period*:
* If present, *pca-active-period.value[x].start* SHALL be equal to, or earlier than, the *period.start* or *period.end* values of any ```PractitionerRole``` resources that reference this ```HealthcareService```.
* If present, *pca-active-period.value[x].end* SHALL be equal to, or later than, the *period.start* or *period.end* values of any ```PractitionerRole``` resources that reference this ```HealthcareService```.


#### Organisation reference
The *providedBy* element must contain a relative reference to an existing [PCA Organization](StructureDefinition-pca-organization.html).  Publishing systems can [search for organisations](CapabilityStatement-pca-publisher-agent.html#search-system) using the PCA Publisher Agent API.  After a healthcare service has been created, the *providedBy* element cannot be changed to reference a different organisation.

#### Service type
To indicate the primary service type of the healthcare service, use the *iso21090-preferred* extension on the *type* element. Multiple healthcare services with the same primary service type are not permitted at a single location.

When a healthcare service is provided to a subscribing system the values for the *type* element are populated with the primary service type (through the presence of the 'iso21090-preferred' extension), as well as any parent terms of the primary service type in the SNOMED hierarchy.

#### Location reference
The *location* element must contain a relative reference to an existing [PCA Location](StructureDefinition-pca-location.html) whose *managingOrganization* references the same PCA Organization as is referenced by the *providedBy* element.  Publishing systems can [create new locations](CapabilityStatement-pca-publisher-agent.html) or [search for existing locations](CapabilityStatement-pca-publisher-agent.html#search-system) using the PCA Publisher Agent API.    After a healthcare service has been created, the *location* element cannot be changed to reference a different location.

#### Availability
To indicate a change in the pattern of availability of the healthcare service during a particular period, use *availableTime* with the *availableTimeApplicability* extension. 

To indicate the healthcare service is not available during a period of time, use *notAvailable*. 

An *availableTime* using the *availableTimeApplicability* modifierExtension overrides any other *availableTime* that contains the same day(s), for the period defined in the *during* element.

#### Coverage area
The coverage area that a service is intended for/available to should be defined using one or more instances of the *coverageArea* element, with the *address* elements of the contained ```Location``` populated depending on the type of coverage area to be defined. PCA currently supports coverage areas to be defined as Australia-wide (in which case only one *coverageArea* element should be present), or as a combination of individual states and/or suburbs (with separate *coverageArea* elements for each). See the [PCA Service Coverage Area](StructureDefinition-pca-service-coverage-area.html) profile for more information.

The *coverageArea* element shall only be present when *eligibility* contains 'coverage-restrictedResidents', and/or the *type* of the referenced *location* is 'MOB' (mobile) or 'VI' (virtual).

#### Referral information
Some subscribing systems may render markdown contained in the [PCA Referral Information For Provider](StructureDefinition-pca-referral-information-for-provider.html) and [PCA Referral Information For Consumer](StructureDefinition-pca-referral-information-for-consumer.html) elements; however this is not guaranteed, so publishing systems should limit markdown syntax in these elements to that which still renders well as plain text (such as bullets, numbered lists, or bold/italic text).

#### Address lines
When a PCA Healthcare Service is created or updated by a publishing system, or retrieved by a publishing or subscribing system, the *line* elements for *pca-postal-address* (if present) are processed/populated by PCA using the rules that are defined in the usage notes of the [PCA Postal Address](StructureDefinition-pca-postal-address.html) extension.

#### Key Contact

To populate details of the PCA Key Contacts that can be recorded against a PCA Healthcare Service, use *keycontact" extension. 

Do not use the extension when the telecom element also contains contact information for the Healthcare service.

### Supported interactions
Supported service interactions for this profile are defined in the following capability statements:
* For publishing systems: [PCA Publisher Agent](CapabilityStatement-pca-publisher-agent.html#healthcareservice)
* For subscribing systems: [PCA Subscriber Agent](CapabilityStatement-pca-subscriber-agent.html#healthcareservice)



