### Must support
The meaning of the presence or absence of the must support flag is described in [Must support](guidance.html#must-support), except for the *extension:pca-active-in-system-of-record* element. When an Organization is provided to a subscribing system the value for this element is populated by the PCA service to indicate if the organisation is currently active in the system of record from which the name and identifier elements were obtained.

### Extensions
Extensions introduced in this profile:
* Organization: [PCA Active In System Of Record](StructureDefinition-pca-active-in-system-of-record.html)
* Organization: [PCA Part Of Legal Entity](StructureDefinition-pca-part-of-legal-entity.html)

### Usage notes

#### Identifiers
The PCA Organization profile explicitly supports the following identifier slices (as indicated by the must support flag):
* Healthcare Provider Identifier – Organisation (HPI-O) 
* Australian Business Number (ABN) 
* PCA Organization Identifier (PCA-OI)

A PCA Organization resource may also have additional identifiers specific to other PCA business partners, and their identifier systems may or may not match other identifier slices defined in [AU Base Organization](http://hl7.org.au/fhir/4.1.0/StructureDefinition-au-organization.html).

#### Organisation type
The PCA Organization profile is used to represent different types of organisations within the PCA service.

* A HI organisation is an organisation sourced from the HI service. It has a *type* of 'HIO', and an [AU HPI-O](https://hl7.org.au/fhir/4.1.0/StructureDefinition-au-hpio.html) *identifier*.

* A legal entity organisation is an organisation with an Australian Business Number (ABN) or a sole trader without an ABN. It has a *type* of 'LEO', and an [AU Australian Business Number](https://build.fhir.org/ig/hl7au/au-fhir-base//StructureDefinition-au-australianbusinessnumber.html) *identifier* (except for sole traders without an ABN).  A legal entity organisation is further classified as either a participating organisation (that is, an organisation that has a participation agreement with PCA), or a subsidiary of a participating organisation: 
  * A participating publishing organisation will additionally include a *type* of 'PPO'.
  * A participating subscribing organisation will additionally include a *type* of 'PSO'.  
  * A subsidiary organisation  will only have a *type* of 'LEO'.

#### Address lines
When a PCA Organization is retrieved by a publishing or subscribing system, the *line* elements for *address* (if present) are populated by PCA using the same rules that are defined in the usage notes of the [PCA Postal Address](StructureDefinition-pca-postal-address.html) extension.

### Supported interactions
Supported service interactions for this profile are defined in the following capability statements:
* For publishing systems: [PCA Publisher Agent](CapabilityStatement-pca-publisher-agent.html#organization)
* For subscribing systems: [PCA Subscriber Agent](CapabilityStatement-pca-subscriber-agent.html#organization)
