### Must support
The meaning of the presence or absence of the must support flag is described in [Must support](guidance.html#must-support)

### Extensions
Extensions introduced in this profile:
* Task: [PCA Property Name](StructureDefinition-pca-property-name.html)

### Usage notes

The PCA Subscriber Agent capability statement describes the requirements for [creating](CapabilityStatement-pca-subscriber-agent.html) and [updating](CapabilityStatement-pca-subscriber-agent.html) different types of PCA Partner Service Tasks via the PCA Subscriber Agent API.

#### Task types
* Use the 'PartnerServiceCompleteOnlineForm' code when creating a Task that directs users to **complete an online form** (using a partner service's website link that has been pre-configured in PCA), within the context of a [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) or [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) that is being published to the partner service.

* Use the 'PartnerServiceProvideMissingInformation' code when creating a Task that requests users to **complete missing information** for one or more fields of a [PCA Organization](StructureDefinition-pca-organization.html), [PCA Location](StructureDefinition-pca-healthcare-service.html), [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) or [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) that is being published to the partner service.

* Use the 'PartnerServiceVerifyInformation' code when creating a Task that requests users to **update suspected incorrect information** for a single field of a [PCA Organization](StructureDefinition-pca-organization.html), [PCA Location](StructureDefinition-pca-healthcare-service.html), [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) or [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) that is being published to the partner service.


### Supported interactions
Supported service interactions for this profile are defined in the following capability statements:
* For subscribing systems: [PCA Subscriber Agent](CapabilityStatement-pca-subscriber-agent.html#task)
