### Must support
The meaning of the presence or absence of the must support flag is described in [Must support](guidance.html#must-support).

### Usage notes

When a [PCA Location](StructureDefinition-pca-location.html) or [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) resource containing the *pca-postal-address* extension is created or updated by a publishing system, the *line* elements are processed by PCA according to the following rules:

If the address contains a GNAF/DPID identifier:
* If the PCA service determines that the first *line* element includes qualifying address details that do not form a part of the GNAF/PAF address (for example shop, suite, or building name):
  * The first *line* element represents the qualifying address details. 
  * The second *line* element represents the first line of the non-locality/state/postcode portion of the GNAF/PAF address.
  * The third *line* element (if present) represents the second line of the non-locality/state/postcode portion of the GNAF/PAF address. If the GNAF/PAF address does not have a unit/level/etc number, this element will not be present.

* If the PCA service determines that the first *line* element does not include qualifying address details that do not form a part of the GNAF/PAF address (for example shop, suite, or building name):
  * The first *line* element represents the first line of the non-locality/state/postcode portion of the GNAF/PAF address.
  * The second *line* element (if present) represents the second line of the non-locality/state/postcode portion of the GNAF/PAF address. If the GNAF/PAF address does not have a unit/level/etc number, this element will not be present.

If the address does not contain a GNAF/DPID identifier:
* If there are three *address.line* elements present:
  * The first *line* element represents the qualifying address details as provided by the publisher. 
  * The second *line* element represents the first line of the address as provided by the publisher.
  * The third *line* element contains the second line of the address as provided by the publisher.

* If there are less than three *address.line* elements present:
  * The first *line* element represents the first line of the address as provided by the publisher.
  * The second *line* element (if present) represents the second line of the address as provided by the publisher.


When a [PCA Location](StructureDefinition-pca-location.html) or [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html) resource containing the *pca-postal-address* extension is retrieved by a publishing or subscribing system, the *line* elements are populated by PCA according to the following rules.

**Note:** when a [PCA Organization](StructureDefinition-pca-organization.html) is retrieved by a publishing or subscribing system, the *line* elements for *address* (if present) are populated by PCA using these same rules.

If the address contains a GNAF/DPID identifier:
* If the publisher provided address details that qualify, but do not form a part of, the GNAF/PAF address (for example shop, suite, or building name):
  * The first *line* element contains the qualifying address details. 
  * The second *line* element contains the first line of the non-locality/state/postcode portion of the GNAF/PAF address.
  * The third *line* element (if present) contains the second line of the non-locality/state/postcode portion of the GNAF/PAF address. If the GNAF/PAF address does not have a unit/level/etc number, this element will not be present.

* If the publisher did not provide address details that qualify, but do not form a part of, the GNAF/PAF address:
  * The first *line* element contains the first line of the non-locality/state/postcode portion of the GNAF/PAF address.
  * The second *line* element (if present) contains the second line of the non-locality/state/postcode portion of the GNAF/PAF address. If the GNAF/PAF address does not have a unit/level/etc number, this element will not be present.

If the address does not contain a GNAF/DPID identifier:
* If there are three *address.line* elements present:
  * The first *line* element contains the qualifying address details as provided by the publisher. 
  * The second *line* element contains the first line of the address as provided by the publisher.
  * The third *line* element contains the second line of the address as provided by the publisher.

* If there are less than three *address.line* elements present:
  * The first *line* element contains the first line of the address as provided by the publisher.
  * The second *line* element (if present) contains the second line of the address as provided by the publisher.



  
