### Must support
The meaning of the presence or absence of the must support flag is described in [Must support](guidance.html#must-support), except for the following element:
* For the *status* element: a publishing system is not permitted to set the *status* element to 'cancelled'.  This value is only set by the PCA service.  When a Contract is provided to a subscribing system the *status* may have a value of either 'executed', 'revoked' or 'cancelled'.

### Extensions
No extensions have been introduced in this profile.

### Usage notes

For publishing systems:

* To authorise publication, use the 'executed' value for the status element.
* To revoke an existing publication authorisation, use the 'revoked' value for the status element.
* Currently, publishing systems can only create Contract resources where the subject is either a PCA Healthcare Service or PCA Practitioner Role. Individual practitioners must use the PCA web portal to authorise the publication of their own Practitioner record independently of any associated Practitioner Role record.

For subscribing systems:

* The presence of a Contract resource whose status = 'executed' represents a decision to authorise publication of the subject of the Contract (either a [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html), [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) or [PCA Practitioner](StructureDefinition-pca-practitioner.html)).
* The presence of a Contract resource whose status = 'revoked' represents a decision to revoke an existing publication authorisation for the subject of the Contract (either a [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html), [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) or [PCA Practitioner](StructureDefinition-pca-practitioner.html)) .

For publishing and subscribing systems:

* The presence of a Contract resource with a status of 'cancelled' indicates that the associated [PCA Partner Service](StructureDefinition-pca-partner-service.html) has been made inactive and the subject of the Contract (either a [PCA Healthcare Service](StructureDefinition-pca-healthcare-service.html), [PCA Practitioner Role](StructureDefinition-pca-practitioner-role.html) or [PCA Practitioner](StructureDefinition-pca-practitioner.html)) is not currently being published to that inactive [PCA Partner Service](StructureDefinition-pca-partner-service.html).

### Supported interactions
Supported service interactions for this profile are defined in the following capability statements:
* For publishing systems: [PCA Publisher Agent](CapabilityStatement-pca-publisher-agent.html#contract)
* For subscribing systems: [PCA Subscriber Agent](CapabilityStatement-pca-subscriber-agent.html#contract)
 