###  Resource profiles

The following profiles defined in this implementation guide are of resources representing published organisation information.
     
<table class="list" width="100%" cellspacing="6" border="1" valign="middle">
    <tbody>
        <col width="20%" />
        <col width="60%" />
        <col width="20" />
        <tr>
            <th>Profile</th>
            <th>Description</th>
            <th>Derived from</th>
        </tr>
        <tr>
            <td><a href ="StructureDefinition-pca-healthcare-service.html">PCA Healthcare Service</a></td>
            <td>This profile of HealthcareService defines a PCA Healthcare Service. A PCA Healthcare Service is a service offered at a location by a PCA publisher.</td>
            <td><a href ="https://hl7.org.au/fhir/4.1.0/StructureDefinition-au-healthcareservice.html">AU Base Healthcare Service</a></td>
        </tr>
		<tr>
            <td><a href ="StructureDefinition-pca-location.html">PCA Location</a></td>
            <td>This profile of Location defines a PCA Location. A PCA Location is a location at which services are offered by a PCA publisher.</td>
            <td><a href ="https://hl7.org.au/fhir/4.1.0/StructureDefinition-au-location.html">AU Base Location</a></td>
        </tr>
        <tr>
            <td><a href ="StructureDefinition-pca-organization.html">PCA Organization</a></td>
            <td>This profile of Organization defines an organisation, in an Australian healthcare context, as supported by the Provider Connect Australia (PCA) service.</td>
            <td><a href ="https://hl7.org.au/fhir/4.1.0/StructureDefinition-au-organization.html">AU Base Organization</a></td>
        </tr>
        <tr>
            <td><a href ="StructureDefinition-pca-practitioner.html">PCA Practitioner</a></td>
            <td>This profile of Practitioner defines a practitioner, in an Australian healthcare context, as supported by the Provider Connect Australia (PCA) service.</td>
            <td><a href ="https://hl7.org.au/fhir/4.1.0/StructureDefinition-au-practitioner.html">AU Base Practitioner</a></td>
        </tr>
        <tr>
            <td><a href ="StructureDefinition-pca-practitioner-role.html">PCA Practitioner Role</a></td>
            <td>This profile of PractitionerRole defines a PCA Practitioner Role. A PCA Practitioner Role is a PCA Practitioner in a role at a PCA Healthcare Service.</td>
            <td><a href ="https://hl7.org.au/fhir/4.1.0/StructureDefinition-au-practitionerrole.html">AU Base PractitionerRole</a></td>
        </tr>
		<tr>
            <td><a href ="StructureDefinition-pca-publication-approver.html">PCA Publication Approver</a></td>
            <td>This profile of Practitioner defines a PCA Publication Approver who approves publication of a service offering.</td>
            <td><a href ="http://hl7.org/fhir/R4/practitioner.html">Practitioner</a></td>
        </tr>
        <tr>
            <td><a href ="StructureDefinition-pca-publication-authorisation-record.html">PCA Publication Authorisation Record</a></td>
            <td>This profile of Contract defines a decision made by a PCA publisher concerning the publication of a PCA Healthcare Service or PCA Practitioner Role to a specific PCA Partner Service.</td>
            <td><a href ="http://hl7.org/fhir/R4/contract.html">Contract</a></td>
        </tr>
        <tr>
            <td><a href ="StructureDefinition-pca-service-coverage-area.html">PCA Service Coverage Area</a></td>
            <td>This profile of Location represents a geographic area in which a service is available.</td>
            <td><a href ="http://hl7.org/fhir/R4/location.html">Location</a></td>
        </tr>
    </tbody>
</table> 

The following profiles defined in this implementation guide are of other resources.
<table class="list" width="100%" cellspacing="6" border="1" valign="middle">
    <tbody>
        <col width="20%" />
        <col width="60%" />
        <col width="20" />    
        <tr>
            <th>Profile</th>
            <th>Description</th>
            <th>Derived from</th>
        </tr>  
        <tr>
             <td><a href ="StructureDefinition-pca-information-use-statement.html">PCA Information Use Statement</a></td>
            <td>This profile of Contract defines an information use statement for a PCA Partner Service. An information use statement is a policy statement by the subscriber that describes how subscribers will use the information that is disclosed to this service.</td>
            <td><a href ="http://hl7.org/fhir/R4/contract.html">Contract</a></td>
        </tr>
		<tr>
            <td><a href ="StructureDefinition-pca-match-record.html">PCA Match Record</a></td>
            <td>This profile of Task shows the status of matching a subscriber's record of an organisation to the publisher's record.</td>
            <td><a href ="http://hl7.org/fhir/R4/task.html">Task</a></td>
        </tr>
		<tr>
            <td><a href ="StructureDefinition-pca-partner-service.html">PCA Partner Service</a></td>
            <td>This profile of HealthcareService defines a PCA Partner Service. A PCA Partner Service is a service offered by a PCA subscriber to which PCA publishers can publish their service offerings (i.e. Healthcare Service).</td>
            <td><a href ="http://hl7.org/fhir/R4/healthcareservice.html">HealthcareService</a></td>
        </tr>
         <tr>
            <td><a href ="StructureDefinition-pca-partner-service-task.html">PCA Partner Service Task</a></td>
            <td>This profile of Task represents a task created by a PCA business partner service via their authorised subscribing system. A PCA Partner Service Task represents an actionable request related to a specific PCA Organisation, PCA Location, PCA Healthcare Service, or PCA Practitioner Role that is being published to the PCA business partner service.</td>
            <td><a href ="http://hl7.org/fhir/R4/task.html">Task</a></td>
        </tr>  
		<tr>
            <td><a href ="StructureDefinition-pca-provenance.html">PCA Provenance</a></td>
            <td>This profile of Provenance is used to record an activity performed by the PCA service (conditionally on behalf of a participating organisation when the target element references a PCA Organization resource) whereby specific data elements of a PCA Organization or PCA Practitioner resource have been initially retrieved, updated or verified from an external system of record.</td>
            <td><a href ="http://hl7.org/fhir/R4/provenance.html">Provenance</a></td>
        </tr>
        <tr>
            <td><a href ="StructureDefinition-pca-subscription.html">PCA Subscription</a></td>
            <td>This profile is used by subscribing systems to register for notifications from the PCA service when new or updated service offerings are available, or when publication of existing service offerings has been newly revoked.</td>
            <td><a href ="http://hl7.org/fhir/R4/subscription.html">Subscription</a></td>
        </tr>
    </tbody>
</table> 

<p> </p>
<p> </p>

### Data type profiles 

The following data type profiles are defined in this implementation guide.

<table class="list" width="100%" cellspacing="6" border="1" valign="middle">
    <tbody>
        <col width="20%" />
        <col width="60%" />
        <col width="20" />    
        <tr>
            <th>Profile</th>
            <th>Description</th>
            <th>Derived from</th>
        </tr>
		<tr>
            <td><a href ="StructureDefinition-pca-healthcare-service-identifier.html">PCA Healthcare Service Identifier (PCA-HSI)</a></td>
            <td>This profile of Identifier defines a PCA Healthcare Service Identifier (PCA-HSI). A PCA-HSI is an identifier issued by the Provider Connect Australia service to each PCA Healthcare Service.</td>
            <td><a href ="http://hl7.org/fhir/R4/datatypes.html#Identifier">Identifier</a></td>
        </tr>
		<tr>
            <td><a href ="StructureDefinition-pca-location-identifier.html">PCA Location Identifier (PCA-LI)</a></td>
            <td>This profile of Identifier defines a PCA Location Identifier (PCA-LI). A PCA-LI is an identifier issued by the Provider Connect Australia service to each PCA Location.</td>
            <td><a href ="http://hl7.org/fhir/R4/datatypes.html#Identifier">Identifier</a></td>
        </tr>
		<tr>
            <td><a href ="StructureDefinition-pca-medicareprovidernumber.html">PCA Medicare Provider Number (PCA-MPN)</a></td>
            <td>This identifier profile defines a Medicare provider number in an Australian context and is used by the PCA service to additionally indicate if the Medicare provider number has been validated with the Medicare system of record.</td>
            <td><a href ="https://hl7.org.au/fhir/4.1.0/StructureDefinition-au-medicareprovidernumber.html">AU Medicare Provider Number</a></td>
        </tr> 
		<tr>
            <td><a href ="StructureDefinition-pca-organization-identifier.html">PCA Organization Identifier (PCA-OI)</a></td>
            <td>This profile of Identifier defines a PCA Organization Identifier (PCA-OI). A PCA-OI is an identifier issued by the Provider Connect Australia service to each PCA Organization.</td>
            <td><a href ="http://hl7.org/fhir/R4/datatypes.html#Identifier">Identifier</a></td>
        </tr>
        <tr>
            <td><a href ="StructureDefinition-pca-partner-service-identifier.html">PCA Partner Service Identifier (PCA-PSI)</a></td>
            <td>This profile of Identifier defines a PCA Partner Service Identifier (PCA-PSI). A PCA-PSI is an identifier issued by the Provider Connect Australia service to each PCA Partner Service.</td>
            <td><a href ="http://hl7.org/fhir/R4/datatypes.html#Identifier">Identifier</a></td>
        </tr>
		<tr>
            <td><a href ="StructureDefinition-pca-practitioner-identifier.html">PCA Practitioner Identifier (PCA-PI)</a></td>
            <td>This profile of Identifier defines a PCA Practitioner Identifier (PCA-PI). A PCA-PI is an identifier issued by the Provider Connect Australia service to each PCA Practitioner.</td>
            <td><a href ="http://hl7.org/fhir/R4/datatypes.html#Identifier">Identifier</a></td>
        </tr>        
        <tr>
            <td><a href ="StructureDefinition-pca-practitioner-role-identifier.html">PCA Practitioner Role Identifier (PCA-PRI)</a></td>
            <td>This profile of Identifier defines a PCA Practitioner Role Identifier (PCA-PRI). A PCA-PRI is an identifier issued by the Provider Connect Australia service to each PCA Practitioner Role.</td>
            <td><a href ="http://hl7.org/fhir/R4/datatypes.html#Identifier">Identifier</a></td>
        </tr>      
    </tbody>
</table> 

<p> </p>
<p> </p>

### Other profiles 

The following <a href ="https://hl7.org.au/fhir/4.1.0/index.html">HL7 AU Base</a> profiles are referenced in this implementation guide.

<table class="list" width="100%" cellspacing="6" border="1" valign="middle">
    <tbody>
        <col width="20%" />
        <col width="60%" />
        <col width="20" />    
        <tr>
            <th>Profile</th>
            <th>Description</th>
            <th>Derived from</th>
        </tr>
        <tr>
            <td><a href ="https://hl7.org.au/fhir/4.1.0/StructureDefinition-au-ahpraregistrationnumber.html">AU Ahpra Registration Number </a></td>
            <td>This identifier profile defines an Australian Health Practitioner Regulation Agency (Ahpra) registration number in an Australian context.</td>
            <td><a href ="http://hl7.org/fhir/R4/datatypes.html#Identifier">Identifier</a></td>
        </tr>  
        <tr>
            <td><a href ="https://hl7.org.au/fhir/4.1.0/StructureDefinition-au-australianbusinessnumber.html">AU Australian Business Number</a></td>
            <td>This identifier profile defines an Australian Business Number (ABN) in an Australian context.</td>
            <td><a href ="http://hl7.org/fhir/R4/datatypes.html#Identifier">Identifier</a></td>
        </tr>
        <tr>
            <td><a href ="https://hl7.org.au/fhir/4.1.0/StructureDefinition-au-address.html">AU Base Address</a></td>
            <td>This profile is provided for use in an Australian context where some constraint on content is desirable to guarantee the quality of an Australian address whilst still supporting other uses such as unstructured addresses.</td>
            <td><a href ="http://hl7.org/fhir/R4/datatypes.html#Address">Address</a></td>
        </tr>
        <tr>
            <td><a href ="https://hl7.org.au/fhir/4.1.0/StructureDefinition-au-hpii.html">AU HPI-I</a></td>
            <td>This identifier profile defines a Healthcare Provider Identifier - Individual - HPI-I in an Australian context.</td>
            <td><a href ="http://hl7.org/fhir/R4/datatypes.html#Identifier">Identifier</a></td>
        </tr>
        <tr>
            <td><a href ="https://hl7.org.au/fhir/4.1.0/StructureDefinition-au-hpio.html">AU HPI-O</a></td>
            <td>This identifier profile defines a Healthcare Provider Identifier – Organisation (HPI-O) identifier in an Australian context.</td>
            <td><a href ="http://hl7.org/fhir/R4/datatypes.html#Identifier">Identifier</a></td>
        </tr>
    </tbody>
</table> 