/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.hi.handler.message;

import au.gov.nehta.common.utils.ArgumentUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HIHeaderHandler
implements SOAPHandler<SOAPMessageContext> {
    private final List<String> headerNames;

    public HIHeaderHandler(List<String> headerNames) {
        ArgumentUtils.checkNotNull(headerNames, (String)"headerNames");
        this.headerNames = headerNames;
    }

    public final boolean handleMessage(SOAPMessageContext context) {
        Boolean isOutgoing = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (isOutgoing.booleanValue()) {
            this.removeSoapHeaders(context);
        }
        return true;
    }

    private void removeSoapHeaders(SOAPMessageContext context) {
        SOAPMessage message = context.getMessage();
        SOAPHeader header = null;
        try {
            header = message.getSOAPHeader();
            for (String name : this.headerNames) {
                NodeList nodeList = header.getChildNodes();
                ArrayList<Node> removeNodesList = new ArrayList<Node>();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (!node.getNodeName().endsWith(name)) continue;
                    removeNodesList.add(nodeList.item(i));
                }
                for (Node node : removeNodesList) {
                    node.getParentNode().removeChild(node);
                }
            }
        }
        catch (SOAPException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public final boolean handleFault(SOAPMessageContext context) {
        return false;
    }

    public final Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext context) {
    }
}

