package au.gov.nehta.xsp.impl;

import java.security.Principal;
import java.security.cert.X509Certificate;

/**
 * A collection of utility functions for X.509 certificates.
 */
public final class CertificateUtils {

  /**
   * Returns the distinguished name of a certificate's subject.
   *
   * @param certificate
   *          The {@code X509Certificate} to get the subject name from.
   * @return The subject name of the {@code X509Certificate}. Or null if the
   *         certificate is null or the subject name is not set on the
   *         certificate.
   */
  public static String getSubjectName(X509Certificate certificate) {
    String subjectName = null;
    if (certificate != null) {
      Principal subject = certificate.getSubjectDN();
      if (subject != null) {
        subjectName = subject.getName();
      }
    }
    return subjectName;
  }

  /*
   * Private constructor to prevent the instantiation of a utility class.
   */
  private CertificateUtils() {
  }

}
