/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.impl.policy;

import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.sourcemodel.AssertionData;
import com.sun.xml.ws.security.impl.policy.Claims;
import com.sun.xml.ws.security.impl.policy.Constants;
import com.sun.xml.ws.security.impl.policy.Issuer;
import com.sun.xml.ws.security.impl.policy.IssuerName;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.policy.SecurityAssertionValidator;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.UserNameToken;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsernameToken
extends PolicyAssertion
implements UserNameToken,
Cloneable,
SecurityAssertionValidator {
    private String tokenType;
    private String id;
    private boolean populated;
    private SecurityAssertionValidator.AssertionFitness fitness = SecurityAssertionValidator.AssertionFitness.IS_VALID;
    private boolean hasPassword = true;
    private boolean useHashPassword = false;
    private SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
    private final QName itQname;
    private String includeToken;
    private Issuer issuer = null;
    private IssuerName issuerName = null;
    private Claims claims = null;
    private boolean reqDK = false;
    private boolean useNonce = false;
    private boolean useCreated = false;

    public UsernameToken() {
        this.id = PolicyUtil.randomUUID();
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this.includeToken = this.spVersion.includeTokenAlways;
    }

    public UsernameToken(AssertionData name, Collection<PolicyAssertion> nestedAssertions, AssertionSet nestedAlternative) {
        super(name, nestedAssertions, nestedAlternative);
        this.id = PolicyUtil.randomUUID();
        String nsUri = this.getName().getNamespaceURI();
        this.spVersion = PolicyUtil.getSecurityPolicyVersion(nsUri);
        this.itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        this.includeToken = this.spVersion.includeTokenAlways;
    }

    public void setType(String type) {
        this.tokenType = type;
    }

    @Override
    public String getType() {
        this.populate();
        return this.tokenType;
    }

    @Override
    public String getTokenId() {
        return this.id;
    }

    public void setTokenId(String _id) {
        this.id = _id;
    }

    @Override
    public String getIncludeToken() {
        this.populate();
        return this.includeToken;
    }

    public void setIncludeToken(String type) {
        Map<QName, String> attrs = this.getAttributes();
        QName itQname = new QName(this.spVersion.namespaceUri, "IncludeToken");
        attrs.put(itQname, type);
    }

    @Override
    public Issuer getIssuer() {
        this.populate();
        return this.issuer;
    }

    @Override
    public IssuerName getIssuerName() {
        this.populate();
        return this.issuerName;
    }

    @Override
    public Claims getClaims() {
        this.populate();
        return this.claims;
    }

    @Override
    public SecurityAssertionValidator.AssertionFitness validate(boolean isServer) {
        return this.populate(isServer);
    }

    private void populate() {
        this.populate(false);
    }

    @Override
    public boolean hasPassword() {
        return this.hasPassword;
    }

    @Override
    public boolean useHashPassword() {
        return this.useHashPassword;
    }

    @Override
    public boolean isRequireDerivedKeys() {
        this.populate();
        return this.reqDK;
    }

    private synchronized SecurityAssertionValidator.AssertionFitness populate(boolean isServer) {
        if (!this.populated) {
            NestedPolicy policy;
            if (this.getAttributeValue(this.itQname) != null) {
                this.includeToken = this.getAttributeValue(this.itQname);
            }
            if ((policy = this.getNestedPolicy()) == null) {
                if (Constants.logger.getLevel() == Level.FINE) {
                    Constants.logger.log(Level.FINE, "NestedPolicy is null");
                }
                this.populated = true;
                return this.fitness;
            }
            AssertionSet assertionSet = policy.getAssertionSet();
            for (PolicyAssertion assertion : assertionSet) {
                if (PolicyUtil.isUsernameTokenType(assertion, this.spVersion)) {
                    this.tokenType = assertion.getName().getLocalPart();
                    continue;
                }
                if (PolicyUtil.hasPassword(assertion, this.spVersion)) {
                    this.hasPassword = false;
                    continue;
                }
                if (PolicyUtil.isHashPassword(assertion, this.spVersion)) {
                    this.useHashPassword = true;
                    continue;
                }
                if (PolicyUtil.isRequireDerivedKeys(assertion, this.spVersion)) {
                    this.reqDK = true;
                    continue;
                }
                if (PolicyUtil.useCreated(assertion, this.spVersion)) {
                    this.useCreated = true;
                    continue;
                }
                if (PolicyUtil.useNonce(assertion, this.spVersion)) {
                    this.useNonce = true;
                    this.useCreated = true;
                    continue;
                }
                if (assertion.isOptional()) continue;
                Constants.log_invalid_assertion(assertion, isServer, "UsernameToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_UNKNOWN_ASSERTION;
            }
            if (this.hasParameters()) {
                Iterator<PolicyAssertion> it = this.getParametersIterator();
                while (it.hasNext()) {
                    PolicyAssertion assertion;
                    assertion = it.next();
                    if (PolicyUtil.isIssuer(assertion, this.spVersion)) {
                        this.issuer = (Issuer)assertion;
                        continue;
                    }
                    if (PolicyUtil.isIssuerName(assertion, this.spVersion)) {
                        this.issuerName = (IssuerName)assertion;
                        continue;
                    }
                    if (!PolicyUtil.isClaimsElement(assertion) || !SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(this.spVersion.namespaceUri)) continue;
                    this.claims = (Claims)assertion;
                }
            }
            if (this.issuer != null && this.issuerName != null) {
                Constants.log_invalid_assertion(this.issuerName, isServer, "SecureConversationToken");
                this.fitness = SecurityAssertionValidator.AssertionFitness.HAS_INVALID_VALUE;
            }
            this.populated = true;
        }
        return this.fitness;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SecurityPolicyVersion getSecurityPolicyVersion() {
        return this.spVersion;
    }

    @Override
    public Set getTokenRefernceType() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean useNonce() {
        return this.useNonce;
    }

    @Override
    public boolean useCreated() {
        return this.useCreated;
    }
}

