/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.at.internal;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.tx.at.WSATException;
import com.sun.xml.ws.tx.at.WSATHelper;
import com.sun.xml.ws.tx.at.common.TransactionImportManager;
import com.sun.xml.ws.tx.at.internal.ForeignRecoveryContext;
import com.sun.xml.ws.tx.at.internal.ForeignRecoveryContextManager;
import com.sun.xml.ws.tx.at.internal.JTAHelper;
import com.sun.xml.ws.tx.at.internal.WSATGatewayRM;
import com.sun.xml.ws.tx.at.internal.XidImpl;
import com.sun.xml.ws.tx.at.runtime.TransactionServices;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import javax.xml.ws.EndpointReference;

public class TransactionServicesImpl
implements TransactionServices {
    private static TransactionServices INSTANCE;
    private static Logger LOGGER;
    static List<Xid> importedXids;

    public static TransactionServices getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TransactionServicesImpl();
        }
        return INSTANCE;
    }

    private TransactionServicesImpl() {
        ForeignRecoveryContextManager.getInstance().start();
    }

    public byte[] getGlobalTransactionId() {
        return new byte[]{97};
    }

    private void removeFromImportedXids(Xid xid) {
        importedXids.remove(xid);
    }

    public Xid enlistResource(XAResource resource, Xid xid) throws WSATException {
        WSATGatewayRM wsatgw = WSATGatewayRM.getInstance();
        if (wsatgw == null) {
            throw new WSATException("WS-AT gateway not deployed.");
        }
        Transaction transaction = WSATHelper.getInstance().getFromXidToTransactionMap(xid);
        try {
            return wsatgw.registerWSATResource(xid, resource, transaction);
        }
        catch (IllegalStateException e) {
            throw new WSATException(e);
        }
        catch (RollbackException e) {
            throw new WSATException((Exception)((Object)e));
        }
        catch (SystemException e) {
            throw new WSATException((Exception)((Object)e));
        }
    }

    public void registerSynchronization(Synchronization synchronization, Xid xid) throws WSATException {
        this.debug("regsync");
    }

    public Xid importTransaction(int timeout, byte[] tId) throws WSATException {
        XidImpl xidImpl = new XidImpl(tId);
        if (importedXids.contains(xidImpl)) {
            return xidImpl;
        }
        TransactionImportManager.getInstance().recreate(xidImpl, timeout);
        importedXids.add(xidImpl);
        return null;
    }

    public String prepare(byte[] tId) throws WSATException {
        int vote;
        this.debug("prepare:" + new String(tId));
        XidImpl xidImpl = new XidImpl(tId);
        this.removeFromImportedXids(xidImpl);
        ForeignRecoveryContextManager.getInstance().persist(xidImpl);
        try {
            vote = TransactionImportManager.getInstance().getXATerminator().prepare((Xid)xidImpl);
        }
        catch (XAException ex) {
            LOGGER.warning(ex.getMessage() + " errorcode:" + ex.errorCode, ex);
            throw new WSATException(ex.getMessage() + " errorcode:" + ex.errorCode, ex);
        }
        finally {
            TransactionImportManager.getInstance().release(xidImpl);
        }
        if (vote == 3) {
            this.debug("deleting record due to readonly reply from prepare for txid:" + new String(tId));
            ForeignRecoveryContextManager.getInstance().delete(xidImpl);
        }
        return vote == 0 ? "Prepared" : "ReadOnly";
    }

    public void commit(byte[] tId) throws WSATException {
        this.debug("commit:" + new String(tId));
        XidImpl xidImpl = new XidImpl(tId);
        try {
            TransactionImportManager.getInstance().getXATerminator().commit((Xid)xidImpl, false);
            ForeignRecoveryContextManager.getInstance().delete(xidImpl);
        }
        catch (XAException ex) {
            LOGGER.warning(ex.getMessage() + " errorcode:" + ex.errorCode, ex);
            throw new WSATException(ex.getMessage() + " errorcode:" + ex.errorCode, ex);
        }
        finally {
            TransactionImportManager.getInstance().release(xidImpl);
        }
    }

    public void rollback(byte[] tId) throws WSATException {
        this.debug("rollback:" + new String(tId));
        XidImpl xidImpl = new XidImpl(tId);
        this.removeFromImportedXids(xidImpl);
        try {
            TransactionImportManager.getInstance().getXATerminator().rollback((Xid)xidImpl);
            ForeignRecoveryContextManager.getInstance().delete(xidImpl);
        }
        catch (XAException ex) {
            LOGGER.warning(ex.getMessage() + " errorcode:" + ex.errorCode, ex);
            if (ex.errorCode == -4 || ex.errorCode == -6) {
                ForeignRecoveryContextManager.getInstance().delete(xidImpl);
            }
            throw new WSATException(ex.getMessage() + " errorcode:" + ex.errorCode, ex);
        }
        finally {
            TransactionImportManager.getInstance().release(xidImpl);
        }
    }

    public void replayCompletion(String tId, XAResource xaResource) throws WSATException {
        this.debug("replayCompletion tid:" + tId + " xaResource:" + xaResource);
        XidImpl xid = new XidImpl(tId.getBytes());
        ForeignRecoveryContext foreignRecoveryContext = ForeignRecoveryContextManager.getInstance().getForeignRecoveryContext(xid);
        if (WSATHelper.isDebugEnabled()) {
            this.debug("replayCompletion() tid=" + tId + " xid=" + xid + " foreignRecoveryContext=" + foreignRecoveryContext);
        }
        if (foreignRecoveryContext == null) {
            try {
                xaResource.rollback(xid);
                ForeignRecoveryContextManager.getInstance().delete(xid);
            }
            catch (XAException xae) {
                this.debug("replayCompletion() tid=" + tId + " (" + xid + "), XAException (" + JTAHelper.xaErrorCodeToString(xae.errorCode, false) + ") rolling back imported transaction: " + xae);
                throw new WSATException("XAException on rollback of subordinate in response to replayCompletion for " + xid + "(tid=" + tId + ")", xae);
            }
        }
    }

    public EndpointReference getParentReference(Xid xid) {
        this.debug("getParentReference xid:" + xid);
        if (xid == null) {
            throw new IllegalArgumentException("No subordinate transaction parent reference as xid is null");
        }
        ForeignRecoveryContext foreignRecoveryContext = ForeignRecoveryContextManager.getInstance().getForeignRecoveryContext(xid);
        if (foreignRecoveryContext == null) {
            throw new AssertionError((Object)("No recovery context associated with transaction " + xid));
        }
        return foreignRecoveryContext.getEndpointReference();
    }

    private void debug(String msg) {
        LOGGER.log(Level.INFO, msg);
    }

    static {
        LOGGER = Logger.getLogger(TransactionServicesImpl.class);
        importedXids = new ArrayList<Xid>();
    }
}

