/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.SelectorFactory;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class OutputWriter {
    private static int defaultWriteTimeout = 30000;

    public static long flushChannel(SocketChannel socketChannel, ByteBuffer bb) throws IOException {
        return OutputWriter.flushChannel(socketChannel, bb, (long)defaultWriteTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long flushChannel(SocketChannel socketChannel, ByteBuffer bb, long writeTimeout) throws IOException {
        if (bb == null || socketChannel == null) {
            if (SelectorThread.logger().isLoggable(Level.FINE)) {
                SelectorThread.logger().log(Level.FINE, "Invalid Response State " + bb + "SocketChannel cannot be null." + socketChannel);
            }
            return -1L;
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        int bytesProduced = 0;
        try {
            while (bb.hasRemaining()) {
                int len = socketChannel.write(bb);
                ++attempts;
                if (len < 0) {
                    throw new EOFException();
                }
                bytesProduced += len;
                if (len == 0) {
                    if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
                    key = socketChannel.register(writeSelector, 4);
                    if (writeSelector.select(writeTimeout) == 0) {
                        if (attempts <= 2) continue;
                        throw new IOException("Client disconnected");
                    }
                    --attempts;
                    continue;
                }
                attempts = 0;
            }
        }
        finally {
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector != null) {
                SelectorFactory.selectNowAndReturnSelector(writeSelector);
            }
        }
        return bytesProduced;
    }

    public static long flushChannel(SocketChannel socketChannel, ByteBuffer[] bb) throws IOException {
        return OutputWriter.flushChannel(socketChannel, bb, (long)defaultWriteTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long flushChannel(SocketChannel socketChannel, ByteBuffer[] bb, long writeTimeout) throws IOException {
        long byteProduced;
        if (bb == null) {
            throw new IllegalStateException("Invalid Response State. ByteBuffer cannot be null.");
        }
        if (socketChannel == null) {
            throw new IllegalStateException("Invalid Response State. SocketChannel cannot be null.");
        }
        SelectionKey key = null;
        Selector writeSelector = null;
        int attempts = 0;
        long totalBytes = 0L;
        for (ByteBuffer aBb : bb) {
            totalBytes += (long)aBb.remaining();
        }
        try {
            long len;
            for (byteProduced = 0L; byteProduced < totalBytes; byteProduced += len) {
                len = socketChannel.write(bb);
                ++attempts;
                if (len < 0L) {
                    throw new EOFException();
                }
                if (len == 0L) {
                    if (writeSelector == null && (writeSelector = SelectorFactory.getSelector()) == null) continue;
                    key = socketChannel.register(writeSelector, 4);
                    if (writeSelector.select(writeTimeout) == 0) {
                        if (attempts <= 2) continue;
                        throw new IOException("Client disconnected");
                    }
                    --attempts;
                    continue;
                }
                attempts = 0;
            }
        }
        finally {
            if (key != null) {
                key.cancel();
                key = null;
            }
            if (writeSelector != null) {
                SelectorFactory.selectNowAndReturnSelector(writeSelector);
            }
        }
        return byteProduced;
    }

    public static int getDefaultWriteTimeout() {
        return defaultWriteTimeout;
    }

    public static void setDefaultWriteTimeout(int aDefaultWriteTimeout) {
        defaultWriteTimeout = aDefaultWriteTimeout;
    }
}

