/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.comet;

import com.sun.enterprise.web.connector.grizzly.AsyncExecutor;
import com.sun.enterprise.web.connector.grizzly.AsyncHandler;
import com.sun.enterprise.web.connector.grizzly.ConcurrentQueue;
import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.ProcessorTask;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.async.AsyncProcessorTask;
import com.sun.enterprise.web.connector.grizzly.comet.CometContext;
import com.sun.enterprise.web.connector.grizzly.comet.CometSelector;
import com.sun.enterprise.web.connector.grizzly.comet.CometTask;
import com.sun.enterprise.web.connector.grizzly.comet.DefaultNotificationHandler;
import com.sun.enterprise.web.connector.grizzly.comet.NotificationHandler;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CometEngine {
    public static final int DISABLE_SUSPEND_TIMEOUT = -1;
    public static final int DISABLE_CLIENT_DISCONNECTION_DETECTION = 0;
    public static final int BEFORE_REQUEST_PROCESSING = 0;
    public static final int AFTER_SERVLET_PROCESSING = 1;
    public static final int AFTER_RESPONSE_PROCESSING = 2;
    private static final Logger logger = SelectorThread.logger();
    protected Pipeline pipeline;
    private static CometEngine cometEngine;
    protected ConcurrentHashMap<String, CometContext> activeContexts;
    protected Queue<CometTask> cometTasks;
    protected Queue<CometContext> cometContexts;
    protected CometSelector cometSelector;
    protected static String notificationHandlerClassName;
    protected ConcurrentHashMap<Long, SelectionKey> threadsId;
    protected ConcurrentHashMap<Long, CometContext> updatedCometContexts;
    private Queue<AsyncProcessorTask> asyncTasks;
    private ReentrantLock lock = new ReentrantLock();

    protected CometEngine() {
        this.activeContexts = new ConcurrentHashMap();
        this.cometTasks = new ConcurrentQueue<CometTask>("CometEngine.cometTasks");
        this.cometContexts = new ConcurrentQueue<CometContext>("CometEngine.cometContexts");
        this.cometSelector = new CometSelector(this);
        try {
            this.cometSelector.start();
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, "Unable to start CometSelector", ex);
        }
        this.threadsId = new ConcurrentHashMap();
        this.updatedCometContexts = new ConcurrentHashMap();
        this.asyncTasks = new ConcurrentQueue<AsyncProcessorTask>("CometEngine.asyncTasks");
    }

    public static synchronized CometEngine getEngine() {
        if (cometEngine == null) {
            cometEngine = new CometEngine();
        }
        return cometEngine;
    }

    public synchronized CometContext unregister(String topic) {
        CometContext cometContext = this.activeContexts.get(topic);
        try {
            cometContext.notify(cometContext, 3);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "unregister", ex);
        }
        this.finalizeContext(cometContext);
        return this.activeContexts.remove(topic);
    }

    public CometContext register(String topic) {
        return this.register(topic, 1);
    }

    public synchronized CometContext register(String topic, int type) {
        return this.register(topic, type, CometContext.class);
    }

    public synchronized CometContext register(String topic, int type, Class<? extends CometContext> contextclass) {
        CometContext cometContext = this.activeContexts.get(topic);
        if (cometContext == null) {
            cometContext = this.cometContexts.poll();
            if (cometContext == null) {
                try {
                    cometContext = contextclass.getConstructor(String.class, Integer.TYPE).newInstance(topic, type);
                }
                catch (Throwable t) {
                    logger.log(Level.SEVERE, "Invalid CometContext class : ", t);
                    cometContext = new CometContext(topic, type);
                }
                cometContext.setCometSelector(this.cometSelector);
                NotificationHandler notificationHandler = CometEngine.loadNotificationHandlerInstance(notificationHandlerClassName);
                cometContext.setNotificationHandler(notificationHandler);
                if (notificationHandler != null && notificationHandler instanceof DefaultNotificationHandler) {
                    ((DefaultNotificationHandler)notificationHandler).setPipeline(this.pipeline);
                }
            }
            this.activeContexts.put(topic, cometContext);
        }
        return cometContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handle(AsyncProcessorTask apt) throws IOException {
        if (this.pipeline == null) {
            this.pipeline = apt.getPipeline();
        }
        String topic = apt.getProcessorTask().getRequestURI();
        CometContext cometContext = null;
        if (topic != null) {
            cometContext = this.activeContexts.get(topic);
            try {
                NotificationHandler notificationHandler;
                this.lock.lock();
                if (cometContext != null && (notificationHandler = cometContext.getNotificationHandler()) instanceof DefaultNotificationHandler) {
                    ((DefaultNotificationHandler)notificationHandler).setPipeline(this.pipeline);
                }
            }
            finally {
                this.lock.unlock();
            }
        }
        boolean activateContinuation = true;
        SelectionKey key = apt.getProcessorTask().getSelectionKey();
        this.threadsId.put(Thread.currentThread().getId(), key);
        int continuationType = cometContext == null ? 1 : cometContext.continuationType;
        this.executeServlet(continuationType, apt);
        cometContext = this.updatedCometContexts.remove(Thread.currentThread().getId());
        if (cometContext == null) {
            activateContinuation = false;
        }
        boolean parkRequest = true;
        if (activateContinuation) {
            CometContext.addInProgressSelectionKey(key);
            key.attach(null);
            boolean isBlocking = cometContext.isBlockingNotification();
            cometContext.setBlockingNotification(true);
            cometContext.initialize(key);
            cometContext.setBlockingNotification(isBlocking);
            if (cometContext.getCometHandler(key) != null) {
                this.asyncTasks.offer(apt);
                CometTask cometTask = this.getCometTask(cometContext, key, apt.getPipeline());
                cometTask.setSelectorThread(apt.getSelectorThread());
                cometTask.setExpirationDelay(cometContext.getExpirationDelay());
                cometContext.addActiveCometTask(cometTask);
                if (cometContext.getExpirationDelay() != 0L) {
                    this.cometSelector.registerKey(key, cometTask);
                }
            } else {
                parkRequest = false;
            }
            CometContext.removeInProgressSelectionKey(key);
        } else {
            parkRequest = false;
        }
        return parkRequest;
    }

    protected SelectionKey activateContinuation(Long threadId, CometContext cometContext, boolean continueExecution) {
        if (!continueExecution) {
            this.updatedCometContexts.put(threadId, cometContext);
        }
        return this.threadsId.remove(threadId);
    }

    protected CometTask getCometTask(CometContext cometContext, SelectionKey key, Pipeline ctxPipeline) {
        CometTask cometTask;
        if (ctxPipeline == null) {
            ctxPipeline = this.pipeline;
        }
        if ((cometTask = this.cometTasks.poll()) == null) {
            cometTask = new CometTask();
        }
        cometTask.setCometContext(cometContext);
        cometTask.setSelectionKey(key);
        cometTask.setCometSelector(this.cometSelector);
        cometTask.setPipeline(ctxPipeline);
        return cometTask;
    }

    private void finalizeContext(CometContext cometContext) {
        for (String topic : this.activeContexts.keySet()) {
            if (!this.activeContexts.get(topic).equals(cometContext)) continue;
            this.activeContexts.remove(topic);
            break;
        }
        for (AsyncProcessorTask apt : this.asyncTasks) {
            this.flushResponse(apt);
        }
        cometContext.recycle();
        this.cometContexts.offer(cometContext);
    }

    public CometContext getCometContext(String topic) {
        return this.activeContexts.get(topic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interrupt(SelectionKey key) {
        CometTask cometTask = (CometTask)key.attachment();
        key.attach(null);
        if (cometTask == null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("CometTask was null");
            }
            return;
        }
        SelectionKey akey = cometTask.getSelectionKey();
        try {
            if (akey == null || !akey.isValid()) {
                return;
            }
            Iterator iterator = this.asyncTasks.iterator();
            AsyncHandler ah = null;
            while (iterator.hasNext()) {
                AsyncProcessorTask apt = (AsyncProcessorTask)iterator.next();
                ah = apt.getAsyncExecutor().getAsyncHandler();
                if (apt.getProcessorTask().getSelectionKey() != akey) continue;
                iterator.remove();
                if (akey != null) {
                    akey.attach(null);
                }
                if (apt.getStage() != 2) {
                } else {
                    this.flushResponse(apt);
                }
                break;
            }
        }
        finally {
            this.returnTask(cometTask);
        }
    }

    protected void returnTask(CometTask cometTask) {
        cometTask.recycle();
        this.cometTasks.offer(cometTask);
    }

    protected synchronized void resume(SelectionKey key) {
        Iterator iterator = this.asyncTasks.iterator();
        AsyncProcessorTask apt = null;
        AsyncExecutor asyncE = null;
        ProcessorTask pt = null;
        while (iterator.hasNext()) {
            apt = (AsyncProcessorTask)iterator.next();
            asyncE = apt.getAsyncExecutor();
            if (asyncE == null) {
                return;
            }
            pt = apt.getProcessorTask();
            if (pt == null || pt.getSelectionKey() != key) continue;
            iterator.remove();
            if (apt.getStage() != 2) break;
            this.flushResponse(apt);
            break;
        }
    }

    private void flushResponse(AsyncProcessorTask apt) {
        apt.setStage(2);
        try {
            apt.doTask();
        }
        catch (IllegalStateException ex) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "flushResponse failed", ex);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "flushResponse failed", ex);
        }
    }

    private void executeServlet(int continuationType, AsyncProcessorTask apt) {
        try {
            switch (continuationType) {
                case 0: {
                    apt.setStage(0);
                    break;
                }
                case 1: {
                    apt.getProcessorTask().invokeAdapter();
                    return;
                }
                case 2: {
                    apt.setStage(2);
                    apt.doTask();
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid state");
                }
            }
            if (apt.getStage() == 2) {
                return;
            }
            apt.doTask();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "executeServlet", ex);
        }
    }

    public static String getNotificationHandlerClassName() {
        return notificationHandlerClassName;
    }

    public static void setNotificationHandlerClassName(String aNotificationHandlerClassName) {
        notificationHandlerClassName = aNotificationHandlerClassName;
    }

    protected static final NotificationHandler loadNotificationHandlerInstance(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            return (NotificationHandler)clazz.newInstance();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Invalid NotificationHandler: ", t);
            return new DefaultNotificationHandler();
        }
    }

    public static final Logger logger() {
        return logger;
    }

    static {
        notificationHandlerClassName = DefaultNotificationHandler.class.getName();
    }
}

