/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.hi.ihi;

import au.gov.nehta.common.utils.ArgumentUtils;
import au.gov.nehta.vendorlibrary.hi.handler.message.HIHeaderHandler;
import au.gov.nehta.vendorlibrary.hi.handler.security.HISecurityHandler;
import au.gov.nehta.vendorlibrary.hi.ihi.ConsumerSearchIHIClient;
import au.gov.nehta.vendorlibrary.ws.TimeUtility;
import au.gov.nehta.vendorlibrary.ws.WebServiceClientUtil;
import au.gov.nehta.vendorlibrary.ws.handler.LoggingHandler;
import au.net.electronichealth.ns.hi.common.commoncoreelements._3_0.ProductType;
import au.net.electronichealth.ns.hi.common.commoncoreelements._3_0.TimestampType;
import au.net.electronichealth.ns.hi.common.qualifiedidentifier._3_0.QualifiedId;
import au.net.electronichealth.ns.hi.consumermessages.searchihibatchmessages._3_0.SearchIHIRequestType;
import au.net.electronichealth.ns.hi.svc.consumersearchihibatchsync._3_0.ConsumerSearchIHIBatchSyncPortType;
import au.net.electronichealth.ns.hi.svc.consumersearchihibatchsync._3_0.ConsumerSearchIHIBatchSyncService;
import au.net.electronichealth.ns.hi.svc.consumersearchihibatchsync._3_0.SearchIHIBatchResponse;
import au.net.electronichealth.ns.hi.svc.consumersearchihibatchsync._3_0.SearchIHIBatchSync;
import au.net.electronichealth.ns.hi.svc.consumersearchihibatchsync._3_0.StandardErrorMsg;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Holder;

public class ConsumerSearchIHIBatchSyncClient {
    public static final String EMPTY = "";
    private static final short REQUEST_IDENTIFIER_LENGTH = 36;
    private static final String SSL_SOCKET_FACTORY = "com.sun.xml.ws.transport.https.client.SSLSocketFactory";
    private static final String HPIO_CSP_HEADER_ELEMENT_NAME = "hpio";
    private SSLSocketFactory sslSocketFactory;
    private PrivateKey signingPrivateKey;
    private X509Certificate signingCertificate;
    private LoggingHandler loggingHandler;
    private QualifiedId individualQualifiedId;
    private QualifiedId organisationQualifiedId;
    private Holder<ProductType> productHeader;
    private ConsumerSearchIHIBatchSyncPortType consumerSearchIHIBatchSyncPort;
    private String lastSoapRequest;
    private String lastSoapResponse;

    public ConsumerSearchIHIBatchSyncClient(String searchIhiServiceEndpoint, QualifiedId individualQualifiedId, Holder<ProductType> productHeader, PrivateKey signingPrivateKey, X509Certificate signingCertificate, SSLSocketFactory sslSocketFactory) {
        this(searchIhiServiceEndpoint, individualQualifiedId, null, productHeader, signingPrivateKey, signingCertificate, sslSocketFactory);
    }

    private ConsumerSearchIHIBatchSyncClient(String searchIhiServiceEndpoint, QualifiedId individualQualifiedId, QualifiedId organisationQualifiedId, Holder<ProductType> productHeader, PrivateKey signingPrivateKey, X509Certificate signingCertificate, SSLSocketFactory sslSocketFactory) {
        ArgumentUtils.checkNotNullNorBlank((String)searchIhiServiceEndpoint, (String)"searchIhiServiceEndpoint");
        ArgumentUtils.checkNotNull((Object)individualQualifiedId, (String)"qualifiedId");
        ArgumentUtils.checkNotNull(productHeader, (String)"productHeader");
        ArgumentUtils.checkNotNull((Object)signingPrivateKey, (String)"signingPrivateKey");
        ArgumentUtils.checkNotNull((Object)signingCertificate, (String)"signingPrivateKey");
        ArgumentUtils.checkNotNull((Object)sslSocketFactory, (String)"sslSocketFactory");
        this.signingPrivateKey = signingPrivateKey;
        this.signingCertificate = signingCertificate;
        this.sslSocketFactory = sslSocketFactory;
        this.individualQualifiedId = individualQualifiedId;
        this.organisationQualifiedId = organisationQualifiedId;
        this.productHeader = productHeader;
        this.loggingHandler = new LoggingHandler(false);
        ArrayList<LoggingHandler> handlerChain = new ArrayList<LoggingHandler>();
        handlerChain.add(this.loggingHandler);
        this.consumerSearchIHIBatchSyncPort = (ConsumerSearchIHIBatchSyncPortType)WebServiceClientUtil.getPort(ConsumerSearchIHIBatchSyncPortType.class, ConsumerSearchIHIBatchSyncService.class, (SocketFactory)sslSocketFactory, handlerChain);
        this.configureEndpoint(this.consumerSearchIHIBatchSyncPort, searchIhiServiceEndpoint);
    }

    public final SearchIHIBatchResponse batchSearch(SearchBatch request) throws StandardErrorMsg {
        TimestampType timestampHeader = new TimestampType();
        timestampHeader.setCreated(TimeUtility.nowXMLGregorianCalendar());
        Holder signatureHeader = null;
        return this.consumerSearchIHIBatchSyncPort.searchIHIBatchSync(request.getBatch(), this.productHeader, timestampHeader, signatureHeader, this.individualQualifiedId, this.organisationQualifiedId);
    }

    private void configureEndpoint(Object servicePort, String endpoint) {
        BindingProvider bindingProvider = (BindingProvider)servicePort;
        Map requestContext = bindingProvider.getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", endpoint.trim());
        requestContext.put(SSL_SOCKET_FACTORY, this.sslSocketFactory);
        if (bindingProvider != null && bindingProvider.getBinding() != null) {
            Binding binding = bindingProvider.getBinding();
            List handlerChain = binding.getHandlerChain();
            ArrayList<String> headerNames = new ArrayList<String>();
            headerNames.add(HPIO_CSP_HEADER_ELEMENT_NAME);
            handlerChain.add(new HIHeaderHandler(headerNames));
            handlerChain.add(new HISecurityHandler(this.signingCertificate, this.signingPrivateKey));
            handlerChain.add(this.loggingHandler);
            binding.setHandlerChain(handlerChain);
        }
    }

    public final String getLastSoapResponse() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapResponse();
        }
        return EMPTY;
    }

    public final String getLastSoapRequest() {
        if (this.loggingHandler != null) {
            return this.loggingHandler.getLastSoapRequest();
        }
        return EMPTY;
    }

    public static class SearchBatch {
        private SearchIHIBatchSync searchIhiBatchSync = new SearchIHIBatchSync();
        private List<SearchIHIRequestType> searches = this.searchIhiBatchSync.getSearchIHIBatchRequest();
        private ConsumerSearchIHIClient.ArgumentValidator argumentValidator = new ConsumerSearchIHIClient.ArgumentValidator();

        public final void addBasicSearch(SearchIHIRequestType search) {
            this.argumentValidator.basicSearchCheck(search.getSearchIHI());
            this.validateRequestIdentifier(search.getRequestIdentifier());
            this.searches.add(search);
        }

        public final void addBasicMedicareSearch(SearchIHIRequestType search) {
            this.argumentValidator.basicMedicareSearchCheck(search.getSearchIHI());
            this.validateRequestIdentifier(search.getRequestIdentifier());
            this.searches.add(search);
        }

        public final void addBasicDvaSearch(SearchIHIRequestType search) {
            this.argumentValidator.basicDvaSearchCheck(search.getSearchIHI());
            this.validateRequestIdentifier(search.getRequestIdentifier());
            this.searches.add(search);
        }

        public final void addDetailedSearch(SearchIHIRequestType search) {
            this.argumentValidator.detailedSearchCheck(search.getSearchIHI());
            this.validateRequestIdentifier(search.getRequestIdentifier());
            this.searches.add(search);
        }

        public final void addAustralianPostalAddressSearch(SearchIHIRequestType search) {
            this.argumentValidator.australianPostalAddressSearchCheck(search.getSearchIHI());
            this.validateRequestIdentifier(search.getRequestIdentifier());
            this.searches.add(search);
        }

        public final void addAustralianStreetAddressSearch(SearchIHIRequestType search) {
            this.argumentValidator.australianStreetAddressSearchCheck(search.getSearchIHI());
            this.validateRequestIdentifier(search.getRequestIdentifier());
            this.searches.add(search);
        }

        public final void addInternationalAddressSearch(SearchIHIRequestType search) {
            this.argumentValidator.internationalAddressSearchCheck(search.getSearchIHI());
            this.validateRequestIdentifier(search.getRequestIdentifier());
            this.searches.add(search);
        }

        private void validateRequestIdentifier(String requestIdentifier) {
            if (requestIdentifier == null) {
                throw new IllegalArgumentException("request Identifier may not be null");
            }
            if (requestIdentifier.length() != 36) {
                throw new IllegalArgumentException("request Identifier must have a length of 36");
            }
        }

        public final SearchIHIBatchSync getBatch() {
            return this.searchIhiBatchSync;
        }
    }
}

