/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DomUtils {
    private static DocumentBuilderFactory DOCBUILDER_FACTORY;

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (DOCBUILDER_FACTORY == null) {
            DOCBUILDER_FACTORY = DocumentBuilderFactory.newInstance();
            DOCBUILDER_FACTORY.setNamespaceAware(true);
        }
        return DOCBUILDER_FACTORY.newDocumentBuilder();
    }

    public static Document newDocument() throws ParserConfigurationException {
        return DomUtils.getDocumentBuilder().newDocument();
    }

    public static Document newDocument(Node rootNode) throws ParserConfigurationException {
        assert (rootNode != null) : "'rootNode' is null.";
        Document doc = DomUtils.newDocument();
        Node nodeCopy = doc.importNode(rootNode, true);
        doc.appendChild(nodeCopy);
        return doc;
    }

    public static Document parse(File file) throws ParserConfigurationException, IOException, SAXException {
        assert (file != null) : "'file' is null.";
        return DomUtils.getDocumentBuilder().parse(file);
    }

    public static Document parse(Reader reader) throws ParserConfigurationException, IOException, SAXException {
        assert (reader != null) : "'reader' is null.";
        return DomUtils.getDocumentBuilder().parse(new InputSource(reader));
    }

    public static Document parse(Reader reader, ErrorHandler errorHandler) throws ParserConfigurationException, SAXException, IOException {
        assert (reader != null) : "'reader' is null.";
        DocumentBuilder parser = DomUtils.getDocumentBuilder();
        if (errorHandler != null) {
            parser.setErrorHandler(errorHandler);
        }
        return parser.parse(new InputSource(reader));
    }

    public static String serialiseToString(Element xmlElem) throws TransformerException, IOException {
        assert (xmlElem != null) : "'xmlElem' is null.";
        StringWriter writer = new StringWriter();
        DomUtils.serialiseNode(xmlElem, writer);
        return writer.toString();
    }

    public static String serialiseToString(Document xmlDoc) throws TransformerException, IOException {
        assert (xmlDoc != null) : "'xmlDoc' is null.";
        StringWriter writer = new StringWriter();
        DomUtils.serialiseNode(xmlDoc, writer);
        return writer.toString();
    }

    public static void serialise(Document xmlDoc, File file) throws TransformerException, IOException {
        assert (xmlDoc != null) : "'xmlDoc' is null.";
        assert (file != null) : "'file' is null.";
        DomUtils.serialiseNode(xmlDoc, new FileWriter(file));
    }

    public static void serialise(Document xmlDoc, Writer writer) throws TransformerException, IOException {
        assert (xmlDoc != null) : "'xmlDoc' is null.";
        assert (writer != null) : "'writer' is null.";
        DomUtils.serialiseNode(xmlDoc, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serialiseNode(Node xmlNode, Writer writer) throws TransformerException, IOException {
        assert (xmlNode != null);
        assert (writer != null);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        try {
            DOMSource source = new DOMSource(xmlNode);
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    public static Element getFirstChildElement(Node node) {
        assert (node != null) : "'node' is null.";
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() > 0) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node currentNode = childNodes.item(i);
                if (!(currentNode instanceof Element)) continue;
                return (Element)currentNode;
            }
        }
        return null;
    }

    public static List<Element> getChildElements(Node node) {
        assert (node != null) : "'node' is null.";
        ArrayList<Element> childElems = new ArrayList<Element>();
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            childElems.add((Element)childNode);
        }
        return childElems;
    }

    public static Element getChildElement(Element element, String namespace, String tagName) {
        assert (element != null) : "'element' is null.";
        assert (namespace != null) : "'namespace' is null.";
        assert (namespace.trim().length() > 0) : "'namespace' is a blank string.";
        assert (tagName != null) : "'tagName' is null.";
        assert (tagName.trim().length() > 0) : "'tagName' is a blank string.";
        List<Element> childElems = DomUtils.getChildElements(element, namespace, tagName);
        if (childElems.size() == 0) {
            throw new IllegalArgumentException("No '{" + namespace + "}" + tagName + "' element found.");
        }
        if (childElems.size() > 1) {
            throw new IllegalArgumentException("More than one '{" + namespace + "}" + tagName + "' elements found.");
        }
        return childElems.get(0);
    }

    public static List<Element> getChildElements(Element element, String namespace, String tagName) {
        assert (element != null) : "'element' is null.";
        assert (namespace != null) : "'namespace' is null.";
        assert (namespace.trim().length() > 0) : "'namespace' is a blank string.";
        assert (tagName != null) : "'tagName' is null.";
        assert (tagName.trim().length() > 0) : "'tagName' is a blank string.";
        ArrayList<Element> childElems = new ArrayList<Element>();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            Element childElem = (Element)childNode;
            String currNamespace = childElem.getNamespaceURI();
            String currLocalName = childElem.getLocalName();
            if (!namespace.equals(currNamespace) || !tagName.equals(currLocalName)) continue;
            childElems.add(childElem);
        }
        return childElems;
    }

    public static void addAttribute(Element elem, String attrName, String attrValue) {
        assert (elem != null) : "'elem' is null.";
        assert (attrName != null) : "'attrName' is null.";
        assert (attrName.trim().length() > 0) : "'attrName' is a blank string.";
        assert (attrValue != null) : "'attrValue' is null.";
        assert (attrValue.trim().length() > 0) : "'attrValue' is a blank string.";
        Document ownerDoc = elem.getOwnerDocument();
        Attr attr = ownerDoc.createAttributeNS(null, attrName);
        attr.setValue(attrValue);
        elem.setAttributeNodeNS(attr);
    }

    public static boolean isDocumentEmpty(Document xmlDoc) {
        assert (xmlDoc != null) : "'xmlDoc' is null.";
        return xmlDoc.getDocumentElement() == null;
    }

    public static void checkNotNullOrEmpty(Document xmlDoc, String name) {
        assert (name != null) : "'name' is null.";
        if (xmlDoc == null || DomUtils.isDocumentEmpty(xmlDoc)) {
            throw new IllegalArgumentException("'" + name + "' cannot be null or empty");
        }
    }

    public static boolean checkElement(Element elem, String name, String namespace) {
        assert (elem != null) : "'elem' is null.";
        assert (name != null) : "'name' is null.";
        assert (name.trim().length() > 0) : "'name' is a blank string.";
        assert (namespace != null) : "'namespace' is null.";
        assert (namespace.trim().length() > 0) : "'namespace' is a blank string.";
        return elem.getLocalName().equals(name) && elem.getNamespaceURI().equals(namespace);
    }

    public static void removeFormatting(Document xmlDoc) {
        if (xmlDoc != null) {
            DomUtils.removeFormatting(xmlDoc.getDocumentElement());
        }
    }

    public static void removeFormatting(Element xmlElem) {
        if (xmlElem != null) {
            String textContent;
            NodeList children = xmlElem.getChildNodes();
            boolean hasChildElements = false;
            ArrayList<Text> nodesToRemove = new ArrayList<Text>();
            for (int idx = 0; idx < children.getLength(); ++idx) {
                Text textChildNode;
                String childTextData;
                Node node = children.item(idx);
                if (node instanceof Element) {
                    Element elemChildNode = (Element)node;
                    hasChildElements = true;
                    DomUtils.removeFormatting(elemChildNode);
                    continue;
                }
                if (!(node instanceof Text) || (childTextData = (textChildNode = (Text)node).getData()).trim().length() != 0) continue;
                nodesToRemove.add(textChildNode);
            }
            for (Node node : nodesToRemove) {
                xmlElem.removeChild(node);
            }
            if (!hasChildElements && (textContent = xmlElem.getTextContent()).length() > 0) {
                xmlElem.setTextContent(textContent.trim());
            }
        }
    }

    private DomUtils() {
    }
}

