/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import au.gov.nehta.common.utils.ArgumentUtils;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class StandardFormatter {
    private static final StandardFormatter INSTANCE = new StandardFormatter();
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSSZ";
    private static final String UNKNOWN_DATE = "<UnknownDate>";
    private static final String UNKNOWN_CLASS = "<UnknownClass>";
    private static final String UNKNOWN_METHOD = "<UnknownMethod>";

    public static StandardFormatter getInstance() {
        return INSTANCE;
    }

    private StandardFormatter() {
    }

    public String formatDateTime(long timeInMillis) {
        return this.formatDateTime(new Date(timeInMillis));
    }

    public String formatDateTime(Date date) {
        String formattedStr = UNKNOWN_DATE;
        if (date != null) {
            SimpleDateFormat formatter = new SimpleDateFormat(DATE_TIME_FORMAT);
            formattedStr = formatter.format(date);
        }
        return formattedStr;
    }

    public String formatLocation(String className, String methodName) {
        String classNameStr = className;
        if (ArgumentUtils.isNullOrBlank(className)) {
            classNameStr = UNKNOWN_CLASS;
        }
        String methodNameStr = methodName;
        if (ArgumentUtils.isNullOrBlank(methodName)) {
            methodNameStr = UNKNOWN_METHOD;
        }
        return String.format("%s.%s()", classNameStr, methodNameStr);
    }
}

