/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.clinicalpackage.util;

import au.gov.nehta.vendorlibrary.clinicalpackage.enums.FormatTypes;
import java.util.List;
import java.util.Map;

public final class SubmissionSetException
extends RuntimeException {
    private static final String MESSAGE = "Failed to build submission set.";
    private final Map<String, List<String>> errorMap;

    public SubmissionSetException(Map<String, List<String>> errorMap) {
        super(MESSAGE);
        this.errorMap = errorMap;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(FormatTypes.ERROR_HEADER.getStructure(), SubmissionSetException.class.getSimpleName(), super.getMessage()));
        for (Map.Entry<String, List<String>> entry : this.errorMap.entrySet()) {
            sb.append(String.format("%s:\n", entry.getKey()));
            List<String> variableErrors = entry.getValue();
            for (String variableError : variableErrors) {
                sb.append(String.format("\t%s\n", variableError));
            }
        }
        return sb.toString();
    }
}

