﻿using System;
using System.Runtime.Serialization;
using Nehta.VendorLibrary.CDA.Common;

namespace CDA.Generator.Common.SCSModel.CeHR.Enum
  {
    /// <summary>
    /// Assesment
    /// </summary>
    [Serializable]
    [DataContract]
    public enum QuestionnairesData
    {
      /// <summary>
      /// NSW Family health history and risk factors
      /// </summary>
      [EnumMember]
      [Name(Code = "01", Name = "NSW Family health history and risk factors", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionnairesData")]
      NSWFamilyHealthHistoryAndRiskFactors,

      /// <summary>
      /// NSW Questions for parents about hearing
      /// </summary>
      [EnumMember]
      [Name(Code = "02", Name = "NSW Questions for parents about hearing", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionnairesData")]
      NSWQuestionsForParentsAboutHearing,

      /// <summary>
      /// NSW Questions for parents - 1 to 4 week check
      /// </summary>
      [EnumMember]
      [Name(Code = "03", Name = "NSW Questions for parents - 1 to 4 week check", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionnairesData")]
      NSWQuestionsForParents1To4WeekCheck,

      /// <summary>
      /// NSW Questions for parents - 6 to 8 week check
      /// </summary>
      [EnumMember]
      [Name(Code = "04", Name = "NSW Questions for parents - 6 to 8 week check", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionnairesData")]
      NSWQuestionsForParents6To8WeekCheck,

      /// <summary>
      /// NSW Questions for parents - 6 month check
      /// </summary>
      [EnumMember]
      [Name(Code = "05", Name = "NSW Questions for parents - 6 month check", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionnairesData")]
      NSWQuestionsForParents6MonthCheck,

      /// <summary>
      /// NSW Questions for parents - 12 month check
      /// </summary>
      [EnumMember]
      [Name(Code = "06", Name = "NSW Questions for parents - 12 month check", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionnairesData")]
      NSWQuestionsForParents12MonthCheck,

      /// <summary>
      /// NSW Questions for parents - 18 month check
      /// </summary>
      [EnumMember]
      [Name(Code = "07", Name = "NSW Questions for parents - 18 month check", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionnairesData")]
      NSWQuestionsForParents18MonthCheck,

      /// <summary>
      /// NSW Questions for parents - 2 year check
      /// </summary>
      [EnumMember]
      [Name(Code = "08", Name = "NSW Questions for parents - 2 year check", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionnairesData")]
      NSWQuestionsForParents2YearCheck,

      /// <summary>
      /// NSW Questions for parents - 3 year check
      /// </summary>
      [EnumMember]
      [Name(Code = "09", Name = "NSW Questions for parents - 3 year check", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionnairesData")]
      NSWQuestionsForParents3YearCheck,

      /// <summary>
      /// NSW Questions for parents - 4 year check
      /// </summary>
      [EnumMember]
      [Name(Code = "10", Name = "NSW Questions for parents - 4 year check", CodeSystem = "NewSouthWalesChildDevelopmentalQuestionnairesData")]
      NSWQuestionsForParents4YearCheck,
    }
  }

