﻿/*
 * Copyright 2011 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

using System;
using System.Runtime.Serialization;

namespace Nehta.VendorLibrary.CDA.Common.Enums
{
    /// <summary>
    /// Occupations
    /// </summary>
    [Serializable]
    [DataContract]
    public enum Occupation
    {
        /// <summary>
        /// Undefined, this is the default value if the enum is left unset.
        /// 
        /// The validation engine uses this to test and assert that the enum has been set (if required)
        /// and is therefore valid.
        /// </summary>
        [EnumMember]
        Undefined,

        /// <summary>
        /// ChiefExecutiveOrManagingDirector
        /// </summary>
        [EnumMember]
        [Name(Code = "111111", Name = "Chief Executive or Managing Director")]
        ChiefExecutiveOrManagingDirector,

        /// <summary>
        /// CorporateGeneralManager
        /// </summary>
        [EnumMember]
        [Name(Code = "111211", Name = "Corporate General Manager")]
        CorporateGeneralManager,

        /// <summary>
        /// CefenceForceSeniorOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "111212", Name = "Defence Force Senior Officer")]
        CefenceForceSeniorOfficer,

        /// <summary>
        /// LocalGovernmentLegislator
        /// </summary>
        [EnumMember]
        [Name(Code = "111311", Name = "Local Government Legislator")]
        LocalGovernmentLegislator,

        /// <summary>
        /// MemberOfParliament
        /// </summary>
        [EnumMember]
        [Name(Code = "111312", Name = "Member of Parliament")]
        MemberOfParliament,

        /// <summary>
        /// LegislatorsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "111399", Name = "Legislators nec")]
        LegislatorsNec,

        /// <summary>
        /// AquacultureFarmer
        /// </summary>
        [EnumMember]
        [Name(Code = "121111", Name = "Aquaculture Farmer")]
        AquacultureFarmer,

        /// <summary>
        /// CottonGrower
        /// </summary>
        [EnumMember]
        [Name(Code = "121211", Name = "Cotton Grower")]
        CottonGrower,

        /// <summary>
        /// FlowerGrower
        /// </summary>
        [EnumMember]
        [Name(Code = "121212", Name = "Flower Grower")]
        FlowerGrower,

        /// <summary>
        /// FruitOrNutGrower
        /// </summary>
        [EnumMember]
        [Name(Code = "121213", Name = "Fruit or Nut Grower")]
        FruitOrNutGrower,

        /// <summary>
        /// GrainOilseedOrPastureGrower
        /// </summary>
        [EnumMember]
        [Name(Code = "121214", Name = "Grain, Oilseed or Pasture Grower")]
        GrainOilseedOrPastureGrower,

        /// <summary>
        /// GrapeGrower
        /// </summary>
        [EnumMember]
        [Name(Code = "121215", Name = "Grape Grower")]
        GrapeGrower,

        /// <summary>
        /// MixedCropFarmer
        /// </summary>
        [EnumMember]
        [Name(Code = "121216", Name = "Mixed Crop Farmer")]
        MixedCropFarmer,

        /// <summary>
        /// SugarCaneGrower
        /// </summary>
        [EnumMember]
        [Name(Code = "121217", Name = "Sugar Cane Grower")]
        SugarCaneGrower,

        /// <summary>
        /// TurfGrower
        /// </summary>
        [EnumMember]
        [Name(Code = "121218", Name = "Turf Grower")]
        TurfGrower,

        /// <summary>
        /// VegetableGrower
        /// </summary>
        [EnumMember]
        [Name(Code = "121221", Name = "Vegetable Grower")]
        VegetableGrower,

        /// <summary>
        /// CropFarmersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "121299", Name = "Crop Farmers nec")]
        CropFarmersNec,

        /// <summary>
        /// Apiarist
        /// </summary>
        [EnumMember]
        [Name(Code = "121311", Name = "Apiarist")]
        Apiarist,

        /// <summary>
        /// BeefCattleFarmer
        /// </summary>
        [EnumMember]
        [Name(Code = "121312", Name = "Beef Cattle Farmer")]
        BeefCattleFarmer,

        /// <summary>
        /// DairyCattleFarmer
        /// </summary>
        [EnumMember]
        [Name(Code = "121313", Name = "Dairy Cattle Farmer")]
        DairyCattleFarmer,

        /// <summary>
        /// DeerFarmer
        /// </summary>
        [EnumMember]
        [Name(Code = "121314", Name = "Deer Farmer")]
        DeerFarmer,

        /// <summary>
        /// GoatFarmer
        /// </summary>
        [EnumMember]
        [Name(Code = "121315", Name = "Goat Farmer")]
        GoatFarmer,

        /// <summary>
        /// HorseBreeder
        /// </summary>
        [EnumMember]
        [Name(Code = "121316", Name = "Horse Breeder")]
        HorseBreeder,

        /// <summary>
        /// MixedLivestockFarmer
        /// </summary>
        [EnumMember]
        [Name(Code = "121317", Name = "Mixed Livestock Farmer")]
        MixedLivestockFarmer,

        /// <summary>
        /// PigFarmer
        /// </summary>
        [EnumMember]
        [Name(Code = "121318", Name = "Pig Farmer")]
        PigFarmer,

        /// <summary>
        /// PoultryFarmer
        /// </summary>
        [EnumMember]
        [Name(Code = "121321", Name = "Poultry Farmer")]
        PoultryFarmer,

        /// <summary>
        /// SheepFarmer
        /// </summary>
        [EnumMember]
        [Name(Code = "121322", Name = "Sheep Farmer")]
        SheepFarmer,

        /// <summary>
        /// LivestockFarmersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "121399", Name = "Livestock Farmers nec")]
        LivestockFarmersNec,

        /// <summary>
        /// MixedCropAndLivestockFarmer
        /// </summary>
        [EnumMember]
        [Name(Code = "121411", Name = "Mixed Crop and Livestock Farmer")]
        MixedCropAndLivestockFarmer,

        /// <summary>
        /// SalesAndMarketingManager
        /// </summary>
        [EnumMember]
        [Name(Code = "131112", Name = "Sales and Marketing Manager")]
        SalesAndMarketingManager,

        /// <summary>
        /// AdvertisingManager
        /// </summary>
        [EnumMember]
        [Name(Code = "131113", Name = "Advertising Manager")]
        AdvertisingManager,

        /// <summary>
        /// PublicRelationsManager
        /// </summary>
        [EnumMember]
        [Name(Code = "131114", Name = "Public Relations Manager")]
        PublicRelationsManager,

        /// <summary>
        /// CorporateServicesManager
        /// </summary>
        [EnumMember]
        [Name(Code = "132111", Name = "Corporate Services Manager")]
        CorporateServicesManager,

        /// <summary>
        /// FinanceManager
        /// </summary>
        [EnumMember]
        [Name(Code = "132211", Name = "Finance Manager")]
        FinanceManager,

        /// <summary>
        /// HumanResourceManager
        /// </summary>
        [EnumMember]
        [Name(Code = "132311", Name = "Human Resource Manager")]
        HumanResourceManager,

        /// <summary>
        /// PolicyAndPlanningManager
        /// </summary>
        [EnumMember]
        [Name(Code = "132411", Name = "Policy and Planning Manager")]
        PolicyAndPlanningManager,

        /// <summary>
        /// ResearchAndDevelopmentManager
        /// </summary>
        [EnumMember]
        [Name(Code = "132511", Name = "Research and Development Manager")]
        ResearchAndDevelopmentManager,

        /// <summary>
        /// ConstructionProjectManager
        /// </summary>
        [EnumMember]
        [Name(Code = "133111", Name = "Construction Project Manager")]
        ConstructionProjectManager,

        /// <summary>
        /// ProjectBuilder
        /// </summary>
        [EnumMember]
        [Name(Code = "133112", Name = "Project Builder")]
        ProjectBuilder,

        /// <summary>
        /// EngineeringManager
        /// </summary>
        [EnumMember]
        [Name(Code = "133211", Name = "Engineering Manager")]
        EngineeringManager,

        /// <summary>
        /// ImporterOrExporter
        /// </summary>
        [EnumMember]
        [Name(Code = "133311", Name = "Importer or Exporter")]
        ImporterOrExporter,

        /// <summary>
        /// Wholesaler
        /// </summary>
        [EnumMember]
        [Name(Code = "133312", Name = "Wholesaler")]
        Wholesaler,

        /// <summary>
        /// Manufacturer
        /// </summary>
        [EnumMember]
        [Name(Code = "133411", Name = "Manufacturer")]
        Manufacturer,

        /// <summary>
        /// ProductionManagerForestry
        /// </summary>
        [EnumMember]
        [Name(Code = "133511", Name = "Production Manager (Forestry)")]
        ProductionManagerForestry,

        /// <summary>
        /// ProductionManagerManufacturing
        /// </summary>
        [EnumMember]
        [Name(Code = "133512", Name = "Production Manager (Manufacturing)")]
        ProductionManagerManufacturing,

        /// <summary>
        /// ProductionManagerMining
        /// </summary>
        [EnumMember]
        [Name(Code = "133513", Name = "Production Manager (Mining)")]
        ProductionManagerMining,

        /// <summary>
        /// SupplyAndDistributionManager
        /// </summary>
        [EnumMember]
        [Name(Code = "133611", Name = "Supply and Distribution Manager")]
        SupplyAndDistributionManager,

        /// <summary>
        /// ChildCareCentreManager
        /// </summary>
        [EnumMember]
        [Name(Code = "134111", Name = "Child Care Centre Manager")]
        ChildCareCentreManager,

        /// <summary>
        /// MedicalAdministrator
        /// </summary>
        [EnumMember]
        [Name(Code = "134211", Name = "Medical Administrator")]
        MedicalAdministrator,

        /// <summary>
        /// NursingClinicalDirector
        /// </summary>
        [EnumMember]
        [Name(Code = "134212", Name = "Nursing Clinical Director")]
        NursingClinicalDirector,

        /// <summary>
        /// PrimaryHealthOrganisationManager
        /// </summary>
        [EnumMember]
        [Name(Code = "134213", Name = "Primary Health Organisation Manager")]
        PrimaryHealthOrganisationManager,

        /// <summary>
        /// WelfareCentreManager
        /// </summary>
        [EnumMember]
        [Name(Code = "134214", Name = "Welfare Centre Manager")]
        WelfareCentreManager,

        /// <summary>
        /// HealthAndWelfareServicesManagersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "134299", Name = "Health and Welfare Services Managers nec")]
        HealthAndWelfareServicesManagersNec,

        /// <summary>
        /// SchoolPrincipal
        /// </summary>
        [EnumMember]
        [Name(Code = "134311", Name = "School Principal")]
        SchoolPrincipal,

        /// <summary>
        /// FacultyHead
        /// </summary>
        [EnumMember]
        [Name(Code = "134411", Name = "Faculty Head")]
        FacultyHead,

        /// <summary>
        /// RegionalEducationManager
        /// </summary>
        [EnumMember]
        [Name(Code = "134412", Name = "Regional Education Manager")]
        RegionalEducationManager,

        /// <summary>
        /// EducationManagersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "134499", Name = "Education Managers nec")]
        EducationManagersNec,

        /// <summary>
        /// ChiefInformationOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "135111", Name = "Chief Information Officer")]
        ChiefInformationOfficer,

        /// <summary>
        /// IctProjectManager
        /// </summary>
        [EnumMember]
        [Name(Code = "135112", Name = "ICT Project Manager")]
        IctProjectManager,

        /// <summary>
        /// IctManagersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "135199", Name = "ICT Managers nec")]
        IctManagersNec,

        /// <summary>
        /// CommissionedDefenceForceOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "139111", Name = "Commissioned Defence Force Officer")]
        CommissionedDefenceForceOfficer,

        /// <summary>
        /// CommissionedFireOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "139112", Name = "Commissioned Fire Officer")]
        CommissionedFireOfficer,

        /// <summary>
        /// CommissionedPoliceOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "139113", Name = "Commissioned Police Officer")]
        CommissionedPoliceOfficer,

        /// <summary>
        /// SeniorNonCommissionedDefenceForceMember
        /// </summary>
        [EnumMember]
        [Name(Code = "139211", Name = "Senior Non-commissioned Defence Force Member")]
        SeniorNonCommissionedDefenceForceMember,

        /// <summary>
        /// ArtsAdministratorOrManager
        /// </summary>
        [EnumMember]
        [Name(Code = "139911", Name = "Arts Administrator or Manager")]
        ArtsAdministratorOrManager,

        /// <summary>
        /// EnvironmentalManager
        /// </summary>
        [EnumMember]
        [Name(Code = "139912", Name = "Environmental Manager")]
        EnvironmentalManager,

        /// <summary>
        /// LaboratoryManager
        /// </summary>
        [EnumMember]
        [Name(Code = "139913", Name = "Laboratory Manager")]
        LaboratoryManager,

        /// <summary>
        /// QualityAssuranceManager
        /// </summary>
        [EnumMember]
        [Name(Code = "139914", Name = "Quality Assurance Manager")]
        QualityAssuranceManager,

        /// <summary>
        /// SportsAdministrator
        /// </summary>
        [EnumMember]
        [Name(Code = "139915", Name = "Sports Administrator")]
        SportsAdministrator,

        /// <summary>
        /// SpecialistManagersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "139999", Name = "Specialist Managers nec")]
        SpecialistManagersNec,

        /// <summary>
        /// CafeOrRestaurantManager
        /// </summary>
        [EnumMember]
        [Name(Code = "141111", Name = "Cafe or Restaurant Manager")]
        CafeOrRestaurantManager,

        /// <summary>
        /// CaravanParkAndCampingGroundManager
        /// </summary>
        [EnumMember]
        [Name(Code = "141211", Name = "Caravan Park and Camping Ground Manager")]
        CaravanParkAndCampingGroundManager,

        /// <summary>
        /// HotelOrMotelManager
        /// </summary>
        [EnumMember]
        [Name(Code = "141311", Name = "Hotel or Motel Manager")]
        HotelOrMotelManager,

        /// <summary>
        /// LicensedClubManager
        /// </summary>
        [EnumMember]
        [Name(Code = "141411", Name = "Licensed Club Manager")]
        LicensedClubManager,

        /// <summary>
        /// BedAndBreakfastOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "141911", Name = "Bed and Breakfast Operator")]
        BedAndBreakfastOperator,

        /// <summary>
        /// RetirementVillageManager
        /// </summary>
        [EnumMember]
        [Name(Code = "141912", Name = "Retirement Village Manager")]
        RetirementVillageManager,

        /// <summary>
        /// AccommodationAndHospitalityManagersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "141999", Name = "Accommodation and Hospitality Managers nec")]
        AccommodationAndHospitalityManagersNec,

        /// <summary>
        /// RetailManagerGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "142111", Name = "Retail Manager (General)")]
        RetailManagerGeneral,

        /// <summary>
        /// AntiqueDealer
        /// </summary>
        [EnumMember]
        [Name(Code = "142112", Name = "Antique Dealer")]
        AntiqueDealer,

        /// <summary>
        /// BettingAgencyManager
        /// </summary>
        [EnumMember]
        [Name(Code = "142113", Name = "Betting Agency Manager")]
        BettingAgencyManager,

        /// <summary>
        /// HairOrBeautySalonManager
        /// </summary>
        [EnumMember]
        [Name(Code = "142114", Name = "Hair or Beauty Salon Manager")]
        HairOrBeautySalonManager,

        /// <summary>
        /// PostOfficeManager
        /// </summary>
        [EnumMember]
        [Name(Code = "142115", Name = "Post Office Manager")]
        PostOfficeManager,

        /// <summary>
        /// TravelAgencyManager
        /// </summary>
        [EnumMember]
        [Name(Code = "142116", Name = "Travel Agency Manager")]
        TravelAgencyManager,

        /// <summary>
        /// AmusementCentreManager
        /// </summary>
        [EnumMember]
        [Name(Code = "149111", Name = "Amusement Centre Manager")]
        AmusementCentreManager,

        /// <summary>
        /// FitnessCentreManager
        /// </summary>
        [EnumMember]
        [Name(Code = "149112", Name = "Fitness Centre Manager")]
        FitnessCentreManager,

        /// <summary>
        /// SportsCentreManager
        /// </summary>
        [EnumMember]
        [Name(Code = "149113", Name = "Sports Centre Manager")]
        SportsCentreManager,

        /// <summary>
        /// CallOrContactCentreManager
        /// </summary>
        [EnumMember]
        [Name(Code = "149211", Name = "Call or Contact Centre Manager")]
        CallOrContactCentreManager,

        /// <summary>
        /// CustomerServiceManager
        /// </summary>
        [EnumMember]
        [Name(Code = "149212", Name = "Customer Service Manager")]
        CustomerServiceManager,

        /// <summary>
        /// ConferenceAndEventOrganiser
        /// </summary>
        [EnumMember]
        [Name(Code = "149311", Name = "Conference and Event Organiser")]
        ConferenceAndEventOrganiser,

        /// <summary>
        /// FleetManager
        /// </summary>
        [EnumMember]
        [Name(Code = "149411", Name = "Fleet Manager")]
        FleetManager,

        /// <summary>
        /// RailwayStationManager
        /// </summary>
        [EnumMember]
        [Name(Code = "149412", Name = "Railway Station Manager")]
        RailwayStationManager,

        /// <summary>
        /// TransportCompanyManager
        /// </summary>
        [EnumMember]
        [Name(Code = "149413", Name = "Transport Company Manager")]
        TransportCompanyManager,

        /// <summary>
        /// BoardingKennelOrCatteryOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "149911", Name = "Boarding Kennel or Cattery Operator")]
        BoardingKennelOrCatteryOperator,

        /// <summary>
        /// CinemaOrTheatreManager
        /// </summary>
        [EnumMember]
        [Name(Code = "149912", Name = "Cinema or Theatre Manager")]
        CinemaOrTheatreManager,

        /// <summary>
        /// FacilitiesManager
        /// </summary>
        [EnumMember]
        [Name(Code = "149913", Name = "Facilities Manager")]
        FacilitiesManager,

        /// <summary>
        /// FinancialInstitutionBranchManager
        /// </summary>
        [EnumMember]
        [Name(Code = "149914", Name = "Financial Institution Branch Manager")]
        FinancialInstitutionBranchManager,

        /// <summary>
        /// EquipmentHireManager
        /// </summary>
        [EnumMember]
        [Name(Code = "149915", Name = "Equipment Hire Manager")]
        EquipmentHireManager,

        /// <summary>
        /// HospitalityRetailAndServiceManagersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "149999", Name = "Hospitality, Retail and Service Managers nec")]
        HospitalityRetailAndServiceManagersNec,

        /// <summary>
        /// Actor
        /// </summary>
        [EnumMember]
        [Name(Code = "211111", Name = "Actor")]
        Actor,

        /// <summary>
        /// DancerOrChoreographer
        /// </summary>
        [EnumMember]
        [Name(Code = "211112", Name = "Dancer or Choreographer")]
        DancerOrChoreographer,

        /// <summary>
        /// EntertainerOrVarietyArtist
        /// </summary>
        [EnumMember]
        [Name(Code = "211113", Name = "Entertainer or Variety Artist")]
        EntertainerOrVarietyArtist,

        /// <summary>
        /// ActorsDancersAndOtherEntertainersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "211199", Name = "Actors, Dancers and Other Entertainers nec")]
        ActorsDancersAndOtherEntertainersNec,

        /// <summary>
        /// Composer
        /// </summary>
        [EnumMember]
        [Name(Code = "211211", Name = "Composer")]
        Composer,

        /// <summary>
        /// MusicDirector
        /// </summary>
        [EnumMember]
        [Name(Code = "211212", Name = "Music Director")]
        MusicDirector,

        /// <summary>
        /// MusicianInstrumental
        /// </summary>
        [EnumMember]
        [Name(Code = "211213", Name = "Musician (Instrumental)")]
        MusicianInstrumental,

        /// <summary>
        /// Singer
        /// </summary>
        [EnumMember]
        [Name(Code = "211214", Name = "Singer")]
        Singer,

        /// <summary>
        /// MusicProfessionalsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "211299", Name = "Music Professionals nec")]
        MusicProfessionalsNec,

        /// <summary>
        /// Photographer
        /// </summary>
        [EnumMember]
        [Name(Code = "211311", Name = "Photographer")]
        Photographer,

        /// <summary>
        /// PainterVisualArts
        /// </summary>
        [EnumMember]
        [Name(Code = "211411", Name = "Painter (Visual Arts)")]
        PainterVisualArts,

        /// <summary>
        /// PotterOrCeramicArtist
        /// </summary>
        [EnumMember]
        [Name(Code = "211412", Name = "Potter or Ceramic Artist")]
        PotterOrCeramicArtist,

        /// <summary>
        /// Sculptor
        /// </summary>
        [EnumMember]
        [Name(Code = "211413", Name = "Sculptor")]
        Sculptor,

        /// <summary>
        /// VisualArtsAndCraftsProfessionalsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "211499", Name = "Visual Arts and Crafts Professionals nec")]
        VisualArtsAndCraftsProfessionalsNec,

        /// <summary>
        /// ArtisticDirector
        /// </summary>
        [EnumMember]
        [Name(Code = "212111", Name = "Artistic Director")]
        ArtisticDirector,

        /// <summary>
        /// MediaProducerExcludingVideo
        /// </summary>
        [EnumMember]
        [Name(Code = "212112", Name = "Media Producer (excluding Video)")]
        MediaProducerExcludingVideo,

        /// <summary>
        /// RadioPresenter
        /// </summary>
        [EnumMember]
        [Name(Code = "212113", Name = "Radio Presenter")]
        RadioPresenter,

        /// <summary>
        /// TelevisionPresenter
        /// </summary>
        [EnumMember]
        [Name(Code = "212114", Name = "Television Presenter")]
        TelevisionPresenter,

        /// <summary>
        /// Author
        /// </summary>
        [EnumMember]
        [Name(Code = "212211", Name = "Author")]
        Author,

        /// <summary>
        /// BookOrScriptEditor
        /// </summary>
        [EnumMember]
        [Name(Code = "212212", Name = "Book or Script Editor")]
        BookOrScriptEditor,

        /// <summary>
        /// ArtDirectorFilmTelevisionOrStage
        /// </summary>
        [EnumMember]
        [Name(Code = "212311", Name = "Art Director (Film, Television or Stage)")]
        ArtDirectorFilmTelevisionOrStage,

        /// <summary>
        /// DirectorFilmTelevisionRadioOrStage
        /// </summary>
        [EnumMember]
        [Name(Code = "212312", Name = "Director (Film, Television, Radio or Stage)")]
        DirectorFilmTelevisionRadioOrStage,

        /// <summary>
        /// DirectorOfPhotography
        /// </summary>
        [EnumMember]
        [Name(Code = "212313", Name = "Director of Photography")]
        DirectorOfPhotography,

        /// <summary>
        /// FilmAndVideoEditor
        /// </summary>
        [EnumMember]
        [Name(Code = "212314", Name = "Film and Video Editor")]
        FilmAndVideoEditor,

        /// <summary>
        /// ProgramDirectorTelevisionOrRadio
        /// </summary>
        [EnumMember]
        [Name(Code = "212315", Name = "Program Director (Television or Radio)")]
        ProgramDirectorTelevisionOrRadio,

        /// <summary>
        /// StageManager
        /// </summary>
        [EnumMember]
        [Name(Code = "212316", Name = "Stage Manager")]
        StageManager,

        /// <summary>
        /// TechnicalDirector
        /// </summary>
        [EnumMember]
        [Name(Code = "212317", Name = "Technical Director")]
        TechnicalDirector,

        /// <summary>
        /// VideoProducer
        /// </summary>
        [EnumMember]
        [Name(Code = "212318", Name = "Video Producer")]
        VideoProducer,

        /// <summary>
        /// FilmTelevisionRadioAndStageDirectorsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "212399", Name = "Film, Television, Radio and Stage Directors nec")]
        FilmTelevisionRadioAndStageDirectorsNec,

        /// <summary>
        /// Copywriter
        /// </summary>
        [EnumMember]
        [Name(Code = "212411", Name = "Copywriter")]
        Copywriter,

        /// <summary>
        /// NewspaperOrPeriodicalEditor
        /// </summary>
        [EnumMember]
        [Name(Code = "212412", Name = "Newspaper or Periodical Editor")]
        NewspaperOrPeriodicalEditor,

        /// <summary>
        /// PrintJournalist
        /// </summary>
        [EnumMember]
        [Name(Code = "212413", Name = "Print Journalist")]
        PrintJournalist,

        /// <summary>
        /// RadioJournalist
        /// </summary>
        [EnumMember]
        [Name(Code = "212414", Name = "Radio Journalist")]
        RadioJournalist,

        /// <summary>
        /// TechnicalWriter
        /// </summary>
        [EnumMember]
        [Name(Code = "212415", Name = "Technical Writer")]
        TechnicalWriter,

        /// <summary>
        /// TelevisionJournalist
        /// </summary>
        [EnumMember]
        [Name(Code = "212416", Name = "Television Journalist")]
        TelevisionJournalist,

        /// <summary>
        /// JournalistsAndOtherWritersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "212499", Name = "Journalists and Other Writers nec")]
        JournalistsAndOtherWritersNec,

        /// <summary>
        /// AccountantGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "221111", Name = "Accountant (General)")]
        AccountantGeneral,

        /// <summary>
        /// ManagementAccountant
        /// </summary>
        [EnumMember]
        [Name(Code = "221112", Name = "Management Accountant")]
        ManagementAccountant,

        /// <summary>
        /// TaxationAccountant
        /// </summary>
        [EnumMember]
        [Name(Code = "221113", Name = "Taxation Accountant")]
        TaxationAccountant,

        /// <summary>
        /// CompanySecretary
        /// </summary>
        [EnumMember]
        [Name(Code = "221211", Name = "Company Secretary")]
        CompanySecretary,

        /// <summary>
        /// CorporateTreasurer
        /// </summary>
        [EnumMember]
        [Name(Code = "221212", Name = "Corporate Treasurer")]
        CorporateTreasurer,

        /// <summary>
        /// ExternalAuditor
        /// </summary>
        [EnumMember]
        [Name(Code = "221213", Name = "External Auditor")]
        ExternalAuditor,

        /// <summary>
        /// InternalAuditor
        /// </summary>
        [EnumMember]
        [Name(Code = "221214", Name = "Internal Auditor")]
        InternalAuditor,

        /// <summary>
        /// CommoditiesTrader
        /// </summary>
        [EnumMember]
        [Name(Code = "222111", Name = "Commodities Trader")]
        CommoditiesTrader,

        /// <summary>
        /// FinanceBroker
        /// </summary>
        [EnumMember]
        [Name(Code = "222112", Name = "Finance Broker")]
        FinanceBroker,

        /// <summary>
        /// InsuranceBroker
        /// </summary>
        [EnumMember]
        [Name(Code = "222113", Name = "Insurance Broker")]
        InsuranceBroker,

        /// <summary>
        /// FinancialBrokersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "222199", Name = "Financial Brokers nec")]
        FinancialBrokersNec,

        /// <summary>
        /// FinancialMarketDealer
        /// </summary>
        [EnumMember]
        [Name(Code = "222211", Name = "Financial Market Dealer")]
        FinancialMarketDealer,

        /// <summary>
        /// FuturesTrader
        /// </summary>
        [EnumMember]
        [Name(Code = "222212", Name = "Futures Trader")]
        FuturesTrader,

        /// <summary>
        /// StockbrokingDealer
        /// </summary>
        [EnumMember]
        [Name(Code = "222213", Name = "Stockbroking Dealer")]
        StockbrokingDealer,

        /// <summary>
        /// FinancialDealersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "222299", Name = "Financial Dealers nec")]
        FinancialDealersNec,

        /// <summary>
        /// FinancialInvestmentAdviser
        /// </summary>
        [EnumMember]
        [Name(Code = "222311", Name = "Financial Investment Adviser")]
        FinancialInvestmentAdviser,

        /// <summary>
        /// FinancialInvestmentManager
        /// </summary>
        [EnumMember]
        [Name(Code = "222312", Name = "Financial Investment Manager")]
        FinancialInvestmentManager,

        /// <summary>
        /// HumanResourceAdviser
        /// </summary>
        [EnumMember]
        [Name(Code = "223111", Name = "Human Resource Adviser")]
        HumanResourceAdviser,

        /// <summary>
        /// RecruitmentConsultant
        /// </summary>
        [EnumMember]
        [Name(Code = "223112", Name = "Recruitment Consultant")]
        RecruitmentConsultant,

        /// <summary>
        /// WorkplaceRelationsAdviser
        /// </summary>
        [EnumMember]
        [Name(Code = "223113", Name = "Workplace Relations Adviser")]
        WorkplaceRelationsAdviser,

        /// <summary>
        /// IctTrainer
        /// </summary>
        [EnumMember]
        [Name(Code = "223211", Name = "ICT Trainer")]
        IctTrainer,

        /// <summary>
        /// TrainingAndDevelopmentProfessional
        /// </summary>
        [EnumMember]
        [Name(Code = "223311", Name = "Training and Development Professional")]
        TrainingAndDevelopmentProfessional,

        /// <summary>
        /// Actuary
        /// </summary>
        [EnumMember]
        [Name(Code = "224111", Name = "Actuary")]
        Actuary,

        /// <summary>
        /// Mathematician
        /// </summary>
        [EnumMember]
        [Name(Code = "224112", Name = "Mathematician")]
        Mathematician,

        /// <summary>
        /// Statistician
        /// </summary>
        [EnumMember]
        [Name(Code = "224113", Name = "Statistician")]
        Statistician,

        /// <summary>
        /// Archivist
        /// </summary>
        [EnumMember]
        [Name(Code = "224211", Name = "Archivist")]
        Archivist,

        /// <summary>
        /// GalleryOrMuseumCurator
        /// </summary>
        [EnumMember]
        [Name(Code = "224212", Name = "Gallery or Museum Curator")]
        GalleryOrMuseumCurator,

        /// <summary>
        /// HealthInformationManager
        /// </summary>
        [EnumMember]
        [Name(Code = "224213", Name = "Health Information Manager")]
        HealthInformationManager,

        /// <summary>
        /// RecordsManager
        /// </summary>
        [EnumMember]
        [Name(Code = "224214", Name = "Records Manager")]
        RecordsManager,

        /// <summary>
        /// Economist
        /// </summary>
        [EnumMember]
        [Name(Code = "224311", Name = "Economist")]
        Economist,

        /// <summary>
        /// IntelligenceOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "224411", Name = "Intelligence Officer")]
        IntelligenceOfficer,

        /// <summary>
        /// PolicyAnalyst
        /// </summary>
        [EnumMember]
        [Name(Code = "224412", Name = "Policy Analyst")]
        PolicyAnalyst,

        /// <summary>
        /// LandEconomist
        /// </summary>
        [EnumMember]
        [Name(Code = "224511", Name = "Land Economist")]
        LandEconomist,

        /// <summary>
        /// Valuer
        /// </summary>
        [EnumMember]
        [Name(Code = "224512", Name = "Valuer")]
        Valuer,

        /// <summary>
        /// Librarian
        /// </summary>
        [EnumMember]
        [Name(Code = "224611", Name = "Librarian")]
        Librarian,

        /// <summary>
        /// ManagementConsultant
        /// </summary>
        [EnumMember]
        [Name(Code = "224711", Name = "Management Consultant")]
        ManagementConsultant,

        /// <summary>
        /// OrganisationAndMethodsAnalyst
        /// </summary>
        [EnumMember]
        [Name(Code = "224712", Name = "Organisation and Methods Analyst")]
        OrganisationAndMethodsAnalyst,

        /// <summary>
        /// ElectorateOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "224911", Name = "Electorate Officer")]
        ElectorateOfficer,

        /// <summary>
        /// LiaisonOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "224912", Name = "Liaison Officer")]
        LiaisonOfficer,

        /// <summary>
        /// MigrationAgent
        /// </summary>
        [EnumMember]
        [Name(Code = "224913", Name = "Migration Agent")]
        MigrationAgent,

        /// <summary>
        /// PatentsExaminer
        /// </summary>
        [EnumMember]
        [Name(Code = "224914", Name = "Patents Examiner")]
        PatentsExaminer,

        /// <summary>
        /// InformationAndOrganisationProfessionalsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "224999", Name = "Information and Organisation Professionals nec")]
        InformationAndOrganisationProfessionalsNec,

        /// <summary>
        /// AdvertisingSpecialist
        /// </summary>
        [EnumMember]
        [Name(Code = "225111", Name = "Advertising Specialist")]
        AdvertisingSpecialist,

        /// <summary>
        /// MarketResearchAnalyst
        /// </summary>
        [EnumMember]
        [Name(Code = "225112", Name = "Market Research Analyst")]
        MarketResearchAnalyst,

        /// <summary>
        /// MarketingSpecialist
        /// </summary>
        [EnumMember]
        [Name(Code = "225113", Name = "Marketing Specialist")]
        MarketingSpecialist,

        /// <summary>
        /// IctAccountManager
        /// </summary>
        [EnumMember]
        [Name(Code = "225211", Name = "ICT Account Manager")]
        IctAccountManager,

        /// <summary>
        /// IctBusinessDevelopmentManager
        /// </summary>
        [EnumMember]
        [Name(Code = "225212", Name = "ICT Business Development Manager")]
        IctBusinessDevelopmentManager,

        /// <summary>
        /// IctSalesRepresentative
        /// </summary>
        [EnumMember]
        [Name(Code = "225213", Name = "ICT Sales Representative")]
        IctSalesRepresentative,

        /// <summary>
        /// PublicRelationsProfessional
        /// </summary>
        [EnumMember]
        [Name(Code = "225311", Name = "Public Relations Professional")]
        PublicRelationsProfessional,

        /// <summary>
        /// SalesRepresentativeIndustrialProducts
        /// </summary>
        [EnumMember]
        [Name(Code = "225411", Name = "Sales Representative (Industrial Products)")]
        SalesRepresentativeIndustrialProducts,

        /// <summary>
        /// SalesRepresentativeMedicalAndPharmaceuticalProducts
        /// </summary>
        [EnumMember]
        [Name(Code = "225412", Name = "Sales Representative (Medical and Pharmaceutical Products)")]
        SalesRepresentativeMedicalAndPharmaceuticalProducts,

        /// <summary>
        /// TechnicalSalesRepresentativesNec
        /// </summary>
        [EnumMember]
        [Name(Code = "225499", Name = "Technical Sales Representatives nec")]
        TechnicalSalesRepresentativesNec,

        /// <summary>
        /// AeroplanePilot
        /// </summary>
        [EnumMember]
        [Name(Code = "231111", Name = "Aeroplane Pilot")]
        AeroplanePilot,

        /// <summary>
        /// AirTrafficController
        /// </summary>
        [EnumMember]
        [Name(Code = "231112", Name = "Air Traffic Controller")]
        AirTrafficController,

        /// <summary>
        /// FlyingInstructor
        /// </summary>
        [EnumMember]
        [Name(Code = "231113", Name = "Flying Instructor")]
        FlyingInstructor,

        /// <summary>
        /// HelicopterPilot
        /// </summary>
        [EnumMember]
        [Name(Code = "231114", Name = "Helicopter Pilot")]
        HelicopterPilot,

        /// <summary>
        /// AirTransportProfessionalsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "231199", Name = "Air Transport Professionals nec")]
        AirTransportProfessionalsNec,

        /// <summary>
        /// MasterFisher
        /// </summary>
        [EnumMember]
        [Name(Code = "231211", Name = "Master Fisher")]
        MasterFisher,

        /// <summary>
        /// ShipSEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "231212", Name = "Ship's Engineer")]
        ShipSEngineer,

        /// <summary>
        /// ShipSMaster
        /// </summary>
        [EnumMember]
        [Name(Code = "231213", Name = "Ship's Master")]
        ShipSMaster,

        /// <summary>
        /// ShipSOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "231214", Name = "Ship's Officer")]
        ShipSOfficer,

        /// <summary>
        /// ShipSSurveyor
        /// </summary>
        [EnumMember]
        [Name(Code = "231215", Name = "Ship's Surveyor")]
        ShipSSurveyor,

        /// <summary>
        /// MarineTransportProfessionalsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "231299", Name = "Marine Transport Professionals nec")]
        MarineTransportProfessionalsNec,

        /// <summary>
        /// Architect
        /// </summary>
        [EnumMember]
        [Name(Code = "232111", Name = "Architect")]
        Architect,

        /// <summary>
        /// LandscapeArchitect
        /// </summary>
        [EnumMember]
        [Name(Code = "232112", Name = "Landscape Architect")]
        LandscapeArchitect,

        /// <summary>
        /// Surveyor
        /// </summary>
        [EnumMember]
        [Name(Code = "232212", Name = "Surveyor")]
        Surveyor,

        /// <summary>
        /// Cartographer
        /// </summary>
        [EnumMember]
        [Name(Code = "232213", Name = "Cartographer")]
        Cartographer,

        /// <summary>
        /// OtherSpatialScientist
        /// </summary>
        [EnumMember]
        [Name(Code = "232214", Name = "Other Spatial Scientist")]
        OtherSpatialScientist,

        /// <summary>
        /// FashionDesigner
        /// </summary>
        [EnumMember]
        [Name(Code = "232311", Name = "Fashion Designer")]
        FashionDesigner,

        /// <summary>
        /// IndustrialDesigner
        /// </summary>
        [EnumMember]
        [Name(Code = "232312", Name = "Industrial Designer")]
        IndustrialDesigner,

        /// <summary>
        /// JewelleryDesigner
        /// </summary>
        [EnumMember]
        [Name(Code = "232313", Name = "Jewellery Designer")]
        JewelleryDesigner,

        /// <summary>
        /// GraphicDesigner
        /// </summary>
        [EnumMember]
        [Name(Code = "232411", Name = "Graphic Designer")]
        GraphicDesigner,

        /// <summary>
        /// Illustrator
        /// </summary>
        [EnumMember]
        [Name(Code = "232412", Name = "Illustrator")]
        Illustrator,

        /// <summary>
        /// MultimediaDesigner
        /// </summary>
        [EnumMember]
        [Name(Code = "232413", Name = "Multimedia Designer")]
        MultimediaDesigner,

        /// <summary>
        /// WebDesigner
        /// </summary>
        [EnumMember]
        [Name(Code = "232414", Name = "Web Designer")]
        WebDesigner,

        /// <summary>
        /// InteriorDesigner
        /// </summary>
        [EnumMember]
        [Name(Code = "232511", Name = "Interior Designer")]
        InteriorDesigner,

        /// <summary>
        /// UrbanAndRegionalPlanner
        /// </summary>
        [EnumMember]
        [Name(Code = "232611", Name = "Urban and Regional Planner")]
        UrbanAndRegionalPlanner,

        /// <summary>
        /// ChemicalEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233111", Name = "Chemical Engineer")]
        ChemicalEngineer,

        /// <summary>
        /// MaterialsEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233112", Name = "Materials Engineer")]
        MaterialsEngineer,

        /// <summary>
        /// CivilEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233211", Name = "Civil Engineer")]
        CivilEngineer,

        /// <summary>
        /// GeotechnicalEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233212", Name = "Geotechnical Engineer")]
        GeotechnicalEngineer,

        /// <summary>
        /// QuantitySurveyor
        /// </summary>
        [EnumMember]
        [Name(Code = "233213", Name = "Quantity Surveyor")]
        QuantitySurveyor,

        /// <summary>
        /// StructuralEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233214", Name = "Structural Engineer")]
        StructuralEngineer,

        /// <summary>
        /// TransportEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233215", Name = "Transport Engineer")]
        TransportEngineer,

        /// <summary>
        /// ElectricalEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233311", Name = "Electrical Engineer")]
        ElectricalEngineer,

        /// <summary>
        /// ElectronicsEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233411", Name = "Electronics Engineer")]
        ElectronicsEngineer,

        /// <summary>
        /// IndustrialEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233511", Name = "Industrial Engineer")]
        IndustrialEngineer,

        /// <summary>
        /// MechanicalEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233512", Name = "Mechanical Engineer")]
        MechanicalEngineer,

        /// <summary>
        /// ProductionOrPlantEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233513", Name = "Production or Plant Engineer")]
        ProductionOrPlantEngineer,

        /// <summary>
        /// MiningEngineerExcludingPetroleum
        /// </summary>
        [EnumMember]
        [Name(Code = "233611", Name = "Mining Engineer (excluding Petroleum)")]
        MiningEngineerExcludingPetroleum,

        /// <summary>
        /// PetroleumEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233612", Name = "Petroleum Engineer")]
        PetroleumEngineer,

        /// <summary>
        /// AeronauticalEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233911", Name = "Aeronautical Engineer")]
        AeronauticalEngineer,

        /// <summary>
        /// AgriculturalEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233912", Name = "Agricultural Engineer")]
        AgriculturalEngineer,

        /// <summary>
        /// BiomedicalEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233913", Name = "Biomedical Engineer")]
        BiomedicalEngineer,

        /// <summary>
        /// EngineeringTechnologist
        /// </summary>
        [EnumMember]
        [Name(Code = "233914", Name = "Engineering Technologist")]
        EngineeringTechnologist,

        /// <summary>
        /// EnvironmentalEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "233915", Name = "Environmental Engineer")]
        EnvironmentalEngineer,

        /// <summary>
        /// NavalArchitect
        /// </summary>
        [EnumMember]
        [Name(Code = "233916", Name = "Naval Architect")]
        NavalArchitect,

        /// <summary>
        /// EngineeringProfessionalsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "233999", Name = "Engineering Professionals nec")]
        EngineeringProfessionalsNec,

        /// <summary>
        /// AgriculturalConsultant
        /// </summary>
        [EnumMember]
        [Name(Code = "234111", Name = "Agricultural Consultant")]
        AgriculturalConsultant,

        /// <summary>
        /// AgriculturalScientist
        /// </summary>
        [EnumMember]
        [Name(Code = "234112", Name = "Agricultural Scientist")]
        AgriculturalScientist,

        /// <summary>
        /// Forester
        /// </summary>
        [EnumMember]
        [Name(Code = "234113", Name = "Forester")]
        Forester,

        /// <summary>
        /// Chemist
        /// </summary>
        [EnumMember]
        [Name(Code = "234211", Name = "Chemist")]
        Chemist,

        /// <summary>
        /// FoodTechnologist
        /// </summary>
        [EnumMember]
        [Name(Code = "234212", Name = "Food Technologist")]
        FoodTechnologist,

        /// <summary>
        /// WineMaker
        /// </summary>
        [EnumMember]
        [Name(Code = "234213", Name = "Wine Maker")]
        WineMaker,

        /// <summary>
        /// ConservationOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "234311", Name = "Conservation Officer")]
        ConservationOfficer,

        /// <summary>
        /// EnvironmentalConsultant
        /// </summary>
        [EnumMember]
        [Name(Code = "234312", Name = "Environmental Consultant")]
        EnvironmentalConsultant,

        /// <summary>
        /// EnvironmentalResearchScientist
        /// </summary>
        [EnumMember]
        [Name(Code = "234313", Name = "Environmental Research Scientist")]
        EnvironmentalResearchScientist,

        /// <summary>
        /// ParkRanger
        /// </summary>
        [EnumMember]
        [Name(Code = "234314", Name = "Park Ranger")]
        ParkRanger,

        /// <summary>
        /// EnvironmentalScientistsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "234399", Name = "Environmental Scientists nec")]
        EnvironmentalScientistsNec,

        /// <summary>
        /// Geologist
        /// </summary>
        [EnumMember]
        [Name(Code = "234411", Name = "Geologist")]
        Geologist,

        /// <summary>
        /// Geophysicist
        /// </summary>
        [EnumMember]
        [Name(Code = "234412", Name = "Geophysicist")]
        Geophysicist,

        /// <summary>
        /// LifeScientistGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "234511", Name = "Life Scientist (General)")]
        LifeScientistGeneral,

        /// <summary>
        /// AnatomistOrPhysiologist
        /// </summary>
        [EnumMember]
        [Name(Code = "234512", Name = "Anatomist or Physiologist")]
        AnatomistOrPhysiologist,

        /// <summary>
        /// Biochemist
        /// </summary>
        [EnumMember]
        [Name(Code = "234513", Name = "Biochemist")]
        Biochemist,

        /// <summary>
        /// Biotechnologist
        /// </summary>
        [EnumMember]
        [Name(Code = "234514", Name = "Biotechnologist")]
        Biotechnologist,

        /// <summary>
        /// Botanist
        /// </summary>
        [EnumMember]
        [Name(Code = "234515", Name = "Botanist")]
        Botanist,

        /// <summary>
        /// MarineBiologist
        /// </summary>
        [EnumMember]
        [Name(Code = "234516", Name = "Marine Biologist")]
        MarineBiologist,

        /// <summary>
        /// Microbiologist
        /// </summary>
        [EnumMember]
        [Name(Code = "234517", Name = "Microbiologist")]
        Microbiologist,

        /// <summary>
        /// Zoologist
        /// </summary>
        [EnumMember]
        [Name(Code = "234518", Name = "Zoologist")]
        Zoologist,

        /// <summary>
        /// LifeScientistsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "234599", Name = "Life Scientists nec")]
        LifeScientistsNec,

        /// <summary>
        /// MedicalLaboratoryScientist
        /// </summary>
        [EnumMember]
        [Name(Code = "234611", Name = "Medical Laboratory Scientist")]
        MedicalLaboratoryScientist,

        /// <summary>
        /// Veterinarian
        /// </summary>
        [EnumMember]
        [Name(Code = "234711", Name = "Veterinarian")]
        Veterinarian,

        /// <summary>
        /// Conservator
        /// </summary>
        [EnumMember]
        [Name(Code = "234911", Name = "Conservator")]
        Conservator,

        /// <summary>
        /// Metallurgist
        /// </summary>
        [EnumMember]
        [Name(Code = "234912", Name = "Metallurgist")]
        Metallurgist,

        /// <summary>
        /// Meteorologist
        /// </summary>
        [EnumMember]
        [Name(Code = "234913", Name = "Meteorologist")]
        Meteorologist,

        /// <summary>
        /// Physicist
        /// </summary>
        [EnumMember]
        [Name(Code = "234914", Name = "Physicist")]
        Physicist,

        /// <summary>
        /// NaturalAndPhysicalScienceProfessionalsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "234999", Name = "Natural and Physical Science Professionals nec")]
        NaturalAndPhysicalScienceProfessionalsNec,

        /// <summary>
        /// EarlyChildhoodPrePrimarySchoolTeacher
        /// </summary>
        [EnumMember]
        [Name(Code = "241111", Name = "Early Childhood (Pre-primary School) Teacher")]
        EarlyChildhoodPrePrimarySchoolTeacher,

        /// <summary>
        /// PrimarySchoolTeacher
        /// </summary>
        [EnumMember]
        [Name(Code = "241213", Name = "Primary School Teacher")]
        PrimarySchoolTeacher,

        /// <summary>
        /// MiddleSchoolTeacher
        /// </summary>
        [EnumMember]
        [Name(Code = "241311", Name = "Middle School Teacher")]
        MiddleSchoolTeacher,

        /// <summary>
        /// SecondarySchoolTeacher
        /// </summary>
        [EnumMember]
        [Name(Code = "241411", Name = "Secondary School Teacher")]
        SecondarySchoolTeacher,

        /// <summary>
        /// SpecialNeedsTeacher
        /// </summary>
        [EnumMember]
        [Name(Code = "241511", Name = "Special Needs Teacher")]
        SpecialNeedsTeacher,

        /// <summary>
        /// TeacherOfTheHearingImpaired
        /// </summary>
        [EnumMember]
        [Name(Code = "241512", Name = "Teacher of the Hearing Impaired")]
        TeacherOfTheHearingImpaired,

        /// <summary>
        /// TeacherOfTheSightImpaired
        /// </summary>
        [EnumMember]
        [Name(Code = "241513", Name = "Teacher of the Sight Impaired")]
        TeacherOfTheSightImpaired,

        /// <summary>
        /// SpecialEducationTeachersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "241599", Name = "Special Education Teachers nec")]
        SpecialEducationTeachersNec,

        /// <summary>
        /// UniversityLecturer
        /// </summary>
        [EnumMember]
        [Name(Code = "242111", Name = "University Lecturer")]
        UniversityLecturer,

        /// <summary>
        /// UniversityTutor
        /// </summary>
        [EnumMember]
        [Name(Code = "242112", Name = "University Tutor")]
        UniversityTutor,

        /// <summary>
        /// VocationalEducationTeacher
        /// </summary>
        [EnumMember]
        [Name(Code = "242211", Name = "Vocational Education Teacher")]
        VocationalEducationTeacher,

        /// <summary>
        /// EducationAdviser
        /// </summary>
        [EnumMember]
        [Name(Code = "249111", Name = "Education Adviser")]
        EducationAdviser,

        /// <summary>
        /// EducationReviewer
        /// </summary>
        [EnumMember]
        [Name(Code = "249112", Name = "Education Reviewer")]
        EducationReviewer,

        /// <summary>
        /// ArtTeacherPrivateTuition
        /// </summary>
        [EnumMember]
        [Name(Code = "249211", Name = "Art Teacher (Private Tuition)")]
        ArtTeacherPrivateTuition,

        /// <summary>
        /// DanceTeacherPrivateTuition
        /// </summary>
        [EnumMember]
        [Name(Code = "249212", Name = "Dance Teacher (Private Tuition)")]
        DanceTeacherPrivateTuition,

        /// <summary>
        /// DramaTeacherPrivateTuition
        /// </summary>
        [EnumMember]
        [Name(Code = "249213", Name = "Drama Teacher (Private Tuition)")]
        DramaTeacherPrivateTuition,

        /// <summary>
        /// MusicTeacherPrivateTuition
        /// </summary>
        [EnumMember]
        [Name(Code = "249214", Name = "Music Teacher (Private Tuition)")]
        MusicTeacherPrivateTuition,

        /// <summary>
        /// PrivateTutorsAndTeachersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "249299", Name = "Private Tutors and Teachers nec")]
        PrivateTutorsAndTeachersNec,

        /// <summary>
        /// TeacherOfEnglishToSpeakersOfOtherLanguages
        /// </summary>
        [EnumMember]
        [Name(Code = "249311", Name = "Teacher of English to Speakers of Other Languages")]
        TeacherOfEnglishToSpeakersOfOtherLanguages,

        /// <summary>
        /// Dietitian
        /// </summary>
        [EnumMember]
        [Name(Code = "251111", Name = "Dietitian")]
        Dietitian,

        /// <summary>
        /// MedicalDiagnosticRadiographer
        /// </summary>
        [EnumMember]
        [Name(Code = "251211", Name = "Medical Diagnostic Radiographer")]
        MedicalDiagnosticRadiographer,

        /// <summary>
        /// MedicalRadiationTherapist
        /// </summary>
        [EnumMember]
        [Name(Code = "251212", Name = "Medical Radiation Therapist")]
        MedicalRadiationTherapist,

        /// <summary>
        /// NuclearMedicineTechnologist
        /// </summary>
        [EnumMember]
        [Name(Code = "251213", Name = "Nuclear Medicine Technologist")]
        NuclearMedicineTechnologist,

        /// <summary>
        /// Sonographer
        /// </summary>
        [EnumMember]
        [Name(Code = "251214", Name = "Sonographer")]
        Sonographer,

        /// <summary>
        /// EnvironmentalHealthOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "251311", Name = "Environmental Health Officer")]
        EnvironmentalHealthOfficer,

        /// <summary>
        /// OccupationalHealthAndSafetyAdviser
        /// </summary>
        [EnumMember]
        [Name(Code = "251312", Name = "Occupational Health and Safety Adviser")]
        OccupationalHealthAndSafetyAdviser,

        /// <summary>
        /// Optometrist
        /// </summary>
        [EnumMember]
        [Name(Code = "251411", Name = "Optometrist")]
        Optometrist,

        /// <summary>
        /// Orthoptist
        /// </summary>
        [EnumMember]
        [Name(Code = "251412", Name = "Orthoptist")]
        Orthoptist,

        /// <summary>
        /// HospitalPharmacist
        /// </summary>
        [EnumMember]
        [Name(Code = "251511", Name = "Hospital Pharmacist")]
        HospitalPharmacist,

        /// <summary>
        /// IndustrialPharmacist
        /// </summary>
        [EnumMember]
        [Name(Code = "251512", Name = "Industrial Pharmacist")]
        IndustrialPharmacist,

        /// <summary>
        /// RetailPharmacist
        /// </summary>
        [EnumMember]
        [Name(Code = "251513", Name = "Retail Pharmacist")]
        RetailPharmacist,

        /// <summary>
        /// HealthPromotionOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "251911", Name = "Health Promotion Officer")]
        HealthPromotionOfficer,

        /// <summary>
        /// OrthotistOrProsthetist
        /// </summary>
        [EnumMember]
        [Name(Code = "251912", Name = "Orthotist or Prosthetist")]
        OrthotistOrProsthetist,

        /// <summary>
        /// HealthDiagnosticAndPromotionProfessionalsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "251999", Name = "Health Diagnostic and Promotion Professionals nec")]
        HealthDiagnosticAndPromotionProfessionalsNec,

        /// <summary>
        /// Chiropractor
        /// </summary>
        [EnumMember]
        [Name(Code = "252111", Name = "Chiropractor")]
        Chiropractor,

        /// <summary>
        /// Osteopath
        /// </summary>
        [EnumMember]
        [Name(Code = "252112", Name = "Osteopath")]
        Osteopath,

        /// <summary>
        /// Acupuncturist
        /// </summary>
        [EnumMember]
        [Name(Code = "252211", Name = "Acupuncturist")]
        Acupuncturist,

        /// <summary>
        /// Homoeopath
        /// </summary>
        [EnumMember]
        [Name(Code = "252212", Name = "Homoeopath")]
        Homoeopath,

        /// <summary>
        /// Naturopath
        /// </summary>
        [EnumMember]
        [Name(Code = "252213", Name = "Naturopath")]
        Naturopath,

        /// <summary>
        /// TraditionalChineseMedicinePractitioner
        /// </summary>
        [EnumMember]
        [Name(Code = "252214", Name = "Traditional Chinese Medicine Practitioner")]
        TraditionalChineseMedicinePractitioner,

        /// <summary>
        /// ComplementaryHealthTherapistsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "252299", Name = "Complementary Health Therapists nec")]
        ComplementaryHealthTherapistsNec,

        /// <summary>
        /// DentalSpecialist
        /// </summary>
        [EnumMember]
        [Name(Code = "252311", Name = "Dental Specialist")]
        DentalSpecialist,

        /// <summary>
        /// Dentist
        /// </summary>
        [EnumMember]
        [Name(Code = "252312", Name = "Dentist")]
        Dentist,

        /// <summary>
        /// OccupationalTherapist
        /// </summary>
        [EnumMember]
        [Name(Code = "252411", Name = "Occupational Therapist")]
        OccupationalTherapist,

        /// <summary>
        /// Physiotherapist
        /// </summary>
        [EnumMember]
        [Name(Code = "252511", Name = "Physiotherapist")]
        Physiotherapist,

        /// <summary>
        /// Podiatrist
        /// </summary>
        [EnumMember]
        [Name(Code = "252611", Name = "Podiatrist")]
        Podiatrist,

        /// <summary>
        /// Audiologist
        /// </summary>
        [EnumMember]
        [Name(Code = "252711", Name = "Audiologist")]
        Audiologist,

        /// <summary>
        /// SpeechPathologist
        /// </summary>
        [EnumMember]
        [Name(Code = "252712", Name = "Speech Pathologist")]
        SpeechPathologist,

        /// <summary>
        /// GeneralMedicalPractitioner
        /// </summary>
        [EnumMember]
        [Name(Code = "253111", Name = "General Medical Practitioner")]
        GeneralMedicalPractitioner,

        /// <summary>
        /// ResidentMedicalOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "253112", Name = "Resident Medical Officer")]
        ResidentMedicalOfficer,

        /// <summary>
        /// Anaesthetist
        /// </summary>
        [EnumMember]
        [Name(Code = "253211", Name = "Anaesthetist")]
        Anaesthetist,

        /// <summary>
        /// SpecialistPhysicianGeneralMedicine
        /// </summary>
        [EnumMember]
        [Name(Code = "253311", Name = "Specialist Physician (General Medicine)")]
        SpecialistPhysicianGeneralMedicine,

        /// <summary>
        /// Cardiologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253312", Name = "Cardiologist")]
        Cardiologist,

        /// <summary>
        /// ClinicalHaematologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253313", Name = "Clinical Haematologist")]
        ClinicalHaematologist,

        /// <summary>
        /// MedicalOncologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253314", Name = "Medical Oncologist")]
        MedicalOncologist,

        /// <summary>
        /// Endocrinologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253315", Name = "Endocrinologist")]
        Endocrinologist,

        /// <summary>
        /// Gastroenterologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253316", Name = "Gastroenterologist")]
        Gastroenterologist,

        /// <summary>
        /// IntensiveCareSpecialist
        /// </summary>
        [EnumMember]
        [Name(Code = "253317", Name = "Intensive Care Specialist")]
        IntensiveCareSpecialist,

        /// <summary>
        /// Neurologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253318", Name = "Neurologist")]
        Neurologist,

        /// <summary>
        /// Paediatrician
        /// </summary>
        [EnumMember]
        [Name(Code = "253321", Name = "Paediatrician")]
        Paediatrician,

        /// <summary>
        /// RenalMedicineSpecialist
        /// </summary>
        [EnumMember]
        [Name(Code = "253322", Name = "Renal Medicine Specialist")]
        RenalMedicineSpecialist,

        /// <summary>
        /// Rheumatologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253323", Name = "Rheumatologist")]
        Rheumatologist,

        /// <summary>
        /// ThoracicMedicineSpecialist
        /// </summary>
        [EnumMember]
        [Name(Code = "253324", Name = "Thoracic Medicine Specialist")]
        ThoracicMedicineSpecialist,

        /// <summary>
        /// SpecialistPhysiciansNec
        /// </summary>
        [EnumMember]
        [Name(Code = "253399", Name = "Specialist Physicians nec")]
        SpecialistPhysiciansNec,

        /// <summary>
        /// Psychiatrist
        /// </summary>
        [EnumMember]
        [Name(Code = "253411", Name = "Psychiatrist")]
        Psychiatrist,

        /// <summary>
        /// SurgeonGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "253511", Name = "Surgeon (General)")]
        SurgeonGeneral,

        /// <summary>
        /// CardiothoracicSurgeon
        /// </summary>
        [EnumMember]
        [Name(Code = "253512", Name = "Cardiothoracic Surgeon")]
        CardiothoracicSurgeon,

        /// <summary>
        /// Neurosurgeon
        /// </summary>
        [EnumMember]
        [Name(Code = "253513", Name = "Neurosurgeon")]
        Neurosurgeon,

        /// <summary>
        /// OrthopaedicSurgeon
        /// </summary>
        [EnumMember]
        [Name(Code = "253514", Name = "Orthopaedic Surgeon")]
        OrthopaedicSurgeon,

        /// <summary>
        /// Otorhinolaryngologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253515", Name = "Otorhinolaryngologist")]
        Otorhinolaryngologist,

        /// <summary>
        /// PaediatricSurgeon
        /// </summary>
        [EnumMember]
        [Name(Code = "253516", Name = "Paediatric Surgeon")]
        PaediatricSurgeon,

        /// <summary>
        /// PlasticAndReconstructiveSurgeon
        /// </summary>
        [EnumMember]
        [Name(Code = "253517", Name = "Plastic and Reconstructive Surgeon")]
        PlasticAndReconstructiveSurgeon,

        /// <summary>
        /// Urologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253518", Name = "Urologist")]
        Urologist,

        /// <summary>
        /// VascularSurgeon
        /// </summary>
        [EnumMember]
        [Name(Code = "253521", Name = "Vascular Surgeon")]
        VascularSurgeon,

        /// <summary>
        /// Dermatologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253911", Name = "Dermatologist")]
        Dermatologist,

        /// <summary>
        /// EmergencyMedicineSpecialist
        /// </summary>
        [EnumMember]
        [Name(Code = "253912", Name = "Emergency Medicine Specialist")]
        EmergencyMedicineSpecialist,

        /// <summary>
        /// ObstetricianAndGynaecologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253913", Name = "Obstetrician and Gynaecologist")]
        ObstetricianAndGynaecologist,

        /// <summary>
        /// Ophthalmologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253914", Name = "Ophthalmologist")]
        Ophthalmologist,

        /// <summary>
        /// Pathologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253915", Name = "Pathologist")]
        Pathologist,

        /// <summary>
        /// DiagnosticAndInterventionalRadiologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253917", Name = "Diagnostic and Interventional Radiologist")]
        DiagnosticAndInterventionalRadiologist,

        /// <summary>
        /// RadiationOncologist
        /// </summary>
        [EnumMember]
        [Name(Code = "253918", Name = "Radiation Oncologist")]
        RadiationOncologist,

        /// <summary>
        /// MedicalPractitionersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "253999", Name = "Medical Practitioners nec")]
        MedicalPractitionersNec,

        /// <summary>
        /// Midwife
        /// </summary>
        [EnumMember]
        [Name(Code = "254111", Name = "Midwife")]
        Midwife,

        /// <summary>
        /// NurseEducator
        /// </summary>
        [EnumMember]
        [Name(Code = "254211", Name = "Nurse Educator")]
        NurseEducator,

        /// <summary>
        /// NurseResearcher
        /// </summary>
        [EnumMember]
        [Name(Code = "254212", Name = "Nurse Researcher")]
        NurseResearcher,

        /// <summary>
        /// NurseManager
        /// </summary>
        [EnumMember]
        [Name(Code = "254311", Name = "Nurse Manager")]
        NurseManager,

        /// <summary>
        /// NursePractitioner
        /// </summary>
        [EnumMember]
        [Name(Code = "254411", Name = "Nurse Practitioner")]
        NursePractitioner,

        /// <summary>
        /// RegisteredNurseAgedCare
        /// </summary>
        [EnumMember]
        [Name(Code = "254412", Name = "Registered Nurse (Aged Care)")]
        RegisteredNurseAgedCare,

        /// <summary>
        /// RegisteredNurseChildAndFamilyHealth
        /// </summary>
        [EnumMember]
        [Name(Code = "254413", Name = "Registered Nurse (Child and Family Health)")]
        RegisteredNurseChildAndFamilyHealth,

        /// <summary>
        /// RegisteredNurseCommunityHealth
        /// </summary>
        [EnumMember]
        [Name(Code = "254414", Name = "Registered Nurse (Community Health)")]
        RegisteredNurseCommunityHealth,

        /// <summary>
        /// RegisteredNurseCriticalCareAndEmergency
        /// </summary>
        [EnumMember]
        [Name(Code = "254415", Name = "Registered Nurse (Critical Care and Emergency)")]
        RegisteredNurseCriticalCareAndEmergency,

        /// <summary>
        /// RegisteredNurseDevelopmentalDisability
        /// </summary>
        [EnumMember]
        [Name(Code = "254416", Name = "Registered Nurse (Developmental Disability)")]
        RegisteredNurseDevelopmentalDisability,

        /// <summary>
        /// RegisteredNurseDisabilityAndRehabilitation
        /// </summary>
        [EnumMember]
        [Name(Code = "254417", Name = "Registered Nurse (Disability and Rehabilitation)")]
        RegisteredNurseDisabilityAndRehabilitation,

        /// <summary>
        /// RegisteredNurseMedical
        /// </summary>
        [EnumMember]
        [Name(Code = "254418", Name = "Registered Nurse (Medical)")]
        RegisteredNurseMedical,

        /// <summary>
        /// RegisteredNurseMedicalPractice
        /// </summary>
        [EnumMember]
        [Name(Code = "254421", Name = "Registered Nurse (Medical Practice)")]
        RegisteredNurseMedicalPractice,

        /// <summary>
        /// RegisteredNurseMentalHealth
        /// </summary>
        [EnumMember]
        [Name(Code = "254422", Name = "Registered Nurse (Mental Health)")]
        RegisteredNurseMentalHealth,

        /// <summary>
        /// RegisteredNursePerioperative
        /// </summary>
        [EnumMember]
        [Name(Code = "254423", Name = "Registered Nurse (Perioperative)")]
        RegisteredNursePerioperative,

        /// <summary>
        /// RegisteredNurseSurgical
        /// </summary>
        [EnumMember]
        [Name(Code = "254424", Name = "Registered Nurse (Surgical)")]
        RegisteredNurseSurgical,

        /// <summary>
        /// RegisteredNursesNec
        /// </summary>
        [EnumMember]
        [Name(Code = "254499", Name = "Registered Nurses nec")]
        RegisteredNursesNec,

        /// <summary>
        /// IctBusinessAnalyst
        /// </summary>
        [EnumMember]
        [Name(Code = "261111", Name = "ICT Business Analyst")]
        IctBusinessAnalyst,

        /// <summary>
        /// SystemsAnalyst
        /// </summary>
        [EnumMember]
        [Name(Code = "261112", Name = "Systems Analyst")]
        SystemsAnalyst,

        /// <summary>
        /// MultimediaSpecialist
        /// </summary>
        [EnumMember]
        [Name(Code = "261211", Name = "Multimedia Specialist")]
        MultimediaSpecialist,

        /// <summary>
        /// WebDeveloper
        /// </summary>
        [EnumMember]
        [Name(Code = "261212", Name = "Web Developer")]
        WebDeveloper,

        /// <summary>
        /// AnalystProgrammer
        /// </summary>
        [EnumMember]
        [Name(Code = "261311", Name = "Analyst Programmer")]
        AnalystProgrammer,

        /// <summary>
        /// DeveloperProgrammer
        /// </summary>
        [EnumMember]
        [Name(Code = "261312", Name = "Developer Programmer")]
        DeveloperProgrammer,

        /// <summary>
        /// SoftwareEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "261313", Name = "Software Engineer")]
        SoftwareEngineer,

        /// <summary>
        /// SoftwareTester
        /// </summary>
        [EnumMember]
        [Name(Code = "261314", Name = "Software Tester")]
        SoftwareTester,

        /// <summary>
        /// SoftwareAndApplicationsProgrammersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "261399", Name = "Software and Applications Programmers nec")]
        SoftwareAndApplicationsProgrammersNec,

        /// <summary>
        /// DatabaseAdministrator
        /// </summary>
        [EnumMember]
        [Name(Code = "262111", Name = "Database Administrator")]
        DatabaseAdministrator,

        /// <summary>
        /// IctSecuritySpecialist
        /// </summary>
        [EnumMember]
        [Name(Code = "262112", Name = "ICT Security Specialist")]
        IctSecuritySpecialist,

        /// <summary>
        /// SystemsAdministrator
        /// </summary>
        [EnumMember]
        [Name(Code = "262113", Name = "Systems Administrator")]
        SystemsAdministrator,

        /// <summary>
        /// ComputerNetworkAndSystemsEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "263111", Name = "Computer Network and Systems Engineer")]
        ComputerNetworkAndSystemsEngineer,

        /// <summary>
        /// NetworkAdministrator
        /// </summary>
        [EnumMember]
        [Name(Code = "263112", Name = "Network Administrator")]
        NetworkAdministrator,

        /// <summary>
        /// NetworkAnalyst
        /// </summary>
        [EnumMember]
        [Name(Code = "263113", Name = "Network Analyst")]
        NetworkAnalyst,

        /// <summary>
        /// IctQualityAssuranceEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "263211", Name = "ICT Quality Assurance Engineer")]
        IctQualityAssuranceEngineer,

        /// <summary>
        /// IctSupportEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "263212", Name = "ICT Support Engineer")]
        IctSupportEngineer,

        /// <summary>
        /// IctSystemsTestEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "263213", Name = "ICT Systems Test Engineer")]
        IctSystemsTestEngineer,

        /// <summary>
        /// IctSupportAndTestEngineersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "263299", Name = "ICT Support and Test Engineers nec")]
        IctSupportAndTestEngineersNec,

        /// <summary>
        /// TelecommunicationsEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "263311", Name = "Telecommunications Engineer")]
        TelecommunicationsEngineer,

        /// <summary>
        /// TelecommunicationsNetworkEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "263312", Name = "Telecommunications Network Engineer")]
        TelecommunicationsNetworkEngineer,

        /// <summary>
        /// Barrister
        /// </summary>
        [EnumMember]
        [Name(Code = "271111", Name = "Barrister")]
        Barrister,

        /// <summary>
        /// Judge
        /// </summary>
        [EnumMember]
        [Name(Code = "271211", Name = "Judge")]
        Judge,

        /// <summary>
        /// Magistrate
        /// </summary>
        [EnumMember]
        [Name(Code = "271212", Name = "Magistrate")]
        Magistrate,

        /// <summary>
        /// TribunalMember
        /// </summary>
        [EnumMember]
        [Name(Code = "271213", Name = "Tribunal Member")]
        TribunalMember,

        /// <summary>
        /// JudicialAndOtherLegalProfessionalsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "271299", Name = "Judicial and Other Legal Professionals nec")]
        JudicialAndOtherLegalProfessionalsNec,

        /// <summary>
        /// Solicitor
        /// </summary>
        [EnumMember]
        [Name(Code = "271311", Name = "Solicitor")]
        Solicitor,

        /// <summary>
        /// CareersCounsellor
        /// </summary>
        [EnumMember]
        [Name(Code = "272111", Name = "Careers Counsellor")]
        CareersCounsellor,

        /// <summary>
        /// DrugAndAlcoholCounsellor
        /// </summary>
        [EnumMember]
        [Name(Code = "272112", Name = "Drug and Alcohol Counsellor")]
        DrugAndAlcoholCounsellor,

        /// <summary>
        /// FamilyAndMarriageCounsellor
        /// </summary>
        [EnumMember]
        [Name(Code = "272113", Name = "Family and Marriage Counsellor")]
        FamilyAndMarriageCounsellor,

        /// <summary>
        /// RehabilitationCounsellor
        /// </summary>
        [EnumMember]
        [Name(Code = "272114", Name = "Rehabilitation Counsellor")]
        RehabilitationCounsellor,

        /// <summary>
        /// StudentCounsellor
        /// </summary>
        [EnumMember]
        [Name(Code = "272115", Name = "Student Counsellor")]
        StudentCounsellor,

        /// <summary>
        /// CounsellorsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "272199", Name = "Counsellors nec")]
        CounsellorsNec,

        /// <summary>
        /// MinisterOfReligion
        /// </summary>
        [EnumMember]
        [Name(Code = "272211", Name = "Minister of Religion")]
        MinisterOfReligion,

        /// <summary>
        /// ClinicalPsychologist
        /// </summary>
        [EnumMember]
        [Name(Code = "272311", Name = "Clinical Psychologist")]
        ClinicalPsychologist,

        /// <summary>
        /// EducationalPsychologist
        /// </summary>
        [EnumMember]
        [Name(Code = "272312", Name = "Educational Psychologist")]
        EducationalPsychologist,

        /// <summary>
        /// OrganisationalPsychologist
        /// </summary>
        [EnumMember]
        [Name(Code = "272313", Name = "Organisational Psychologist")]
        OrganisationalPsychologist,

        /// <summary>
        /// Psychotherapist
        /// </summary>
        [EnumMember]
        [Name(Code = "272314", Name = "Psychotherapist")]
        Psychotherapist,

        /// <summary>
        /// PsychologistsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "272399", Name = "Psychologists nec")]
        PsychologistsNec,

        /// <summary>
        /// Historian
        /// </summary>
        [EnumMember]
        [Name(Code = "272411", Name = "Historian")]
        Historian,

        /// <summary>
        /// Interpreter
        /// </summary>
        [EnumMember]
        [Name(Code = "272412", Name = "Interpreter")]
        Interpreter,

        /// <summary>
        /// Translator
        /// </summary>
        [EnumMember]
        [Name(Code = "272413", Name = "Translator")]
        Translator,

        /// <summary>
        /// SocialProfessionalsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "272499", Name = "Social Professionals nec")]
        SocialProfessionalsNec,

        /// <summary>
        /// SocialWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "272511", Name = "Social Worker")]
        SocialWorker,

        /// <summary>
        /// CommunityArtsWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "272611", Name = "Community Arts Worker")]
        CommunityArtsWorker,

        /// <summary>
        /// RecreationOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "272612", Name = "Recreation Officer")]
        RecreationOfficer,

        /// <summary>
        /// WelfareWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "272613", Name = "Welfare Worker")]
        WelfareWorker,

        /// <summary>
        /// AgriculturalTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "311111", Name = "Agricultural Technician")]
        AgriculturalTechnician,

        /// <summary>
        /// AnaestheticTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "311211", Name = "Anaesthetic Technician")]
        AnaestheticTechnician,

        /// <summary>
        /// CardiacTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "311212", Name = "Cardiac Technician")]
        CardiacTechnician,

        /// <summary>
        /// MedicalLaboratoryTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "311213", Name = "Medical Laboratory Technician")]
        MedicalLaboratoryTechnician,

        /// <summary>
        /// OperatingTheatreTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "311214", Name = "Operating Theatre Technician")]
        OperatingTheatreTechnician,

        /// <summary>
        /// PharmacyTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "311215", Name = "Pharmacy Technician")]
        PharmacyTechnician,

        /// <summary>
        /// PathologyCollector
        /// </summary>
        [EnumMember]
        [Name(Code = "311216", Name = "Pathology Collector")]
        PathologyCollector,

        /// <summary>
        /// MedicalTechniciansNec
        /// </summary>
        [EnumMember]
        [Name(Code = "311299", Name = "Medical Technicians nec")]
        MedicalTechniciansNec,

        /// <summary>
        /// FisheriesOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "311311", Name = "Fisheries Officer")]
        FisheriesOfficer,

        /// <summary>
        /// MeatInspector
        /// </summary>
        [EnumMember]
        [Name(Code = "311312", Name = "Meat Inspector")]
        MeatInspector,

        /// <summary>
        /// QuarantineOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "311313", Name = "Quarantine Officer")]
        QuarantineOfficer,

        /// <summary>
        /// PrimaryProductsInspectorsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "311399", Name = "Primary Products Inspectors nec")]
        PrimaryProductsInspectorsNec,

        /// <summary>
        /// ChemistryTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "311411", Name = "Chemistry Technician")]
        ChemistryTechnician,

        /// <summary>
        /// EarthScienceTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "311412", Name = "Earth Science Technician")]
        EarthScienceTechnician,

        /// <summary>
        /// LifeScienceTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "311413", Name = "Life Science Technician")]
        LifeScienceTechnician,

        /// <summary>
        /// SchoolLaboratoryTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "311414", Name = "School Laboratory Technician")]
        SchoolLaboratoryTechnician,

        /// <summary>
        /// ScienceTechniciansNec
        /// </summary>
        [EnumMember]
        [Name(Code = "311499", Name = "Science Technicians nec")]
        ScienceTechniciansNec,

        /// <summary>
        /// ArchitecturalDraftsperson
        /// </summary>
        [EnumMember]
        [Name(Code = "312111", Name = "Architectural Draftsperson")]
        ArchitecturalDraftsperson,

        /// <summary>
        /// BuildingAssociate
        /// </summary>
        [EnumMember]
        [Name(Code = "312112", Name = "Building Associate")]
        BuildingAssociate,

        /// <summary>
        /// BuildingInspector
        /// </summary>
        [EnumMember]
        [Name(Code = "312113", Name = "Building Inspector")]
        BuildingInspector,

        /// <summary>
        /// ConstructionEstimator
        /// </summary>
        [EnumMember]
        [Name(Code = "312114", Name = "Construction Estimator")]
        ConstructionEstimator,

        /// <summary>
        /// PlumbingInspector
        /// </summary>
        [EnumMember]
        [Name(Code = "312115", Name = "Plumbing Inspector")]
        PlumbingInspector,

        /// <summary>
        /// SurveyingOrSpatialScienceTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "312116", Name = "Surveying or Spatial Science Technician")]
        SurveyingOrSpatialScienceTechnician,

        /// <summary>
        /// ArchitecturalBuildingAndSurveyingTechniciansNec
        /// </summary>
        [EnumMember]
        [Name(Code = "312199", Name = "Architectural, Building and Surveying Technicians nec")]
        ArchitecturalBuildingAndSurveyingTechniciansNec,

        /// <summary>
        /// CivilEngineeringDraftsperson
        /// </summary>
        [EnumMember]
        [Name(Code = "312211", Name = "Civil Engineering Draftsperson")]
        CivilEngineeringDraftsperson,

        /// <summary>
        /// CivilEngineeringTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "312212", Name = "Civil Engineering Technician")]
        CivilEngineeringTechnician,

        /// <summary>
        /// ElectricalEngineeringDraftsperson
        /// </summary>
        [EnumMember]
        [Name(Code = "312311", Name = "Electrical Engineering Draftsperson")]
        ElectricalEngineeringDraftsperson,

        /// <summary>
        /// ElectricalEngineeringTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "312312", Name = "Electrical Engineering Technician")]
        ElectricalEngineeringTechnician,

        /// <summary>
        /// ElectronicEngineeringDraftsperson
        /// </summary>
        [EnumMember]
        [Name(Code = "312411", Name = "Electronic Engineering Draftsperson")]
        ElectronicEngineeringDraftsperson,

        /// <summary>
        /// ElectronicEngineeringTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "312412", Name = "Electronic Engineering Technician")]
        ElectronicEngineeringTechnician,

        /// <summary>
        /// MechanicalEngineeringDraftsperson
        /// </summary>
        [EnumMember]
        [Name(Code = "312511", Name = "Mechanical Engineering Draftsperson")]
        MechanicalEngineeringDraftsperson,

        /// <summary>
        /// MechanicalEngineeringTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "312512", Name = "Mechanical Engineering Technician")]
        MechanicalEngineeringTechnician,

        /// <summary>
        /// SafetyInspector
        /// </summary>
        [EnumMember]
        [Name(Code = "312611", Name = "Safety Inspector")]
        SafetyInspector,

        /// <summary>
        /// MaintenancePlanner
        /// </summary>
        [EnumMember]
        [Name(Code = "312911", Name = "Maintenance Planner")]
        MaintenancePlanner,

        /// <summary>
        /// MetallurgicalOrMaterialsTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "312912", Name = "Metallurgical or Materials Technician")]
        MetallurgicalOrMaterialsTechnician,

        /// <summary>
        /// MineDeputy
        /// </summary>
        [EnumMember]
        [Name(Code = "312913", Name = "Mine Deputy")]
        MineDeputy,

        /// <summary>
        /// BuildingAndEngineeringTechniciansNec
        /// </summary>
        [EnumMember]
        [Name(Code = "312999", Name = "Building and Engineering Technicians nec")]
        BuildingAndEngineeringTechniciansNec,

        /// <summary>
        /// HardwareTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "313111", Name = "Hardware Technician")]
        HardwareTechnician,

        /// <summary>
        /// IctCustomerSupportOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "313112", Name = "ICT Customer Support Officer")]
        IctCustomerSupportOfficer,

        /// <summary>
        /// WebAdministrator
        /// </summary>
        [EnumMember]
        [Name(Code = "313113", Name = "Web Administrator")]
        WebAdministrator,

        /// <summary>
        /// IctSupportTechniciansNec
        /// </summary>
        [EnumMember]
        [Name(Code = "313199", Name = "ICT Support Technicians nec")]
        IctSupportTechniciansNec,

        /// <summary>
        /// RadiocommunicationsTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "313211", Name = "Radiocommunications Technician")]
        RadiocommunicationsTechnician,

        /// <summary>
        /// TelecommunicationsFieldEngineer
        /// </summary>
        [EnumMember]
        [Name(Code = "313212", Name = "Telecommunications Field Engineer")]
        TelecommunicationsFieldEngineer,

        /// <summary>
        /// TelecommunicationsNetworkPlanner
        /// </summary>
        [EnumMember]
        [Name(Code = "313213", Name = "Telecommunications Network Planner")]
        TelecommunicationsNetworkPlanner,

        /// <summary>
        /// TelecommunicationsTechnicalOfficerOrTechnologist
        /// </summary>
        [EnumMember]
        [Name(Code = "313214", Name = "Telecommunications Technical Officer or Technologist")]
        TelecommunicationsTechnicalOfficerOrTechnologist,

        /// <summary>
        /// AutomotiveElectrician
        /// </summary>
        [EnumMember]
        [Name(Code = "321111", Name = "Automotive Electrician")]
        AutomotiveElectrician,

        /// <summary>
        /// MotorMechanicGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "321211", Name = "Motor Mechanic (General)")]
        MotorMechanicGeneral,

        /// <summary>
        /// DieselMotorMechanic
        /// </summary>
        [EnumMember]
        [Name(Code = "321212", Name = "Diesel Motor Mechanic")]
        DieselMotorMechanic,

        /// <summary>
        /// MotorcycleMechanic
        /// </summary>
        [EnumMember]
        [Name(Code = "321213", Name = "Motorcycle Mechanic")]
        MotorcycleMechanic,

        /// <summary>
        /// SmallEngineMechanic
        /// </summary>
        [EnumMember]
        [Name(Code = "321214", Name = "Small Engine Mechanic")]
        SmallEngineMechanic,

        /// <summary>
        /// Blacksmith
        /// </summary>
        [EnumMember]
        [Name(Code = "322111", Name = "Blacksmith")]
        Blacksmith,

        /// <summary>
        /// Electroplater
        /// </summary>
        [EnumMember]
        [Name(Code = "322112", Name = "Electroplater")]
        Electroplater,

        /// <summary>
        /// Farrier
        /// </summary>
        [EnumMember]
        [Name(Code = "322113", Name = "Farrier")]
        Farrier,

        /// <summary>
        /// MetalCastingTradesWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "322114", Name = "Metal Casting Trades Worker")]
        MetalCastingTradesWorker,

        /// <summary>
        /// MetalPolisher
        /// </summary>
        [EnumMember]
        [Name(Code = "322115", Name = "Metal Polisher")]
        MetalPolisher,

        /// <summary>
        /// SheetmetalTradesWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "322211", Name = "Sheetmetal Trades Worker")]
        SheetmetalTradesWorker,

        /// <summary>
        /// MetalFabricator
        /// </summary>
        [EnumMember]
        [Name(Code = "322311", Name = "Metal Fabricator")]
        MetalFabricator,

        /// <summary>
        /// PressureWelder
        /// </summary>
        [EnumMember]
        [Name(Code = "322312", Name = "Pressure Welder")]
        PressureWelder,

        /// <summary>
        /// WelderFirstClass
        /// </summary>
        [EnumMember]
        [Name(Code = "322313", Name = "Welder (First Class)")]
        WelderFirstClass,

        /// <summary>
        /// AircraftMaintenanceEngineerAvionics
        /// </summary>
        [EnumMember]
        [Name(Code = "323111", Name = "Aircraft Maintenance Engineer (Avionics)")]
        AircraftMaintenanceEngineerAvionics,

        /// <summary>
        /// AircraftMaintenanceEngineerMechanical
        /// </summary>
        [EnumMember]
        [Name(Code = "323112", Name = "Aircraft Maintenance Engineer (Mechanical)")]
        AircraftMaintenanceEngineerMechanical,

        /// <summary>
        /// AircraftMaintenanceEngineerStructures
        /// </summary>
        [EnumMember]
        [Name(Code = "323113", Name = "Aircraft Maintenance Engineer (Structures)")]
        AircraftMaintenanceEngineerStructures,

        /// <summary>
        /// FitterGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "323211", Name = "Fitter (General)")]
        FitterGeneral,

        /// <summary>
        /// FitterAndTurner
        /// </summary>
        [EnumMember]
        [Name(Code = "323212", Name = "Fitter and Turner")]
        FitterAndTurner,

        /// <summary>
        /// FitterWelder
        /// </summary>
        [EnumMember]
        [Name(Code = "323213", Name = "Fitter-Welder")]
        FitterWelder,

        /// <summary>
        /// MetalMachinistFirstClass
        /// </summary>
        [EnumMember]
        [Name(Code = "323214", Name = "Metal Machinist (First Class)")]
        MetalMachinistFirstClass,

        /// <summary>
        /// TextileClothingAndFootwearMechanic
        /// </summary>
        [EnumMember]
        [Name(Code = "323215", Name = "Textile, Clothing and Footwear Mechanic")]
        TextileClothingAndFootwearMechanic,

        /// <summary>
        /// MetalFittersAndMachinistsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "323299", Name = "Metal Fitters and Machinists nec")]
        MetalFittersAndMachinistsNec,

        /// <summary>
        /// Engraver
        /// </summary>
        [EnumMember]
        [Name(Code = "323311", Name = "Engraver")]
        Engraver,

        /// <summary>
        /// Gunsmith
        /// </summary>
        [EnumMember]
        [Name(Code = "323312", Name = "Gunsmith")]
        Gunsmith,

        /// <summary>
        /// Locksmith
        /// </summary>
        [EnumMember]
        [Name(Code = "323313", Name = "Locksmith")]
        Locksmith,

        /// <summary>
        /// PrecisionInstrumentMakerAndRepairer
        /// </summary>
        [EnumMember]
        [Name(Code = "323314", Name = "Precision Instrument Maker and Repairer")]
        PrecisionInstrumentMakerAndRepairer,

        /// <summary>
        /// SawMakerAndRepairer
        /// </summary>
        [EnumMember]
        [Name(Code = "323315", Name = "Saw Maker and Repairer")]
        SawMakerAndRepairer,

        /// <summary>
        /// WatchAndClockMakerAndRepairer
        /// </summary>
        [EnumMember]
        [Name(Code = "323316", Name = "Watch and Clock Maker and Repairer")]
        WatchAndClockMakerAndRepairer,

        /// <summary>
        /// EngineeringPatternmaker
        /// </summary>
        [EnumMember]
        [Name(Code = "323411", Name = "Engineering Patternmaker")]
        EngineeringPatternmaker,

        /// <summary>
        /// Toolmaker
        /// </summary>
        [EnumMember]
        [Name(Code = "323412", Name = "Toolmaker")]
        Toolmaker,

        /// <summary>
        /// Panelbeater
        /// </summary>
        [EnumMember]
        [Name(Code = "324111", Name = "Panelbeater")]
        Panelbeater,

        /// <summary>
        /// VehicleBodyBuilder
        /// </summary>
        [EnumMember]
        [Name(Code = "324211", Name = "Vehicle Body Builder")]
        VehicleBodyBuilder,

        /// <summary>
        /// VehicleTrimmer
        /// </summary>
        [EnumMember]
        [Name(Code = "324212", Name = "Vehicle Trimmer")]
        VehicleTrimmer,

        /// <summary>
        /// VehiclePainter
        /// </summary>
        [EnumMember]
        [Name(Code = "324311", Name = "Vehicle Painter")]
        VehiclePainter,

        /// <summary>
        /// Bricklayer
        /// </summary>
        [EnumMember]
        [Name(Code = "331111", Name = "Bricklayer")]
        Bricklayer,

        /// <summary>
        /// Stonemason
        /// </summary>
        [EnumMember]
        [Name(Code = "331112", Name = "Stonemason")]
        Stonemason,

        /// <summary>
        /// CarpenterAndJoiner
        /// </summary>
        [EnumMember]
        [Name(Code = "331211", Name = "Carpenter and Joiner")]
        CarpenterAndJoiner,

        /// <summary>
        /// Carpenter
        /// </summary>
        [EnumMember]
        [Name(Code = "331212", Name = "Carpenter")]
        Carpenter,

        /// <summary>
        /// Joiner
        /// </summary>
        [EnumMember]
        [Name(Code = "331213", Name = "Joiner")]
        Joiner,

        /// <summary>
        /// FloorFinisher
        /// </summary>
        [EnumMember]
        [Name(Code = "332111", Name = "Floor Finisher")]
        FloorFinisher,

        /// <summary>
        /// PaintingTradesWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "332211", Name = "Painting Trades Worker")]
        PaintingTradesWorker,

        /// <summary>
        /// Glazier
        /// </summary>
        [EnumMember]
        [Name(Code = "333111", Name = "Glazier")]
        Glazier,

        /// <summary>
        /// FibrousPlasterer
        /// </summary>
        [EnumMember]
        [Name(Code = "333211", Name = "Fibrous Plasterer")]
        FibrousPlasterer,

        /// <summary>
        /// SolidPlasterer
        /// </summary>
        [EnumMember]
        [Name(Code = "333212", Name = "Solid Plasterer")]
        SolidPlasterer,

        /// <summary>
        /// RoofTiler
        /// </summary>
        [EnumMember]
        [Name(Code = "333311", Name = "Roof Tiler")]
        RoofTiler,

        /// <summary>
        /// WallAndFloorTiler
        /// </summary>
        [EnumMember]
        [Name(Code = "333411", Name = "Wall and Floor Tiler")]
        WallAndFloorTiler,

        /// <summary>
        /// PlumberGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "334111", Name = "Plumber (General)")]
        PlumberGeneral,

        /// <summary>
        /// AirconditioningAndMechanicalServicesPlumber
        /// </summary>
        [EnumMember]
        [Name(Code = "334112", Name = "Airconditioning and Mechanical Services Plumber")]
        AirconditioningAndMechanicalServicesPlumber,

        /// <summary>
        /// Drainer
        /// </summary>
        [EnumMember]
        [Name(Code = "334113", Name = "Drainer")]
        Drainer,

        /// <summary>
        /// Gasfitter
        /// </summary>
        [EnumMember]
        [Name(Code = "334114", Name = "Gasfitter")]
        Gasfitter,

        /// <summary>
        /// RoofPlumber
        /// </summary>
        [EnumMember]
        [Name(Code = "334115", Name = "Roof Plumber")]
        RoofPlumber,

        /// <summary>
        /// ElectricianGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "341111", Name = "Electrician (General)")]
        ElectricianGeneral,

        /// <summary>
        /// ElectricianSpecialClass
        /// </summary>
        [EnumMember]
        [Name(Code = "341112", Name = "Electrician (Special Class)")]
        ElectricianSpecialClass,

        /// <summary>
        /// LiftMechanic
        /// </summary>
        [EnumMember]
        [Name(Code = "341113", Name = "Lift Mechanic")]
        LiftMechanic,

        /// <summary>
        /// AirconditioningAndRefrigerationMechanic
        /// </summary>
        [EnumMember]
        [Name(Code = "342111", Name = "Airconditioning and Refrigeration Mechanic")]
        AirconditioningAndRefrigerationMechanic,

        /// <summary>
        /// ElectricalLinesworker
        /// </summary>
        [EnumMember]
        [Name(Code = "342211", Name = "Electrical Linesworker")]
        ElectricalLinesworker,

        /// <summary>
        /// TechnicalCableJointer
        /// </summary>
        [EnumMember]
        [Name(Code = "342212", Name = "Technical Cable Jointer")]
        TechnicalCableJointer,

        /// <summary>
        /// BusinessMachineMechanic
        /// </summary>
        [EnumMember]
        [Name(Code = "342311", Name = "Business Machine Mechanic")]
        BusinessMachineMechanic,

        /// <summary>
        /// CommunicationsOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "342312", Name = "Communications Operator")]
        CommunicationsOperator,

        /// <summary>
        /// ElectronicEquipmentTradesWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "342313", Name = "Electronic Equipment Trades Worker")]
        ElectronicEquipmentTradesWorker,

        /// <summary>
        /// ElectronicInstrumentTradesWorkerGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "342314", Name = "Electronic Instrument Trades Worker (General)")]
        ElectronicInstrumentTradesWorkerGeneral,

        /// <summary>
        /// ElectronicInstrumentTradesWorkerSpecialClass
        /// </summary>
        [EnumMember]
        [Name(Code = "342315", Name = "Electronic Instrument Trades Worker (Special Class)")]
        ElectronicInstrumentTradesWorkerSpecialClass,

        /// <summary>
        /// CablerDataAndTelecommunications
        /// </summary>
        [EnumMember]
        [Name(Code = "342411", Name = "Cabler (Data and Telecommunications)")]
        CablerDataAndTelecommunications,

        /// <summary>
        /// TelecommunicationsCableJointer
        /// </summary>
        [EnumMember]
        [Name(Code = "342412", Name = "Telecommunications Cable Jointer")]
        TelecommunicationsCableJointer,

        /// <summary>
        /// TelecommunicationsLinesworker
        /// </summary>
        [EnumMember]
        [Name(Code = "342413", Name = "Telecommunications Linesworker")]
        TelecommunicationsLinesworker,

        /// <summary>
        /// TelecommunicationsTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "342414", Name = "Telecommunications Technician")]
        TelecommunicationsTechnician,

        /// <summary>
        /// Baker
        /// </summary>
        [EnumMember]
        [Name(Code = "351111", Name = "Baker")]
        Baker,

        /// <summary>
        /// Pastrycook
        /// </summary>
        [EnumMember]
        [Name(Code = "351112", Name = "Pastrycook")]
        Pastrycook,

        /// <summary>
        /// ButcherOrSmallgoodsMaker
        /// </summary>
        [EnumMember]
        [Name(Code = "351211", Name = "Butcher or Smallgoods Maker")]
        ButcherOrSmallgoodsMaker,

        /// <summary>
        /// Chef
        /// </summary>
        [EnumMember]
        [Name(Code = "351311", Name = "Chef")]
        Chef,

        /// <summary>
        /// Cook
        /// </summary>
        [EnumMember]
        [Name(Code = "351411", Name = "Cook")]
        Cook,

        /// <summary>
        /// DogHandlerOrTrainer
        /// </summary>
        [EnumMember]
        [Name(Code = "361111", Name = "Dog Handler or Trainer")]
        DogHandlerOrTrainer,

        /// <summary>
        /// HorseTrainer
        /// </summary>
        [EnumMember]
        [Name(Code = "361112", Name = "Horse Trainer")]
        HorseTrainer,

        /// <summary>
        /// PetGroomer
        /// </summary>
        [EnumMember]
        [Name(Code = "361113", Name = "Pet Groomer")]
        PetGroomer,

        /// <summary>
        /// Zookeeper
        /// </summary>
        [EnumMember]
        [Name(Code = "361114", Name = "Zookeeper")]
        Zookeeper,

        /// <summary>
        /// AnimalAttendantsAndTrainersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "361199", Name = "Animal Attendants and Trainers nec")]
        AnimalAttendantsAndTrainersNec,

        /// <summary>
        /// Shearer
        /// </summary>
        [EnumMember]
        [Name(Code = "361211", Name = "Shearer")]
        Shearer,

        /// <summary>
        /// VeterinaryNurse
        /// </summary>
        [EnumMember]
        [Name(Code = "361311", Name = "Veterinary Nurse")]
        VeterinaryNurse,

        /// <summary>
        /// Florist
        /// </summary>
        [EnumMember]
        [Name(Code = "362111", Name = "Florist")]
        Florist,

        /// <summary>
        /// GardenerGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "362211", Name = "Gardener (General)")]
        GardenerGeneral,

        /// <summary>
        /// Arborist
        /// </summary>
        [EnumMember]
        [Name(Code = "362212", Name = "Arborist")]
        Arborist,

        /// <summary>
        /// LandscapeGardener
        /// </summary>
        [EnumMember]
        [Name(Code = "362213", Name = "Landscape Gardener")]
        LandscapeGardener,

        /// <summary>
        /// Greenkeeper
        /// </summary>
        [EnumMember]
        [Name(Code = "362311", Name = "Greenkeeper")]
        Greenkeeper,

        /// <summary>
        /// Nurseryperson
        /// </summary>
        [EnumMember]
        [Name(Code = "362411", Name = "Nurseryperson")]
        Nurseryperson,

        /// <summary>
        /// Hairdresser
        /// </summary>
        [EnumMember]
        [Name(Code = "391111", Name = "Hairdresser")]
        Hairdresser,

        /// <summary>
        /// PrintFinisher
        /// </summary>
        [EnumMember]
        [Name(Code = "392111", Name = "Print Finisher")]
        PrintFinisher,

        /// <summary>
        /// ScreenPrinter
        /// </summary>
        [EnumMember]
        [Name(Code = "392112", Name = "Screen Printer")]
        ScreenPrinter,

        /// <summary>
        /// GraphicPrePressTradesWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "392211", Name = "Graphic Pre-press Trades Worker")]
        GraphicPrePressTradesWorker,

        /// <summary>
        /// PrintingMachinist
        /// </summary>
        [EnumMember]
        [Name(Code = "392311", Name = "Printing Machinist")]
        PrintingMachinist,

        /// <summary>
        /// SmallOffsetPrinter
        /// </summary>
        [EnumMember]
        [Name(Code = "392312", Name = "Small Offset Printer")]
        SmallOffsetPrinter,

        /// <summary>
        /// CanvasGoodsFabricator
        /// </summary>
        [EnumMember]
        [Name(Code = "393111", Name = "Canvas Goods Fabricator")]
        CanvasGoodsFabricator,

        /// <summary>
        /// LeatherGoodsMaker
        /// </summary>
        [EnumMember]
        [Name(Code = "393112", Name = "Leather Goods Maker")]
        LeatherGoodsMaker,

        /// <summary>
        /// SailMaker
        /// </summary>
        [EnumMember]
        [Name(Code = "393113", Name = "Sail Maker")]
        SailMaker,

        /// <summary>
        /// Shoemaker
        /// </summary>
        [EnumMember]
        [Name(Code = "393114", Name = "Shoemaker")]
        Shoemaker,

        /// <summary>
        /// ApparelCutter
        /// </summary>
        [EnumMember]
        [Name(Code = "393211", Name = "Apparel Cutter")]
        ApparelCutter,

        /// <summary>
        /// ClothingPatternmaker
        /// </summary>
        [EnumMember]
        [Name(Code = "393212", Name = "Clothing Patternmaker")]
        ClothingPatternmaker,

        /// <summary>
        /// DressmakerOrTailor
        /// </summary>
        [EnumMember]
        [Name(Code = "393213", Name = "Dressmaker or Tailor")]
        DressmakerOrTailor,

        /// <summary>
        /// ClothingTradesWorkersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "393299", Name = "Clothing Trades Workers nec")]
        ClothingTradesWorkersNec,

        /// <summary>
        /// Upholsterer
        /// </summary>
        [EnumMember]
        [Name(Code = "393311", Name = "Upholsterer")]
        Upholsterer,

        /// <summary>
        /// Cabinetmaker
        /// </summary>
        [EnumMember]
        [Name(Code = "394111", Name = "Cabinetmaker")]
        Cabinetmaker,

        /// <summary>
        /// FurnitureFinisher
        /// </summary>
        [EnumMember]
        [Name(Code = "394211", Name = "Furniture Finisher")]
        FurnitureFinisher,

        /// <summary>
        /// PictureFramer
        /// </summary>
        [EnumMember]
        [Name(Code = "394212", Name = "Picture Framer")]
        PictureFramer,

        /// <summary>
        /// WoodMachinist
        /// </summary>
        [EnumMember]
        [Name(Code = "394213", Name = "Wood Machinist")]
        WoodMachinist,

        /// <summary>
        /// WoodTurner
        /// </summary>
        [EnumMember]
        [Name(Code = "394214", Name = "Wood Turner")]
        WoodTurner,

        /// <summary>
        /// WoodMachinistsAndOtherWoodTradesWorkersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "394299", Name = "Wood Machinists and Other Wood Trades Workers nec")]
        WoodMachinistsAndOtherWoodTradesWorkersNec,

        /// <summary>
        /// BoatBuilderAndRepairer
        /// </summary>
        [EnumMember]
        [Name(Code = "399111", Name = "Boat Builder and Repairer")]
        BoatBuilderAndRepairer,

        /// <summary>
        /// Shipwright
        /// </summary>
        [EnumMember]
        [Name(Code = "399112", Name = "Shipwright")]
        Shipwright,

        /// <summary>
        /// ChemicalPlantOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "399211", Name = "Chemical Plant Operator")]
        ChemicalPlantOperator,

        /// <summary>
        /// GasOrPetroleumOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "399212", Name = "Gas or Petroleum Operator")]
        GasOrPetroleumOperator,

        /// <summary>
        /// PowerGenerationPlantOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "399213", Name = "Power Generation Plant Operator")]
        PowerGenerationPlantOperator,

        /// <summary>
        /// GalleryOrMuseumTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "399311", Name = "Gallery or Museum Technician")]
        GalleryOrMuseumTechnician,

        /// <summary>
        /// LibraryTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "399312", Name = "Library Technician")]
        LibraryTechnician,

        /// <summary>
        /// Jeweller
        /// </summary>
        [EnumMember]
        [Name(Code = "399411", Name = "Jeweller")]
        Jeweller,

        /// <summary>
        /// BroadcastTransmitterOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "399511", Name = "Broadcast Transmitter Operator")]
        BroadcastTransmitterOperator,

        /// <summary>
        /// CameraOperatorFilmTelevisionOrVideo
        /// </summary>
        [EnumMember]
        [Name(Code = "399512", Name = "Camera Operator (Film, Television or Video)")]
        CameraOperatorFilmTelevisionOrVideo,

        /// <summary>
        /// LightTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "399513", Name = "Light Technician")]
        LightTechnician,

        /// <summary>
        /// MakeUpArtist
        /// </summary>
        [EnumMember]
        [Name(Code = "399514", Name = "Make Up Artist")]
        MakeUpArtist,

        /// <summary>
        /// MusicalInstrumentMakerOrRepairer
        /// </summary>
        [EnumMember]
        [Name(Code = "399515", Name = "Musical Instrument Maker or Repairer")]
        MusicalInstrumentMakerOrRepairer,

        /// <summary>
        /// SoundTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "399516", Name = "Sound Technician")]
        SoundTechnician,

        /// <summary>
        /// TelevisionEquipmentOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "399517", Name = "Television Equipment Operator")]
        TelevisionEquipmentOperator,

        /// <summary>
        /// PerformingArtsTechniciansNec
        /// </summary>
        [EnumMember]
        [Name(Code = "399599", Name = "Performing Arts Technicians nec")]
        PerformingArtsTechniciansNec,

        /// <summary>
        /// Signwriter
        /// </summary>
        [EnumMember]
        [Name(Code = "399611", Name = "Signwriter")]
        Signwriter,

        /// <summary>
        /// Diver
        /// </summary>
        [EnumMember]
        [Name(Code = "399911", Name = "Diver")]
        Diver,

        /// <summary>
        /// InteriorDecorator
        /// </summary>
        [EnumMember]
        [Name(Code = "399912", Name = "Interior Decorator")]
        InteriorDecorator,

        /// <summary>
        /// OpticalDispenser
        /// </summary>
        [EnumMember]
        [Name(Code = "399913", Name = "Optical Dispenser")]
        OpticalDispenser,

        /// <summary>
        /// OpticalMechanic
        /// </summary>
        [EnumMember]
        [Name(Code = "399914", Name = "Optical Mechanic")]
        OpticalMechanic,

        /// <summary>
        /// PhotographerSAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "399915", Name = "Photographer's Assistant")]
        PhotographerSAssistant,

        /// <summary>
        /// PlasticsTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "399916", Name = "Plastics Technician")]
        PlasticsTechnician,

        /// <summary>
        /// WoolClasser
        /// </summary>
        [EnumMember]
        [Name(Code = "399917", Name = "Wool Classer")]
        WoolClasser,

        /// <summary>
        /// FireProtectionEquipmentTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "399918", Name = "Fire Protection Equipment Technician")]
        FireProtectionEquipmentTechnician,

        /// <summary>
        /// TechniciansAndTradesWorkersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "399999", Name = "Technicians and Trades Workers nec")]
        TechniciansAndTradesWorkersNec,

        /// <summary>
        /// AmbulanceOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "411111", Name = "Ambulance Officer")]
        AmbulanceOfficer,

        /// <summary>
        /// IntensiveCareAmbulanceParamedic
        /// </summary>
        [EnumMember]
        [Name(Code = "411112", Name = "Intensive Care Ambulance Paramedic")]
        IntensiveCareAmbulanceParamedic,

        /// <summary>
        /// DentalHygienist
        /// </summary>
        [EnumMember]
        [Name(Code = "411211", Name = "Dental Hygienist")]
        DentalHygienist,

        /// <summary>
        /// DentalProsthetist
        /// </summary>
        [EnumMember]
        [Name(Code = "411212", Name = "Dental Prosthetist")]
        DentalProsthetist,

        /// <summary>
        /// DentalTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "411213", Name = "Dental Technician")]
        DentalTechnician,

        /// <summary>
        /// DentalTherapist
        /// </summary>
        [EnumMember]
        [Name(Code = "411214", Name = "Dental Therapist")]
        DentalTherapist,

        /// <summary>
        /// DiversionalTherapist
        /// </summary>
        [EnumMember]
        [Name(Code = "411311", Name = "Diversional Therapist")]
        DiversionalTherapist,

        /// <summary>
        /// EnrolledNurse
        /// </summary>
        [EnumMember]
        [Name(Code = "411411", Name = "Enrolled Nurse")]
        EnrolledNurse,

        /// <summary>
        /// MothercraftNurse
        /// </summary>
        [EnumMember]
        [Name(Code = "411412", Name = "Mothercraft Nurse")]
        MothercraftNurse,

        /// <summary>
        /// AboriginalAndTorresStraitIslanderHealthWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "411511", Name = "Aboriginal and Torres Strait Islander Health Worker")]
        AboriginalAndTorresStraitIslanderHealthWorker,

        /// <summary>
        /// MassageTherapist
        /// </summary>
        [EnumMember]
        [Name(Code = "411611", Name = "Massage Therapist")]
        MassageTherapist,

        /// <summary>
        /// CommunityWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "411711", Name = "Community Worker")]
        CommunityWorker,

        /// <summary>
        /// DisabilitiesServicesOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "411712", Name = "Disabilities Services Officer")]
        DisabilitiesServicesOfficer,

        /// <summary>
        /// FamilySupportWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "411713", Name = "Family Support Worker")]
        FamilySupportWorker,

        /// <summary>
        /// ParoleOrProbationOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "411714", Name = "Parole or Probation Officer")]
        ParoleOrProbationOfficer,

        /// <summary>
        /// ResidentialCareOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "411715", Name = "Residential Care Officer")]
        ResidentialCareOfficer,

        /// <summary>
        /// YouthWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "411716", Name = "Youth Worker")]
        YouthWorker,

        /// <summary>
        /// ChildCareWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "421111", Name = "Child Care Worker")]
        ChildCareWorker,

        /// <summary>
        /// FamilyDayCareWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "421112", Name = "Family Day Care Worker")]
        FamilyDayCareWorker,

        /// <summary>
        /// Nanny
        /// </summary>
        [EnumMember]
        [Name(Code = "421113", Name = "Nanny")]
        Nanny,

        /// <summary>
        /// OutOfSchoolHoursCareWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "421114", Name = "Out of School Hours Care Worker")]
        OutOfSchoolHoursCareWorker,

        /// <summary>
        /// AboriginalAndTorresStraitIslanderEducationWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "422111", Name = "Aboriginal and Torres Strait Islander Education Worker")]
        AboriginalAndTorresStraitIslanderEducationWorker,

        /// <summary>
        /// IntegrationAide
        /// </summary>
        [EnumMember]
        [Name(Code = "422112", Name = "Integration Aide")]
        IntegrationAide,

        /// <summary>
        /// PreschoolAide
        /// </summary>
        [EnumMember]
        [Name(Code = "422115", Name = "Preschool Aide")]
        PreschoolAide,

        /// <summary>
        /// TeachersAide
        /// </summary>
        [EnumMember]
        [Name(Code = "422116", Name = "Teachers' Aide")]
        TeachersAide,

        /// <summary>
        /// AgedOrDisabledCarer
        /// </summary>
        [EnumMember]
        [Name(Code = "423111", Name = "Aged or Disabled Carer")]
        AgedOrDisabledCarer,

        /// <summary>
        /// DentalAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "423211", Name = "Dental Assistant")]
        DentalAssistant,

        /// <summary>
        /// HospitalOrderly
        /// </summary>
        [EnumMember]
        [Name(Code = "423311", Name = "Hospital Orderly")]
        HospitalOrderly,

        /// <summary>
        /// NursingSupportWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "423312", Name = "Nursing Support Worker")]
        NursingSupportWorker,

        /// <summary>
        /// PersonalCareAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "423313", Name = "Personal Care Assistant")]
        PersonalCareAssistant,

        /// <summary>
        /// TherapyAide
        /// </summary>
        [EnumMember]
        [Name(Code = "423314", Name = "Therapy Aide")]
        TherapyAide,

        /// <summary>
        /// ChildOrYouthResidentialCareAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "423411", Name = "Child or Youth Residential Care Assistant")]
        ChildOrYouthResidentialCareAssistant,

        /// <summary>
        /// HostelParent
        /// </summary>
        [EnumMember]
        [Name(Code = "423412", Name = "Hostel Parent")]
        HostelParent,

        /// <summary>
        /// RefugeWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "423413", Name = "Refuge Worker")]
        RefugeWorker,

        /// <summary>
        /// BarAttendant
        /// </summary>
        [EnumMember]
        [Name(Code = "431111", Name = "Bar Attendant")]
        BarAttendant,

        /// <summary>
        /// Barista
        /// </summary>
        [EnumMember]
        [Name(Code = "431112", Name = "Barista")]
        Barista,

        /// <summary>
        /// CafeWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "431211", Name = "Cafe Worker")]
        CafeWorker,

        /// <summary>
        /// GamingWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "431311", Name = "Gaming Worker")]
        GamingWorker,

        /// <summary>
        /// HotelServiceManager
        /// </summary>
        [EnumMember]
        [Name(Code = "431411", Name = "Hotel Service Manager")]
        HotelServiceManager,

        /// <summary>
        /// Waiter
        /// </summary>
        [EnumMember]
        [Name(Code = "431511", Name = "Waiter")]
        Waiter,

        /// <summary>
        /// BarUsefulOrBusser
        /// </summary>
        [EnumMember]
        [Name(Code = "431911", Name = "Bar Useful or Busser")]
        BarUsefulOrBusser,

        /// <summary>
        /// DoorpersonOrLuggagePorter
        /// </summary>
        [EnumMember]
        [Name(Code = "431912", Name = "Doorperson or Luggage Porter")]
        DoorpersonOrLuggagePorter,

        /// <summary>
        /// HospitalityWorkersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "431999", Name = "Hospitality Workers nec")]
        HospitalityWorkersNec,

        /// <summary>
        /// DefenceForceMemberOtherRanks
        /// </summary>
        [EnumMember]
        [Name(Code = "441111", Name = "Defence Force Member - Other Ranks")]
        DefenceForceMemberOtherRanks,

        /// <summary>
        /// EmergencyServiceWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "441211", Name = "Emergency Service Worker")]
        EmergencyServiceWorker,

        /// <summary>
        /// FireFighter
        /// </summary>
        [EnumMember]
        [Name(Code = "441212", Name = "Fire Fighter")]
        FireFighter,

        /// <summary>
        /// Detective
        /// </summary>
        [EnumMember]
        [Name(Code = "441311", Name = "Detective")]
        Detective,

        /// <summary>
        /// PoliceOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "441312", Name = "Police Officer")]
        PoliceOfficer,

        /// <summary>
        /// PrisonOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "442111", Name = "Prison Officer")]
        PrisonOfficer,

        /// <summary>
        /// AlarmSecurityOrSurveillanceMonitor
        /// </summary>
        [EnumMember]
        [Name(Code = "442211", Name = "Alarm, Security or Surveillance Monitor")]
        AlarmSecurityOrSurveillanceMonitor,

        /// <summary>
        /// ArmouredCarEscort
        /// </summary>
        [EnumMember]
        [Name(Code = "442212", Name = "Armoured Car Escort")]
        ArmouredCarEscort,

        /// <summary>
        /// CrowdController
        /// </summary>
        [EnumMember]
        [Name(Code = "442213", Name = "Crowd Controller")]
        CrowdController,

        /// <summary>
        /// PrivateInvestigator
        /// </summary>
        [EnumMember]
        [Name(Code = "442214", Name = "Private Investigator")]
        PrivateInvestigator,

        /// <summary>
        /// RetailLossPreventionOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "442215", Name = "Retail Loss Prevention Officer")]
        RetailLossPreventionOfficer,

        /// <summary>
        /// SecurityConsultant
        /// </summary>
        [EnumMember]
        [Name(Code = "442216", Name = "Security Consultant")]
        SecurityConsultant,

        /// <summary>
        /// SecurityOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "442217", Name = "Security Officer")]
        SecurityOfficer,

        /// <summary>
        /// SecurityOfficersAndGuardsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "442299", Name = "Security Officers and Guards nec")]
        SecurityOfficersAndGuardsNec,

        /// <summary>
        /// BeautyTherapist
        /// </summary>
        [EnumMember]
        [Name(Code = "451111", Name = "Beauty Therapist")]
        BeautyTherapist,

        /// <summary>
        /// DrivingInstructor
        /// </summary>
        [EnumMember]
        [Name(Code = "451211", Name = "Driving Instructor")]
        DrivingInstructor,

        /// <summary>
        /// FuneralDirector
        /// </summary>
        [EnumMember]
        [Name(Code = "451311", Name = "Funeral Director")]
        FuneralDirector,

        /// <summary>
        /// FuneralWorkersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "451399", Name = "Funeral Workers nec")]
        FuneralWorkersNec,

        /// <summary>
        /// GalleryOrMuseumGuide
        /// </summary>
        [EnumMember]
        [Name(Code = "451411", Name = "Gallery or Museum Guide")]
        GalleryOrMuseumGuide,

        /// <summary>
        /// TourGuide
        /// </summary>
        [EnumMember]
        [Name(Code = "451412", Name = "Tour Guide")]
        TourGuide,

        /// <summary>
        /// NaturalRemedyConsultant
        /// </summary>
        [EnumMember]
        [Name(Code = "451511", Name = "Natural Remedy Consultant")]
        NaturalRemedyConsultant,

        /// <summary>
        /// WeightLossConsultant
        /// </summary>
        [EnumMember]
        [Name(Code = "451512", Name = "Weight Loss Consultant")]
        WeightLossConsultant,

        /// <summary>
        /// TouristInformationOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "451611", Name = "Tourist Information Officer")]
        TouristInformationOfficer,

        /// <summary>
        /// TravelConsultant
        /// </summary>
        [EnumMember]
        [Name(Code = "451612", Name = "Travel Consultant")]
        TravelConsultant,

        /// <summary>
        /// FlightAttendant
        /// </summary>
        [EnumMember]
        [Name(Code = "451711", Name = "Flight Attendant")]
        FlightAttendant,

        /// <summary>
        /// TravelAttendantsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "451799", Name = "Travel Attendants nec")]
        TravelAttendantsNec,

        /// <summary>
        /// CivilCelebrant
        /// </summary>
        [EnumMember]
        [Name(Code = "451811", Name = "Civil Celebrant")]
        CivilCelebrant,

        /// <summary>
        /// HairOrBeautySalonAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "451812", Name = "Hair or Beauty Salon Assistant")]
        HairOrBeautySalonAssistant,

        /// <summary>
        /// SexWorkerOrEscort
        /// </summary>
        [EnumMember]
        [Name(Code = "451813", Name = "Sex Worker or Escort")]
        SexWorkerOrEscort,

        /// <summary>
        /// BodyArtist
        /// </summary>
        [EnumMember]
        [Name(Code = "451814", Name = "Body Artist")]
        BodyArtist,

        /// <summary>
        /// FirstAidTrainer
        /// </summary>
        [EnumMember]
        [Name(Code = "451815", Name = "First Aid Trainer")]
        FirstAidTrainer,

        /// <summary>
        /// ReligiousAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "451816", Name = "Religious Assistant")]
        ReligiousAssistant,

        /// <summary>
        /// PersonalServiceWorkersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "451899", Name = "Personal Service Workers nec")]
        PersonalServiceWorkersNec,

        /// <summary>
        /// FitnessInstructor
        /// </summary>
        [EnumMember]
        [Name(Code = "452111", Name = "Fitness Instructor")]
        FitnessInstructor,

        /// <summary>
        /// BungyJumpMaster
        /// </summary>
        [EnumMember]
        [Name(Code = "452211", Name = "Bungy Jump Master")]
        BungyJumpMaster,

        /// <summary>
        /// FishingGuide
        /// </summary>
        [EnumMember]
        [Name(Code = "452212", Name = "Fishing Guide")]
        FishingGuide,

        /// <summary>
        /// HuntingGuide
        /// </summary>
        [EnumMember]
        [Name(Code = "452213", Name = "Hunting Guide")]
        HuntingGuide,

        /// <summary>
        /// MountainOrGlacierGuide
        /// </summary>
        [EnumMember]
        [Name(Code = "452214", Name = "Mountain or Glacier Guide")]
        MountainOrGlacierGuide,

        /// <summary>
        /// OutdoorAdventureInstructor
        /// </summary>
        [EnumMember]
        [Name(Code = "452215", Name = "Outdoor Adventure Instructor")]
        OutdoorAdventureInstructor,

        /// <summary>
        /// TrekkingGuide
        /// </summary>
        [EnumMember]
        [Name(Code = "452216", Name = "Trekking Guide")]
        TrekkingGuide,

        /// <summary>
        /// WhitewaterRaftingGuide
        /// </summary>
        [EnumMember]
        [Name(Code = "452217", Name = "Whitewater Rafting Guide")]
        WhitewaterRaftingGuide,

        /// <summary>
        /// OutdoorAdventureGuidesNec
        /// </summary>
        [EnumMember]
        [Name(Code = "452299", Name = "Outdoor Adventure Guides nec")]
        OutdoorAdventureGuidesNec,

        /// <summary>
        /// DivingInstructorOpenWater
        /// </summary>
        [EnumMember]
        [Name(Code = "452311", Name = "Diving Instructor (Open Water)")]
        DivingInstructorOpenWater,

        /// <summary>
        /// GymnasticsCoachOrInstructor
        /// </summary>
        [EnumMember]
        [Name(Code = "452312", Name = "Gymnastics Coach or Instructor")]
        GymnasticsCoachOrInstructor,

        /// <summary>
        /// HorseRidingCoachOrInstructor
        /// </summary>
        [EnumMember]
        [Name(Code = "452313", Name = "Horse Riding Coach or Instructor")]
        HorseRidingCoachOrInstructor,

        /// <summary>
        /// SnowsportInstructor
        /// </summary>
        [EnumMember]
        [Name(Code = "452314", Name = "Snowsport Instructor")]
        SnowsportInstructor,

        /// <summary>
        /// SwimmingCoachOrInstructor
        /// </summary>
        [EnumMember]
        [Name(Code = "452315", Name = "Swimming Coach or Instructor")]
        SwimmingCoachOrInstructor,

        /// <summary>
        /// TennisCoach
        /// </summary>
        [EnumMember]
        [Name(Code = "452316", Name = "Tennis Coach")]
        TennisCoach,

        /// <summary>
        /// OtherSportsCoachOrInstructor
        /// </summary>
        [EnumMember]
        [Name(Code = "452317", Name = "Other Sports Coach or Instructor")]
        OtherSportsCoachOrInstructor,

        /// <summary>
        /// DogOrHorseRacingOfficial
        /// </summary>
        [EnumMember]
        [Name(Code = "452318", Name = "Dog or Horse Racing Official")]
        DogOrHorseRacingOfficial,

        /// <summary>
        /// SportsDevelopmentOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "452321", Name = "Sports Development Officer")]
        SportsDevelopmentOfficer,

        /// <summary>
        /// SportsUmpire
        /// </summary>
        [EnumMember]
        [Name(Code = "452322", Name = "Sports Umpire")]
        SportsUmpire,

        /// <summary>
        /// OtherSportsOfficial
        /// </summary>
        [EnumMember]
        [Name(Code = "452323", Name = "Other Sports Official")]
        OtherSportsOfficial,

        /// <summary>
        /// Footballer
        /// </summary>
        [EnumMember]
        [Name(Code = "452411", Name = "Footballer")]
        Footballer,

        /// <summary>
        /// Golfer
        /// </summary>
        [EnumMember]
        [Name(Code = "452412", Name = "Golfer")]
        Golfer,

        /// <summary>
        /// Jockey
        /// </summary>
        [EnumMember]
        [Name(Code = "452413", Name = "Jockey")]
        Jockey,

        /// <summary>
        /// Lifeguard
        /// </summary>
        [EnumMember]
        [Name(Code = "452414", Name = "Lifeguard")]
        Lifeguard,

        /// <summary>
        /// SportspersonsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "452499", Name = "Sportspersons nec")]
        SportspersonsNec,

        /// <summary>
        /// ContractAdministrator
        /// </summary>
        [EnumMember]
        [Name(Code = "511111", Name = "Contract Administrator")]
        ContractAdministrator,

        /// <summary>
        /// ProgramOrProjectAdministrator
        /// </summary>
        [EnumMember]
        [Name(Code = "511112", Name = "Program or Project Administrator")]
        ProgramOrProjectAdministrator,

        /// <summary>
        /// OfficeManager
        /// </summary>
        [EnumMember]
        [Name(Code = "512111", Name = "Office Manager")]
        OfficeManager,

        /// <summary>
        /// HealthPracticeManager
        /// </summary>
        [EnumMember]
        [Name(Code = "512211", Name = "Health Practice Manager")]
        HealthPracticeManager,

        /// <summary>
        /// PracticeManagersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "512299", Name = "Practice Managers nec")]
        PracticeManagersNec,

        /// <summary>
        /// PersonalAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "521111", Name = "Personal Assistant")]
        PersonalAssistant,

        /// <summary>
        /// SecretaryGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "521211", Name = "Secretary (General)")]
        SecretaryGeneral,

        /// <summary>
        /// LegalSecretary
        /// </summary>
        [EnumMember]
        [Name(Code = "521212", Name = "Legal Secretary")]
        LegalSecretary,

        /// <summary>
        /// GeneralClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "531111", Name = "General Clerk")]
        GeneralClerk,

        /// <summary>
        /// DataEntryOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "532111", Name = "Data Entry Operator")]
        DataEntryOperator,

        /// <summary>
        /// MachineShorthandReporter
        /// </summary>
        [EnumMember]
        [Name(Code = "532112", Name = "Machine Shorthand Reporter")]
        MachineShorthandReporter,

        /// <summary>
        /// WordProcessingOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "532113", Name = "Word Processing Operator")]
        WordProcessingOperator,

        /// <summary>
        /// CallOrContactCentreTeamLeader
        /// </summary>
        [EnumMember]
        [Name(Code = "541111", Name = "Call or Contact Centre Team Leader")]
        CallOrContactCentreTeamLeader,

        /// <summary>
        /// CallOrContactCentreOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "541112", Name = "Call or Contact Centre Operator")]
        CallOrContactCentreOperator,

        /// <summary>
        /// InquiryClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "541211", Name = "Inquiry Clerk")]
        InquiryClerk,

        /// <summary>
        /// ReceptionistGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "542111", Name = "Receptionist (General)")]
        ReceptionistGeneral,

        /// <summary>
        /// AdmissionsClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "542112", Name = "Admissions Clerk")]
        AdmissionsClerk,

        /// <summary>
        /// HotelOrMotelReceptionist
        /// </summary>
        [EnumMember]
        [Name(Code = "542113", Name = "Hotel or Motel Receptionist")]
        HotelOrMotelReceptionist,

        /// <summary>
        /// MedicalReceptionist
        /// </summary>
        [EnumMember]
        [Name(Code = "542114", Name = "Medical Receptionist")]
        MedicalReceptionist,

        /// <summary>
        /// AccountsClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "551111", Name = "Accounts Clerk")]
        AccountsClerk,

        /// <summary>
        /// CostClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "551112", Name = "Cost Clerk")]
        CostClerk,

        /// <summary>
        /// Bookkeeper
        /// </summary>
        [EnumMember]
        [Name(Code = "551211", Name = "Bookkeeper")]
        Bookkeeper,

        /// <summary>
        /// PayrollClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "551311", Name = "Payroll Clerk")]
        PayrollClerk,

        /// <summary>
        /// BankWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "552111", Name = "Bank Worker")]
        BankWorker,

        /// <summary>
        /// CreditOrLoansOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "552211", Name = "Credit or Loans Officer")]
        CreditOrLoansOfficer,

        /// <summary>
        /// Bookmaker
        /// </summary>
        [EnumMember]
        [Name(Code = "552311", Name = "Bookmaker")]
        Bookmaker,

        /// <summary>
        /// InsuranceConsultant
        /// </summary>
        [EnumMember]
        [Name(Code = "552312", Name = "Insurance Consultant")]
        InsuranceConsultant,

        /// <summary>
        /// MoneyMarketClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "552313", Name = "Money Market Clerk")]
        MoneyMarketClerk,

        /// <summary>
        /// StatisticalClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "552314", Name = "Statistical Clerk")]
        StatisticalClerk,

        /// <summary>
        /// BettingAgencyCounterClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "561111", Name = "Betting Agency Counter Clerk")]
        BettingAgencyCounterClerk,

        /// <summary>
        /// BookmakerSClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "561112", Name = "Bookmaker's Clerk")]
        BookmakerSClerk,

        /// <summary>
        /// TelephoneBettingClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "561113", Name = "Telephone Betting Clerk")]
        TelephoneBettingClerk,

        /// <summary>
        /// BettingClerksNec
        /// </summary>
        [EnumMember]
        [Name(Code = "561199", Name = "Betting Clerks nec")]
        BettingClerksNec,

        /// <summary>
        /// Courier
        /// </summary>
        [EnumMember]
        [Name(Code = "561211", Name = "Courier")]
        Courier,

        /// <summary>
        /// PostalDeliveryOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "561212", Name = "Postal Delivery Officer")]
        PostalDeliveryOfficer,

        /// <summary>
        /// FilingOrRegistryClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "561311", Name = "Filing or Registry Clerk")]
        FilingOrRegistryClerk,

        /// <summary>
        /// MailClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "561411", Name = "Mail Clerk")]
        MailClerk,

        /// <summary>
        /// PostalSortingOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "561412", Name = "Postal Sorting Officer")]
        PostalSortingOfficer,

        /// <summary>
        /// SurveyInterviewer
        /// </summary>
        [EnumMember]
        [Name(Code = "561511", Name = "Survey Interviewer")]
        SurveyInterviewer,

        /// <summary>
        /// SwitchboardOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "561611", Name = "Switchboard Operator")]
        SwitchboardOperator,

        /// <summary>
        /// ClassifiedAdvertisingClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "561911", Name = "Classified Advertising Clerk")]
        ClassifiedAdvertisingClerk,

        /// <summary>
        /// MeterReader
        /// </summary>
        [EnumMember]
        [Name(Code = "561912", Name = "Meter Reader")]
        MeterReader,

        /// <summary>
        /// ParkingInspector
        /// </summary>
        [EnumMember]
        [Name(Code = "561913", Name = "Parking Inspector")]
        ParkingInspector,

        /// <summary>
        /// ClericalAndOfficeSupportWorkersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "561999", Name = "Clerical and Office Support Workers nec")]
        ClericalAndOfficeSupportWorkersNec,

        /// <summary>
        /// ProductionClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "591112", Name = "Production Clerk")]
        ProductionClerk,

        /// <summary>
        /// PurchasingOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "591113", Name = "Purchasing Officer")]
        PurchasingOfficer,

        /// <summary>
        /// StockClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "591115", Name = "Stock Clerk")]
        StockClerk,

        /// <summary>
        /// WarehouseAdministrator
        /// </summary>
        [EnumMember]
        [Name(Code = "591116", Name = "Warehouse Administrator")]
        WarehouseAdministrator,

        /// <summary>
        /// OrderClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "591117", Name = "Order Clerk")]
        OrderClerk,

        /// <summary>
        /// DespatchingAndReceivingClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "591211", Name = "Despatching and Receiving Clerk")]
        DespatchingAndReceivingClerk,

        /// <summary>
        /// ImportExportClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "591212", Name = "Import-Export Clerk")]
        ImportExportClerk,

        /// <summary>
        /// Conveyancer
        /// </summary>
        [EnumMember]
        [Name(Code = "599111", Name = "Conveyancer")]
        Conveyancer,

        /// <summary>
        /// LegalExecutive
        /// </summary>
        [EnumMember]
        [Name(Code = "599112", Name = "Legal Executive")]
        LegalExecutive,

        /// <summary>
        /// ClerkOfCourt
        /// </summary>
        [EnumMember]
        [Name(Code = "599211", Name = "Clerk of Court")]
        ClerkOfCourt,

        /// <summary>
        /// CourtBailiffOrSheriff
        /// </summary>
        [EnumMember]
        [Name(Code = "599212", Name = "Court Bailiff or Sheriff")]
        CourtBailiffOrSheriff,

        /// <summary>
        /// CourtOrderly
        /// </summary>
        [EnumMember]
        [Name(Code = "599213", Name = "Court Orderly")]
        CourtOrderly,

        /// <summary>
        /// LawClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "599214", Name = "Law Clerk")]
        LawClerk,

        /// <summary>
        /// TrustOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "599215", Name = "Trust Officer")]
        TrustOfficer,

        /// <summary>
        /// DebtCollector
        /// </summary>
        [EnumMember]
        [Name(Code = "599311", Name = "Debt Collector")]
        DebtCollector,

        /// <summary>
        /// HumanResourceClerk
        /// </summary>
        [EnumMember]
        [Name(Code = "599411", Name = "Human Resource Clerk")]
        HumanResourceClerk,

        /// <summary>
        /// CustomsOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "599511", Name = "Customs Officer")]
        CustomsOfficer,

        /// <summary>
        /// ImmigrationOfficer
        /// </summary>
        [EnumMember]
        [Name(Code = "599512", Name = "Immigration Officer")]
        ImmigrationOfficer,

        /// <summary>
        /// MotorVehicleLicenceExaminer
        /// </summary>
        [EnumMember]
        [Name(Code = "599513", Name = "Motor Vehicle Licence Examiner")]
        MotorVehicleLicenceExaminer,

        /// <summary>
        /// NoxiousWeedsAndPestInspector
        /// </summary>
        [EnumMember]
        [Name(Code = "599514", Name = "Noxious Weeds and Pest Inspector")]
        NoxiousWeedsAndPestInspector,

        /// <summary>
        /// SocialSecurityAssessor
        /// </summary>
        [EnumMember]
        [Name(Code = "599515", Name = "Social Security Assessor")]
        SocialSecurityAssessor,

        /// <summary>
        /// TaxationInspector
        /// </summary>
        [EnumMember]
        [Name(Code = "599516", Name = "Taxation Inspector")]
        TaxationInspector,

        /// <summary>
        /// TrainExaminer
        /// </summary>
        [EnumMember]
        [Name(Code = "599517", Name = "Train Examiner")]
        TrainExaminer,

        /// <summary>
        /// TransportOperationsInspector
        /// </summary>
        [EnumMember]
        [Name(Code = "599518", Name = "Transport Operations Inspector")]
        TransportOperationsInspector,

        /// <summary>
        /// WaterInspector
        /// </summary>
        [EnumMember]
        [Name(Code = "599521", Name = "Water Inspector")]
        WaterInspector,

        /// <summary>
        /// InspectorsAndRegulatoryOfficersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "599599", Name = "Inspectors and Regulatory Officers nec")]
        InspectorsAndRegulatoryOfficersNec,

        /// <summary>
        /// InsuranceInvestigator
        /// </summary>
        [EnumMember]
        [Name(Code = "599611", Name = "Insurance Investigator")]
        InsuranceInvestigator,

        /// <summary>
        /// InsuranceLossAdjuster
        /// </summary>
        [EnumMember]
        [Name(Code = "599612", Name = "Insurance Loss Adjuster")]
        InsuranceLossAdjuster,

        /// <summary>
        /// InsuranceRiskSurveyor
        /// </summary>
        [EnumMember]
        [Name(Code = "599613", Name = "Insurance Risk Surveyor")]
        InsuranceRiskSurveyor,

        /// <summary>
        /// LibraryAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "599711", Name = "Library Assistant")]
        LibraryAssistant,

        /// <summary>
        /// ProductionAssistantFilmTelevisionRadioOrStage
        /// </summary>
        [EnumMember]
        [Name(Code = "599912", Name = "Production Assistant (Film, Television, Radio or Stage)")]
        ProductionAssistantFilmTelevisionRadioOrStage,

        /// <summary>
        /// ProofReader
        /// </summary>
        [EnumMember]
        [Name(Code = "599913", Name = "Proof Reader")]
        ProofReader,

        /// <summary>
        /// RadioDespatcher
        /// </summary>
        [EnumMember]
        [Name(Code = "599914", Name = "Radio Despatcher")]
        RadioDespatcher,

        /// <summary>
        /// ClinicalCoder
        /// </summary>
        [EnumMember]
        [Name(Code = "599915", Name = "Clinical Coder")]
        ClinicalCoder,

        /// <summary>
        /// FacilitiesAdministrator
        /// </summary>
        [EnumMember]
        [Name(Code = "599916", Name = "Facilities Administrator")]
        FacilitiesAdministrator,

        /// <summary>
        /// ClericalAndAdministrativeWorkersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "599999", Name = "Clerical and Administrative Workers nec")]
        ClericalAndAdministrativeWorkersNec,

        /// <summary>
        /// Auctioneer
        /// </summary>
        [EnumMember]
        [Name(Code = "611111", Name = "Auctioneer")]
        Auctioneer,

        /// <summary>
        /// StockAndStationAgent
        /// </summary>
        [EnumMember]
        [Name(Code = "611112", Name = "Stock and Station Agent")]
        StockAndStationAgent,

        /// <summary>
        /// InsuranceAgent
        /// </summary>
        [EnumMember]
        [Name(Code = "611211", Name = "Insurance Agent")]
        InsuranceAgent,

        /// <summary>
        /// SalesRepresentativeBuildingAndPlumbingSupplies
        /// </summary>
        [EnumMember]
        [Name(Code = "611311", Name = "Sales Representative (Building and Plumbing Supplies)")]
        SalesRepresentativeBuildingAndPlumbingSupplies,

        /// <summary>
        /// SalesRepresentativeBusinessServices
        /// </summary>
        [EnumMember]
        [Name(Code = "611312", Name = "Sales Representative (Business Services)")]
        SalesRepresentativeBusinessServices,

        /// <summary>
        /// SalesRepresentativeMotorVehiclePartsAndAccessories
        /// </summary>
        [EnumMember]
        [Name(Code = "611313", Name = "Sales Representative (Motor Vehicle Parts and Accessories)")]
        SalesRepresentativeMotorVehiclePartsAndAccessories,

        /// <summary>
        /// SalesRepresentativePersonalAndHouseholdGoods
        /// </summary>
        [EnumMember]
        [Name(Code = "611314", Name = "Sales Representative (Personal and Household Goods)")]
        SalesRepresentativePersonalAndHouseholdGoods,

        /// <summary>
        /// SalesRepresentativesNec
        /// </summary>
        [EnumMember]
        [Name(Code = "611399", Name = "Sales Representatives nec")]
        SalesRepresentativesNec,

        /// <summary>
        /// BusinessBroker
        /// </summary>
        [EnumMember]
        [Name(Code = "612111", Name = "Business Broker")]
        BusinessBroker,

        /// <summary>
        /// PropertyManager
        /// </summary>
        [EnumMember]
        [Name(Code = "612112", Name = "Property Manager")]
        PropertyManager,

        /// <summary>
        /// RealEstateAgencyPrincipal
        /// </summary>
        [EnumMember]
        [Name(Code = "612113", Name = "Real Estate Agency Principal")]
        RealEstateAgencyPrincipal,

        /// <summary>
        /// RealEstateAgent
        /// </summary>
        [EnumMember]
        [Name(Code = "612114", Name = "Real Estate Agent")]
        RealEstateAgent,

        /// <summary>
        /// RealEstateRepresentative
        /// </summary>
        [EnumMember]
        [Name(Code = "612115", Name = "Real Estate Representative")]
        RealEstateRepresentative,

        /// <summary>
        /// SalesAssistantGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "621111", Name = "Sales Assistant (General)")]
        SalesAssistantGeneral,

        /// <summary>
        /// IctSalesAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "621211", Name = "ICT Sales Assistant")]
        IctSalesAssistant,

        /// <summary>
        /// MotorVehicleOrCaravanSalesperson
        /// </summary>
        [EnumMember]
        [Name(Code = "621311", Name = "Motor Vehicle or Caravan Salesperson")]
        MotorVehicleOrCaravanSalesperson,

        /// <summary>
        /// MotorVehiclePartsInterpreter
        /// </summary>
        [EnumMember]
        [Name(Code = "621312", Name = "Motor Vehicle Parts Interpreter")]
        MotorVehiclePartsInterpreter,

        /// <summary>
        /// PharmacySalesAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "621411", Name = "Pharmacy Sales Assistant")]
        PharmacySalesAssistant,

        /// <summary>
        /// RetailSupervisor
        /// </summary>
        [EnumMember]
        [Name(Code = "621511", Name = "Retail Supervisor")]
        RetailSupervisor,

        /// <summary>
        /// ServiceStationAttendant
        /// </summary>
        [EnumMember]
        [Name(Code = "621611", Name = "Service Station Attendant")]
        ServiceStationAttendant,

        /// <summary>
        /// CashVanSalesperson
        /// </summary>
        [EnumMember]
        [Name(Code = "621711", Name = "Cash Van Salesperson")]
        CashVanSalesperson,

        /// <summary>
        /// DoorToDoorSalesperson
        /// </summary>
        [EnumMember]
        [Name(Code = "621712", Name = "Door-to-door Salesperson")]
        DoorToDoorSalesperson,

        /// <summary>
        /// StreetVendor
        /// </summary>
        [EnumMember]
        [Name(Code = "621713", Name = "Street Vendor")]
        StreetVendor,

        /// <summary>
        /// MaterialsRecycler
        /// </summary>
        [EnumMember]
        [Name(Code = "621911", Name = "Materials Recycler")]
        MaterialsRecycler,

        /// <summary>
        /// RentalSalesperson
        /// </summary>
        [EnumMember]
        [Name(Code = "621912", Name = "Rental Salesperson")]
        RentalSalesperson,

        /// <summary>
        /// SalesAssistantsAndSalespersonsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "621999", Name = "Sales Assistants and Salespersons nec")]
        SalesAssistantsAndSalespersonsNec,

        /// <summary>
        /// CheckoutOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "631111", Name = "Checkout Operator")]
        CheckoutOperator,

        /// <summary>
        /// OfficeCashier
        /// </summary>
        [EnumMember]
        [Name(Code = "631112", Name = "Office Cashier")]
        OfficeCashier,

        /// <summary>
        /// Model
        /// </summary>
        [EnumMember]
        [Name(Code = "639111", Name = "Model")]
        Model,

        /// <summary>
        /// SalesDemonstrator
        /// </summary>
        [EnumMember]
        [Name(Code = "639112", Name = "Sales Demonstrator")]
        SalesDemonstrator,

        /// <summary>
        /// RetailBuyer
        /// </summary>
        [EnumMember]
        [Name(Code = "639211", Name = "Retail Buyer")]
        RetailBuyer,

        /// <summary>
        /// WoolBuyer
        /// </summary>
        [EnumMember]
        [Name(Code = "639212", Name = "Wool Buyer")]
        WoolBuyer,

        /// <summary>
        /// Telemarketer
        /// </summary>
        [EnumMember]
        [Name(Code = "639311", Name = "Telemarketer")]
        Telemarketer,

        /// <summary>
        /// TicketSeller
        /// </summary>
        [EnumMember]
        [Name(Code = "639411", Name = "Ticket Seller")]
        TicketSeller,

        /// <summary>
        /// TransportConductor
        /// </summary>
        [EnumMember]
        [Name(Code = "639412", Name = "Transport Conductor")]
        TransportConductor,

        /// <summary>
        /// VisualMerchandiser
        /// </summary>
        [EnumMember]
        [Name(Code = "639511", Name = "Visual Merchandiser")]
        VisualMerchandiser,

        /// <summary>
        /// OtherSalesSupportWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "639911", Name = "Other Sales Support Worker")]
        OtherSalesSupportWorker,

        /// <summary>
        /// ClayProductsMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711111", Name = "Clay Products Machine Operator")]
        ClayProductsMachineOperator,

        /// <summary>
        /// ConcreteProductsMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711112", Name = "Concrete Products Machine Operator")]
        ConcreteProductsMachineOperator,

        /// <summary>
        /// GlassProductionMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711113", Name = "Glass Production Machine Operator")]
        GlassProductionMachineOperator,

        /// <summary>
        /// StoneProcessingMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711114", Name = "Stone Processing Machine Operator")]
        StoneProcessingMachineOperator,

        /// <summary>
        /// ClayConcreteGlassAndStoneProcessingMachineOperatorsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "711199", Name = "Clay, Concrete, Glass and Stone Processing Machine Operators nec")]
        ClayConcreteGlassAndStoneProcessingMachineOperatorsNec,

        /// <summary>
        /// IndustrialSpraypainter
        /// </summary>
        [EnumMember]
        [Name(Code = "711211", Name = "Industrial Spraypainter")]
        IndustrialSpraypainter,

        /// <summary>
        /// PaperProductsMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711311", Name = "Paper Products Machine Operator")]
        PaperProductsMachineOperator,

        /// <summary>
        /// SawmillingOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711313", Name = "Sawmilling Operator")]
        SawmillingOperator,

        /// <summary>
        /// OtherWoodProcessingMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711314", Name = "Other Wood Processing Machine Operator")]
        OtherWoodProcessingMachineOperator,

        /// <summary>
        /// PhotographicDeveloperAndPrinter
        /// </summary>
        [EnumMember]
        [Name(Code = "711411", Name = "Photographic Developer and Printer")]
        PhotographicDeveloperAndPrinter,

        /// <summary>
        /// PlasticCablemakingMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711511", Name = "Plastic Cablemaking Machine Operator")]
        PlasticCablemakingMachineOperator,

        /// <summary>
        /// PlasticCompoundingAndReclamationMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711512", Name = "Plastic Compounding and Reclamation Machine Operator")]
        PlasticCompoundingAndReclamationMachineOperator,

        /// <summary>
        /// PlasticsFabricatorOrWelder
        /// </summary>
        [EnumMember]
        [Name(Code = "711513", Name = "Plastics Fabricator or Welder")]
        PlasticsFabricatorOrWelder,

        /// <summary>
        /// PlasticsProductionMachineOperatorGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "711514", Name = "Plastics Production Machine Operator (General)")]
        PlasticsProductionMachineOperatorGeneral,

        /// <summary>
        /// ReinforcedPlasticAndCompositeProductionWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "711515", Name = "Reinforced Plastic and Composite Production Worker")]
        ReinforcedPlasticAndCompositeProductionWorker,

        /// <summary>
        /// RubberProductionMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711516", Name = "Rubber Production Machine Operator")]
        RubberProductionMachineOperator,

        /// <summary>
        /// PlasticsAndRubberProductionMachineOperatorsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "711599", Name = "Plastics and Rubber Production Machine Operators nec")]
        PlasticsAndRubberProductionMachineOperatorsNec,

        /// <summary>
        /// SewingMachinist
        /// </summary>
        [EnumMember]
        [Name(Code = "711611", Name = "Sewing Machinist")]
        SewingMachinist,

        /// <summary>
        /// FootwearProductionMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711711", Name = "Footwear Production Machine Operator")]
        FootwearProductionMachineOperator,

        /// <summary>
        /// HideAndSkinProcessingMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711712", Name = "Hide and Skin Processing Machine Operator")]
        HideAndSkinProcessingMachineOperator,

        /// <summary>
        /// KnittingMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711713", Name = "Knitting Machine Operator")]
        KnittingMachineOperator,

        /// <summary>
        /// TextileDyeingAndFinishingMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711714", Name = "Textile Dyeing and Finishing Machine Operator")]
        TextileDyeingAndFinishingMachineOperator,

        /// <summary>
        /// WeavingMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711715", Name = "Weaving Machine Operator")]
        WeavingMachineOperator,

        /// <summary>
        /// YarnCardingAndSpinningMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711716", Name = "Yarn Carding and Spinning Machine Operator")]
        YarnCardingAndSpinningMachineOperator,

        /// <summary>
        /// TextileAndFootwearProductionMachineOperatorsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "711799", Name = "Textile and Footwear Production Machine Operators nec")]
        TextileAndFootwearProductionMachineOperatorsNec,

        /// <summary>
        /// ChemicalProductionMachineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "711911", Name = "Chemical Production Machine Operator")]
        ChemicalProductionMachineOperator,

        /// <summary>
        /// MotionPictureProjectionist
        /// </summary>
        [EnumMember]
        [Name(Code = "711912", Name = "Motion Picture Projectionist")]
        MotionPictureProjectionist,

        /// <summary>
        /// SandBlaster
        /// </summary>
        [EnumMember]
        [Name(Code = "711913", Name = "Sand Blaster")]
        SandBlaster,

        /// <summary>
        /// SterilisationTechnician
        /// </summary>
        [EnumMember]
        [Name(Code = "711914", Name = "Sterilisation Technician")]
        SterilisationTechnician,

        /// <summary>
        /// MachineOperatorsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "711999", Name = "Machine Operators nec")]
        MachineOperatorsNec,

        /// <summary>
        /// CraneHoistOrLiftOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "712111", Name = "Crane, Hoist or Lift Operator")]
        CraneHoistOrLiftOperator,

        /// <summary>
        /// Driller
        /// </summary>
        [EnumMember]
        [Name(Code = "712211", Name = "Driller")]
        Driller,

        /// <summary>
        /// Miner
        /// </summary>
        [EnumMember]
        [Name(Code = "712212", Name = "Miner")]
        Miner,

        /// <summary>
        /// ShotFirer
        /// </summary>
        [EnumMember]
        [Name(Code = "712213", Name = "Shot Firer")]
        ShotFirer,

        /// <summary>
        /// EngineeringProductionWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "712311", Name = "Engineering Production Worker")]
        EngineeringProductionWorker,

        /// <summary>
        /// BoilerOrEngineOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "712911", Name = "Boiler or Engine Operator")]
        BoilerOrEngineOperator,

        /// <summary>
        /// BulkMaterialsHandlingPlantOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "712912", Name = "Bulk Materials Handling Plant Operator")]
        BulkMaterialsHandlingPlantOperator,

        /// <summary>
        /// CementProductionPlantOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "712913", Name = "Cement Production Plant Operator")]
        CementProductionPlantOperator,

        /// <summary>
        /// ConcreteBatchingPlantOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "712914", Name = "Concrete Batching Plant Operator")]
        ConcreteBatchingPlantOperator,

        /// <summary>
        /// ConcretePumpOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "712915", Name = "Concrete Pump Operator")]
        ConcretePumpOperator,

        /// <summary>
        /// PaperAndPulpMillOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "712916", Name = "Paper and Pulp Mill Operator")]
        PaperAndPulpMillOperator,

        /// <summary>
        /// RailwaySignalOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "712917", Name = "Railway Signal Operator")]
        RailwaySignalOperator,

        /// <summary>
        /// TrainController
        /// </summary>
        [EnumMember]
        [Name(Code = "712918", Name = "Train Controller")]
        TrainController,

        /// <summary>
        /// WasteWaterOrWaterPlantOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "712921", Name = "Waste Water or Water Plant Operator")]
        WasteWaterOrWaterPlantOperator,

        /// <summary>
        /// WeighbridgeOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "712922", Name = "Weighbridge Operator")]
        WeighbridgeOperator,

        /// <summary>
        /// StationaryPlantOperatorsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "712999", Name = "Stationary Plant Operators nec")]
        StationaryPlantOperatorsNec,

        /// <summary>
        /// AgriculturalAndHorticulturalMobilePlantOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "721111", Name = "Agricultural and Horticultural Mobile Plant Operator")]
        AgriculturalAndHorticulturalMobilePlantOperator,

        /// <summary>
        /// LoggingPlantOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "721112", Name = "Logging Plant Operator")]
        LoggingPlantOperator,

        /// <summary>
        /// EarthmovingPlantOperatorGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "721211", Name = "Earthmoving Plant Operator (General)")]
        EarthmovingPlantOperatorGeneral,

        /// <summary>
        /// BackhoeOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "721212", Name = "Backhoe Operator")]
        BackhoeOperator,

        /// <summary>
        /// BulldozerOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "721213", Name = "Bulldozer Operator")]
        BulldozerOperator,

        /// <summary>
        /// ExcavatorOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "721214", Name = "Excavator Operator")]
        ExcavatorOperator,

        /// <summary>
        /// GraderOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "721215", Name = "Grader Operator")]
        GraderOperator,

        /// <summary>
        /// LoaderOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "721216", Name = "Loader Operator")]
        LoaderOperator,

        /// <summary>
        /// ForkliftDriver
        /// </summary>
        [EnumMember]
        [Name(Code = "721311", Name = "Forklift Driver")]
        ForkliftDriver,

        /// <summary>
        /// AircraftBaggageHandlerAndAirlineGroundCrew
        /// </summary>
        [EnumMember]
        [Name(Code = "721911", Name = "Aircraft Baggage Handler and Airline Ground Crew")]
        AircraftBaggageHandlerAndAirlineGroundCrew,

        /// <summary>
        /// Linemarker
        /// </summary>
        [EnumMember]
        [Name(Code = "721912", Name = "Linemarker")]
        Linemarker,

        /// <summary>
        /// PavingPlantOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "721913", Name = "Paving Plant Operator")]
        PavingPlantOperator,

        /// <summary>
        /// RailwayTrackPlantOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "721914", Name = "Railway Track Plant Operator")]
        RailwayTrackPlantOperator,

        /// <summary>
        /// RoadRollerOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "721915", Name = "Road Roller Operator")]
        RoadRollerOperator,

        /// <summary>
        /// StreetsweeperOperator
        /// </summary>
        [EnumMember]
        [Name(Code = "721916", Name = "Streetsweeper Operator")]
        StreetsweeperOperator,

        /// <summary>
        /// MobilePlantOperatorsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "721999", Name = "Mobile Plant Operators nec")]
        MobilePlantOperatorsNec,

        /// <summary>
        /// Chauffeur
        /// </summary>
        [EnumMember]
        [Name(Code = "731111", Name = "Chauffeur")]
        Chauffeur,

        /// <summary>
        /// TaxiDriver
        /// </summary>
        [EnumMember]
        [Name(Code = "731112", Name = "Taxi Driver")]
        TaxiDriver,

        /// <summary>
        /// AutomobileDriversNec
        /// </summary>
        [EnumMember]
        [Name(Code = "731199", Name = "Automobile Drivers nec")]
        AutomobileDriversNec,

        /// <summary>
        /// BusDriver
        /// </summary>
        [EnumMember]
        [Name(Code = "731211", Name = "Bus Driver")]
        BusDriver,

        /// <summary>
        /// CharterAndTourBusDriver
        /// </summary>
        [EnumMember]
        [Name(Code = "731212", Name = "Charter and Tour Bus Driver")]
        CharterAndTourBusDriver,

        /// <summary>
        /// PassengerCoachDriver
        /// </summary>
        [EnumMember]
        [Name(Code = "731213", Name = "Passenger Coach Driver")]
        PassengerCoachDriver,

        /// <summary>
        /// TrainDriver
        /// </summary>
        [EnumMember]
        [Name(Code = "731311", Name = "Train Driver")]
        TrainDriver,

        /// <summary>
        /// TramDriver
        /// </summary>
        [EnumMember]
        [Name(Code = "731312", Name = "Tram Driver")]
        TramDriver,

        /// <summary>
        /// DeliveryDriver
        /// </summary>
        [EnumMember]
        [Name(Code = "732111", Name = "Delivery Driver")]
        DeliveryDriver,

        /// <summary>
        /// TruckDriverGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "733111", Name = "Truck Driver (General)")]
        TruckDriverGeneral,

        /// <summary>
        /// AircraftRefueller
        /// </summary>
        [EnumMember]
        [Name(Code = "733112", Name = "Aircraft Refueller")]
        AircraftRefueller,

        /// <summary>
        /// FurnitureRemovalist
        /// </summary>
        [EnumMember]
        [Name(Code = "733113", Name = "Furniture Removalist")]
        FurnitureRemovalist,

        /// <summary>
        /// TankerDriver
        /// </summary>
        [EnumMember]
        [Name(Code = "733114", Name = "Tanker Driver")]
        TankerDriver,

        /// <summary>
        /// TowTruckDriver
        /// </summary>
        [EnumMember]
        [Name(Code = "733115", Name = "Tow Truck Driver")]
        TowTruckDriver,

        /// <summary>
        /// Storeperson
        /// </summary>
        [EnumMember]
        [Name(Code = "741111", Name = "Storeperson")]
        Storeperson,

        /// <summary>
        /// CarDetailer
        /// </summary>
        [EnumMember]
        [Name(Code = "811111", Name = "Car Detailer")]
        CarDetailer,

        /// <summary>
        /// CommercialCleaner
        /// </summary>
        [EnumMember]
        [Name(Code = "811211", Name = "Commercial Cleaner")]
        CommercialCleaner,

        /// <summary>
        /// DomesticCleaner
        /// </summary>
        [EnumMember]
        [Name(Code = "811311", Name = "Domestic Cleaner")]
        DomesticCleaner,

        /// <summary>
        /// CommercialHousekeeper
        /// </summary>
        [EnumMember]
        [Name(Code = "811411", Name = "Commercial Housekeeper")]
        CommercialHousekeeper,

        /// <summary>
        /// DomesticHousekeeper
        /// </summary>
        [EnumMember]
        [Name(Code = "811412", Name = "Domestic Housekeeper")]
        DomesticHousekeeper,

        /// <summary>
        /// LaundryWorkerGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "811511", Name = "Laundry Worker (General)")]
        LaundryWorkerGeneral,

        /// <summary>
        /// Drycleaner
        /// </summary>
        [EnumMember]
        [Name(Code = "811512", Name = "Drycleaner")]
        Drycleaner,

        /// <summary>
        /// IronerOrPresser
        /// </summary>
        [EnumMember]
        [Name(Code = "811513", Name = "Ironer or Presser")]
        IronerOrPresser,

        /// <summary>
        /// CarpetCleaner
        /// </summary>
        [EnumMember]
        [Name(Code = "811611", Name = "Carpet Cleaner")]
        CarpetCleaner,

        /// <summary>
        /// WindowCleaner
        /// </summary>
        [EnumMember]
        [Name(Code = "811612", Name = "Window Cleaner")]
        WindowCleaner,

        /// <summary>
        /// CleanersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "811699", Name = "Cleaners nec")]
        CleanersNec,

        /// <summary>
        /// BuilderSLabourer
        /// </summary>
        [EnumMember]
        [Name(Code = "821111", Name = "Builder's Labourer")]
        BuilderSLabourer,

        /// <summary>
        /// DrainageSewerageAndStormwaterLabourer
        /// </summary>
        [EnumMember]
        [Name(Code = "821112", Name = "Drainage, Sewerage and Stormwater Labourer")]
        DrainageSewerageAndStormwaterLabourer,

        /// <summary>
        /// EarthmovingLabourer
        /// </summary>
        [EnumMember]
        [Name(Code = "821113", Name = "Earthmoving Labourer")]
        EarthmovingLabourer,

        /// <summary>
        /// PlumberSAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "821114", Name = "Plumber's Assistant")]
        PlumberSAssistant,

        /// <summary>
        /// Concreter
        /// </summary>
        [EnumMember]
        [Name(Code = "821211", Name = "Concreter")]
        Concreter,

        /// <summary>
        /// Fencer
        /// </summary>
        [EnumMember]
        [Name(Code = "821311", Name = "Fencer")]
        Fencer,

        /// <summary>
        /// BuildingInsulationInstaller
        /// </summary>
        [EnumMember]
        [Name(Code = "821411", Name = "Building Insulation Installer")]
        BuildingInsulationInstaller,

        /// <summary>
        /// HomeImprovementInstaller
        /// </summary>
        [EnumMember]
        [Name(Code = "821412", Name = "Home Improvement Installer")]
        HomeImprovementInstaller,

        /// <summary>
        /// PavingAndSurfacingLabourer
        /// </summary>
        [EnumMember]
        [Name(Code = "821511", Name = "Paving and Surfacing Labourer")]
        PavingAndSurfacingLabourer,

        /// <summary>
        /// RailwayTrackWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "821611", Name = "Railway Track Worker")]
        RailwayTrackWorker,

        /// <summary>
        /// ConstructionRigger
        /// </summary>
        [EnumMember]
        [Name(Code = "821711", Name = "Construction Rigger")]
        ConstructionRigger,

        /// <summary>
        /// Scaffolder
        /// </summary>
        [EnumMember]
        [Name(Code = "821712", Name = "Scaffolder")]
        Scaffolder,

        /// <summary>
        /// SteelFixer
        /// </summary>
        [EnumMember]
        [Name(Code = "821713", Name = "Steel Fixer")]
        SteelFixer,

        /// <summary>
        /// StructuralSteelErector
        /// </summary>
        [EnumMember]
        [Name(Code = "821714", Name = "Structural Steel Erector")]
        StructuralSteelErector,

        /// <summary>
        /// CraneChaser
        /// </summary>
        [EnumMember]
        [Name(Code = "821911", Name = "Crane Chaser")]
        CraneChaser,

        /// <summary>
        /// DrillerSAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "821912", Name = "Driller's Assistant")]
        DrillerSAssistant,

        /// <summary>
        /// Lagger
        /// </summary>
        [EnumMember]
        [Name(Code = "821913", Name = "Lagger")]
        Lagger,

        /// <summary>
        /// MiningSupportWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "821914", Name = "Mining Support Worker")]
        MiningSupportWorker,

        /// <summary>
        /// SurveyorSAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "821915", Name = "Surveyor's Assistant")]
        SurveyorSAssistant,

        /// <summary>
        /// BakingFactoryWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "831111", Name = "Baking Factory Worker")]
        BakingFactoryWorker,

        /// <summary>
        /// BreweryWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "831112", Name = "Brewery Worker")]
        BreweryWorker,

        /// <summary>
        /// ConfectioneryMaker
        /// </summary>
        [EnumMember]
        [Name(Code = "831113", Name = "Confectionery Maker")]
        ConfectioneryMaker,

        /// <summary>
        /// DairyProductsMaker
        /// </summary>
        [EnumMember]
        [Name(Code = "831114", Name = "Dairy Products Maker")]
        DairyProductsMaker,

        /// <summary>
        /// FruitAndVegetableFactoryWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "831115", Name = "Fruit and Vegetable Factory Worker")]
        FruitAndVegetableFactoryWorker,

        /// <summary>
        /// GrainMillWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "831116", Name = "Grain Mill Worker")]
        GrainMillWorker,

        /// <summary>
        /// SugarMillWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "831117", Name = "Sugar Mill Worker")]
        SugarMillWorker,

        /// <summary>
        /// WineryCellarHand
        /// </summary>
        [EnumMember]
        [Name(Code = "831118", Name = "Winery Cellar Hand")]
        WineryCellarHand,

        /// <summary>
        /// FoodAndDrinkFactoryWorkersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "831199", Name = "Food and Drink Factory Workers nec")]
        FoodAndDrinkFactoryWorkersNec,

        /// <summary>
        /// Slaughterer
        /// </summary>
        [EnumMember]
        [Name(Code = "831211", Name = "Meat Boner and Slicer")]
        Slaughterer,

        /// <summary>
        /// MeatBonerAndSlicer
        /// </summary>
        [EnumMember]
        [Name(Code = "831212", Name = "Slaughterer")]
        MeatBonerAndSlicer,

        /// <summary>
        /// MeatProcessWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "831311", Name = "Meat Process Worker")]
        MeatProcessWorker,

        /// <summary>
        /// PoultryProcessWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "831312", Name = "Poultry Process Worker")]
        PoultryProcessWorker,

        /// <summary>
        /// SeafoodProcessWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "831313", Name = "Seafood Process Worker")]
        SeafoodProcessWorker,

        /// <summary>
        /// ChocolatePacker
        /// </summary>
        [EnumMember]
        [Name(Code = "832111", Name = "Chocolate Packer")]
        ChocolatePacker,

        /// <summary>
        /// ContainerFiller
        /// </summary>
        [EnumMember]
        [Name(Code = "832112", Name = "Container Filler")]
        ContainerFiller,

        /// <summary>
        /// FruitAndVegetablePacker
        /// </summary>
        [EnumMember]
        [Name(Code = "832113", Name = "Fruit and Vegetable Packer")]
        FruitAndVegetablePacker,

        /// <summary>
        /// MeatPacker
        /// </summary>
        [EnumMember]
        [Name(Code = "832114", Name = "Meat Packer")]
        MeatPacker,

        /// <summary>
        /// SeafoodPacker
        /// </summary>
        [EnumMember]
        [Name(Code = "832115", Name = "Seafood Packer")]
        SeafoodPacker,

        /// <summary>
        /// PackersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "832199", Name = "Packers nec")]
        PackersNec,

        /// <summary>
        /// ProductAssembler
        /// </summary>
        [EnumMember]
        [Name(Code = "832211", Name = "Product Assembler")]
        ProductAssembler,

        /// <summary>
        /// MetalEngineeringProcessWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "839111", Name = "Metal Engineering Process Worker")]
        MetalEngineeringProcessWorker,

        /// <summary>
        /// PlasticsFactoryWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "839211", Name = "Plastics Factory Worker")]
        PlasticsFactoryWorker,

        /// <summary>
        /// RubberFactoryWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "839212", Name = "Rubber Factory Worker")]
        RubberFactoryWorker,

        /// <summary>
        /// ProductExaminer
        /// </summary>
        [EnumMember]
        [Name(Code = "839311", Name = "Product Examiner")]
        ProductExaminer,

        /// <summary>
        /// ProductGrader
        /// </summary>
        [EnumMember]
        [Name(Code = "839312", Name = "Product Grader")]
        ProductGrader,

        /// <summary>
        /// ProductTester
        /// </summary>
        [EnumMember]
        [Name(Code = "839313", Name = "Product Tester")]
        ProductTester,

        /// <summary>
        /// PaperAndPulpMillWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "839411", Name = "Paper and Pulp Mill Worker")]
        PaperAndPulpMillWorker,

        /// <summary>
        /// SawmillOrTimberYardWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "839412", Name = "Sawmill or Timber Yard Worker")]
        SawmillOrTimberYardWorker,

        /// <summary>
        /// WoodAndWoodProductsFactoryWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "839413", Name = "Wood and Wood Products Factory Worker")]
        WoodAndWoodProductsFactoryWorker,

        /// <summary>
        /// CementAndConcretePlantWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "839911", Name = "Cement and Concrete Plant Worker")]
        CementAndConcretePlantWorker,

        /// <summary>
        /// ChemicalPlantWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "839912", Name = "Chemical Plant Worker")]
        ChemicalPlantWorker,

        /// <summary>
        /// ClayProcessingFactoryWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "839913", Name = "Clay Processing Factory Worker")]
        ClayProcessingFactoryWorker,

        /// <summary>
        /// FabricAndTextileFactoryWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "839914", Name = "Fabric and Textile Factory Worker")]
        FabricAndTextileFactoryWorker,

        /// <summary>
        /// FootwearFactoryWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "839915", Name = "Footwear Factory Worker")]
        FootwearFactoryWorker,

        /// <summary>
        /// GlassProcessingWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "839916", Name = "Glass Processing Worker")]
        GlassProcessingWorker,

        /// <summary>
        /// HideAndSkinProcessingWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "839917", Name = "Hide and Skin Processing Worker")]
        HideAndSkinProcessingWorker,

        /// <summary>
        /// RecyclingWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "839918", Name = "Recycling Worker")]
        RecyclingWorker,

        /// <summary>
        /// FactoryProcessWorkersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "839999", Name = "Factory Process Workers nec")]
        FactoryProcessWorkersNec,

        /// <summary>
        /// AquacultureWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "841111", Name = "Aquaculture Worker")]
        AquacultureWorker,

        /// <summary>
        /// FruitOrNutFarmWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "841211", Name = "Fruit or Nut Farm Worker")]
        FruitOrNutFarmWorker,

        /// <summary>
        /// FruitOrNutPicker
        /// </summary>
        [EnumMember]
        [Name(Code = "841212", Name = "Fruit or Nut Picker")]
        FruitOrNutPicker,

        /// <summary>
        /// GrainOilseedOrPastureFarmWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "841213", Name = "Grain, Oilseed or Pasture Farm Worker")]
        GrainOilseedOrPastureFarmWorker,

        /// <summary>
        /// VegetableFarmWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "841214", Name = "Vegetable Farm Worker")]
        VegetableFarmWorker,

        /// <summary>
        /// VegetablePicker
        /// </summary>
        [EnumMember]
        [Name(Code = "841215", Name = "Vegetable Picker")]
        VegetablePicker,

        /// <summary>
        /// VineyardWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "841216", Name = "Vineyard Worker")]
        VineyardWorker,

        /// <summary>
        /// MushroomPicker
        /// </summary>
        [EnumMember]
        [Name(Code = "841217", Name = "Mushroom Picker")]
        MushroomPicker,

        /// <summary>
        /// CropFarmWorkersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "841299", Name = "Crop Farm Workers nec")]
        CropFarmWorkersNec,

        /// <summary>
        /// ForestryWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "841311", Name = "Forestry Worker")]
        ForestryWorker,

        /// <summary>
        /// LoggingAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "841312", Name = "Logging Assistant")]
        LoggingAssistant,

        /// <summary>
        /// TreeFaller
        /// </summary>
        [EnumMember]
        [Name(Code = "841313", Name = "Tree Faller")]
        TreeFaller,

        /// <summary>
        /// GardenLabourer
        /// </summary>
        [EnumMember]
        [Name(Code = "841411", Name = "Garden Labourer")]
        GardenLabourer,

        /// <summary>
        /// HorticulturalNurseryAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "841412", Name = "Horticultural Nursery Assistant")]
        HorticulturalNurseryAssistant,

        /// <summary>
        /// BeefCattleFarmWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "841511", Name = "Beef Cattle Farm Worker")]
        BeefCattleFarmWorker,

        /// <summary>
        /// DairyCattleFarmWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "841512", Name = "Dairy Cattle Farm Worker")]
        DairyCattleFarmWorker,

        /// <summary>
        /// MixedLivestockFarmWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "841513", Name = "Mixed Livestock Farm Worker")]
        MixedLivestockFarmWorker,

        /// <summary>
        /// PoultryFarmWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "841514", Name = "Poultry Farm Worker")]
        PoultryFarmWorker,

        /// <summary>
        /// SheepFarmWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "841515", Name = "Sheep Farm Worker")]
        SheepFarmWorker,

        /// <summary>
        /// Stablehand
        /// </summary>
        [EnumMember]
        [Name(Code = "841516", Name = "Stablehand")]
        Stablehand,

        /// <summary>
        /// WoolHandler
        /// </summary>
        [EnumMember]
        [Name(Code = "841517", Name = "Wool Handler")]
        WoolHandler,

        /// <summary>
        /// LivestockFarmWorkersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "841599", Name = "Livestock Farm Workers nec")]
        LivestockFarmWorkersNec,

        /// <summary>
        /// MixedCropAndLivestockFarmWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "841611", Name = "Mixed Crop and Livestock Farm Worker")]
        MixedCropAndLivestockFarmWorker,

        /// <summary>
        /// HunterTrapper
        /// </summary>
        [EnumMember]
        [Name(Code = "841911", Name = "Hunter-Trapper")]
        HunterTrapper,

        /// <summary>
        /// PestController
        /// </summary>
        [EnumMember]
        [Name(Code = "841913", Name = "Pest Controller")]
        PestController,

        /// <summary>
        /// FarmForestryAndGardenWorkersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "841999", Name = "Farm, Forestry and Garden Workers nec")]
        FarmForestryAndGardenWorkersNec,

        /// <summary>
        /// FastFoodCook
        /// </summary>
        [EnumMember]
        [Name(Code = "851111", Name = "Fast Food Cook")]
        FastFoodCook,

        /// <summary>
        /// PastrycookSAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "851211", Name = "Pastrycook's Assistant")]
        PastrycookSAssistant,

        /// <summary>
        /// FoodTradesAssistantsNec
        /// </summary>
        [EnumMember]
        [Name(Code = "851299", Name = "Food Trades Assistants nec")]
        FoodTradesAssistantsNec,

        /// <summary>
        /// Kitchenhand
        /// </summary>
        [EnumMember]
        [Name(Code = "851311", Name = "Kitchenhand")]
        Kitchenhand,

        /// <summary>
        /// FreightHandlerRailOrRoad
        /// </summary>
        [EnumMember]
        [Name(Code = "891111", Name = "Freight Handler (Rail or Road)")]
        FreightHandlerRailOrRoad,

        /// <summary>
        /// TruckDriverSOffsider
        /// </summary>
        [EnumMember]
        [Name(Code = "891112", Name = "Truck Driver's Offsider")]
        TruckDriverSOffsider,

        /// <summary>
        /// WatersideWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "891113", Name = "Waterside Worker")]
        WatersideWorker,

        /// <summary>
        /// ShelfFiller
        /// </summary>
        [EnumMember]
        [Name(Code = "891211", Name = "Shelf Filler")]
        ShelfFiller,

        /// <summary>
        /// Caretaker
        /// </summary>
        [EnumMember]
        [Name(Code = "899111", Name = "Caretaker")]
        Caretaker,

        /// <summary>
        /// DeckHand
        /// </summary>
        [EnumMember]
        [Name(Code = "899211", Name = "Deck Hand")]
        DeckHand,

        /// <summary>
        /// FishingHand
        /// </summary>
        [EnumMember]
        [Name(Code = "899212", Name = "Fishing Hand")]
        FishingHand,

        /// <summary>
        /// Handyperson
        /// </summary>
        [EnumMember]
        [Name(Code = "899311", Name = "Handyperson")]
        Handyperson,

        /// <summary>
        /// MotorVehiclePartsAndAccessoriesFitterGeneral
        /// </summary>
        [EnumMember]
        [Name(Code = "899411", Name = "Motor Vehicle Parts and Accessories Fitter (General)")]
        MotorVehiclePartsAndAccessoriesFitterGeneral,

        /// <summary>
        /// Autoglazier
        /// </summary>
        [EnumMember]
        [Name(Code = "899412", Name = "Autoglazier")]
        Autoglazier,

        /// <summary>
        /// ExhaustAndMufflerRepairer
        /// </summary>
        [EnumMember]
        [Name(Code = "899413", Name = "Exhaust and Muffler Repairer")]
        ExhaustAndMufflerRepairer,

        /// <summary>
        /// RadiatorRepairer
        /// </summary>
        [EnumMember]
        [Name(Code = "899414", Name = "Radiator Repairer")]
        RadiatorRepairer,

        /// <summary>
        /// TyreFitter
        /// </summary>
        [EnumMember]
        [Name(Code = "899415", Name = "Tyre Fitter")]
        TyreFitter,

        /// <summary>
        /// PrinterSAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "899511", Name = "Printer's Assistant")]
        PrinterSAssistant,

        /// <summary>
        /// PrintingTableWorker
        /// </summary>
        [EnumMember]
        [Name(Code = "899512", Name = "Printing Table Worker")]
        PrintingTableWorker,

        /// <summary>
        /// RecyclingOrRubbishCollector
        /// </summary>
        [EnumMember]
        [Name(Code = "899611", Name = "Recycling or Rubbish Collector")]
        RecyclingOrRubbishCollector,

        /// <summary>
        /// VendingMachineAttendant
        /// </summary>
        [EnumMember]
        [Name(Code = "899711", Name = "Vending Machine Attendant")]
        VendingMachineAttendant,

        /// <summary>
        /// BicycleMechanic
        /// </summary>
        [EnumMember]
        [Name(Code = "899911", Name = "Bicycle Mechanic")]
        BicycleMechanic,

        /// <summary>
        /// CarParkAttendant
        /// </summary>
        [EnumMember]
        [Name(Code = "899912", Name = "Car Park Attendant")]
        CarParkAttendant,

        /// <summary>
        /// CrossingSupervisor
        /// </summary>
        [EnumMember]
        [Name(Code = "899913", Name = "Crossing Supervisor")]
        CrossingSupervisor,

        /// <summary>
        /// ElectricalOrTelecommunicationsTradesAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "899914", Name = "Electrical or Telecommunications Trades Assistant")]
        ElectricalOrTelecommunicationsTradesAssistant,

        /// <summary>
        /// LeafletOrNewspaperDeliverer
        /// </summary>
        [EnumMember]
        [Name(Code = "899915", Name = "Leaflet or Newspaper Deliverer")]
        LeafletOrNewspaperDeliverer,

        /// <summary>
        /// MechanicSAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "899916", Name = "Mechanic's Assistant")]
        MechanicSAssistant,

        /// <summary>
        /// RailwaysAssistant
        /// </summary>
        [EnumMember]
        [Name(Code = "899917", Name = "Railways Assistant")]
        RailwaysAssistant,

        /// <summary>
        /// SignErector
        /// </summary>
        [EnumMember]
        [Name(Code = "899918", Name = "Sign Erector")]
        SignErector,

        /// <summary>
        /// TicketCollectorOrUsher
        /// </summary>
        [EnumMember]
        [Name(Code = "899921", Name = "Ticket Collector or Usher")]
        TicketCollectorOrUsher,

        /// <summary>
        /// TrolleyCollector
        /// </summary>
        [EnumMember]
        [Name(Code = "899922", Name = "Trolley Collector")]
        TrolleyCollector,

        /// <summary>
        /// RoadTrafficController
        /// </summary>
        [EnumMember]
        [Name(Code = "899923", Name = "Road Traffic Controller")]
        RoadTrafficController,

        /// <summary>
        ///        LabourersNec
        /// </summary>
        [EnumMember]
        [Name(Code = "899999", Name = "Labourers nec")]
        LabourersNec
    }
}
