﻿/*
 * Copyright 2011 NEHTA
 *
 * Licensed under the NEHTA Open Source (Apache) License; you may not use this
 * file except in compliance with the License. A copy of the License is in the
 * 'license.txt' file, which should be provided with this work.
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using JetBrains.Annotations;
using Nehta.VendorLibrary.CDA.Generator.Enums;
using Nehta.VendorLibrary.CDA.SCSModel.Common.Entities;
using Nehta.VendorLibrary.Common;

namespace Nehta.VendorLibrary.CDA.SCSModel.Common
{
    /// <summary>
    /// This class is designed to encapsulate the properties within a CDA document that make up 
    /// an anatomical site
    /// </summary>
    [Serializable]
    [DataContract]
    public class AnatomicalSite
    {
        #region Properties
        /// <summary>
        /// The name of the location
        /// </summary>
        [CanBeNull]
        [DataMember]
        public AnatomicalLocation AnatomicalLocation { get; set; }

        /// <summary>
        /// The description
        /// </summary>
        [CanBeNull]
        [DataMember]
        public String Description { get; set; }

        /// <summary>
        /// The Image
        /// </summary>
        [CanBeNull]
        [DataMember]
        public List<ExternalData> Images { get; set; }
        #endregion

        #region Constructors
        internal AnatomicalSite()
        {
        }
        #endregion

        #region Validation
        /// <summary>
        /// Validates this anatomical site
        /// </summary>
        /// <param name="path">The path to this object as a string</param>
        /// <param name="messages">the validation messages to date, these may be added to within this method</param>
        public void Validate(string path, List<ValidationMessage> messages)
        {
            var vb = new ValidationBuilder(path, messages);

            if(AnatomicalLocation != null)
            {
                AnatomicalLocation.Validate(vb.Path + "AnatomicalLocation", messages);
            }

            if(Images != null && Images.Any())
            {
                foreach (var image in Images)
                {
                    if (image != null)
                    {
                        if (
                            image.ExternalDataMediaType == MediaType.GIF ||
                            image.ExternalDataMediaType == MediaType.JPEG ||
                            image.ExternalDataMediaType == MediaType.PNG
                            )
                        {
                             image.Validate(vb.Path + "Images", messages);
                        } else
                        {
                            vb.AddValidationMessage(vb.PathName, null, "The image must be of a type GIF, JPEG or a PNG");
                        }
                    }
                }
            }
        }

        #endregion
    }
}