/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.common.utils;

import au.gov.nehta.common.utils.ArgumentUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class DomUtils {
    private static DocumentBuilderFactory DOCBUILDER_FACTORY;

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (DOCBUILDER_FACTORY == null) {
            DOCBUILDER_FACTORY = DocumentBuilderFactory.newInstance();
            DOCBUILDER_FACTORY.setNamespaceAware(true);
        }
        return DOCBUILDER_FACTORY.newDocumentBuilder();
    }

    public static Document newDocument() throws ParserConfigurationException {
        return DomUtils.getDocumentBuilder().newDocument();
    }

    public static Document newDocument(Node rootNode) throws ParserConfigurationException {
        ArgumentUtils.checkNotNull(rootNode, "rootNode");
        Document doc = DomUtils.newDocument();
        Node nodeCopy = doc.importNode(rootNode, true);
        doc.appendChild(nodeCopy);
        return doc;
    }

    public static Document parse(File file) throws ParserConfigurationException, IOException, SAXException {
        ArgumentUtils.checkNotNull(file, "file");
        return DomUtils.getDocumentBuilder().parse(file);
    }

    public static Document parse(Reader reader) throws ParserConfigurationException, IOException, SAXException {
        ArgumentUtils.checkNotNull(reader, "reader");
        return DomUtils.getDocumentBuilder().parse(new InputSource(reader));
    }

    public static Document parse(Reader reader, ErrorHandler errorHandler) throws ParserConfigurationException, SAXException, IOException {
        ArgumentUtils.checkNotNull(reader, "reader");
        DocumentBuilder parser = DomUtils.getDocumentBuilder();
        if (errorHandler != null) {
            parser.setErrorHandler(errorHandler);
        }
        return parser.parse(new InputSource(reader));
    }

    public static String serialiseToString(Element xmlElem) throws TransformerException, IOException {
        ArgumentUtils.checkNotNull(xmlElem, "xmlElem");
        StringWriter writer = new StringWriter();
        DomUtils.serialiseNode(xmlElem, writer);
        return writer.toString();
    }

    public static String serialiseToString(Document xmlDoc) throws TransformerException, IOException {
        ArgumentUtils.checkNotNull(xmlDoc, "xmlDoc");
        StringWriter writer = new StringWriter();
        DomUtils.serialiseNode(xmlDoc, writer);
        return writer.toString();
    }

    public static void serialise(Document xmlDoc, File file) throws TransformerException, IOException {
        ArgumentUtils.checkNotNull(xmlDoc, "xmlDoc");
        ArgumentUtils.checkNotNull(file, "file");
        DomUtils.serialiseNode(xmlDoc, new FileWriter(file));
    }

    public static void serialise(Document xmlDoc, Writer writer) throws TransformerException, IOException {
        ArgumentUtils.checkNotNull(xmlDoc, "xmlDoc");
        ArgumentUtils.checkNotNull(writer, "writer");
        DomUtils.serialiseNode(xmlDoc, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void serialiseNode(Node xmlNode, Writer writer) throws TransformerException, IOException {
        assert (xmlNode != null);
        assert (writer != null);
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        try {
            DOMSource source = new DOMSource(xmlNode);
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    public static Element getFirstChildElement(Node node) {
        ArgumentUtils.checkNotNull(node, "node");
        NodeList childNodes = node.getChildNodes();
        if (childNodes.getLength() > 0) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node currentNode = childNodes.item(i);
                if (!(currentNode instanceof Element)) continue;
                return (Element)currentNode;
            }
        }
        return null;
    }

    public static List<Element> getChildElements(Node node) {
        ArrayList<Element> childElems = new ArrayList<Element>();
        NodeList childNodes = node.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            childElems.add((Element)childNode);
        }
        return childElems;
    }

    public static Element getChildElement(Element element, String namespace, String tagName) {
        ArgumentUtils.checkNotNull(element, "element");
        ArgumentUtils.checkNotNullNorBlank(namespace, "namespace");
        ArgumentUtils.checkNotNullNorBlank(tagName, "tagName");
        List<Element> childElems = DomUtils.getChildElements(element, namespace, tagName);
        if (childElems.size() == 0) {
            throw new IllegalArgumentException("No '{" + namespace + "}" + tagName + "' element found.");
        }
        if (childElems.size() > 1) {
            throw new IllegalArgumentException("More than one '{" + namespace + "}" + tagName + "' elements found.");
        }
        return childElems.get(0);
    }

    public static List<Element> getChildElements(Element element, String namespace, String tagName) {
        ArgumentUtils.checkNotNull(element, "element");
        ArgumentUtils.checkNotNullNorBlank(namespace, "namespace");
        ArgumentUtils.checkNotNullNorBlank(tagName, "tagName");
        ArrayList<Element> childElems = new ArrayList<Element>();
        NodeList childNodes = element.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (!(childNode instanceof Element)) continue;
            Element childElem = (Element)childNode;
            String currNamespace = childElem.getNamespaceURI();
            String currLocalName = childElem.getLocalName();
            if (!namespace.equals(currNamespace) || !tagName.equals(currLocalName)) continue;
            childElems.add(childElem);
        }
        return childElems;
    }

    public static void addAttribute(Element elem, String attrName, String attrValue) {
        ArgumentUtils.checkNotNull(elem, "elem");
        ArgumentUtils.checkNotNullNorBlank(attrName, "attrName");
        ArgumentUtils.checkNotNullNorBlank(attrValue, "attrValue");
        Document ownerDoc = elem.getOwnerDocument();
        Attr attr = ownerDoc.createAttributeNS(null, attrName);
        attr.setValue(attrValue);
        elem.setAttributeNodeNS(attr);
    }

    public static boolean isDocumentEmpty(Document xmlDoc) {
        ArgumentUtils.checkNotNull(xmlDoc, "xmlDoc");
        return xmlDoc.getDocumentElement() == null;
    }

    public static void checkNotNullOrEmpty(Document xmlDoc, String name) {
        if (xmlDoc == null || DomUtils.isDocumentEmpty(xmlDoc)) {
            throw new IllegalArgumentException("'" + name + "' cannot be null or empty");
        }
    }

    public static boolean checkElement(Element elem, String name, String namespace) {
        ArgumentUtils.checkNotNull(elem, "elem");
        ArgumentUtils.checkNotNullNorBlank(name, "name");
        ArgumentUtils.checkNotNullNorBlank(namespace, "namespace");
        return elem.getLocalName().equals(name) && elem.getNamespaceURI().equals(namespace);
    }

    private DomUtils() {
    }
}

