/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.ws;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public final class TimeUtility {
    public static final String DATE_FORMAT_NOW = "yyyyMMdd HH:mm:ss";
    public static final String DATE_FORMAT_NOW_REGX = "^([0-9]{4})([0-1][0-9])([0-3][0-9])\\s([0-1][0-9]|[2][0-3]):([0-5][0-9]):([0-5][0-9])$";
    public static final String DATE_FORMAT = "yyyyMMdd";
    public static final String DATE_FORMAT_REGX = "^(19|20)\\d\\d(0[1-9]|1[012])(0[1-9]|[12][0-9]|3[01])$";
    public static final String COMPACT_DATE_TIME_FORMAT = "yyyyMMddHHmmss";
    public static final int DATE_TIME_LENGTH = "yyyyMMddHHmmss".length();
    private static final Logger LOGGER = Logger.getLogger(TimeUtility.class.getName());

    private TimeUtility() {
    }

    public static XMLGregorianCalendar getXMLGregorianDateTime(String date) {
        try {
            if (date.matches(DATE_FORMAT_NOW_REGX)) {
                XMLGregorianCalendar cal = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
                SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT_NOW);
                String pattern = format.toPattern();
                Date simpleDate = format.parse(date);
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(simpleDate);
                int year = calendar.get(1);
                int month = calendar.get(2);
                int day = calendar.get(5);
                int hour = calendar.get(11);
                int min = calendar.get(12);
                int second = calendar.get(13);
                cal.setDay(day);
                cal.setYear(year);
                cal.setMonth(month);
                cal.setHour(hour);
                cal.setMinute(min);
                cal.setSecond(second);
                return cal;
            }
        }
        catch (DatatypeConfigurationException ex) {
            throw new IllegalArgumentException("Incorrect date format" + date + ". Must be set in " + DATE_FORMAT + " format", ex);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Incorrect date format" + date + ". Must be set in " + DATE_FORMAT + " format", ex);
        }
        throw new IllegalArgumentException("Incorrect date format" + date + ". Must be set in " + DATE_FORMAT + " format");
    }

    public static XMLGregorianCalendar getXMLGregorianDate(String date) {
        try {
            XMLGregorianCalendar cal = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            if (date.matches(DATE_FORMAT_REGX)) {
                SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
                Calendar calendar = Calendar.getInstance();
                Date simpleDate = format.parse(date);
                calendar.setTime(simpleDate);
                int year = calendar.get(1);
                int month = calendar.get(2);
                int day = calendar.get(5);
                cal.setDay(day);
                cal.setYear(year);
                cal.setMonth(month + 1);
                cal.setTimezone(Integer.MIN_VALUE);
                return cal;
            }
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException("Incorrect date format" + date + ". Must be set in " + DATE_FORMAT + " format", ex);
        }
        catch (DatatypeConfigurationException ex) {
            throw new IllegalArgumentException("Incorrect date format" + date + ". Must be set in " + DATE_FORMAT + " format", ex);
        }
        throw new IllegalArgumentException("Incorrect date format " + date + ". Must be set in " + DATE_FORMAT + " format");
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    public static Date nowDate() {
        Calendar cal = Calendar.getInstance();
        return cal.getTime();
    }

    public static String getDateAsYYYYMMDD(Date date) {
        String dateTime = null;
        if (date != null) {
            SimpleDateFormat dateformatYYYYMMDD = new SimpleDateFormat(DATE_FORMAT);
            dateTime = new String(dateformatYYYYMMDD.format(date));
        }
        return dateTime;
    }

    public static XMLGregorianCalendar nowXMLGregorianCalendar() {
        try {
            XMLGregorianCalendar cal = DatatypeFactory.newInstance().newXMLGregorianCalendar(new GregorianCalendar());
            return cal;
        }
        catch (DatatypeConfigurationException ex) {
            LOGGER.log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

