/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.type;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum DocumentStatus {
    SUBMITTED("urn:oasis:names:tc:ebxml-regrep:StatusType:Submitted"),
    APPROVED("urn:oasis:names:tc:ebxml-regrep:StatusType:Approved"),
    DELETED("urn:orcl.reg:names:StatusType:Deleted"),
    DEPRECATED("urn:oasis:names:tc:ebxml-regrep:StatusType:Deprecated");

    private static final Map<String, DocumentStatus> CODE_MAP;
    private final String code;

    private DocumentStatus(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    public static DocumentStatus fromCode(String code) {
        if (!CODE_MAP.containsKey(code)) {
            throw new IllegalArgumentException("'" + code + "' is not a valid DocumentStatus code.");
        }
        return CODE_MAP.get(code);
    }

    static {
        CODE_MAP = new HashMap<String, DocumentStatus>();
        for (DocumentStatus s : EnumSet.allOf(DocumentStatus.class)) {
            CODE_MAP.put(s.getCode(), s);
        }
    }
}

