/*
 * Decompiled with CFR 0.152.
 */
package au.gov.nehta.vendorlibrary.pcehr.clients.common.util;

import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CX;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.CodedValue;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentMetadata;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.DocumentTypeCodes;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.HD;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.XCN;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.type.XON;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.DateUtils;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.OIDUtil;
import au.gov.nehta.vendorlibrary.pcehr.clients.common.util.XPathUtils;
import au.net.electronichealth.ns.pcehr.xsd.common.commoncoreelements._1.PCEHRHeader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public final class MetadataUtils {
    private static final String DEFAULT_LANGUAGE_CODE = "en-AU";
    private static final int YMD_DATE_FORMAT = 8;
    private static final int YMDHM_DATE_FORMAT = 12;
    private static final int YMDHMS_DATE_FORMAT = 14;
    private static final int TIMEZONE_FORMAT = 5;
    private static final int YMDHM_WITH_TIMEZONE_FORMAT = 17;
    private static final int YMDHMS_WITH_TIMEZONE_FORMAT = 19;

    private MetadataUtils() {
    }

    public static byte[] calculateSha1Hash(byte[] value) {
        try {
            MessageDigest md = MessageDigest.getInstance("sha1");
            return md.digest(value);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unexpected digest method encountered.", e);
        }
    }

    public static DocumentMetadata toDocumentMetadata(PCEHRHeader commonHeader, byte[] cdaDocument) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(new ByteArrayInputStream(cdaDocument));
        return MetadataUtils.toDocumentMetadata(commonHeader, doc);
    }

    public static DocumentMetadata toDocumentMetadata(PCEHRHeader commonHeader, Document rootDocument) throws XPathExpressionException {
        DocumentMetadata documentMetadata = new DocumentMetadata();
        String docId = XPathUtils.evaluateXPath("/ClinicalDocument/id/@root", rootDocument);
        UUID docUuid = null;
        try {
            docUuid = UUID.fromString(docId);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (docUuid != null) {
            documentMetadata.setUniqueId(OIDUtil.convertUUIDToOIDIntegerPair(docId));
        } else {
            documentMetadata.setUniqueId(docId);
        }
        documentMetadata.setCreationTime(DateUtils.toUtcDate(XPathUtils.evaluateXPath("/ClinicalDocument/effectiveTime/@value", rootDocument)));
        String languageCode = XPathUtils.evaluateXPath("/ClinicalDocument/languageCode/@code", rootDocument);
        if (languageCode == null || languageCode.length() == 0) {
            languageCode = DEFAULT_LANGUAGE_CODE;
        }
        documentMetadata.setLanguageCode(languageCode);
        documentMetadata.setPatientId(MetadataUtils.getPatientId(rootDocument));
        documentMetadata.setSourcePatientId(MetadataUtils.getPatientId(rootDocument));
        MetadataUtils.setStartTime(rootDocument, documentMetadata);
        MetadataUtils.setStopTime(rootDocument, documentMetadata);
        String orgId = XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/asEmployment/employerOrganization/asOrganizationPartOf/wholeOrganization/asEntityIdentifier[@classCode='IDENT']/id[@assigningAuthorityName='HPI-O']/@root", rootDocument);
        String orgName = XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/asEmployment/employerOrganization/asOrganizationPartOf/wholeOrganization/name", rootDocument);
        if (MetadataUtils.isEmpty(orgId)) {
            orgId = XPathUtils.evaluateXPath("/ClinicalDocument/custodian/assignedCustodian/representedCustodianOrganization/asEntityIdentifier[@classCode='IDENT']/id[@assigningAuthorityName='HPI-O']/@root", rootDocument);
            orgName = XPathUtils.evaluateXPath("/ClinicalDocument/custodian/assignedCustodian/representedCustodianOrganization/name", rootDocument);
            if (MetadataUtils.isEmpty(orgId)) {
                orgId = XPathUtils.evaluateXPath("/ClinicalDocument/componentOf/encompassingEncounter/location/healthCareFacility/serviceProviderOrganization/asOrganizationPartOf/wholeOrganization/asEntityIdentifier[@classCode='IDENT']/id[@assigningAuthorityName='HPI-O']/@root", rootDocument);
                orgName = XPathUtils.evaluateXPath("/ClinicalDocument/componentOf/encompassingEncounter/location/healthCareFacility/serviceProviderOrganization/asOrganizationPartOf/wholeOrganization/name", rootDocument);
            }
        }
        XON.Builder xonBuilder = new XON.Builder();
        xonBuilder.organisationName(orgName);
        xonBuilder.organisationIdentifier(orgId);
        documentMetadata.setAuthorInstitution(xonBuilder.build());
        documentMetadata.setAuthorSpecialty(XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/code/@displayName", rootDocument));
        XCN.Builder xcnBuilder = new XCN.Builder();
        xcnBuilder.familyName(XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/name/family", rootDocument));
        xcnBuilder.givenName(XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/name/given[1]", rootDocument));
        xcnBuilder.prefix(XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/name/prefix", rootDocument));
        String hpii = XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/asEntityIdentifier[@classCode='IDENT']/id[@assigningAuthorityName='HPI-I']/@root", rootDocument);
        HD.Builder hdBuilder = new HD.Builder();
        if (MetadataUtils.isNotEmpty(hpii)) {
            hdBuilder.identifier(hpii).identifierType("ISO");
        } else {
            String pai_d = XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/asEntityIdentifier[@classCode='IDENT']/id[@assigningAuthorityName='PAI-D']/@root", rootDocument);
            if (MetadataUtils.isNotEmpty(pai_d)) {
                hdBuilder.identifier(pai_d).identifierType("ISO");
            } else {
                String root = XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/asEntityIdentifier[@classCode='IDENT']/id/@root", rootDocument);
                String ext = XPathUtils.evaluateXPath("/ClinicalDocument/author/assignedAuthor/assignedPerson/asEntityIdentifier[@classCode='IDENT']/id/@extension", rootDocument);
                hdBuilder.namespace(root + "^").identifier(ext).identifierType("ISO");
            }
        }
        xcnBuilder.assigningAuthority(hdBuilder.build());
        documentMetadata.setAuthorPerson(xcnBuilder.build());
        DocumentTypeCodes type = MetadataUtils.getDocumentTypeCode(rootDocument);
        documentMetadata.setDocumentClass(MetadataUtils.getDocumentClass(type));
        documentMetadata.setDocumentType(MetadataUtils.getDocumentType(type));
        return documentMetadata;
    }

    private static void setStopTime(Document rootDocument, DocumentMetadata documentMetadata) throws XPathExpressionException {
        boolean prescriptionCode = Boolean.parseBoolean(XPathUtils.evaluateXPath("/ClinicalDocument/code/@code='100.16764'", rootDocument));
        boolean dispenseCode = Boolean.parseBoolean(XPathUtils.evaluateXPath("/ClinicalDocument/code/@code='100.16765'", rootDocument));
        if (prescriptionCode) {
            String prescriptionTime = XPathUtils.evaluateXPath("/ClinicalDocument/author/time/@value", rootDocument);
            if (MetadataUtils.isNotEmpty(prescriptionTime)) {
                documentMetadata.setServiceStopTime(DateUtils.toUtcDate(prescriptionTime));
            } else {
                MetadataUtils.addGenricStopTime(documentMetadata, rootDocument);
            }
        } else if (dispenseCode) {
            String disepnseTime = XPathUtils.evaluateXPath("/ClinicalDocument/component/structuredBody/component/section[code/@code='102.16210' and code/@codeSystem='1.2.36.1.2001.1001.101']/entry/substanceAdministration/entryRelationship/supply/effectiveTime/@value", rootDocument);
            if (MetadataUtils.isNotEmpty(disepnseTime)) {
                documentMetadata.setServiceStopTime(DateUtils.toUtcDate(disepnseTime));
            } else {
                MetadataUtils.addGenricStopTime(documentMetadata, rootDocument);
            }
        } else {
            MetadataUtils.addGenricStopTime(documentMetadata, rootDocument);
        }
    }

    private static void addGenricStopTime(DocumentMetadata documentMetadata, Document rootDocument) throws XPathExpressionException {
        String cdaStopTime = XPathUtils.evaluateXPath("/ClinicalDocument/componentOf/encompassingEncounter/effectiveTime/high/@value", rootDocument);
        String cdaFixedTime = XPathUtils.evaluateXPath("/ClinicalDocument/componentOf/encompassingEncounter/effectiveTime/@value", rootDocument);
        if (MetadataUtils.isNotEmpty(cdaStopTime)) {
            documentMetadata.setServiceStopTime(DateUtils.toUtcDate(cdaStopTime));
        } else if (MetadataUtils.isNotEmpty(cdaFixedTime)) {
            documentMetadata.setServiceStopTime(DateUtils.toUtcDate(cdaFixedTime));
        } else {
            documentMetadata.setServiceStopTime(documentMetadata.getCreationTime());
        }
    }

    private static void setStartTime(Document rootDocument, DocumentMetadata documentMetadata) throws XPathExpressionException {
        boolean prescriptionCode = Boolean.parseBoolean(XPathUtils.evaluateXPath("/ClinicalDocument/code/@code='100.16764'", rootDocument));
        boolean dispenseCode = Boolean.parseBoolean(XPathUtils.evaluateXPath("/ClinicalDocument/code/@code='100.16765'", rootDocument));
        if (prescriptionCode) {
            String prescriptionTime = XPathUtils.evaluateXPath("/ClinicalDocument/author/time/@value", rootDocument);
            if (MetadataUtils.isNotEmpty(prescriptionTime)) {
                documentMetadata.setServiceStartTime(DateUtils.toUtcDate(prescriptionTime));
            } else {
                MetadataUtils.addGenericStartTime(rootDocument, documentMetadata);
            }
        } else if (dispenseCode) {
            String disepnseTime = XPathUtils.evaluateXPath("/ClinicalDocument/component/structuredBody/component/section[code/@code='102.16210' and code/@codeSystem='1.2.36.1.2001.1001.101']/entry/substanceAdministration/entryRelationship/supply/effectiveTime/@value", rootDocument);
            if (MetadataUtils.isNotEmpty(disepnseTime)) {
                documentMetadata.setServiceStartTime(DateUtils.toUtcDate(disepnseTime));
            } else {
                MetadataUtils.addGenericStartTime(rootDocument, documentMetadata);
            }
        } else {
            MetadataUtils.addGenericStartTime(rootDocument, documentMetadata);
        }
    }

    private static void addGenericStartTime(Document rootDocument, DocumentMetadata documentMetadata) throws XPathExpressionException {
        String cdaStartTime = XPathUtils.evaluateXPath("/ClinicalDocument/componentOf/encompassingEncounter/effectiveTime/low/@value", rootDocument);
        String cdaFixedTime = XPathUtils.evaluateXPath("/ClinicalDocument/componentOf/encompassingEncounter/effectiveTime/@value", rootDocument);
        if (MetadataUtils.isNotEmpty(cdaStartTime)) {
            documentMetadata.setServiceStartTime(DateUtils.toUtcDate(cdaStartTime));
        } else if (MetadataUtils.isNotEmpty(cdaFixedTime)) {
            documentMetadata.setServiceStartTime(DateUtils.toUtcDate(cdaFixedTime));
        } else {
            documentMetadata.setServiceStartTime(documentMetadata.getCreationTime());
        }
    }

    private static CX getPatientId(Document rootDocument) throws XPathExpressionException {
        CX.Builder builder = new CX.Builder();
        String cdaId = XPathUtils.evaluateXPath("/ClinicalDocument/recordTarget/patientRole/patient/asEntityIdentifier/id[@assigningAuthorityName='IHI']/@root", rootDocument);
        String[] components = StringUtils.split((String)cdaId, (String)".");
        builder.identifier(components[components.length - 1]);
        builder.assigningAuthority(new HD.Builder().identifier(StringUtils.substringBeforeLast((String)cdaId, (String)".")).identifierType("ISO").build());
        return builder.build();
    }

    private static CodedValue getDocumentClass(DocumentTypeCodes docType) {
        CodedValue codingSystem = docType.getCodingSystem();
        return new CodedValue(codingSystem.getCodeSystem(), codingSystem.getValue(), codingSystem.getDisplayName());
    }

    private static CodedValue getDocumentType(DocumentTypeCodes docType) {
        CodedValue codingSystem = docType.getCodingSystem();
        return new CodedValue(codingSystem.getCodeSystem(), codingSystem.getValue(), docType.getTypeCodeDisplayName());
    }

    private static DocumentTypeCodes getDocumentTypeCode(Document rootDocument) throws XPathExpressionException {
        String extractedCode = XPathUtils.evaluateXPath("/ClinicalDocument/code/@code", rootDocument);
        return DocumentTypeCodes.findByConceptCode(extractedCode);
    }

    public static Date parseDate(String str) {
        String formatStr = str.length() == 8 ? "yyyyMMdd" : (str.length() == 12 ? "yyyyMMddHHmm" : (str.length() == 14 ? "yyyyMMddHHmmss" : (str.length() == 17 ? "yyyyMMddHHmmz" : (str.length() == 19 ? "yyyyMMddHHmmssz" : ""))));
        SimpleDateFormat df = new SimpleDateFormat(formatStr);
        try {
            Date tmp = df.parse(str);
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(tmp);
            return df.parse(str);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Value [" + str + "] did not contain a valid date/time.", e);
        }
    }

    private static boolean isEmpty(String string) {
        return string == null || "".equals(string);
    }

    private static boolean isNotEmpty(String string) {
        return string != null && !string.isEmpty();
    }
}

