/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.config.management.jmx;

import com.sun.istack.logging.Logger;
import com.sun.xml.ws.api.config.management.EndpointCreationAttributes;
import com.sun.xml.ws.api.config.management.jmx.JmxConstants;
import com.sun.xml.ws.config.management.ManagementMessages;
import com.sun.xml.ws.config.management.jmx.MBeanAttribute;
import com.sun.xml.ws.metro.api.config.management.Configurator;
import com.sun.xml.ws.metro.api.config.management.ManagedEndpoint;
import com.sun.xml.ws.metro.api.config.management.NamedParameters;
import javax.management.InvalidAttributeValueException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReconfigAttribute<T>
implements MBeanAttribute {
    private static final Logger LOGGER = Logger.getLogger(ReconfigAttribute.class);
    private final ManagedEndpoint<T> managedEndpoint;
    private final Configurator<T> configurator;
    private final EndpointCreationAttributes endpointCreationAttributes;
    private final ClassLoader classLoader;

    public ReconfigAttribute(ManagedEndpoint<T> endpoint, Configurator<T> configurator, EndpointCreationAttributes creationAttributes, ClassLoader classLoader) {
        this.managedEndpoint = endpoint;
        this.configurator = configurator;
        this.endpointCreationAttributes = creationAttributes;
        this.classLoader = classLoader;
    }

    @Override
    public boolean isReadable() {
        return false;
    }

    @Override
    public boolean isWritable() {
        return true;
    }

    @Override
    public String getDescription() {
        return ManagementMessages.RECONFIG_ATTRIBUTE_DESCRIPTION();
    }

    @Override
    public OpenType getType() {
        return SimpleType.STRING;
    }

    @Override
    public Object getValue() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(ManagementMessages.WSM_5085_ATTRIBUTE_UNREADABLE(ManagementMessages.RECONFIG_ATTRIBUTE_NAME()));
    }

    @Override
    public void setValue(Object value) throws InvalidAttributeValueException {
        if (!String.class.isAssignableFrom(value.getClass())) {
            throw LOGGER.logSevereException(new InvalidAttributeValueException(ManagementMessages.WSM_5010_EXPECTED_STRING(JmxConstants.SERVICE_POLICIES_ATTRIBUTE_NAME, value.getClass().getName())));
        }
        this.update((String)value);
    }

    private void update(String value) throws InvalidAttributeValueException {
        try {
            NamedParameters parameters = new NamedParameters().put("ENDPOINT_INSTANCE", this.managedEndpoint).put("CREATION_ATTRIBUTES", this.endpointCreationAttributes).put("CLASS_LOADER", this.classLoader).put("CONFIGURATION_DATA", value);
            this.configurator.recreate(parameters);
        }
        catch (WebServiceException cause) {
            InvalidAttributeValueException exception = new InvalidAttributeValueException(ManagementMessages.WSM_5009_RECONFIGURATION_FAILED());
            LOGGER.logSevereException(cause);
            throw LOGGER.logSevereException(exception);
        }
    }
}

