﻿using System;
using System.ServiceModel.Activation;

namespace HIPS.AppServer.HIPSServiceHost.BackgroundThread
{
    /// <summary>
    /// Extends ServiceHostFactory to allow IhiCleanupServiceHost to be used.
    /// </summary>
    public class IhiCleanupServiceHostFactory : ServiceHostFactory
    {
        /// <summary>
        /// Creates a new IhiCleanupServiceHost using the specified service and base addresses.
        /// </summary>
        /// <param name="serviceType"></param>
        /// <param name="baseAddresses"></param>
        /// <returns></returns>
        protected override System.ServiceModel.ServiceHost CreateServiceHost(Type serviceType, Uri[] baseAddresses)
        {
            System.ServiceModel.ServiceHost host;
            switch (serviceType.Name)
            {
                case "IhiCleanUpService":
                    host = new IhiCleanUpServiceHost(serviceType, baseAddresses);
                    break;

                default:

                    //host = new System.ServiceModel.ServiceHost(serviceType, baseAddresses);
                    host = new IhiCleanUpServiceHost(serviceType, baseAddresses);
                    break;
            }

            return host;
        }
    }
}