﻿using System.ServiceModel;

using HIPS.ServiceContracts.AckQueue;
using HIPS.ServiceContracts.AckQueue.Message;

namespace HIPS.Client.Proxy
{
    public class AckQueueProxy : ClientBase<IAckQueue>, IAckQueue
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="AckQueueProxy" /> class.
        /// </summary>
        /// <param name="endpointName"></param>
        public AckQueueProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// This operation is triggered by the Ack Queue MSMQ when there is a 
        /// SendAckRequest ready to process. It stores the acknowledgment in the logs 
        /// and if the MLLP is set up for responses sends the acknowledgment to the MLLP interface for forwarding.
        /// </summary>
        /// <param name="request">The request containing the acknowledgement to be processed.</param>
        public void SendAck(SendAckQueueRequest request)
        {
            Channel.SendAck(request);
        }
    }
}
