﻿using System.ServiceModel;

using HIPS.ServiceContracts.Cda;
using HIPS.ServiceContracts.Cda.Message;

namespace HIPS.Client.Proxy
{
    /// <summary>
    /// This pre-built client class can be referenced by a .net client application in lieu of generating client classes from the WSDL.
    /// </summary>
    public class CdaProxy : ClientBase<ICdaService>, ICdaService
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="CdaProxy" /> class.
        /// </summary>
        /// <param name="endpointName"></param>
        public CdaProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Package a CDA document.
        /// Used by the P2P module to package a CDA® document for sending via the SMD. 
        /// All validation is done as part of the P2P module before the CDA® Packaging is invoked.
        /// A successful response indicates the document has been sent to the SMD service successfully. 
        /// The SMD component will attempt to send the message and any errors are handled in this component.
        /// </summary>
        /// <param name="request">Request Message</param>
        /// <returns>Response Message</returns>
        public ServiceContracts.Cda.Message.PackageCdaResponse PackageCdaDocument(ServiceContracts.Cda.Message.PackageCdaRequest request)
        {
            return Channel.PackageCdaDocument(request);
        }

        /// <summary>
        /// Unpackage a CDA document.
        /// Used by the P2P module to unpack a CDA® document that has been sent via the SMD Component. 
        /// The result is sent back as the Unpackage CDA® Document response. 
        /// </summary>
        /// <param name="request">Request Message</param>
        /// <returns>Response Message</returns>
        public ServiceContracts.Cda.Message.UnpackageCdaResponse UnpackageCdaDocument(ServiceContracts.Cda.Message.UnpackageCdaRequest request)
        {
            return Channel.UnpackageCdaDocument(request);
        }

        /// <summary>
        /// Get the content from a provided CDA unpackaged document.
        /// </summary>
        /// <param name="request">Request message.</param>
        /// <returns>Response message.</returns>
        public ServiceContracts.Cda.Message.GetCdaContentResponse GetCdaContent(ServiceContracts.Cda.Message.GetCdaContentRequest request)
        {
            return Channel.GetCdaContent(request);
        }

        /// <summary>
        /// Creates a CDA discharge summary document that wraps a PDF document body.
        /// This may be for the purpose of uploading the discharge summary to the
        /// PCEHR or for provider-to-provider (P2P) secure message delivery (SMD).
        /// This takes in the PDF document, required metadata, and any attachments
        /// and creates a CDA document.
        /// </summary>
        /// <param name="request">Request containing a PDF and required metadata for creating the CDA package.</param>
        /// <returns>Response containing details of the created document.</returns>
        public CreateDischargeSummaryLevel1AResponse CreateDischargeSummaryLevel1A(CreateDischargeSummaryLevel1ARequest request)
        {
            return Channel.CreateDischargeSummaryLevel1A(request);
        }
    }
}