﻿using System.ServiceModel;

using HIPS.CommonSchemas;
using HIPS.ServiceContracts.ServiceInterfaces;

namespace HIPS.Client.Proxy
{
    /// <summary>
    /// This pre-built client class can be referenced by a .net client application in lieu of generating client classes from the WSDL.
    /// </summary>
    public class DatabaseLoaderProxy : ClientBase<IDatabaseLoaderService>, IDatabaseLoaderService
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="DatabaseLoaderProxy" /> class.
        /// </summary>
        /// <param name="endpointName">Configured endpoint name.</param>
        public DatabaseLoaderProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Notifies HIPS of an event in the Patient Administration System.
        /// </summary>
        /// <param name="messageForm">An HL7 message.</param>
        /// <param name="user">Details of the responsible user.</param>
        /// <returns>An HL7 acknowledgement message.</returns>
        public string NotifyPasEvent(string messageForm, UserDetails user)
        {
            return Channel.NotifyPasEvent(messageForm, user);
        }

        /// <summary>
        /// Notifies HIPS of a pathology result.
        /// </summary>
        /// <param name="messageForm">An HL7 message.</param>
        /// <param name="user">Details of the responsible user.</param>
        /// <returns>An HL7 acknowledgement message.</returns>
        public string NotifyPathEvent(string messageForm, UserDetails user)
        {
            return Channel.NotifyPathEvent(messageForm, user);
        }
    }
}