﻿using System.Collections.Generic;
using System.ServiceModel;
using HIPS.CommonSchemas.Hi;
using HIPS.Reference.ServiceContracts;

namespace HIPS.Client.Proxy
{
    public class HiReferenceProxy : ClientBase<IHiReferenceService>, IHiReferenceService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName"></param>
        public HiReferenceProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Gets the Country List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of countries.</returns>
        public List<HiCountry> GetHiCountries()
        {
            return Channel.GetHiCountries();
        }

        /// <summary>
        /// Gets the LevelType List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of level types.</returns>
        public List<HiLevelType> GetHiLevelTypes()
        {
            return Channel.GetHiLevelTypes();
        }

        /// <summary>
        /// Gets the PostalDeliveryType List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of postal delivery types.</returns>
        public List<HiPostalDeliveryType> GetHiPostalDeliveryTypes()
        {
            return Channel.GetHiPostalDeliveryTypes();
        }

        /// <summary>
        /// Gets the Sex List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of sex codes.</returns>
        public List<HiSex> GetHiSexes()
        {
            return Channel.GetHiSexes();
        }

        /// <summary>
        /// Gets the State List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of states.</returns>
        public List<HiState> GetHiStates()
        {
            return Channel.GetHiStates();
        }

        /// <summary>
        /// Gets the StreetSuffixTypes List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of street suffixes.</returns>
        public List<HiStreetSuffixType> GetHiStreetSuffixTypes()
        {
            return Channel.GetHiStreetSuffixTypes();
        }

        /// <summary>
        /// Gets the StreetType List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of street types.</returns>
        public List<HiStreetType> GetHiStreetTypes()
        {
            return Channel.GetHiStreetTypes();
        }

        /// <summary>
        /// Gets the UnitType List from the Healthcare Identifier Reference Service
        /// </summary>
        /// <returns>List of unit types.</returns>
        public List<HiUnitType> GetHiUnitTypes()
        {
            return Channel.GetHiUnitTypes();
        }
    }
}