﻿#region Using Directives

using System;
using System.ServiceModel;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.IhiSchemas.Schemas;
using HIPS.ServiceContracts.ServiceInterfaces;
using HIPS.ServiceContracts.Common.DTO.ParticipatingIndividual;

#endregion Using Directives

namespace HIPS.Client.Proxy
{
    /// <summary>
    /// Client proxy for the IHI Service.
    /// </summary>
    public class IHIProxy : ClientBase<IIHIService>, IIHIService
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="IHIProxy"/> class.
        /// </summary>
        /// <param name="endpointName">The endpoint configuration name</param>
        public IHIProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Obtains validated IHI information for use in a clinical document.
        /// </summary>
        /// <param name="patientIdentifier">Patient identifier (Hospital-level MRN, State Patient ID, Validated IHI or PCEHR Data Store PatientMasterId)</param>
        /// <param name="dateOfBirth">Date of Birth</param>
        /// <param name="user">User Details</param>
        /// <returns>Validated IHI Information</returns>
        public ValidatedIhiResponse GetValidatedIhi(PatientIdentifierBase patientIdentifier, DateTime dateOfBirth, UserDetails user)
        {
            return Channel.GetValidatedIhi(patientIdentifier, dateOfBirth, user);
        }

        /// <summary>
        /// Obtains validated IHI information for use when sending an e-health message.
        /// </summary>
        /// <param name="patientIdentifier">Hospital-level (MRN) patient identifier.</param>
        /// <param name="dateOfBirth">Patient's date of birth (for identity verification)</param>
        /// <param name="user">The user responsible for this action</param>
        /// <returns>Validated IHI information</returns>
        public ValidatedIhiResponse ValidateSendingPatient(Mrn patientIdentifier, DateTime dateOfBirth, UserDetails user)
        {
            return Channel.ValidateSendingPatient(patientIdentifier, dateOfBirth, user);
        }

        /// <summary>
        /// Obtains validated IHI information for use when receiving an e-health message.
        /// </summary>
        /// <param name="consumer">Participating Consumer</param>
        /// <param name="user">The user responsible for this action</param>
        /// <param name="hpio">Health Provider Organisation Id</param>
        /// <returns>Validated IHI information</returns>
        public ValidatedIhiResponse ValidateReceivingPatient(ParticipatingConsumer consumer, string hpio, UserDetails user)
        {
            return Channel.ValidateReceivingPatient(consumer, hpio, user);
        }
    }
}