﻿using System.ServiceModel;

using HIPS.ServiceContracts.Patient;
using HIPS.ServiceContracts.Patient.Message;

namespace HIPS.Client.Proxy
{
    /// <summary>
    /// This pre-built client class can be referenced by a .net client application in lieu of generating client classes from the WSDL.
    /// </summary>
    public class PatientServiceV2Proxy : ClientBase<IPatientServiceV2>, IPatientServiceV2
    {
        /// <summary>
        /// Initialises a new instance of the <see cref="PatientServiceV2Proxy" /> class.
        /// </summary>
        /// <param name="endpointName">Configured endpoint name.</param>
        public PatientServiceV2Proxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Lists the episodes for a specific patient in a defined hospital
        /// </summary>
        /// <param name="request">Request containing a patient identifier for retrieving patient episodes.</param>
        /// <returns>Response containing the a list of the admitted or discharged episodes for the patient with in the specified number of days</returns>
        public ListPatientEpisodesInHospitalResponse ListPatientEpisodesInHospital(ListPatientEpisodesInHospitalRequest request)
        {
            return Channel.ListPatientEpisodesInHospital(request);
        }
        
        /// <summary>
        /// Allows for the creation of a patient within the eHISC system.
        /// </summary>
        /// <param name="request">Request containing a MRN, Demographic and validated IHI for creating a patient.</param>
        /// <returns>Register patient response.</returns>
        public RegisterPatientResponse RegisterPatient(RegisterPatientRequest request)
        {
            return Channel.RegisterPatient(request);
        }
    }
}