﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using HIPS.CommonBusinessLogic.Mapping;
using HIPS.CommonSchemas.Cda;
using Nehta.VendorLibrary.CDA.Common;

namespace HIPS.CommonBusinessLogic.Cda
{
    /// <summary>
    /// Responsible for mapping the CDA® Model data to the NEHTA CDA® 
    /// </summary>
    public class CdaMappingResource
    {
        /// <summary>
        /// Maps CDA® Diagnostic Imaging Detail model to NEHTA CDA® Diagnostic Imaging Report model.
        /// </summary>
        /// <param name="diagnosticImagingDetails">Diagnostic Imaging Details.</param>
        /// <returns>Diagnostic Imaging Report.</returns>
        public static DiagnosticImagingReport PopulateDiagnosticImagingCda(CdaPathDIDocumentDetails diagnosticImagingDetails)
        {
            return ObjectMapper.Map<DiagnosticImagingReport>(diagnosticImagingDetails);
        }

        /// <summary>
        /// Maps CDA® Pathology Details model to NEHTA CDA® Pathology Result Report model.
        /// </summary>
        /// <param name="pathologyDetails">Pathology Details.</param>
        /// <returns>Pathology Result Report.</returns>
        public static PathologyResultReport PopulatePathologyCda(CdaPathDIDocumentDetails pathologyDetails)
        {
            return ObjectMapper.Map<PathologyResultReport>(pathologyDetails);
        }
    }
}
