﻿using HIPS.CommonSchemas;
using HIPS.HL7.Common;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.PcehrQueueLogic;
using HIPS.PcehrSchemas;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;
using System.Threading.Tasks;

namespace HIPS.CommonBusinessLogic.Pcehr
{
    public class HL7ReportUploadBeforeQueue
    {

        #region Private Fields

        private QueuedHL7ReportOperation queuedHl7ReportOperation;
        
        #endregion Private Fields
        #region Constructors

        /// <summary>
        /// Creates an instance of the business logic for the upload of a HL7 Report to the PCEHR system. 
        /// </summary>
        /// <param name="user">Identifies the person responsible for sending the HL7 Report</param>
        /// <param name="hl7Message">The parsed HL7 Message</param>
        /// <param name="pdfReport">The PDF Report in bytes</param>
        /// <param name="hl7MessageLogId">The HL7 Message Log Id used for Acknowlegdement</param>
        /// <param name="documentTypeCode">The document type code of the HL7 Report</param>
        public HL7ReportUploadBeforeQueue(UserDetails user, string hl7Message, byte[] pdfReport, int hl7MessageLogId, string documentTypeCode)
        {
            this.queuedHl7ReportOperation = new QueuedHL7ReportOperation(user);
            this.queuedHl7ReportOperation.HL7Message = hl7Message;
            this.queuedHl7ReportOperation.Report = pdfReport;
            this.queuedHl7ReportOperation.HL7MessageLogId = hl7MessageLogId;
            this.queuedHl7ReportOperation.DocumentFormatCode = documentTypeCode;
            
        }

        #endregion Constructors

        #region Public methods

        /// <summary>
        /// Adds the HL7 Report Request to the PCEHR MSMQ 
        /// </summary>
        /// <returns>HipsResponse object</returns>
        public HipsResponse SendHl7ReportRequest()
        {
            this.queuedHl7ReportOperation.PendingItem = new PcehrMessageQueue();
            this.queuedHl7ReportOperation.PendingItem.QueueOperationId = (int)QueueOperation.UploadOrSupersede;
            this.queuedHl7ReportOperation.PendingItem.QueueStatusId = (int)QueueStatus.Pending;
            // We don't know what these are yet so lets set to empty values
            this.queuedHl7ReportOperation.PendingItem.EpisodeId = -1;
            this.queuedHl7ReportOperation.PendingItem.SourceSystemSetId = "";
            this.queuedHl7ReportOperation.PendingItem.SourceSystemDocumentId = "";

            using (MemoryStream stream = new MemoryStream())
            {
                new DataContractSerializer(typeof(QueuedHL7ReportOperation)).WriteObject(stream, this.queuedHl7ReportOperation);
                this.queuedHl7ReportOperation.PendingItem.SerialisedObject = stream.ToArray();
            }

            // Saves the HL7 Report Operation to the PCEHR data store and places the operation onto the MSMQ
            DocumentQueueTransactionHandler handler = new DocumentQueueTransactionHandler(this.queuedHl7ReportOperation.User);
            return handler.SaveHl7ReportOperationAndPlaceOnQueue(this.queuedHl7ReportOperation);

        }

        #endregion Public methods
    }
}
