﻿using System;
using System.Runtime.Serialization;

namespace HIPS.PcehrSchemas
{
    /// <summary>
    /// Represents an attachment to a CDA document.
    /// The namespace of this class must stay as HIPS.PcehrSchemas for compatibility
    /// with the legacy PCEHRService that does not have separate DTO classes.
    /// </summary>
    [KnownType(typeof(Attachment))]
    [Serializable]
    [DataContract]
    public class Attachment
    {
        private string fileName;
        private byte[] contents;

        /// <summary>
        /// Gets or sets the file name of the attachment.
        /// </summary>
        /// <value>
        /// The file name of the attachment.
        /// </value>
        [DataMember]
        public string FileName
        {
            get
            {
                return fileName;
            }
            set
            {
                fileName = value;
            }
        }

        /// <summary>
        /// Gets or sets the contents of the attachment.
        /// </summary>
        /// <value>
        /// The contents of the attachment.
        /// </value>
        [DataMember]
        public byte[] Contents
        {
            get
            {
                return contents;
            }
            set
            {
                contents = value;
            }
        }
    }
}