﻿using System.Collections.Generic;
using HIPS.CommonSchemas.PatientIdentifier;

namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Document Upload Details. This object represents details about a clinical document that has been queued for upload to the PCEHR system.
    /// </summary>
    public class CdaDocumentDetails
    {
        /// <summary>
        /// Gets or sets the attachments.
        /// </summary>
        public List<CdaAttachment> Attachments { get; set; }

        /// <summary>
        /// Gets or sets the XML document content.
        /// </summary>
        public byte[] CdaDocumentXmlBytes { get; set; }

        /// <summary>
        /// Gets or sets the document format code.
        /// </summary>
        public string DocumentFormatCode { get; set; }

        /// <summary>
        /// Gets or sets the document identifier used when creating the CDA document for upload.
        /// </summary>
        public EntityIdentifier DocumentId { get; set; }

        /// <summary>
        /// Gets or sets the document set identifier used when creating the CDA document for upload.
        /// </summary>
        public EntityIdentifier DocumentSetId { get; set; }

        /// <summary>
        /// Gets or sets the episode.
        /// </summary>
        public PcehrDataStore.Schemas.Episode Episode { get; set; }

        /// <summary>
        /// Gets or sets the narrative text for the Event section of the document.
        /// </summary>
        public string EventNarrativeText { get; set; }

        /// <summary>
        /// Gets or sets the hospital.
        /// </summary>
        public PcehrDataStore.Schemas.Hospital Hospital { get; set; }

        /// <summary>
        /// Gets or sets the hospital patient.
        /// </summary>
        public PcehrDataStore.Schemas.HospitalPatient HospitalPatient { get; set; }

        /// <summary>
        /// Gets or sets the metadata.
        /// </summary>
        public CdaHeaderMetadata Metadata { get; set; }

        /// <summary>
        /// Gets or sets the MRN number of the patient at the hospital that is
        /// specified in the patient identifier. If the MRN was auto-generated
        /// by HIPS then that value (which is based on a GUID) will be returned,
        /// otherwise it will be the MRN that was passed in the HL7 message to
        /// the Database Loader.
        /// </summary>
        public string Mrn { get; set; }

        /// <summary>
        /// Gets or sets a patient identifier of the same type that was specified in the upload request.
        /// </summary>
        public PatientIdentifierBase PatientIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the patient master.
        /// </summary>
        public PcehrDataStore.Schemas.PatientMaster PatientMaster { get; set; }

        /// <summary>
        /// Gets or sets the patient names for the document.
        /// </summary>
        public List<IndividualName> PatientNames { get; set; }

        /// <summary>
        /// Gets or sets the status of the operation.
        /// </summary>
        public HipsResponse Status { get; set; }

        /// <summary>
        /// Gets or sets the document version used when creating the CDA document for upload.
        /// </summary>
        public int Version { get; set; }

        /// <summary>
        /// Gets or sets the PatientIndigenousStatus for the CDA document.
        /// </summary>
        public string PatientIndigenousStatus { get; set; }
    }
}