﻿namespace HIPS.CommonSchemas.Cda
{
    /// <summary>
    /// Represents the metadata required for packaging a CDA document.
    /// </summary>
    public class CdaMetadata
    {
        /// <summary>
        /// Gets or sets the hospital.
        /// </summary>
        public HIPS.PcehrDataStore.Schemas.Hospital Hospital { get; set; }

        /// <summary>
        /// Gets or sets the document.
        /// </summary>
        public CdaDocument Document { get; set; }

        /// <summary>
        /// Gets or sets the packaging format.
        /// </summary>
        public CdaPackageFormat Format { get; set; }

        /// <summary>
        /// Gets or sets the message sender.
        /// </summary>
        public MessageAddressee Sender { get; set; }

        /// <summary>
        /// Gets or sets the message recipient.
        /// </summary>
        public MessageAddressee Recipient { get; set; }

        /// <summary>
        /// Gets or sets the SMD invocation identifier.
        /// </summary>
        public string SmdInvocationIdentifier { get; set; }

        /// <summary>
        /// Gets or sets the hospital code.
        /// </summary>
        public string HospitalCode { get; set; }

        /// <summary>
        /// Gets or sets the hospital code system.
        /// </summary>
        public string HospitalCodeSystem { get; set; }
    }
}