﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.Text;

namespace HIPS.CommonSchemas.Cda.ParticipatingIndividual
{
    /// <summary>
    /// Participating Consumer model. This object contains information that identifies
    /// the person who is the subject of care in the context of this document.
    /// </summary>
    public class ParticipatingConsumer : ParticipatingIndividual
    {
        #region Properties

        /// <summary>
        /// Gets or sets the person's date of birth.
        /// </summary>
        public DateTime? DateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the person's IHI.
        /// </summary>
        public string Ihi { get; set; }

        /// <summary>
        /// Gets or sets a code representing the person's sex.
        /// </summary>
        public PcehrDataStore.Schemas.Enumerators.SexEnumerator Sex { get; set; }

        #endregion
    }
}
